/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.images;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.osgi.framework.Bundle;
import su.artix.discountmanager.Activator;

public enum ImagesFactory implements ISharedImages
{
    INSTANCE;

    private Map<String, ImageDescriptor> descriptors;
    private ImageRegistry imageRegistry;

    private void declareImages() {
        this.declareImage("16x16/plane/clear.png", "icons/actions/16x16/plane/clear.png", true);
        this.declareImage("16x16/shadow/clear.png", "icons/actions/16x16/shadow/clear.png", true);
        this.declareImage("16x16/plane/add.png", "icons/actions/16x16/plane/add.png", true);
        this.declareImage("16x16/plane/edit.png", "icons/actions/16x16/plane/edit.png", true);
        this.declareImage("16x16/plane/delete.png", "icons/actions/16x16/plane/delete.png", true);
        this.declareImage("16x16/plane/up.png", "icons/actions/16x16/plane/up.png", true);
        this.declareImage("16x16/plane/down.png", "icons/actions/16x16/plane/down.png", true);
        this.declareImage("16x16/plane/copy.png", "icons/actions/16x16/plane/copy.png", true);
        this.declareImage("16x16/plane/paste.png", "icons/actions/16x16/plane/paste.png", true);
        this.declareImage("16x16/plane/period.png", "icons/actions/16x16/plane/period.png", true);
        this.declareImage("16x16/plane/refresh.png", "icons/actions/16x16/plane/refresh.png", true);
        this.declareImage("16x16/plane/find.png", "icons/actions/16x16/plane/find.png", true);
        this.declareImage("16x16/shadow/redo_edit.gif", "icons/actions/16x16/shadow/redo_edit.gif", true);
        this.declareImage("16x16/shadow/undo_edit.gif", "icons/actions/16x16/shadow/undo_edit.gif", true);
        this.declareImage("16x16/shadow/show_revision_discount.gif", "icons/actions/16x16/shadow/show_revision_discount.gif", true);
        this.declareImage("16x16/shadow/compare_view.gif", "icons/actions/16x16/shadow/compare_view.gif", true);
        this.declareImage("16x16/plane/restore_template.gif", "icons/actions/16x16/plane/restore_template.gif", true);
        this.declareImage("16x16/plane/system.png", "icons/system/16x16/plane/system.png", true);
        this.declareImage("24x24/plane/system.png", "icons/system/24x24/plane/system.png", true);
        this.declareImage("16x16/plane/campaigngroup_worse.png", "icons/campaigngroup/16x16/plane/campaigngroup_worse.png", true);
        this.declareImage("24x24/plane/campaigngroup_worse.png", "icons/campaigngroup/24x24/plane/campaigngroup_worse.png", true);
        this.declareImage("16x16/plane/campaign.png", "icons/campaign/16x16/plane/campaign.png", true);
        this.declareImage("24x24/plane/campaign.png", "icons/campaign/24x24/plane/campaign.png", true);
        this.declareImage("16x16/plane/campaign_disable.png", "icons/campaign/16x16/plane/campaign_disable.png", true);
        this.declareImage("24x24/plane/campaign_disable.png", "icons/campaign/24x24/plane/campaign_disable.png", true);
        this.declareImage("16x16/plane/discount.png", "icons/discount/16x16/plane/discount.png", true);
        this.declareImage("24x24/plane/discount.png", "icons/discount/24x24/plane/discount.png", true);
        this.declareImage("16x16/plane/discount_disable.png", "icons/discount/16x16/plane/discount_disable.png", true);
        this.declareImage("24x24/plane/discount_disable.png", "icons/discount/24x24/plane/discount_disable.png", true);
        this.declareImage("24x24/shadow/less.png", "icons/discountconstructor/24x24/shadow/less.png", true);
        this.declareImage("24x24/shadow/greater.png", "icons/discountconstructor/24x24/shadow/greater.png", true);
        this.declareImage("24x24/shadow/less_or_equal.png", "icons/discountconstructor/24x24/shadow/less_or_equal.png", true);
        this.declareImage("24x24/shadow/greater_or_equal.png", "icons/discountconstructor/24x24/shadow/greater_or_equal.png", true);
        this.declareImage("24x24/shadow/equal.png", "icons/discountconstructor/24x24/shadow/equal.png", true);
        this.declareImage("24x24/shadow/not_equal.png", "icons/discountconstructor/24x24/shadow/not_equal.png", true);
        this.declareImage("24x24/shadow/form_green.png", "icons/discountconstructor/24x24/shadow/form_green.png", true);
        this.declareImage("16x16/shadow/form_green.png", "icons/discountconstructor/16x16/shadow/form_green.png", true);
        this.declareImage("24x24/shadow/view.png", "icons/discountconstructor/24x24/shadow/view.png", true);
        this.declareImage("16x16/shadow/view.png", "icons/discountconstructor/16x16/shadow/view.png", true);
        this.declareImage("16x16/shadow/construction.png", "icons/discountconstructor/16x16/shadow/construction.png", true);
        this.declareImage("24x24/shadow/construction.png", "icons/discountconstructor/24x24/shadow/construction.png", true);
        this.declareImage("16x16/shadow/add.png", "icons/discountconstructor/16x16/shadow/add.png", true);
        this.declareImage("16x16/shadow/subtract.png", "icons/discountconstructor/16x16/shadow/subtract.png", true);
        this.declareImage("16x16/shadow/multiply.png", "icons/discountconstructor/16x16/shadow/multiply.png", true);
        this.declareImage("16x16/shadow/divide.png", "icons/discountconstructor/16x16/shadow/divide.png", true);
        this.declareImage("24x24/shadow/add.png", "icons/discountconstructor/24x24/shadow/add.png", true);
        this.declareImage("24x24/shadow/subtract.png", "icons/discountconstructor/24x24/shadow/subtract.png", true);
        this.declareImage("24x24/shadow/multiply.png", "icons/discountconstructor/24x24/shadow/multiply.png", true);
        this.declareImage("24x24/shadow/divide.png", "icons/discountconstructor/24x24/shadow/divide.png", true);
        this.declareImage("24x24/shadow/list.png", "icons/discountconstructor/24x24/shadow/list.png", true);
        this.declareImage("24x24/shadow/inList.png", "icons/discountconstructor/24x24/shadow/inList.png", true);
        this.declareImage("16x16/plane/object.png", "icons/object/16x16/plane/object.png", true);
        this.declareImage("16x16/plane/object_disable.png", "icons/object/16x16/plane/object_disable.png", true);
        this.declareImage("16x16/plane/condition.png", "icons/condition/16x16/plane/condition.png", true);
        this.declareImage("16x16/plane/condition_disable.png", "icons/condition/16x16/plane/condition_disable.png", true);
        this.declareImage("24x24/plane/condition.png", "icons/condition/24x24/plane/condition.png", true);
        this.declareImage("16x16/plane/conditioncard.png", "icons/condition/16x16/plane/conditioncard.png", true);
        this.declareImage("16x16/plane/conditioncard_disable.png", "icons/condition/16x16/plane/conditioncard_disable.png", true);
        this.declareImage("24x24/plane/conditioncard.png", "icons/condition/24x24/plane/conditioncard.png", true);
        this.declareImage("16x16/plane/conditioncoupon.png", "icons/condition/16x16/plane/conditioncoupon.png", true);
        this.declareImage("16x16/plane/conditioncoupon_disable.png", "icons/condition/16x16/plane/conditioncoupon_disable.png", true);
        this.declareImage("16x16/plane/rate.png", "icons/rate/16x16/plane/rate.png", true);
        this.declareImage("16x16/plane/rate_disable.png", "icons/rate/16x16/plane/rate_disable.png", true);
        this.declareImage("24x24/plane/rate.png", "icons/rate/24x24/plane/rate.png", true);
        this.declareImage("16x16/plane/cards.png", "icons/cards/16x16/plane/cards.png", true);
        this.declareImage("24x24/plane/cards.png", "icons/cards/24x24/plane/cards.png", true);
        this.declareImage("16x16/plane/cards_mass.png", "icons/cards/16x16/plane/cards_mass.png", true);
        this.declareImage("24x24/plane/cards_mass.png", "icons/cards/24x24/plane/cards_mass.png", true);
        this.declareImage("16x16/plane/cards_mass_create.png", "icons/cards/16x16/plane/cards_mass_create.png", true);
        this.declareImage("24x24/plane/cards_mass_create.png", "icons/cards/24x24/plane/cards_mass_create.png", true);
        this.declareImage("16x16/plane/lock.png", "icons/cards/16x16/plane/lock.png", true);
        this.declareImage("16x16/plane/unlock.png", "icons/cards/16x16/plane/unlock.png", true);
        this.declareImage("16x16/plane/clients.png", "icons/clients/16x16/plane/clients.png", true);
        this.declareImage("24x24/plane/clients.png", "icons/clients/24x24/plane/clients.png", true);
        this.declareImage("16x16/plane/clients_mass.png", "icons/clients/16x16/plane/clients_mass.png", true);
        this.declareImage("24x24/plane/clients_mass.png", "icons/clients/24x24/plane/clients_mass.png", true);
        this.declareImage("16x16/plane/accounting.png", "icons/accounting/16x16/plane/accounting.png", true);
        this.declareImage("24x24/plane/accounting.png", "icons/accounting/24x24/plane/accounting.png", true);
        this.declareImage("16x16/plane/asset.png", "icons/accounting/16x16/plane/asset.png", true);
        this.declareImage("24x24/plane/asset.png", "icons/accounting/24x24/plane/asset.png", true);
        this.declareImage("16x16/plane/earn.png", "icons/bonuses/16x16/plane/earn.png", true);
        this.declareImage("16x16/plane/single_object.png", "icons/actions/16x16/plane/single_object.png", true);
        this.declareImage("16x16/plane/multi_object.png", "icons/actions/16x16/plane/multi_object.png", true);
        this.declareImage("16x16/tag.png", "icons/tag/16x16/tag.png", true);
        this.declareImage("16x16/tag_type.png", "icons/tag/16x16/tag_type.png", true);
        this.declareImage("24x24/tag.png", "icons/tag/24x24/tag.png", true);
        this.declareImage("Coupon-icon.png", "icons/new/Coupon-icon.png", true);
        this.declareImage("Data-Meter-icon.png", "icons/new/Data-Meter-icon.png", true);
        this.declareImage("gift.png", "icons/new/gift.png", true);
        this.declareImage("report.png", "icons/new/report.png", true);
    }

    private void initializeImageRegistry() {
        this.imageRegistry = new ImageRegistry();
        this.descriptors = new HashMap<String, ImageDescriptor>();
        this.declareImages();
    }

    private Map<String, ImageDescriptor> getDescriptors() {
        if (this.descriptors == null) {
            this.initializeImageRegistry();
        }
        return this.descriptors;
    }

    public void dispose() {
        if (this.imageRegistry != null) {
            this.imageRegistry.dispose();
            this.imageRegistry = null;
        }
        this.descriptors = null;
    }

    public ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.initializeImageRegistry();
        }
        return this.imageRegistry;
    }

    private void declareImage(String key, String path, boolean shared) {
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(path), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        this.declareImage(key, desc, shared);
    }

    public void declareImage(String symbolicName, ImageDescriptor descriptor, boolean shared) {
        this.getDescriptors().put(symbolicName, descriptor);
        if (shared) {
            this.getImageRegistry().put(symbolicName, descriptor);
        }
    }

    public Image getImage(String symbolicName) {
        Image image = this.getImageRegistry().get(symbolicName);
        if (image == null) {
            ImageDescriptor imageDescriptor = Activator.getImageDescriptor(symbolicName);
            if (imageDescriptor == null) {
                image = this.getImageRegistry().get("IMG_OBJ_ELEMENTS");
            } else {
                this.getImageRegistry().put(symbolicName, imageDescriptor);
                image = this.getImageRegistry().get(symbolicName);
            }
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String symbolicName) {
        return this.getDescriptors().get(symbolicName);
    }
}

