/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component._LabeledFacesMessage;
import javax.faces.context.FacesContext;

class _MessageUtils {
    private static final String DETAIL_SUFFIX = "_detail";

    _MessageUtils() {
    }

    static void addErrorMessage(FacesContext facesContext, UIComponent component, String messageId) {
        facesContext.addMessage(component.getClientId(facesContext), _MessageUtils.getMessage(facesContext, facesContext.getViewRoot().getLocale(), FacesMessage.SEVERITY_ERROR, messageId, null));
    }

    static void addErrorMessage(FacesContext facesContext, UIComponent component, String messageId, Object[] args) {
        facesContext.addMessage(component.getClientId(facesContext), _MessageUtils.getMessage(facesContext, facesContext.getViewRoot().getLocale(), FacesMessage.SEVERITY_ERROR, messageId, args));
    }

    static void addErrorMessage(FacesContext facesContext, UIComponent component, Throwable cause) {
        facesContext.addMessage(component.getClientId(facesContext), new FacesMessage(FacesMessage.SEVERITY_ERROR, cause.getLocalizedMessage(), cause.getLocalizedMessage()));
    }

    static FacesMessage getMessage(FacesContext facesContext, Locale locale, FacesMessage.Severity severity, String messageId, Object[] args) {
        String detail;
        ResourceBundle appBundle = _MessageUtils.getApplicationBundle(facesContext, locale);
        String summary = _MessageUtils.getBundleString(appBundle, messageId);
        if (summary != null) {
            detail = _MessageUtils.getBundleString(appBundle, messageId + DETAIL_SUFFIX);
        } else {
            ResourceBundle defBundle = _MessageUtils.getDefaultBundle(facesContext, locale);
            summary = _MessageUtils.getBundleString(defBundle, messageId);
            if (summary != null) {
                detail = _MessageUtils.getBundleString(defBundle, messageId + DETAIL_SUFFIX);
            } else {
                detail = _MessageUtils.getBundleString(appBundle, messageId + DETAIL_SUFFIX);
                if (detail != null) {
                    summary = null;
                } else {
                    detail = _MessageUtils.getBundleString(defBundle, messageId + DETAIL_SUFFIX);
                    if (detail != null) {
                        summary = null;
                    } else {
                        facesContext.getExternalContext().log("No message with id " + messageId + " found in any bundle");
                        return new FacesMessage(severity, messageId, null);
                    }
                }
            }
        }
        if (args != null && args.length > 0) {
            MessageFormat format;
            if (summary != null) {
                format = new MessageFormat(summary, locale);
                summary = format.format(args);
            }
            if (detail != null) {
                format = new MessageFormat(detail, locale);
                detail = format.format(args);
            }
        }
        return new _LabeledFacesMessage(severity, summary, detail);
    }

    private static String getBundleString(ResourceBundle bundle, String key) {
        try {
            return bundle == null ? null : bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static ResourceBundle getApplicationBundle(FacesContext facesContext, Locale locale) {
        String bundleName = facesContext.getApplication().getMessageBundle();
        return bundleName != null ? _MessageUtils.getBundle(facesContext, locale, bundleName) : null;
    }

    private static ResourceBundle getDefaultBundle(FacesContext facesContext, Locale locale) {
        return _MessageUtils.getBundle(facesContext, locale, "javax.faces.Messages");
    }

    private static ResourceBundle getBundle(FacesContext facesContext, Locale locale, String bundleName) {
        try {
            return ResourceBundle.getBundle(bundleName, locale, facesContext.getClass().getClassLoader());
        }
        catch (MissingResourceException ignore1) {
            try {
                return ResourceBundle.getBundle(bundleName, locale, _MessageUtils.class.getClassLoader());
            }
            catch (MissingResourceException ignore2) {
                try {
                    return ResourceBundle.getBundle(bundleName, locale, Thread.currentThread().getContextClassLoader());
                }
                catch (MissingResourceException damned) {
                    facesContext.getExternalContext().log("resource bundle " + bundleName + " could not be found");
                    return null;
                }
            }
        }
    }

    static String getLabel(FacesContext facesContext, UIComponent component) {
        Object label = component.getAttributes().get("label");
        if (label != null) {
            return label.toString();
        }
        ValueExpression expression = component.getValueExpression("label");
        if (expression != null) {
            return expression.getExpressionString();
        }
        return component.getClientId(facesContext);
    }
}

