/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client.entities;

import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import su.artix.cashserver.core.cashregistry.domain.ToolTip;
import su.artix.cashserver.rest.client.RestInvoker;
import su.artix.cashserver.rest.client.RestInvokerManager;

public class ToolTipsRestClient {
    private static final String TOOLTIP_URL = "toolTips";
    private final RestInvokerManager restInvokerManager;

    public ToolTipsRestClient(RestInvokerManager restInvokerManager) {
        this.restInvokerManager = restInvokerManager;
    }

    public List<ToolTip> getToolTips() {
        ParameterizedTypeReference<List<ToolTip>> returnTypeRef = new ParameterizedTypeReference<List<ToolTip>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(TOOLTIP_URL, returnTypeRef);
    }

    public ToolTip getToolTip(String id) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("toolTips/{0}", id), ToolTip.class);
    }

    public void addToolTip(ToolTip toolTip) {
        this.restInvokerManager.getRestInvoker().invokePost(TOOLTIP_URL, toolTip);
    }

    public void updateToolTip(String id, ToolTip toolTip) {
        this.restInvokerManager.getRestInvoker().invokePut(RestInvoker.urlBuild("toolTips/{0}", id), toolTip);
    }

    public void removeToolTip(String id) {
        this.restInvokerManager.getRestInvoker().invokeDelete(RestInvoker.urlBuild("toolTips/{0}", id));
    }
}

