/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DateHelper {
    private static final long MILLISECONDS_IN_DAY = 86400000L;
    private static Map _dateFormatMap = new HashMap();
    private static int _todayYear;
    private static int _todayYearDate;
    private static Locale _locale;

    public static void initialize(Locale locale) {
        _locale = locale;
        Calendar temp = Calendar.getInstance(locale);
        _todayYear = temp.get(1);
        _todayYearDate = temp.get(6);
        _dateFormatMap.clear();
    }

    public static int hoursBetween(Calendar start, Calendar end, boolean assumeSameDate) {
        return DateHelper.minutesBetween(start.getTime(), end.getTime(), assumeSameDate, false) / 60;
    }

    public static int hoursBetween(Date start, Date end, boolean assumeSameDate) {
        return DateHelper.minutesBetween(start, end, assumeSameDate, false) / 60;
    }

    public static int minutesBetween(Date start, Date end, boolean assumeSameDate, boolean assumeSameHour) {
        Calendar sDate = Calendar.getInstance(_locale);
        Calendar eDate = Calendar.getInstance(_locale);
        sDate.setTime(start);
        eDate.setTime(end);
        if (assumeSameDate) {
            eDate.set(1, 2000);
            sDate.set(1, 2000);
            eDate.set(6, 1);
            sDate.set(6, 1);
        }
        if (assumeSameHour) {
            eDate.set(10, 1);
            sDate.set(10, 1);
        }
        long diff = eDate.getTimeInMillis() - sDate.getTimeInMillis();
        diff /= 1000L;
        return (int)(diff /= 60L);
    }

    public static int secondsBetween(Date start, Date end, boolean assumeSameDate, boolean assumeSameHour) {
        Calendar sDate = Calendar.getInstance(_locale);
        Calendar eDate = Calendar.getInstance(_locale);
        sDate.setTime(start);
        eDate.setTime(end);
        if (assumeSameDate) {
            eDate.set(1, 2000);
            sDate.set(1, 2000);
            eDate.set(6, 1);
            sDate.set(6, 1);
        }
        if (assumeSameHour) {
            eDate.set(10, 1);
            sDate.set(10, 1);
        }
        long diff = eDate.getTimeInMillis() - sDate.getTimeInMillis();
        return (int)(diff /= 1000L);
    }

    public static long daysBetween(Calendar start, Calendar end) {
        GregorianCalendar startDate = new GregorianCalendar(_locale);
        GregorianCalendar endDate = new GregorianCalendar(_locale);
        startDate.setGregorianChange(new Date(Long.MAX_VALUE));
        endDate.setGregorianChange(new Date(Long.MAX_VALUE));
        startDate.setTime(start.getTime());
        endDate.setTime(end.getTime());
        startDate.set(11, 12);
        endDate.set(11, 12);
        startDate.set(12, 0);
        endDate.set(12, 0);
        startDate.set(13, 0);
        endDate.set(13, 0);
        startDate.set(14, 0);
        endDate.set(14, 0);
        long endMilli = endDate.getTimeInMillis() + (long)endDate.getTimeZone().getOffset(endDate.getTimeInMillis());
        long startMilli = startDate.getTimeInMillis() + (long)startDate.getTimeZone().getOffset(startDate.getTimeInMillis());
        long diff = (endMilli - startMilli) / 86400000L;
        return diff;
    }

    public static long daysBetweenxX(Calendar start, Calendar end) {
        Calendar startCal = GregorianCalendar.getInstance();
        startCal.setTime(start.getTime());
        startCal.set(11, 0);
        startCal.set(12, 0);
        startCal.set(13, 0);
        long startTime = startCal.getTimeInMillis();
        Calendar endCal = GregorianCalendar.getInstance();
        endCal.setTime(end.getTime());
        endCal.set(11, 0);
        endCal.set(12, 0);
        endCal.set(13, 0);
        long endTime = endCal.getTimeInMillis();
        return (endTime - startTime) / 86400000L;
    }

    public static long daysBetween(Date start, Date end) {
        Calendar dEnd = Calendar.getInstance(_locale);
        Calendar dStart = Calendar.getInstance(_locale);
        dEnd.setTime(end);
        dStart.setTime(start);
        return DateHelper.daysBetween(dStart, dEnd);
    }

    public static boolean isNow(Calendar cal, Locale locale, boolean minuteCheck) {
        Calendar today;
        if (DateHelper.isToday(cal) && (today = Calendar.getInstance(locale)).get(11) == cal.get(11)) {
            if (!minuteCheck) {
                return true;
            }
            if (today.get(12) == cal.get(12)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isToday(Date date) {
        Calendar cal = Calendar.getInstance(_locale);
        cal.setTime(date);
        return DateHelper.isToday(cal);
    }

    public static boolean isToday(Calendar cal) {
        return cal.get(1) == _todayYear && cal.get(6) == _todayYearDate;
    }

    public static Calendar getNewCalendar(Calendar old) {
        Calendar ret = _locale == null ? Calendar.getInstance() : Calendar.getInstance(_locale);
        ret.setTime(old.getTime());
        return ret;
    }

    public static String getDate(Calendar cal, String dateFormat) {
        Calendar toUse = Calendar.getInstance(_locale);
        toUse.setTime(cal.getTime());
        toUse.add(2, -1);
        SimpleDateFormat df = null;
        if (_dateFormatMap.get(dateFormat) != null) {
            df = (SimpleDateFormat)_dateFormatMap.get(dateFormat);
        } else {
            df = new SimpleDateFormat(dateFormat, _locale);
            _dateFormatMap.put(dateFormat, df);
        }
        df.setLenient(true);
        return df.format(cal.getTime());
    }

    public static boolean sameDate(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance(_locale);
        Calendar cal2 = Calendar.getInstance(_locale);
        cal1.setTime(date1);
        cal2.setTime(date2);
        return DateHelper.sameDate(cal1, cal2);
    }

    public static boolean sameDate(Calendar cal1, Calendar cal2) {
        return cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }
}

