/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.nebula.widgets.ganttchart.ColorCache;
import org.eclipse.nebula.widgets.ganttchart.DateHelper;
import org.eclipse.nebula.widgets.ganttchart.GanttChart;
import org.eclipse.nebula.widgets.ganttchart.GanttComposite;
import org.eclipse.nebula.widgets.ganttchart.utils.DateRange;
import org.eclipse.swt.graphics.Color;

public class GanttSpecialDateRange {
    public static final int REPEAT_DAILY = 1;
    public static final int REPEAT_WEEKLY = 2;
    public static final int REPEAT_MONTHLY = 3;
    public static final int REPEAT_YEARLY = 4;
    public static final int REPEAT_DDAY = 5;
    public static final int NO_END = -1;
    private Calendar _start;
    private Calendar _end;
    private Color _bgColorTop = ColorCache.getWhite();
    private Color _bgColorBottom = ColorCache.getBlack();
    private GanttChart _parentChart;
    private GanttComposite _parentComposite;
    private boolean _allowEventsOnDates = true;
    private int _frequency = 2;
    private int _recurCount = 1;
    private List _recurDays = new ArrayList();
    private int _startHour = 0;
    private int _startMinute = 0;
    private final int _startSecond = 0;
    private int _endHour = 23;
    private int _endMinute = 59;
    private final int _endSecond = 59;
    private int _endAfter = -1;
    private Calendar _lastActualEndDate;
    private List _cachedRanges = null;
    private int _ddayRepeatInterval = 0;

    GanttSpecialDateRange() {
        this(null, null, null);
    }

    public GanttSpecialDateRange(GanttChart parent) {
        this(parent, null, null);
    }

    public GanttSpecialDateRange(GanttChart parent, Calendar start, Calendar end) {
        this._parentChart = parent;
        if (parent != null) {
            this._parentComposite = parent.getGanttComposite();
        }
        this._start = start == null ? null : DateHelper.getNewCalendar(start);
        Calendar calendar = this._end = end == null ? null : DateHelper.getNewCalendar(end);
        if (parent != null) {
            this._parentComposite.addSpecialDateRange(this);
        }
        this.updateCalculations();
    }

    public Calendar getStart() {
        return this._start;
    }

    public void setStart(Calendar start) {
        this._start = start == null ? null : DateHelper.getNewCalendar(start);
        this.updateCalculations();
    }

    public Calendar getEnd() {
        return this._end;
    }

    public void setEnd(Calendar end) {
        this._end = end == null ? null : DateHelper.getNewCalendar(end);
        this.updateCalculations();
    }

    public Color getBackgroundColorTop() {
        return this._bgColorTop;
    }

    public void setBackgroundColorTop(Color backgroundColorTop) {
        this._bgColorTop = backgroundColorTop;
    }

    public Color getBackgroundColorBottom() {
        return this._bgColorBottom;
    }

    public void setBackgroundColorBottom(Color backgroundColorBottom) {
        this._bgColorBottom = backgroundColorBottom;
    }

    public GanttChart getParentChart() {
        return this._parentChart;
    }

    public GanttComposite getParentComposite() {
        return this._parentComposite;
    }

    public boolean isAllowEventsOnDates() {
        return this._allowEventsOnDates;
    }

    public void setAllowEventsOnDates(boolean allowEventsOnDates) {
        this._allowEventsOnDates = allowEventsOnDates;
    }

    public boolean addRecurDay(int day) {
        if (day < 1 || day > 7) {
            return false;
        }
        if (this._recurDays.contains(new Integer(day))) {
            return false;
        }
        boolean ret = this._recurDays.add(new Integer(day));
        if (ret) {
            this.updateCalculations();
        }
        return ret;
    }

    public boolean removeRecurDay(int calDate) {
        boolean ret = this._recurDays.remove(new Integer(calDate));
        if (ret) {
            this.updateCalculations();
        }
        return ret;
    }

    public int getFrequency() {
        return this._frequency;
    }

    public void setFrequency(int frequency) {
        this._frequency = frequency;
        this.updateCalculations();
    }

    public int getDDayRepeatInterval() {
        return this._ddayRepeatInterval;
    }

    public void setDDayRepeatInterval(int interval) {
        this._ddayRepeatInterval = interval;
    }

    public int getRecurCount() {
        return this._recurCount;
    }

    public void setRecurCount(int recurMax) {
        this._recurCount = recurMax;
        this.updateCalculations();
    }

    public List getRecurDays() {
        return this._recurDays;
    }

    public int getStartHour() {
        return this._startHour;
    }

    public boolean setStartHour(int startHour) {
        if (startHour < 0 || startHour > 23) {
            return false;
        }
        this._startHour = startHour;
        this.updateCalculations();
        return true;
    }

    public int getStartMinute() {
        return this._startMinute;
    }

    public boolean setStartMinute(int startMinute) {
        if (startMinute < 0 || startMinute > 59) {
            return false;
        }
        this._startMinute = startMinute;
        this.updateCalculations();
        return true;
    }

    public int getEndHour() {
        return this._endHour;
    }

    public boolean setEndHour(int endHour) {
        if (endHour < 0 || endHour > 23) {
            return false;
        }
        this._endHour = endHour;
        this.updateCalculations();
        return true;
    }

    public int getEndMinute() {
        return this._endMinute;
    }

    public boolean setEndMinute(int endMinute) {
        if (endMinute < 0 || endMinute > 59) {
            return false;
        }
        this._endMinute = endMinute;
        this.updateCalculations();
        return true;
    }

    public int getEndAfter() {
        return this._endAfter;
    }

    public void setEndAfter(int endAfter) {
        this._endAfter = endAfter;
        this.updateCalculations();
    }

    public void setParentChart(GanttChart parentChart) {
        this._parentChart = parentChart;
    }

    public void setParentComposite(GanttComposite parentComposite) {
        this._parentComposite = parentComposite;
    }

    private void updateCalculations() {
        this._lastActualEndDate = null;
        this._cachedRanges = null;
    }

    public boolean canEventOccupy(Calendar start, Calendar end) {
        if (this.isAllowEventsOnDates()) {
            return true;
        }
        if (!this.isVisible(start, end)) {
            return true;
        }
        List blocks = this.getBlocks(start, end);
        DateRange us = new DateRange(this._start, this._end);
        for (int i = 0; i < blocks.size(); ++i) {
            Calendar blockEnd;
            ArrayList block = (ArrayList)blocks.get(i);
            Calendar blockStart = (Calendar)block.get(0);
            DateRange range = new DateRange(blockStart, blockEnd = (Calendar)block.get(1));
            if (!us.Overlaps(range)) continue;
            return false;
        }
        return true;
    }

    boolean isVisible(Calendar start, Calendar end) {
        if (!this.isUseable()) {
            return false;
        }
        if (this._recurDays.isEmpty() && this._frequency != 5) {
            return false;
        }
        if (this._recurCount <= 0) {
            return false;
        }
        if (this._end != null && this._end.before(start)) {
            return false;
        }
        Calendar aEnd = this.getActualEndDate();
        if (aEnd != null && aEnd.before(start)) {
            return false;
        }
        return this._start.before(end) && aEnd.after(start);
    }

    Calendar getActualStartDate() {
        return this._start;
    }

    Calendar getActualEndDate() {
        if (this._lastActualEndDate != null) {
            return this._lastActualEndDate;
        }
        if (this._end != null) {
            this._lastActualEndDate = DateHelper.getNewCalendar(this._end);
            return this._end;
        }
        Calendar cal = DateHelper.getNewCalendar(this._start);
        block7: for (int i = 0; i < this._recurCount; ++i) {
            switch (this._frequency) {
                case 1: {
                    cal.add(5, 1);
                    continue block7;
                }
                case 2: {
                    cal.add(3, 1);
                    continue block7;
                }
                case 3: {
                    cal.add(2, 1);
                    continue block7;
                }
                case 4: {
                    cal.add(1, 1);
                    continue block7;
                }
                case 5: {
                    cal.add(5, this._ddayRepeatInterval);
                    continue block7;
                }
            }
        }
        int d = this.getHighestRecurDate();
        cal.set(7, d);
        cal.set(11, this._endHour);
        cal.set(12, this._endMinute);
        cal.set(13, 59);
        cal.set(14, 999);
        this._lastActualEndDate = DateHelper.getNewCalendar(cal);
        return cal;
    }

    List getBlocks() {
        return this.getBlocks(null, null);
    }

    List getBlocks(Calendar start, Calendar end) {
        this._cachedRanges = new ArrayList();
        Calendar cal = DateHelper.getNewCalendar(this._start);
        Calendar ourEnd = this.getActualEndDate();
        block7: for (int i = 0; i < this._recurCount; ++i) {
            Calendar calEnd = DateHelper.getNewCalendar(cal);
            if (this._recurDays.isEmpty() && this._frequency == 5) {
                cal.set(11, this._startHour);
                cal.set(12, this._startMinute);
                cal.set(13, 0);
                cal.set(14, 0);
                calEnd.set(11, this._endHour);
                calEnd.set(12, this._endMinute);
                calEnd.set(13, 59);
                calEnd.set(14, 999);
                if (calEnd.after(end) || ourEnd != null && calEnd.after(ourEnd)) continue;
                ArrayList<Calendar> foo = new ArrayList<Calendar>();
                foo.add(DateHelper.getNewCalendar(cal));
                foo.add(DateHelper.getNewCalendar(calEnd));
                this._cachedRanges.add(foo);
            } else {
                for (int x = 0; x < this._recurDays.size(); ++x) {
                    int day = (Integer)this._recurDays.get(x);
                    cal.set(11, this._startHour);
                    cal.set(12, this._startMinute);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    cal.set(7, day);
                    calEnd.set(11, this._endHour);
                    calEnd.set(12, this._endMinute);
                    calEnd.set(13, 59);
                    calEnd.set(14, 999);
                    calEnd.set(7, day);
                    if (start != null && calEnd.before(start) || end != null && cal.after(end) || cal.after(ourEnd)) continue;
                    ArrayList<Calendar> foo = new ArrayList<Calendar>();
                    foo.add(DateHelper.getNewCalendar(cal));
                    foo.add(DateHelper.getNewCalendar(calEnd));
                    this._cachedRanges.add(foo);
                }
            }
            switch (this._frequency) {
                case 1: {
                    cal.add(5, 1);
                    continue block7;
                }
                case 2: {
                    cal.add(3, 1);
                    continue block7;
                }
                case 3: {
                    cal.add(2, 1);
                    continue block7;
                }
                case 4: {
                    cal.add(1, 1);
                    continue block7;
                }
                case 5: {
                    cal.add(5, this._ddayRepeatInterval);
                    continue block7;
                }
            }
        }
        return this._cachedRanges;
    }

    int getHighestRecurDate() {
        int max = 0;
        for (int i = 0; i < this._recurDays.size(); ++i) {
            Integer day = (Integer)this._recurDays.get(i);
            max = Math.max(max, day);
        }
        return max;
    }

    boolean isUseable() {
        return this._start != null;
    }

    public String toString() {
        String freq = "";
        switch (this._frequency) {
            case 1: {
                freq = "Daily";
                break;
            }
            case 2: {
                freq = "Weekly";
                break;
            }
            case 3: {
                freq = "Monthly";
                break;
            }
            case 4: {
                freq = "Yearly";
                break;
            }
            case 5: {
                freq = "DDay";
                break;
            }
        }
        return "[GanttSpecialDateRange: " + (this._start == null ? null : this._start.getTime()) + " - " + (this._end == null ? null : this._end.getTime()) + ". Freqency: " + freq + ". Recur Count: " + this._recurCount + ". Last actual end date: " + (this._lastActualEndDate == null ? null : this._lastActualEndDate.getTime()) + "]";
    }
}

