/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.validation.validator;

import com.richclientgui.toolbox.Messages;
import com.richclientgui.toolbox.validation.validator.AbstractInputMaskValidator;
import java.text.MessageFormat;

public class TelephoneNumberValidator
extends AbstractInputMaskValidator<String> {
    private static final String INTERNATIONAL = "+## (##) ###-####";
    private static final String DOMESTIC = "(###) ###-####";
    private static final String INTERNATIONAL_ERROR = MessageFormat.format(Messages.getString("TelephoneNumberValidator.message.error"), "+## (##) ###-####");
    private static final String DOMESTIC_ERROR = MessageFormat.format(Messages.getString("TelephoneNumberValidator.message.error"), "(###) ###-####");
    private boolean useCountryCode = false;

    public TelephoneNumberValidator(boolean useCountryCode) {
        super(useCountryCode ? INTERNATIONAL : DOMESTIC);
        this.useCountryCode = useCountryCode;
    }

    @Override
    public boolean isContentsValid(String contents) {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.useCountryCode ? INTERNATIONAL_ERROR : DOMESTIC_ERROR;
    }

    @Override
    public String getWarningMessage() {
        return "";
    }

    @Override
    public boolean warningExist(String contents) {
        return false;
    }
}

