/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.security.utils;

import java.util.List;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtils.class);

    private SecurityUtils() {
    }

    public static void resetPerspectivesOnDefault(IWorkbenchWindow window) {
        try {
            window.getActivePage().closeAllPerspectives(false, true);
            window.getWorkbench().showPerspective("ru.ssa.artixadmin.Perspective", window);
        }
        catch (WorkbenchException exception) {
            log.error("cann't reset perspective: {}", (Throwable)exception);
        }
    }

    public static void checkPerspectives(final List<String> perspectiveIds) {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    IPerspectiveDescriptor perspectiveDescriptor = window.getActivePage().getPerspective();
                    for (String perspectiveId : perspectiveIds) {
                        if (!perspectiveDescriptor.getId().equals(perspectiveId)) continue;
                        SecurityUtils.resetPerspectivesOnDefault(window);
                        log.info("reset perspective state to default...");
                        break;
                    }
                }
            }
        });
    }
}

