/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.action.menutree.dnd;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.action.menutree.dnd.Paste;
import ru.ssa.cashadmin.domain.advanced.HierarchicalMenuItem;

public class MenuTreeDropListener
extends ViewerDropAdapter {
    private static final Logger log = LoggerFactory.getLogger(MenuTreeDropListener.class);
    private final Viewer viewer;
    private HierarchicalMenuItem target;

    public MenuTreeDropListener(Viewer viewer) {
        super(viewer);
        this.viewer = viewer;
    }

    public void drop(DropTargetEvent event) {
        int location = this.determineLocation(event);
        this.target = null;
        switch (location) {
            case 3: {
                this.target = (HierarchicalMenuItem)this.determineTarget(event);
                break;
            }
            default: {
                this.target = ((HierarchicalMenuItem)this.determineTarget(event)).getParent();
            }
        }
        super.drop(event);
    }

    public boolean performDrop(Object data) {
        log.trace("data {}", (Object)((HierarchicalMenuItem)data).getName());
        HierarchicalMenuItem src = (HierarchicalMenuItem)data;
        Paste.INSTANCE.paste(src, this.target, false);
        this.viewer.refresh();
        return true;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (target == null) {
            return false;
        }
        return ((HierarchicalMenuItem)target).getMenu() != null;
    }
}

