/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.notes;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ru.ssa.cashadmin.domain.dict.notes.DialogInputMultiTextField;
import su.artix.yuki.directory.Directory;
import su.artix.yuki.directory.DirectoryLabelProvider;
import su.artix.yuki.directory.MyKeyValue;

public class DialogInputMultiTextFieldEditDialog
extends Dialog {
    private DialogInputMultiTextField dataModel;
    private Text fieldId;
    private Text description;
    private Button required;
    private Button editable;
    private ComboViewer type;
    private Text regexp;
    private Text inputMask;
    private Text defaultValue;
    private Text dateFormat;
    private Text labels;
    private StackLayout optionLayout;
    private Composite optionPanel;
    private Composite stringFields;
    private Composite radiobattonFields;
    private Composite dateFields;
    private Composite dateTimeFields;

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 5;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(131072, 1024, false, false);
        data.horizontalSpan = 1;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(5, 5).numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)composite);
        Label fieldIdLabel = new Label(composite, 0);
        fieldIdLabel.setText("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440:");
        this.fieldId = new Text(composite, 2048);
        this.fieldId.setText(this.dataModel.getFieldId() == null ? "" : this.dataModel.getFieldId());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fieldId);
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:");
        this.description = new Text(composite, 2048);
        this.description.setText(this.dataModel.getDescription() == null ? "" : this.dataModel.getDescription());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.description);
        this.required = new Button(composite, 32);
        this.required.setText("\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f");
        this.required.setSelection(this.dataModel.isRequired());
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.required);
        this.editable = new Button(composite, 32);
        this.editable.setText("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
        this.editable.setSelection(this.dataModel.isEditable());
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.editable);
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText("\u0422\u0438\u043f:");
        this.type = new ComboViewer(composite, 8);
        this.type.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.type.setLabelProvider((IBaseLabelProvider)new DirectoryLabelProvider());
        this.type.setInput((Object)Directory.notesDialogInputMultiTextFieldType);
        this.type.getCombo().select(this.dataModel.getType() == null ? 1 : Directory.notesDialogInputMultiTextFieldType.indexOf((Object)new MyKeyValue((Object)this.dataModel.getType())));
        this.type.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (DialogInputMultiTextFieldEditDialog.this.type.getCombo().getText()) {
                    case "\u0421\u0442\u0440\u043e\u043a\u0430": {
                        ((DialogInputMultiTextFieldEditDialog)DialogInputMultiTextFieldEditDialog.this).optionLayout.topControl = DialogInputMultiTextFieldEditDialog.this.stringFields;
                        DialogInputMultiTextFieldEditDialog.this.optionPanel.layout();
                        break;
                    }
                    case "\u0414\u0430\u0442\u0430": {
                        ((DialogInputMultiTextFieldEditDialog)DialogInputMultiTextFieldEditDialog.this).optionLayout.topControl = DialogInputMultiTextFieldEditDialog.this.dateFields;
                        DialogInputMultiTextFieldEditDialog.this.optionPanel.layout();
                        break;
                    }
                    case "\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f": {
                        ((DialogInputMultiTextFieldEditDialog)DialogInputMultiTextFieldEditDialog.this).optionLayout.topControl = DialogInputMultiTextFieldEditDialog.this.dateTimeFields;
                        DialogInputMultiTextFieldEditDialog.this.optionPanel.layout();
                        break;
                    }
                    case "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430": {
                        ((DialogInputMultiTextFieldEditDialog)DialogInputMultiTextFieldEditDialog.this).optionLayout.topControl = DialogInputMultiTextFieldEditDialog.this.radiobattonFields;
                        DialogInputMultiTextFieldEditDialog.this.optionPanel.layout();
                        break;
                    }
                    default: {
                        ((DialogInputMultiTextFieldEditDialog)DialogInputMultiTextFieldEditDialog.this).optionLayout.topControl = null;
                        DialogInputMultiTextFieldEditDialog.this.optionPanel.layout();
                    }
                }
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.type.getCombo());
        this.optionLayout = new StackLayout();
        this.optionPanel = new Composite(composite, 0);
        this.optionPanel.setLayout((Layout)this.optionLayout);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, true).applyTo((Control)this.optionPanel);
        this.stringFields = this.createFormForStringField(this.optionPanel);
        this.dateFields = this.createFormForDateField(this.optionPanel);
        this.dateTimeFields = this.createFormForDateTimeField(this.optionPanel);
        this.radiobattonFields = this.createFormForRadiobattonField(this.optionPanel);
        if (this.dataModel.getType() != null) {
            if (this.dataModel.getType() == 2) {
                this.optionLayout.topControl = this.radiobattonFields;
            } else if (this.dataModel.getType() == 10) {
                this.optionLayout.topControl = this.stringFields;
            } else if (this.dataModel.getType() == 14) {
                this.optionLayout.topControl = this.dateFields;
            } else if (this.dataModel.getType() == 16) {
                this.optionLayout.topControl = this.dateTimeFields;
            }
        } else {
            this.optionLayout.topControl = this.stringFields;
        }
        return parent;
    }

    private Composite createFormForStringField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)composite);
        Label regexpLabel = new Label(composite, 0);
        regexpLabel.setText("\u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438:");
        this.regexp = new Text(composite, 2048);
        this.regexp.setText(this.dataModel.getRegexp() == null ? "" : this.dataModel.getRegexp());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.regexp);
        Label inputMaskLabel = new Label(composite, 0);
        inputMaskLabel.setText("\u041c\u0430\u0441\u043a\u0430 \u0432\u0432\u043e\u0434\u0430:");
        this.inputMask = new Text(composite, 2048);
        this.inputMask.setText(this.dataModel.getInputMask() == null ? "" : this.dataModel.getInputMask());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.inputMask);
        Label defaultValueLabel = new Label(composite, 0);
        defaultValueLabel.setText("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e:");
        this.defaultValue = new Text(composite, 2048);
        this.defaultValue.setText(this.dataModel.getDefaultValue() == null ? "" : this.dataModel.getDefaultValue());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.defaultValue);
        return composite;
    }

    private Composite createFormForDateField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)composite);
        Label defaultValueLabel = new Label(composite, 0);
        defaultValueLabel.setText("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e (\u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 dd/MM/yyyy):");
        this.defaultValue = new Text(composite, 2048);
        this.defaultValue.setText(this.dataModel.getDefaultValue() == null ? "" : this.dataModel.getDefaultValue());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.defaultValue);
        return composite;
    }

    private Composite createFormForDateTimeField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)composite);
        Label dateFormatLabel = new Label(composite, 0);
        dateFormatLabel.setText("\u0424\u043e\u0440\u043c\u0430\u0442 \u0432\u0432\u043e\u0434\u0430 \u0434\u0430\u0442\u044b:");
        this.dateFormat = new Text(composite, 2048);
        this.dateFormat.setText(this.dataModel.getDateFormat() == null ? "" : this.dataModel.getDateFormat());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.dateFormat);
        return composite;
    }

    private Composite createFormForRadiobattonField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)composite);
        Label labelsLabel = new Label(composite, 0);
        labelsLabel.setText("\u0421\u043f\u0438\u0441\u043e\u043a \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u0432\u044b\u0431\u043e\u0440\u0430 \u0447\u0435\u0440\u0435\u0437 \u0437\u0430\u043f\u044f\u0442\u0443\u044e:");
        this.labels = new Text(composite, 2048);
        this.labels.setText(this.dataModel.getLabels() == null ? "" : StringUtils.join((Collection)this.dataModel.getLabels(), (String)", "));
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.labels);
        return composite;
    }

    protected Point getInitialSize() {
        return new Point(500, 360);
    }

    protected void okPressed() {
        boolean flagIsOk = true;
        DialogInputMultiTextField newDataModel = this.createDialogInputMultiTextField();
        if (StringUtils.isBlank((String)newDataModel.getFieldId())) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430!", (String)"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d!");
            flagIsOk = false;
        }
        if (StringUtils.isBlank((String)newDataModel.getDescription())) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430!", (String)"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e!");
            flagIsOk = false;
        }
        if (newDataModel.getType() == null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430!", (String)"\u0422\u0438\u043f \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d!");
            flagIsOk = false;
        }
        if (newDataModel.getType() == 2 && CollectionUtils.isEmpty((Collection)newDataModel.getLabels())) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430!", (String)"\u0414\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u044b \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u0432\u044b\u0431\u043e\u0440\u0430!");
            flagIsOk = false;
        }
        if (flagIsOk) {
            this.dataModel = newDataModel;
            super.okPressed();
        }
    }

    private DialogInputMultiTextField createDialogInputMultiTextField() {
        DialogInputMultiTextField newDataModel = new DialogInputMultiTextField();
        newDataModel.setDateFormat(StringUtils.isBlank((String)this.dateFormat.getText()) ? null : this.dateFormat.getText());
        newDataModel.setDefaultValue(StringUtils.isBlank((String)this.defaultValue.getText()) ? null : this.defaultValue.getText());
        newDataModel.setDescription(this.description.getText());
        newDataModel.setEditable(this.editable.getSelection());
        newDataModel.setFieldId(this.fieldId.getText());
        newDataModel.setInputMask(StringUtils.isBlank((String)this.inputMask.getText()) ? null : this.inputMask.getText());
        newDataModel.setLabels(StringUtils.isBlank((String)this.labels.getText()) ? null : Arrays.asList(this.labels.getText().split("\\s*,\\s*")));
        newDataModel.setRegexp(StringUtils.isBlank((String)this.regexp.getText()) ? null : this.regexp.getText());
        newDataModel.setRequired(this.required.getSelection());
        switch (this.type.getCombo().getText()) {
            case "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430": {
                newDataModel.setType(Integer.valueOf(2));
                break;
            }
            case "\u0421\u0442\u0440\u043e\u043a\u0430": {
                newDataModel.setType(Integer.valueOf(10));
                break;
            }
            case "\u0414\u0430\u0442\u0430": {
                newDataModel.setType(Integer.valueOf(14));
                break;
            }
            case "\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f": {
                newDataModel.setType(Integer.valueOf(16));
            }
        }
        return newDataModel;
    }

    public DialogInputMultiTextFieldEditDialog(DialogInputMultiTextField dataModel) {
        super(Display.getDefault().getActiveShell());
        this.dataModel = dataModel;
    }

    public DialogInputMultiTextField getDialogInputMultiTextField() {
        return this.dataModel;
    }

    public void setDialogInputMultiTextField(DialogInputMultiTextField dataModel) {
        this.dataModel = dataModel;
    }

    protected boolean isResizable() {
        return true;
    }
}

