/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.connect;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import ru.ssa.artixadmin.editors.connect.EditConnectXmlFile;
import ru.ssa.cashadmin.domain.Connect;

public class ConnectTableViewer
extends TableViewer {
    private final TableColumn nameColumn;
    private final TableColumn addressColumn;
    private final TableColumn portColumn;
    private List<Connect> connections = new ArrayList<Connect>();

    public ConnectTableViewer(Composite parent, int style) {
        super(parent, style);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 50, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 25, true));
        this.getTable().setLayout((Layout)tableLayout);
        GridDataFactory.fillDefaults().hint(350, 100).align(4, 4).grab(true, true).applyTo((Control)this.getTable());
        this.getTable().setLinesVisible(true);
        this.getTable().setHeaderVisible(true);
        this.nameColumn = new TableColumn(this.getTable(), 16384);
        this.nameColumn.setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        this.addressColumn = new TableColumn(this.getTable(), 16384);
        this.addressColumn.setText("\u0425\u043e\u0441\u0442");
        this.portColumn = new TableColumn(this.getTable(), 16384);
        this.portColumn.setText("\u041f\u043e\u0440\u0442");
    }

    public Connect getSelectedConnect() {
        return (Connect)((IStructuredSelection)this.getSelection()).getFirstElement();
    }

    public void setInput(List<Connect> connections) {
        this.connections = connections;
        super.setInput(connections);
    }

    public void add(Object element) {
        this.connections.add((Connect)element);
        EditConnectXmlFile.saveConnections(this.connections);
        super.add(element);
    }

    public void remove(Object element) {
        this.connections.remove(element);
        EditConnectXmlFile.saveConnections(this.connections);
        super.remove(element);
    }

    public void update(Object element, String[] properties) {
        int index = this.connections.indexOf(element);
        this.connections.set(index, (Connect)element);
        EditConnectXmlFile.saveConnections(this.connections);
        super.refresh();
    }
}

