/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.directory.goods;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.provider.goods.GroupLabelProvider;
import ru.ssa.artixadmin.provider.goods.GroupTreeLazyContentProvider;
import ru.ssa.artixadmin.view.directory.goods.GroupHierarchicalViewPanel;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.dao.SessionManager;
import ru.ssa.cashadmin.domain.InventGroup;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.action.DirectoryEditActionGroup;
import su.artix.yuki.view.DirectoryTreeView;
import su.artix.yuki.view.DirectoryViewPanel;

@SecurityKey(title="\u0413\u0440\u0443\u043f\u043f\u044b \u0442\u043e\u0432\u0430\u0440\u043e\u0432 (\u0434\u0435\u0440\u0435\u0432\u043e)")
public class GroupHierarchicalView
extends DirectoryTreeView<InventGroup> {
    public static final String ID = "ru.ssa.artixadmin.view.directory.goods.GroupHierarchicalView";
    private static final Logger log = LoggerFactory.getLogger(GroupHierarchicalView.class);
    private InventGroup parentGroup;

    public void createPartControl(Composite parent) {
        this.setPojoClass(InventGroup.class);
        this.setViewPanel((DirectoryViewPanel)new GroupHierarchicalViewPanel(parent, 0, false));
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        ((TreeViewer)this.getViewer()).setContentProvider(new GroupTreeLazyContentProvider<InventGroup>(InventGroup.class, (TreeViewer)this.getViewer()));
        ((TreeViewer)this.getViewer()).setLabelProvider((IBaseLabelProvider)new GroupLabelProvider());
        TreeViewer treeViewer = (TreeViewer)this.getViewer();
        treeViewer.setAutoExpandLevel(2);
        treeViewer.refresh();
        SessionManager.openSession(InventGroup.class);
        this.getViewPanel().setInput(LibActivator.getDefault().getActualClassResolver().getInstance(InventGroup.class));
        SessionManager.closeSession(InventGroup.class);
        this.commonActionGroup = new DirectoryEditActionGroup(InventGroup.class);
        this.commonActionGroup.fillActionBars(this.getViewSite().getActionBars());
        super.createPartControl(parent);
        this.restoreState();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selectionIn) {
        log.trace("selectionChanged part {} selection {}", (Object)part, (Object)selectionIn);
        IStructuredSelection selection = (IStructuredSelection)selectionIn;
        if (part instanceof GroupHierarchicalView) {
            InventGroup groups = (InventGroup)LibActivator.getDefault().getActualClassResolver().getInstance(InventGroup.class);
            if (selection.size() == 1 && selection.getFirstElement() instanceof InventGroup) {
                InventGroup currentGroup = (InventGroup)selection.getFirstElement();
                if (this.parentGroup != null && this.parentGroup.getGroupcode().equals(currentGroup.getGroupcode())) {
                    this.parentGroup = null;
                    ((TreeViewer)this.getViewer()).getTree().deselectAll();
                    this.commonActionGroup.setEnabledEditGroupActions(Boolean.valueOf(false));
                    this.commonActionGroup.getAddAction().setEnabled(true);
                    this.commonActionGroup.getAddAction().setModel((Object)groups);
                } else {
                    this.parentGroup = currentGroup;
                    groups.setParentgroupcode(currentGroup.getGroupcode());
                    this.commonActionGroup.getAddAction().setModel((Object)groups);
                }
            } else {
                this.parentGroup = null;
                this.commonActionGroup.getAddAction().setModel((Object)groups);
            }
        }
    }

    protected String getID() {
        return ID;
    }

    public void setFocus() {
        ((TreeViewer)this.getViewer()).getControl().setFocus();
    }
}

