/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.gauges;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class CoolGauge
extends Canvas {
    private final List<Point> points = new ArrayList<Point>();
    private final List<Integer> distanceToNextPoint = new ArrayList<Integer>();
    private final Image gaugeImage;
    private Image needlePivotPointImage;
    private Point needlePivotPoint;
    private Color needleColor;
    private int needleLength = 0;
    private Point currentNeedlePosition;
    private int needleWidth = 1;
    private int totalDistance = 0;
    private int swt_cap_style = 1;
    private int swt_line_style = 1;
    private LineAttributes lineAttributes;

    public CoolGauge(Composite parent, Image gaugeImage) {
        super(parent, 0x20000000);
        this.gaugeImage = gaugeImage;
        if (gaugeImage == null) {
            throw new IllegalArgumentException("The gauge image must not be null.");
        }
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                CoolGauge.this.paintControl(e);
            }
        });
    }

    public void setNeedleLineAttributes(LineAttributes lineAttributes) {
        this.checkWidget();
        this.lineAttributes = lineAttributes;
        this.redrawNeedle();
    }

    public void setNeedleLineStyle(int swt_line_style) {
        this.checkWidget();
        this.swt_line_style = swt_line_style;
        this.redrawNeedle();
    }

    public void setNeedleCap(int swt_cap_style) {
        this.checkWidget();
        this.swt_cap_style = swt_cap_style;
        this.redrawNeedle();
    }

    private void paintControl(PaintEvent e) {
        Image image = new Image((Device)e.display, this.gaugeImage.getImageData());
        GC gc = new GC((Drawable)image);
        gc.setAdvanced(true);
        gc.setAntialias(1);
        gc.setForeground(this.needleColor);
        gc.setLineWidth(this.needleWidth);
        gc.setLineCap(this.swt_cap_style);
        gc.setLineStyle(this.swt_line_style);
        if (this.lineAttributes != null) {
            gc.setLineAttributes(this.lineAttributes);
        }
        Point pnt = this.needlePivotPoint;
        if (this.currentNeedlePosition != null) {
            gc.drawLine(pnt.x, pnt.y, this.currentNeedlePosition.x, this.currentNeedlePosition.y);
        }
        if (this.needlePivotPointImage != null) {
            Rectangle rect = this.needlePivotPointImage.getBounds();
            gc.drawImage(this.needlePivotPointImage, pnt.x - rect.width / 2, pnt.y - rect.height / 2);
        }
        e.gc.drawImage(image, 0, 0);
        gc.dispose();
        image.dispose();
    }

    public void setPoints(List<Point> points) {
        this.checkWidget();
        this.points.clear();
        this.points.addAll(points);
        int size = this.points.size();
        int totalDist = 0;
        int i = 0;
        while (i < size) {
            Point pnt0;
            Point pnt1 = pnt0 = this.points.get(i);
            if (i + 1 < size) {
                pnt1 = this.points.get(i + 1);
            }
            int dis = CoolGauge.getShortestDistance(pnt0, pnt1) + 1;
            totalDist += dis;
            this.distanceToNextPoint.add(new Integer(dis));
            ++i;
        }
        if (size > 0) {
            this.currentNeedlePosition = points.get(0);
        }
        this.totalDistance = totalDist;
        this.redrawNeedle();
    }

    private static int getShortestDistance(Point pnt0, Point pnt1) {
        return (int)Math.sqrt(Math.pow(pnt1.x - pnt0.x, 2.0) + Math.pow(pnt1.y - pnt0.y, 2.0));
    }

    private Point getCurrentPoint(int distance) {
        int size = this.distanceToNextPoint.size();
        int cnt = 0;
        int i = 0;
        while (i < size) {
            if (i + 1 < size && cnt + this.distanceToNextPoint.get(i) >= distance) {
                return this.getPointBetweenIndices(i, i + 1, distance - cnt);
            }
            cnt += this.distanceToNextPoint.get(i).intValue();
            ++i;
        }
        return this.points.get(size - 1);
    }

    private Point getPointBetweenIndices(int index0, int index1, int offset) {
        Point needle;
        int R;
        int r;
        int startX = this.points.get((int)index0).x;
        int startY = this.points.get((int)index0).y;
        int endX = this.points.get((int)index1).x;
        int endY = this.points.get((int)index1).y;
        int width = Math.abs(endX - startX);
        int height = Math.abs(endY - startY);
        double hypot = Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0));
        int newX = (int)((double)(offset * width) * 1.0 / hypot);
        int newY = (int)((double)(offset * height) * 1.0 / hypot);
        Point pnt = new Point(startX, startY);
        if (CoolGauge.isQ1(startX, startY, endX, endY)) {
            pnt.x = startX - newX;
            pnt.y = startY - newY;
        } else if (CoolGauge.isQ2(startX, startY, endX, endY)) {
            pnt.x = startX + newX;
            pnt.y = startY - newY;
        } else if (CoolGauge.isQ3(startX, startY, endX, endY)) {
            pnt.x = startX - newX;
            pnt.y = startY + newY;
        } else if (CoolGauge.isQ4(startX, startY, endX, endY)) {
            pnt.x = startX + newX;
            pnt.y = startY + newY;
        }
        if (this.needleLength > 0 && (r = this.needleLength) != (R = CoolGauge.getShortestDistance(needle = this.needlePivotPoint, pnt))) {
            int X = Math.abs(pnt.x - needle.x);
            int Y = Math.abs(pnt.y - needle.y);
            double rat = (double)r * 1.0 / (double)R;
            int sX = (int)((double)X * rat);
            int sY = (int)((double)Y * rat);
            if (CoolGauge.isQ1(needle.x, needle.y, pnt.x, pnt.y)) {
                pnt.x = needle.x - sX;
                pnt.y = needle.y - sY;
            } else if (CoolGauge.isQ2(needle.x, needle.y, pnt.x, pnt.y)) {
                pnt.x = needle.x + sX;
                pnt.y = needle.y - sY;
            } else if (CoolGauge.isQ3(needle.x, needle.y, pnt.x, pnt.y)) {
                pnt.x = needle.x - sX;
                pnt.y = needle.y + sY;
            } else if (CoolGauge.isQ4(needle.x, needle.y, pnt.x, pnt.y)) {
                pnt.x = needle.x + sX;
                pnt.y = needle.y + sY;
            }
        }
        return pnt;
    }

    public void setLevel(double percentage) {
        this.checkWidget();
        if (percentage < 0.0) {
            percentage = 0.0;
        } else if (percentage > 1.0) {
            percentage = 1.0;
        }
        this.redrawNeedle();
        this.currentNeedlePosition = this.getCurrentPoint((int)((double)this.totalDistance * percentage));
        this.redrawNeedle();
    }

    private void redrawNeedle() {
        int heightNyBigger;
        int width = this.needleWidth;
        int nX = this.needlePivotPoint.x;
        int nY = this.needlePivotPoint.y;
        int cX = this.currentNeedlePosition.x;
        int cY = this.currentNeedlePosition.y;
        int widthCxBigger = cX - nX <= 1 ? 2 + 2 * width : cX - nX + 2 * width;
        int widthNxBigger = nX - cX <= 1 ? 2 + 2 * width : nX - cX + 2 * width;
        int heightCyBigger = cY - nY <= 1 ? 2 + 2 * width : cY - nY + 2 * width;
        int n = heightNyBigger = nY - cY <= 1 ? 2 + 2 * width : nY - cY + 2 * width;
        if (CoolGauge.isQ1(nX, nY, cX, cY)) {
            this.redraw(cX - width, cY - width, widthNxBigger, heightNyBigger, false);
        } else if (CoolGauge.isQ2(nX, nY, cX, cY)) {
            this.redraw(nX - width, cY - width, widthCxBigger, heightNyBigger, false);
        } else if (CoolGauge.isQ3(nX, nY, cX, cY)) {
            this.redraw(cX - width, nY - width, widthNxBigger, heightCyBigger, false);
        } else if (CoolGauge.isQ4(nX, nY, cX, cY)) {
            this.redraw(nX - width, nY - width, widthCxBigger, heightCyBigger, false);
        } else {
            this.redraw();
        }
    }

    private static boolean isQ1(int nX, int nY, int cX, int cY) {
        return nX >= cX && nY >= cY;
    }

    private static boolean isQ2(int nX, int nY, int cX, int cY) {
        return nX <= cX && nY >= cY;
    }

    private static boolean isQ3(int nX, int nY, int cX, int cY) {
        return nX >= cX && nY <= cY;
    }

    private static boolean isQ4(int nX, int nY, int cX, int cY) {
        return nX <= cX && nY <= cY;
    }

    public void setGaugeNeedlePivotImage(Image pivotImage) {
        this.checkWidget();
        if (pivotImage == null) {
            throw new IllegalArgumentException("The pivot image cannot be null");
        }
        this.needlePivotPointImage = pivotImage;
        if (this.needlePivotPoint != null && this.currentNeedlePosition != null) {
            this.redrawNeedle();
        } else {
            this.redraw();
        }
    }

    public void setGaugeNeedlePivot(Point point) {
        this.checkWidget();
        if (point == null) {
            throw new IllegalArgumentException("The point cannot be null");
        }
        this.needlePivotPoint = point;
        if (this.needlePivotPoint != null && this.currentNeedlePosition != null) {
            this.redrawNeedle();
        } else {
            this.redraw();
        }
    }

    public void setGaugeNeedleColour(Color colour) {
        this.checkWidget();
        if (colour == null) {
            throw new IllegalArgumentException("The color cannot be null");
        }
        this.needleColor = colour;
        if (this.needlePivotPoint != null && this.currentNeedlePosition != null) {
            this.redrawNeedle();
        } else {
            this.redraw();
        }
    }

    public void setGaugeNeedleLength(int length) {
        this.checkWidget();
        if (length <= 0) {
            throw new IllegalArgumentException("The needle length must be greater than 0");
        }
        this.needleLength = length;
        if (this.needlePivotPoint != null && this.currentNeedlePosition != null) {
            this.redrawNeedle();
        } else {
            this.redraw();
        }
    }

    public void setGaugeNeedleWidth(int width) {
        this.checkWidget();
        if (width <= 0) {
            throw new IllegalArgumentException("The needle width must be greater than 0");
        }
        this.needleWidth = width;
        if (this.needlePivotPoint != null && this.currentNeedlePosition != null) {
            this.redrawNeedle();
        } else {
            this.redraw();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (this.gaugeImage != null && !this.gaugeImage.isDisposed()) {
            Rectangle bounds = this.gaugeImage.getBounds();
            width = bounds.width;
            height = bounds.height;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }
}

