/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.dialogs.SystemTitleAreaDialog;
import su.artix.discountmanager.dialogs.discountsystem.GiftPanel;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.discountmanagercore.dao.discountsystem.DiscountSystemDAO;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.Gift;
import su.artix.yuki.editors.DialogMode;

@SecurityKey(title="\u041f\u043e\u0434\u0430\u0440\u043a\u0438")
public class GiftDialog
extends SystemTitleAreaDialog {
    private Discount discount;
    private Gift gift;
    private GiftPanel giftPanel;
    private DiscountSystemDAO.SystemType type;

    public GiftDialog(Discount discount, Gift gift, DiscountSystemDAO.SystemType type, DialogMode dialogMode) {
        super(Display.getCurrent().getActiveShell(), dialogMode, null);
        this.discount = discount;
        this.gift = gift;
        this.type = type;
    }

    @Override
    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        this.setTitleDialog(String.valueOf(this.getDialogMode() == DialogMode.CREATE ? "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435" : "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435") + " \u043f\u043e\u0434\u0430\u0440\u043a\u0430");
        this.setMessage("\u041f\u043e\u0434\u0430\u0440\u043e\u043a");
        return content;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.giftPanel = new GiftPanel(container, 0, Gift.class, this.gift, this.type);
        this.giftPanel.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        if (this.getDialogMode() == DialogMode.CREATE) {
            Gift initedModel = (Gift)this.giftPanel.getModel();
            this.giftPanel.initDefault(initedModel);
        }
        this.giftPanel.initialize();
        return container;
    }

    @Override
    public void applyRights(String selector) {
        this.giftPanel.applyRights();
        super.applyRights(selector);
    }

    protected void okPressed() {
        Gift model = (Gift)this.giftPanel.getModel();
        if (model == null || model.getCatalogCode() == null || model.getCount() == null || model.getCount() < 1) {
            ErrorMessageFactory.emptyFieldMessage();
        } else {
            if (model.getCount() != null && model.getMinCount() != null && model.getMinCount() > model.getCount()) {
                ErrorMessageFactory.generalErrorMessage("\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0434\u0430\u0440\u043a\u043e\u0432 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0433\u043e");
                return;
            }
            if ((this.getDialogMode() == DialogMode.CREATE || !((Gift)this.giftPanel.getModel()).getCatalogCode().equals(this.gift.getCatalogCode())) && CollectionUtils.isNotEmpty((Collection)this.discount.getGifts())) {
                for (Gift g : this.discount.getGifts()) {
                    if (!model.getCatalogCode().equals(g.getCatalogCode())) continue;
                    ErrorMessageFactory.generalErrorMessage("\u041f\u043e\u0434\u0430\u0440\u043e\u043a \u0434\u043b\u044f \u0442\u0430\u043a\u043e\u0433\u043e \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0430 \u0443\u0436\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d");
                    return;
                }
            }
        }
        super.okPressed();
    }

    public Gift getGift() {
        return (Gift)this.giftPanel.getModel();
    }
}

