/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.discountsystem.compare.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.domain.EnversRevEntity;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.discountsystem.compare.CompareInput;
import su.artix.discountmanager.discountsystem.compare.dialog.DiscountSystemViewerDialog;
import su.artix.discountmanager.discountsystem.compare.view.DiscountHistoryViewPanel;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.images.ImagesFactory;
import su.artix.discountmanager.providers.SystemLabelProvider;
import su.artix.discountmanager.providers.bonussystem.EarnBonusSystemLabelProvider;
import su.artix.discountmanager.providers.bonussystem.LimitBonusSystemLabelProvider;
import su.artix.discountmanager.providers.bonussystem.PeriodicImpactsBonusSystemLabelProvider;
import su.artix.discountmanager.providers.discountsystem.DiscountSystemContentProvider;
import su.artix.discountmanager.providers.discountsystem.DiscountSystemLabelProvider;
import su.artix.discountmanager.providers.discountsystem.SecondDiscountSystemLabelProvider;
import su.artix.discountmanager.trees.CustomSystemTreeViewer;
import su.artix.discountmanager.views.DiscountSystemView;
import su.artix.discountmanager.views.EarnBonusSystemView;
import su.artix.discountmanager.views.LimitBonusSystemView;
import su.artix.discountmanager.views.PeriodicImpactsBonusSystemView;
import su.artix.discountmanager.views.SecondSystemView;
import su.artix.discountmanagercore.dao.discountsystem.DiscountSystemDAO;
import su.artix.discountmanagercore.dao.discountsystem.EarnBonusSystemDAO;
import su.artix.discountmanagercore.dao.discountsystem.LimitBonusSystemDAO;
import su.artix.discountmanagercore.dao.discountsystem.PeriodicImpactsBonusSystemDAO;
import su.artix.discountmanagercore.dao.discountsystem.SecondSystemDAO;
import su.artix.loyaltylib.convertor.discountsystem.DiscountSystem2Yaml;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem;
import su.artix.yuki.action.DirectoryEditActionGroup;
import su.artix.yuki.provider.LazyContentProvider;
import su.artix.yuki.provider.PojoTableLabelProvider;
import su.artix.yuki.view.DirectoryTableView;
import su.artix.yuki.view.DirectoryViewPanel;

@SecurityKey(title="\u0421\u043a\u0438\u0434\u043a\u0438. \u0414\u0438\u0441\u043a\u043e\u043d\u0442. \u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0434\u0438\u0441\u043a\u043e\u043d\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b")
public class DiscountHistoryView
extends DirectoryTableView<EnversRevEntity> {
    private static final Logger log = LoggerFactory.getLogger(DiscountHistoryView.class);
    private final Map<String, Dialog> alreadyOpenedRevisions = new HashMap<String, Dialog>();
    public static final String ID = "su.artix.discountmanager.discountsystem.compare.view.discounthistoryview";

    protected String getID() {
        return ID;
    }

    public void createPartControl(Composite parent) {
        this.setPojoClass(EnversRevEntity.class);
        this.setViewPanel((DirectoryViewPanel)new DiscountHistoryViewPanel(parent, 0, true, false));
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        LazyContentProvider lazyContentProvider = new LazyContentProvider(EnversRevEntity.class, (TableViewer)this.getViewer());
        lazyContentProvider.setSortProperty("id");
        lazyContentProvider.setAscending(false);
        ((TableViewer)this.getViewer()).setContentProvider((IContentProvider)lazyContentProvider);
        ((TableViewer)this.getViewer()).setLabelProvider((IBaseLabelProvider)new PojoTableLabelProvider(this.getColumns()));
        this.getViewPanel().setInput(null);
        Action openRevisionDiscountAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return ImagesFactory.INSTANCE.getImageDescriptor("16x16/shadow/show_revision_discount.gif");
            }

            public String getToolTipText() {
                return "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0440\u0435\u0432\u0438\u0437\u0438\u0438";
            }

            public void run() {
                StructuredSelection selection = (StructuredSelection)((TableViewer)DiscountHistoryView.this.getViewer()).getSelection();
                if (selection != null && selection.size() == 1) {
                    EnversRevEntity entity = (EnversRevEntity)selection.getFirstElement();
                    IWorkbenchPart view = ViewHolder.INSTANCE.getActiveViewPart();
                    if (view instanceof ViewPart) {
                        try {
                            Class<DiscountSystemDAO> daoClass = null;
                            DiscountSystemDAO.SystemType discountType = null;
                            SystemLabelProvider labelProvider = null;
                            if (view instanceof DiscountSystemView) {
                                discountType = DiscountSystemDAO.SystemType.DISCOUNT_SYSTEM;
                                labelProvider = new DiscountSystemLabelProvider();
                                daoClass = DiscountSystemDAO.class;
                            } else if (view instanceof EarnBonusSystemView) {
                                discountType = DiscountSystemDAO.SystemType.EARN_BONUS_SYSTEM;
                                labelProvider = new EarnBonusSystemLabelProvider();
                                daoClass = EarnBonusSystemDAO.class;
                            } else if (view instanceof LimitBonusSystemView) {
                                discountType = DiscountSystemDAO.SystemType.LIMIT_BONUS_SYSTEM;
                                labelProvider = new LimitBonusSystemLabelProvider();
                                daoClass = LimitBonusSystemDAO.class;
                            } else if (view instanceof PeriodicImpactsBonusSystemView) {
                                discountType = DiscountSystemDAO.SystemType.PERIODIC_IMPACTS_BONUS_SYSTEM;
                                labelProvider = new PeriodicImpactsBonusSystemLabelProvider();
                                daoClass = PeriodicImpactsBonusSystemDAO.class;
                            } else if (view instanceof SecondSystemView) {
                                discountType = DiscountSystemDAO.SystemType.SECOND_SYSTEM;
                                labelProvider = new SecondDiscountSystemLabelProvider();
                                daoClass = SecondSystemDAO.class;
                            }
                            if (entity != null) {
                                DiscountSystemDAO dao = Activator.getDefault().getBeanByClass(daoClass);
                                final DiscountSystem revision = dao.getRevisionDiscountSystem(discountType, entity.getId());
                                if (revision == null) {
                                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"\u0421\u0438\u0441\u0442\u0435\u043c\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430", (String)"\u0412 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0440\u0435\u0432\u0438\u0437\u0438\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043f\u043e \u0434\u0430\u043d\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435");
                                    return;
                                }
                                log.trace("revision info: {}", (Object)revision);
                                final CustomSystemTreeViewer treeViewer = (CustomSystemTreeViewer)view.getSite().getSelectionProvider();
                                final ITreeContentProvider currentTreeContentProvider = (ITreeContentProvider)treeViewer.getContentProvider();
                                DiscountSystemContentProvider contentProvider = new DiscountSystemContentProvider(discountType){

                                    @Override
                                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                                    }

                                    @Override
                                    public Object[] getElements(Object inputElement) {
                                        if (inputElement instanceof Map) {
                                            return ((Map)inputElement).values().toArray();
                                        }
                                        return this.getChildren(inputElement);
                                    }

                                    @Override
                                    public Object[] getChildren(Object parentElement) {
                                        return currentTreeContentProvider.getChildren(parentElement);
                                    }
                                };
                                final String dialogTitle = String.format("%s (\u0440\u0435\u0432\u0438\u0437\u0438\u044f #%d)", view.getTitle(), entity.getId());
                                if (DiscountHistoryView.this.alreadyOpenedRevisions.containsKey(dialogTitle)) {
                                    ((Dialog)DiscountHistoryView.this.alreadyOpenedRevisions.get(dialogTitle)).getShell().setFocus();
                                    return;
                                }
                                DiscountSystemViewerDialog dialog = new DiscountSystemViewerDialog(Display.getCurrent().getActiveShell(), dialogTitle, revision, contentProvider, (IBaseLabelProvider)labelProvider){

                                    protected void okPressed() {
                                        treeViewer.addHistoryItemValue(DiscountSystem2Yaml.getDiscountSystemYaml((DiscountSystem)revision));
                                        treeViewer.showCurrentChange();
                                        super.okPressed();
                                    }
                                };
                                dialog.open();
                                DiscountHistoryView.this.alreadyOpenedRevisions.put(dialogTitle, dialog);
                                dialog.getShell().addDisposeListener(new DisposeListener(){

                                    public void widgetDisposed(DisposeEvent e) {
                                        DiscountHistoryView.this.alreadyOpenedRevisions.remove(dialogTitle);
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            log.error("Exception while show revision discount: {}", (Throwable)e);
                        }
                    }
                }
            }
        };
        openRevisionDiscountAction.setEnabled(false);
        Action showHistoryDialogAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return ImagesFactory.INSTANCE.getImageDescriptor("16x16/shadow/compare_view.gif");
            }

            public String getToolTipText() {
                return "\u0421\u0440\u0430\u0432\u043d\u0438\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u0434\u0438\u0441\u043a\u043e\u043d\u0442 \u0441 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0440\u0435\u0432\u0438\u0437\u0438\u0435\u0439...";
            }

            public void run() {
                IWorkbenchPart view;
                StructuredSelection selection = (StructuredSelection)((TableViewer)DiscountHistoryView.this.getViewer()).getSelection();
                if (selection != null && selection.size() == 1 && (view = ViewHolder.INSTANCE.getActiveViewPart()) instanceof ViewPart) {
                    try {
                        Class<DiscountSystemDAO> daoClass = null;
                        DiscountSystemDAO.SystemType discountType = null;
                        if (view instanceof DiscountSystemView) {
                            discountType = DiscountSystemDAO.SystemType.DISCOUNT_SYSTEM;
                            daoClass = DiscountSystemDAO.class;
                        } else if (view instanceof EarnBonusSystemView) {
                            discountType = DiscountSystemDAO.SystemType.EARN_BONUS_SYSTEM;
                            daoClass = EarnBonusSystemDAO.class;
                        } else if (view instanceof LimitBonusSystemView) {
                            discountType = DiscountSystemDAO.SystemType.LIMIT_BONUS_SYSTEM;
                            daoClass = LimitBonusSystemDAO.class;
                        } else if (view instanceof PeriodicImpactsBonusSystemView) {
                            discountType = DiscountSystemDAO.SystemType.PERIODIC_IMPACTS_BONUS_SYSTEM;
                            daoClass = PeriodicImpactsBonusSystemDAO.class;
                        } else if (view instanceof SecondSystemView) {
                            discountType = DiscountSystemDAO.SystemType.SECOND_SYSTEM;
                            daoClass = SecondSystemDAO.class;
                        }
                        if (discountType != null) {
                            EnversRevEntity revisionEntity = (EnversRevEntity)selection.getFirstElement();
                            CustomSystemTreeViewer systemTree = (CustomSystemTreeViewer)view.getSite().getSelectionProvider();
                            DiscountSystemDAO dao = Activator.getDefault().getBeanByClass(daoClass);
                            DiscountSystem revision = dao.getRevisionDiscountSystem(discountType, revisionEntity.getId());
                            ILabelProvider labelProvider = (ILabelProvider)systemTree.getLabelProvider();
                            ITreeContentProvider contentProvider = (ITreeContentProvider)systemTree.getContentProvider();
                            DiscountSystem current = ((DiscountSystemContentProvider)contentProvider).getCurrentSystem();
                            CompareConfiguration configuration = new CompareConfiguration();
                            configuration.setRightLabel("\u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435");
                            configuration.setLeftLabel(String.format("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 %d \u0440\u0435\u0432\u0438\u0437\u0438\u0438", revisionEntity.getId()));
                            CompareUI.openCompareDialog((CompareEditorInput)new CompareInput(revision, current, labelProvider, contentProvider, configuration));
                        }
                    }
                    catch (Exception exception) {
                        log.error("Execution error: {}", (Throwable)exception);
                    }
                }
            }
        };
        showHistoryDialogAction.setEnabled(false);
        ArrayList customActions = new ArrayList();
        Collections.addAll(customActions, openRevisionDiscountAction, showHistoryDialogAction);
        ((TableViewer)this.getViewer()).addSelectionChangedListener(new ISelectionChangedListener((IAction)openRevisionDiscountAction, (IAction)showHistoryDialogAction){
            private final /* synthetic */ IAction val$openRevisionDiscountAction;
            private final /* synthetic */ IAction val$showHistoryDialogAction;
            {
                this.val$openRevisionDiscountAction = iAction;
                this.val$showHistoryDialogAction = iAction2;
            }

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabled = !event.getSelection().isEmpty();
                this.val$openRevisionDiscountAction.setEnabled(enabled);
                this.val$showHistoryDialogAction.setEnabled(enabled);
            }
        });
        ((TableViewer)this.getViewer()).addDoubleClickListener(new IDoubleClickListener((IAction)openRevisionDiscountAction){
            private final /* synthetic */ IAction val$openRevisionDiscountAction;
            {
                this.val$openRevisionDiscountAction = iAction;
            }

            public void doubleClick(DoubleClickEvent event) {
                this.val$openRevisionDiscountAction.run();
            }
        });
        this.commonActionGroup = new DirectoryEditActionGroup(EnversRevEntity.class, customActions).removeAction(new String[]{"ru.ssa.artixadmin.action.DirectoryAddAction", "ru.ssa.artixadmin.action.DirectoryEditAction", "ru.ssa.artixadmin.action.DirectoryCopyAction", "ru.ssa.artixadmin.action.DirectoryRemoveAction"});
        this.commonActionGroup.fillActionBars(this.getViewSite().getActionBars());
        this.commonActionGroup.setEnabledEditGroupActions(Boolean.valueOf(false));
        super.createPartControl(parent);
        this.restoreState();
    }
}

