/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.views;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.nebula.widgets.ganttchart.AdvancedTooltip;
import org.eclipse.nebula.widgets.ganttchart.ColorCache;
import org.eclipse.nebula.widgets.ganttchart.DefaultSettings;
import org.eclipse.nebula.widgets.ganttchart.GanttChart;
import org.eclipse.nebula.widgets.ganttchart.GanttEvent;
import org.eclipse.nebula.widgets.ganttchart.IGanttEventListener;
import org.eclipse.nebula.widgets.ganttchart.ISettings;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.discountmanager.views.DiscountGanttEventListener;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaignGroup;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem;
import su.artix.yuki.directory.Directory;

public class DiscountGanttChartViewPanel
extends Composite {
    private static final Logger log = LoggerFactory.getLogger(DiscountGanttChartViewPanel.class);
    public static final Color ACTIVE_NOW_COLOR = ColorCache.getColor((int)0, (int)100, (int)0);
    public static final Color ACTIVE_NOW_GRADIENT_COLOR = ColorCache.getColor((int)160, (int)210, (int)181);
    public static final Color ACTIVE_COLOR = ColorCache.getColor((int)70, (int)70, (int)70);
    public static final Color ACTIVE_GRADIENT_COLOR = ColorCache.getColor((int)140, (int)140, (int)140);
    public static final Color NOT_ACTIVE_COLOR = ColorCache.getColor((int)170, (int)170, (int)170);
    public static final Color NOT_ACTIVE_GRADIENT_COLOR = ColorCache.getColor((int)230, (int)230, (int)230);
    private DiscountSystem system;
    private GanttChart ganttChart;
    private HashMap<String, List<ViewerFilter>> filters;
    private String activeParentId;

    public DiscountGanttChartViewPanel(Composite parent, int style) {
        super(parent, style);
        this.createContent();
    }

    public void refresh() {
        if (!this.isDisposed()) {
            this.ganttChart.getGanttComposite().clearChart();
            if (this.system != null && this.system.getCampaignGroup() != null) {
                this.createGanttEvent(this.ganttChart, this.system.getCampaignGroup());
            }
        }
    }

    protected void createContent() {
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo((Composite)this);
        this.ganttChart = new GanttChart((Composite)this, 2048, (ISettings)new DefaultSettings(){

            public boolean lockHeaderOnVerticalScroll() {
                return true;
            }
        });
        this.ganttChart.addGanttEventListener((IGanttEventListener)new DiscountGanttEventListener());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.ganttChart);
    }

    protected void createGanttEvent(GanttChart ganttChart, DiscountCampaignGroup campaignGroup) {
        if (ganttChart != null && campaignGroup != null) {
            for (DiscountCampaign campaign : campaignGroup.getDiscountCampaigns()) {
                this.createGanttEvent(ganttChart, campaign);
            }
            for (DiscountCampaignGroup subGroup : campaignGroup.getSubGroups()) {
                this.createGanttEvent(ganttChart, subGroup);
            }
        }
    }

    protected GanttEvent createGanttEvent(GanttChart ganttChart, DiscountCampaign campaign) {
        if (ganttChart != null && campaign != null && this.inFilter(campaign)) {
            Calendar begin = Calendar.getInstance();
            if (campaign.getBeginDate() != null) {
                begin.setTime(campaign.getBeginDate());
            } else {
                begin.add(5, -365);
            }
            Calendar end = Calendar.getInstance();
            if (campaign.getEndDate() != null) {
                end.setTime(campaign.getEndDate());
            } else {
                end.add(5, 365);
            }
            log.trace("create event {}", (Object)campaign.getName());
            GanttEvent event = new GanttEvent(ganttChart, campaign.getName(), begin, end, 0);
            event.setData((Object)campaign);
            event.setTextDisplayFormat("#name#");
            event.setMoveable(false);
            event.setResizable(false);
            String contentTooltip = "\u0412\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435: " + Directory.interactionDiscountCampaignType.getDisplayValue((Object)campaign.getDiscountInteraction());
            AdvancedTooltip at = new AdvancedTooltip(campaign.getName(), contentTooltip);
            event.setAdvancedTooltip(at);
            event.setHorizontalTextLocation(0x1000000);
            event.setVerticalTextLocation(128);
            event.setShowBoldText(true);
            if (campaign.getActive().booleanValue()) {
                if (campaign.isActiveNow()) {
                    event.setStatusColor(ACTIVE_NOW_COLOR);
                    event.setGradientStatusColor(ACTIVE_NOW_GRADIENT_COLOR);
                } else {
                    event.setStatusColor(ACTIVE_COLOR);
                    event.setGradientStatusColor(ACTIVE_GRADIENT_COLOR);
                }
            } else {
                event.setStatusColor(NOT_ACTIVE_COLOR);
                event.setGradientStatusColor(NOT_ACTIVE_GRADIENT_COLOR);
            }
            return event;
        }
        return null;
    }

    private boolean inFilter(DiscountCampaign campaign) {
        boolean result = true;
        if (this.filters != null && this.filters.containsKey(this.activeParentId)) {
            for (ViewerFilter filter : this.filters.get(this.activeParentId)) {
                if (filter.select(null, null, (Object)campaign)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public void setDiscountSystem(DiscountSystem system) {
        this.system = system;
    }

    public void addFilter(String parentViewId, ViewerFilter filter) {
        if (this.filters == null) {
            this.filters = new HashMap();
        }
        if (!this.filters.containsKey(parentViewId)) {
            this.filters.put(parentViewId, new ArrayList());
        }
        this.filters.get(parentViewId).add(filter);
        this.refresh();
    }

    public void removeFilter(String parentViewId, ViewerFilter filter) {
        Assert.isNotNull((Object)filter);
        if (this.filters != null && this.filters.containsKey(parentViewId)) {
            this.filters.get(parentViewId).remove(filter);
            this.refresh();
        }
    }

    public void setActiveParentId(String activeParentId) {
        this.activeParentId = activeParentId;
    }
}

