/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.nebula.widgets.ganttchart.AdvancedTooltip;
import org.eclipse.nebula.widgets.ganttchart.AdvancedTooltipDialog;
import org.eclipse.nebula.widgets.ganttchart.ColorCache;
import org.eclipse.nebula.widgets.ganttchart.Constants;
import org.eclipse.nebula.widgets.ganttchart.DateHelper;
import org.eclipse.nebula.widgets.ganttchart.GanttChart;
import org.eclipse.nebula.widgets.ganttchart.GanttConnection;
import org.eclipse.nebula.widgets.ganttchart.GanttDateTip;
import org.eclipse.nebula.widgets.ganttchart.GanttEvent;
import org.eclipse.nebula.widgets.ganttchart.GanttGroup;
import org.eclipse.nebula.widgets.ganttchart.GanttMap;
import org.eclipse.nebula.widgets.ganttchart.GanttPhase;
import org.eclipse.nebula.widgets.ganttchart.GanttSection;
import org.eclipse.nebula.widgets.ganttchart.GanttSpecialDateRange;
import org.eclipse.nebula.widgets.ganttchart.GanttToolTip;
import org.eclipse.nebula.widgets.ganttchart.HorizontalScrollbarHandler;
import org.eclipse.nebula.widgets.ganttchart.IColorManager;
import org.eclipse.nebula.widgets.ganttchart.IGanttChartItem;
import org.eclipse.nebula.widgets.ganttchart.IGanttEventListener;
import org.eclipse.nebula.widgets.ganttchart.ILanguageManager;
import org.eclipse.nebula.widgets.ganttchart.IPaintManager;
import org.eclipse.nebula.widgets.ganttchart.ISettings;
import org.eclipse.nebula.widgets.ganttchart.ViewPortHandler;
import org.eclipse.nebula.widgets.ganttchart.dnd.VerticalDragDropManager;
import org.eclipse.nebula.widgets.ganttchart.undoredo.GanttUndoRedoManager;
import org.eclipse.nebula.widgets.ganttchart.undoredo.commands.ClusteredCommand;
import org.eclipse.nebula.widgets.ganttchart.undoredo.commands.IUndoRedoCommand;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tracker;

public final class GanttComposite
extends Canvas
implements MouseListener,
MouseMoveListener,
MouseTrackListener,
KeyListener {
    public static int _osType = 0;
    private final GanttChart _parentChart;
    private int _autoScrollDir = 0;
    private boolean _showZoomHelper;
    private Rectangle _zoomLevelArea;
    private int _zoomLevel;
    private boolean _zoomLevelChanged;
    private boolean _forceSBUpdate;
    private int _currentView;
    private boolean _threeDee;
    private boolean _showNumDays;
    private boolean _showPlannedDates;
    private final int _calStartOffset;
    private final int _moveAreaInsets;
    private int _yearDayWidth;
    private int _monthDayWidth;
    private int _monthWeekWidth;
    private int _dayWidth;
    private int _weekWidth;
    private int _bottomMostY;
    private Color _lineTodayColor;
    private Color _lineColor;
    private Color _lineWkDivColor;
    private Color _textColor;
    private Color _satBGColorTop;
    private Color _satBGColorBottom;
    private Color _weekdayTextColor;
    private Color _satTextColor;
    private Color _sunTextColor;
    private Color _sunBGColorTop;
    private Color _sunBGColorBottom;
    private Color _wkBGColorTop;
    private Color _wkBGColorBottom;
    private Color _txtHeaderBGColorTop;
    private Color _txtHeaderBGColorBottom;
    private Color _timeHeaderBGColorTop;
    private Color _timeHeaderBGColorBottom;
    private Color _phaseHeaderBGColorTop;
    private Color _phaseHeaderBGColorBottom;
    private Color _arrowColor;
    private Color _reverseArrowColor;
    private Color _todayBGColorTop;
    private Color _todayBGColorBottom;
    private final List _selectedEvents;
    private Calendar _mainCalendar;
    private Calendar _endCalendar;
    private int _daysVisible;
    private int _hoursVisible;
    private final List _ganttEvents;
    private final List _ganttConnections;
    private final Map _dayLetterStringExtentMap;
    private boolean _dragging = false;
    private boolean _resizing = false;
    private Point _dragStartLoc;
    private boolean _freeDragging = false;
    private int _vDragDir = 0;
    private int _lastX;
    private int _lastY;
    private int _cursor;
    private List _dragEvents;
    private GanttPhase _dragPhase;
    private boolean _lastLeft = false;
    private Calendar _dragStartDate = null;
    private boolean _justStartedMoveOrResize = false;
    private int _initialHoursDragOffset = 0;
    private final ISettings _settings;
    private final IColorManager _colorManager;
    private final IPaintManager _paintManager;
    private final ILanguageManager _languageManager;
    private final List _eventListeners;
    private boolean _mouseIsDown;
    private Point _mouseDragStartLocation;
    private final List _ganttGroups;
    private final List _ganttSections;
    private Menu _rightClickMenu;
    private boolean _useAdvTooltips;
    private boolean _useAlpha;
    private Rectangle _mainBounds;
    private Rectangle _visibleBounds;
    private final Locale _defaultLocale;
    private final int _eventHeight;
    private boolean _recalcScopes = true;
    private boolean _recalcSecBounds = true;
    private final Set _allEventsCombined;
    private final List _verticalLineLocations;
    private final Set _verticalWeekDividerLineLocations;
    private final Set _hiddenLayers;
    private final Map _layerOpacityMap;
    private int _eventSpacer;
    private int _fixedRowHeight;
    private boolean _drawVerticalLines;
    private boolean _drawHorizontalLines;
    private int _lockedHeaderY;
    private int _vScrollPos;
    private final Point _origin = new Point(0, 0);
    private int _lastVScrollPos;
    private ScrollBar _vScrollBar;
    private List _selHeaderDates;
    private final int _style;
    private Tracker _tracker;
    private final boolean _multiSelect;
    private Calendar _dDayCalendar;
    private HorizontalScrollbarHandler _hScrollHandler;
    private ViewPortHandler _viewPortHandler;
    private boolean _savingChartImage = false;
    private final List _ganttPhases;
    private final List _specDateRanges;
    private final Map _stringWidthCache;
    private int _totVisEventCnt;
    private final VerticalDragDropManager _vDNDManager;
    private final GanttUndoRedoManager _undoRedoManager;
    private boolean _drawToMinute;
    private int _daysToAppendForEndOfDay;

    public GanttComposite(GanttChart parent, int style, ISettings settings, IColorManager colorManager, IPaintManager paintManager, ILanguageManager languageManager) {
        super((Composite)parent, 537133824);
        this._parentChart = parent;
        if (settings.getInitialView() == 5) {
            this._dDayCalendar = DateHelper.getNewCalendar(settings.getDDayRootCalendar());
        }
        this.startMidnightThread();
        this._style = style;
        this._multiSelect = (this._style & 2) != 0;
        this._settings = settings;
        this._colorManager = colorManager;
        this._paintManager = paintManager;
        this._languageManager = languageManager;
        this._ganttConnections = new ArrayList();
        this._dragEvents = new ArrayList();
        this._eventListeners = new ArrayList();
        this._ganttEvents = new ArrayList();
        this._ganttGroups = new ArrayList();
        this._ganttSections = new ArrayList();
        this._verticalLineLocations = new ArrayList();
        this._verticalWeekDividerLineLocations = new HashSet();
        this._hiddenLayers = new HashSet();
        this._allEventsCombined = new HashSet();
        this._dayLetterStringExtentMap = new HashMap();
        this._layerOpacityMap = new HashMap();
        this._selHeaderDates = new ArrayList();
        this._selectedEvents = new ArrayList();
        this._ganttPhases = new ArrayList();
        this._specDateRanges = new ArrayList();
        this._stringWidthCache = new HashMap();
        this._defaultLocale = this._settings.getDefaultLocale();
        DateHelper.initialize(this._defaultLocale);
        this._useAdvTooltips = this._settings.getUseAdvancedTooltips();
        this._currentView = this._settings.getInitialView();
        this._zoomLevel = this._settings.getInitialZoomLevel();
        this._showNumDays = this._settings.showNumberOfDaysOnBars();
        this._showPlannedDates = this._settings.showPlannedDates();
        this._threeDee = this._settings.showBarsIn3D();
        this._yearDayWidth = this._settings.getYearMonthDayWidth();
        this._monthDayWidth = this._settings.getMonthDayWidth();
        this._monthWeekWidth = this._monthDayWidth * 7;
        this._dayWidth = this._settings.getDayWidth();
        this._weekWidth = this._dayWidth * 7;
        this._calStartOffset = this._settings.getCalendarStartupDateOffset();
        this._mainCalendar = this._settings.getStartupCalendarDate();
        this._moveAreaInsets = this._settings.getMoveAreaNegativeSensitivity();
        this._eventSpacer = this._settings.getEventSpacer();
        this._eventHeight = this._settings.getEventHeight();
        this._daysToAppendForEndOfDay = this._settings.getNumberOfDaysToAppendForEndOfDay();
        this._drawHorizontalLines = this._settings.drawHorizontalLines();
        this._drawVerticalLines = this._settings.drawVerticalLines();
        this._vDNDManager = new VerticalDragDropManager();
        this._undoRedoManager = new GanttUndoRedoManager(this, 50);
        this._drawToMinute = this._settings.drawEventsDownToTheHourAndMinute();
        this.updateZoomLevel();
        if (this._currentView == 5) {
            this._mainCalendar = DateHelper.getNewCalendar(this._dDayCalendar);
        }
        this.setDate(this._mainCalendar, true, false);
        this.setLayout((Layout)new FillLayout());
        this.initColors();
        this.initListeners();
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (GanttComposite.this.isDisposed()) {
                    return;
                }
                GanttComposite.this.updateVerticalScrollBar(false);
                GanttComposite.this.updateHorizontalScrollbar();
            }
        });
    }

    private void startMidnightThread() {
        this._parentChart.getDisplay().timerExec(60000, new Runnable(){

            public void run() {
                try {
                    if (GanttComposite.this.isDisposed()) {
                        return;
                    }
                    Calendar cal = Calendar.getInstance(GanttComposite.this._settings.getDefaultLocale());
                    if (cal.get(11) == 0 && cal.get(12) == 0) {
                        GanttComposite.this.redraw();
                        DateHelper.initialize(GanttComposite.this._settings.getDefaultLocale());
                    }
                    if (GanttComposite.this.getDisplay() != null && !GanttComposite.this.getDisplay().isDisposed()) {
                        GanttComposite.this.getDisplay().timerExec(60000, (Runnable)this);
                    }
                }
                catch (Exception err) {
                    SWT.error((int)1, (Throwable)err);
                }
            }
        });
    }

    private void initListeners() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GanttComposite.this.repaint(event);
            }
        });
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseTrackListener(this);
        this.addKeyListener(this);
        Listener mouseWheelListner = new Listener(){

            public void handleEvent(Event event) {
                if (!GanttComposite.this._settings.enableZooming()) {
                    return;
                }
                if (event.stateMask == GanttComposite.this._settings.getZoomWheelModifierKey()) {
                    GanttComposite.this._showZoomHelper = GanttComposite.this._settings.showZoomLevelBox();
                    if (event.count > 0) {
                        GanttComposite.this.zoomIn(true, new Point(event.x, event.y));
                    } else {
                        GanttComposite.this.zoomOut(true, new Point(event.x, event.y));
                    }
                } else if (GanttComposite.this._settings.scrollChartVerticallyOnMouseWheel()) {
                    GanttComposite.this.vScroll(event);
                }
            }
        };
        this.addListener(37, mouseWheelListner);
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                if (event.stateMask == 65536 || event.keyCode == 65536) {
                    GanttComposite.this.killDialogs();
                }
            }

            public void keyReleased(KeyEvent event) {
                if (GanttComposite.this._tracker != null && !GanttComposite.this._tracker.isDisposed()) {
                    GanttComposite.this._tracker.dispose();
                    GanttComposite.this._mouseIsDown = false;
                }
                if (GanttComposite.this._showZoomHelper) {
                    GanttComposite.this._showZoomHelper = false;
                    if (GanttComposite.this._zoomLevelArea != null) {
                        GanttComposite.this.redraw(((GanttComposite)GanttComposite.this)._zoomLevelArea.x, ((GanttComposite)GanttComposite.this)._zoomLevelArea.y, ((GanttComposite)GanttComposite.this)._zoomLevelArea.width + 1, ((GanttComposite)GanttComposite.this)._zoomLevelArea.height + 1, false);
                    }
                }
            }
        });
        this._viewPortHandler = new ViewPortHandler(this);
        this._hScrollHandler = new HorizontalScrollbarHandler(this, this.getHorizontalBar(), this._style);
        this._vScrollBar = this.getVerticalBar();
        this._vScrollBar.setPageIncrement(this._settings.getEventHeight() + this._settings.getEventSpacer());
        this._vScrollBar.setIncrement(this._settings.getEventHeight());
        this._vScrollBar.setVisible(false);
        this._vScrollBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GanttComposite.this.vScroll(event);
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GanttComposite.this.handleResize(false);
                GanttComposite.this.updateHorizontalScrollbar();
                GanttComposite.this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (GanttComposite.this.isDisposed()) {
                            return;
                        }
                        GanttComposite.this.redraw();
                    }
                });
            }
        });
    }

    private void vScroll(Event event) {
        int vSelection;
        if (event != null && event.detail == 0) {
            this.killDialogs();
            return;
        }
        if (!this._vScrollBar.isVisible()) {
            this._vScrollPos = 0;
            return;
        }
        this._vScrollPos = vSelection = this._vScrollBar.getSelection();
        int diff = this._vScrollPos - this._lastVScrollPos;
        this._lastVScrollPos = this._vScrollPos;
        this.moveYBounds(diff);
        this._recalcSecBounds = true;
        this.redraw();
    }

    void updateVerticalScrollBar(boolean redraw) {
        this.handleResize(redraw);
    }

    private void handleResize(boolean redraw) {
        Rectangle rect = this.getBounds();
        Rectangle client = this.getClientArea();
        this._vScrollBar.setMaximum(rect.height);
        this._vScrollBar.setPageIncrement(15);
        this._vScrollBar.setThumb(Math.min(rect.height, client.height));
        int vPage = rect.height - client.height;
        int vSelection = this._vScrollBar.getSelection();
        if (vSelection >= vPage) {
            if (vPage <= 0) {
                vSelection = 0;
            }
            this._origin.y = -vSelection;
        }
        if (this._bottomMostY < this.getClientArea().height) {
            if (this._vScrollBar.isVisible()) {
                this._vScrollBar.setVisible(false);
                if (this._vScrollPos != 0) {
                    this.moveYBounds(-this._vScrollPos);
                    this._vScrollPos = 0;
                }
            }
        } else {
            this._vScrollBar.setVisible(true);
        }
        if (this._endCalendar != null) {
            this.updateEventVisibilities(client);
        }
        this._recalcSecBounds = true;
        if (redraw) {
            this.redraw();
        }
    }

    private void initColors() {
        this._lineTodayColor = this._colorManager.getTodayLineColor();
        this._lineColor = this._colorManager.getLineColor();
        this._textColor = this._colorManager.getTextColor();
        this._satTextColor = this._colorManager.getSaturdayTextColor();
        this._satBGColorTop = this._colorManager.getSaturdayBackgroundColorTop();
        this._satBGColorBottom = this._colorManager.getSaturdayBackgroundColorBottom();
        this._sunBGColorTop = this._colorManager.getSundayBackgroundColorTop();
        this._sunBGColorBottom = this._colorManager.getSundayBackgroundColorBottom();
        this._weekdayTextColor = this._colorManager.getWeekdayTextColor();
        this._sunTextColor = this._colorManager.getSundayTextColor();
        this._satTextColor = this._colorManager.getSaturdayTextColor();
        this._wkBGColorTop = this._colorManager.getWeekdayBackgroundColorTop();
        this._wkBGColorBottom = this._colorManager.getWeekdayBackgroundColorBottom();
        this._lineWkDivColor = this._colorManager.getWeekDividerLineColor();
        this._txtHeaderBGColorTop = this._colorManager.getTextHeaderBackgroundColorTop();
        this._txtHeaderBGColorBottom = this._colorManager.getTextHeaderBackgroundColorBottom();
        this._timeHeaderBGColorTop = this._colorManager.getTimeHeaderBackgroundColorTop();
        this._timeHeaderBGColorBottom = this._colorManager.getTimeHeaderBackgroundColorBottom();
        this._phaseHeaderBGColorTop = this._colorManager.getPhaseHeaderBackgroundColorTop();
        this._phaseHeaderBGColorBottom = this._colorManager.getPhaseHeaderBackgroundColorBottom();
        this._arrowColor = this._colorManager.getArrowColor();
        this._reverseArrowColor = this._colorManager.getReverseArrowColor();
        this._todayBGColorTop = this._colorManager.getTodayBackgroundColorTop();
        this._todayBGColorBottom = this._colorManager.getTodayBackgroundColorBottom();
        this._useAlpha = this._colorManager.useAlphaDrawing();
    }

    public Calendar getDate() {
        return DateHelper.getNewCalendar(this._mainCalendar);
    }

    public Calendar getRootCalendar() {
        return this._mainCalendar;
    }

    public Calendar getRootEndCalendar() {
        return this._endCalendar;
    }

    public void hideLayer(int layer) {
        if (!this._hiddenLayers.contains(new Integer(layer))) {
            this._hiddenLayers.add(new Integer(layer));
        }
    }

    public void showLayer(int layer) {
        boolean removed = this._hiddenLayers.remove(new Integer(layer));
        if (removed) {
            this.redrawEventsArea();
        }
    }

    public void redraw(Rectangle rect) {
        this.redraw(rect.x, rect.y, rect.width, rect.height, false);
    }

    public void showAllLayers() {
        if (this._hiddenLayers.isEmpty()) {
            return;
        }
        this._hiddenLayers.clear();
        this.redrawEventsArea();
    }

    public void hideAllLayers() {
        for (int i = 0; i < this._ganttEvents.size(); ++i) {
            GanttEvent event = (GanttEvent)this._ganttEvents.get(i);
            Integer layer = new Integer(event.getLayer());
            if (this._hiddenLayers.contains(layer)) continue;
            this._hiddenLayers.add(layer);
        }
        this.redrawEventsArea();
    }

    public void setLayerOpacity(int layer, int opacity) {
        int toSet = opacity;
        if (toSet >= 255) {
            this._layerOpacityMap.remove(new Integer(layer));
            return;
        }
        if (toSet < 0) {
            toSet = 0;
        }
        this._layerOpacityMap.put(new Integer(layer), new Integer(toSet));
        this.redrawEventsArea();
    }

    public int getLayerOpacity(int layer) {
        int ret = -1;
        if (this._layerOpacityMap.containsKey(new Integer(layer))) {
            ret = (Integer)this._layerOpacityMap.get(new Integer(layer));
        }
        return ret;
    }

    public void setFixedRowHeightOverride(int height) {
        this._fixedRowHeight = height;
    }

    public void setEventSpacerOverride(int height) {
        this._eventSpacer = height;
    }

    public void setDrawHorizontalLinesOverride(boolean drawHorizontal) {
        this._drawHorizontalLines = drawHorizontal;
    }

    public void setDrawVerticalLinesOverride(boolean drawVertical) {
        this._drawVerticalLines = drawVertical;
    }

    public void setSelection(GanttEvent event) {
        this._selectedEvents.clear();
        this._selectedEvents.add(event);
        this.redrawEventsArea();
    }

    public void setSelection(List list) {
        if (!this._multiSelect) {
            return;
        }
        this._selectedEvents.clear();
        this._selectedEvents.addAll(list);
        this.redrawEventsArea();
    }

    public void addGroup(GanttGroup group) {
        this.internalAddGroup(-1, group);
    }

    public List getGroups() {
        return this._ganttGroups;
    }

    public void removeGroup(GanttGroup group) {
        this.internalRemoveGroup(group);
    }

    public void addSection(GanttSection section) {
        this.internalAddSection(section);
    }

    public void removeSection(GanttSection section) {
        this.internalRemoveSection(section);
    }

    public List getGanttSections() {
        return this._ganttSections;
    }

    void showScrollDate() {
        if (this._settings.showDateTips() && this._settings.showDateTipsOnScrolling()) {
            String str = DateHelper.getDate(this._mainCalendar, this._currentView == 1 ? this._settings.getHourDateFormat() : this._settings.getDateFormat());
            GC gc = new GC((Drawable)this);
            Point ext = gc.stringExtent(str);
            gc.dispose();
            int bottomY = this._mainBounds.height - ext.y - 12;
            int bottomX = this._mainBounds.x + this._mainBounds.width / 2 - ext.x;
            Point point = this.toDisplay(bottomX, bottomY);
            GanttDateTip.makeDialog(this._colorManager, str, point, bottomY);
        }
    }

    public GanttEvent getTopEvent() {
        for (int i = 0; i < this._ganttEvents.size(); ++i) {
            GanttEvent event = (GanttEvent)this._ganttEvents.get(i);
            if (event.getVisibility() != 1) continue;
            return event;
        }
        return null;
    }

    public GanttEvent getBottomEvent() {
        GanttEvent top = this.getTopEvent();
        if (top == null) {
            return null;
        }
        boolean start = false;
        for (int i = 0; i < this._ganttEvents.size(); ++i) {
            GanttEvent event = (GanttEvent)this._ganttEvents.get(i);
            if (i < this._ganttEvents.size() - 1) {
                GanttEvent nextEvent = (GanttEvent)this._ganttEvents.get(i + 1);
                if (event.equals(top)) {
                    start = true;
                    continue;
                }
                if (!start || nextEvent.getVisibility() != 6) continue;
                return event;
            }
            return event;
        }
        return null;
    }

    void killDialogs() {
        if (this._settings.showToolTips()) {
            GanttToolTip.kill();
            GanttDateTip.kill();
            AdvancedTooltipDialog.kill();
        }
    }

    private void repaint(PaintEvent event) {
        this._paintManager.redrawStarting();
        GC gc = event.gc;
        this.drawChartOntoGC(gc, null);
    }

    private void drawChartOntoGC(GC gc, Rectangle boundsOverride) {
        int i;
        boolean drawSections = this.hasGanttSections();
        if (this._recalcScopes || drawSections) {
            this._bottomMostY = 0;
        }
        Rectangle bounds = super.getClientArea();
        if (boundsOverride != null) {
            bounds = boundsOverride;
        }
        this._visibleBounds = new Rectangle(bounds.x, bounds.y + this._vScrollPos, bounds.width, bounds.height);
        if (drawSections) {
            bounds = this._settings.getSectionSide() == 16384 ? new Rectangle(this._settings.getSectionBarWidth(), bounds.y, bounds.width - this._settings.getSectionBarWidth(), bounds.height) : new Rectangle(0, bounds.y, bounds.width - this._settings.getSectionBarWidth(), bounds.height);
        }
        this._mainBounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        this._lockedHeaderY = this._mainBounds.y;
        this._mainBounds.y -= this._vScrollPos;
        boolean calcHeaderOnly = this._settings.drawHeader() && this._settings.lockHeaderOnVerticalScroll() || !this._settings.drawHeader();
        this.drawHeader(gc, calcHeaderOnly);
        this.updateEventVisibilities(this._visibleBounds);
        if (drawSections) {
            GanttSection section;
            if (this._recalcSecBounds) {
                this.calculateSectionBounds(gc, bounds);
            }
            if (this._settings.drawFillsToBottomWhenUsingGanttSections()) {
                Rectangle extraBounds = new Rectangle(this._mainBounds.x, this._mainBounds.y + this.getHeaderHeight() - this._vScrollPos, this._mainBounds.x + this._mainBounds.width, this._mainBounds.y + this._mainBounds.height - this.getHeaderHeight() + this._vScrollPos);
                this.drawFills(gc, extraBounds);
                this.drawVerticalLines(gc, extraBounds, false);
            }
            for (i = 0; i < this._ganttSections.size(); ++i) {
                section = (GanttSection)this._ganttSections.get(i);
                Rectangle gsBounds = section.getBounds();
                if (boundsOverride != null) {
                    gsBounds.width = boundsOverride.width;
                }
                if (this._recalcScopes) {
                    this.calculateAllScopes(gsBounds, section);
                }
                this.drawFills(gc, gsBounds, section);
                if (this.hasGanttPhases()) {
                    this.drawGanttPhases(gc, gsBounds, false, section);
                }
                if (this._drawVerticalLines) {
                    this.drawVerticalLines(gc, gsBounds, true);
                }
                if (this._drawHorizontalLines) {
                    this.drawHorizontalLines(gc, bounds);
                }
                if (this.hasSpecialDateRanges()) {
                    this.drawGanttSpecialDateRanges(gc, gsBounds, section);
                }
                this.drawEvents(gc, gsBounds, section);
            }
            this.drawConnections(gc);
            for (i = 0; i < this._ganttSections.size(); ++i) {
                section = (GanttSection)this._ganttSections.get(i);
                this._bottomMostY = Math.max(section.getBounds().y + section.getBounds().height, this._bottomMostY);
            }
        } else {
            bounds = new Rectangle(bounds.x, this.getHeaderHeight(), bounds.width, bounds.height);
            if (this._recalcScopes) {
                this.calculateAllScopes(bounds, null);
            }
            this.drawFills(gc, bounds);
            if (this.hasGanttPhases()) {
                this.drawGanttPhases(gc, bounds, false, null);
            }
            if (this._drawVerticalLines) {
                this.drawVerticalLines(gc, bounds, true);
            }
            if (this._drawHorizontalLines) {
                this.drawHorizontalLines(gc, bounds);
            }
            if (this.hasSpecialDateRanges()) {
                this.drawGanttSpecialDateRanges(gc, bounds, null);
            }
            this.drawEvents(gc, bounds);
            this.drawConnections(gc);
        }
        if (drawSections) {
            this.drawSectionColumn(gc, bounds, false, false, false, false);
        }
        if (this._settings.lockHeaderOnVerticalScroll() && this._settings.drawHeader()) {
            this.drawHeader(gc, false);
            this.drawSectionColumn(gc, bounds, true, false, true, false);
        }
        if (this._showZoomHelper && this._settings.showZoomLevelBox()) {
            this.drawZoomLevel(gc);
        }
        if (this._settings.enableLastDraw()) {
            for (i = 0; i < this._eventListeners.size(); ++i) {
                IGanttEventListener listener = (IGanttEventListener)this._eventListeners.get(i);
                listener.lastDraw(gc);
            }
        }
        this._recalcScopes = false;
        this._recalcSecBounds = false;
        if (this._zoomLevelChanged) {
            this._zoomLevelChanged = false;
            this.updateHorizontalScrollbar();
            this._hScrollHandler.resetScrollPosition();
        }
        if (this._forceSBUpdate) {
            this.updateVerticalScrollBar(true);
            this.updateHorizontalScrollbar();
            this._forceSBUpdate = false;
        }
        this.calculateVerticalInsertLocations();
        this.drawVerticalInsertMarkers(gc);
    }

    public void setShowPlannedDates(boolean showPlanned) {
        if (this._showPlannedDates == showPlanned) {
            return;
        }
        this._showPlannedDates = showPlanned;
        this.flagForceFullUpdate();
        this.redraw();
    }

    public boolean isShowingPlannedDates() {
        return this._showPlannedDates;
    }

    public void setShowDaysOnEvents(boolean showDates) {
        this._showNumDays = showDates;
        this.redraw();
    }

    public boolean isShowingDaysOnEvents() {
        return this._showNumDays;
    }

    public boolean isShowingGanttSections() {
        return !this._ganttSections.isEmpty();
    }

    private void drawHeader(GC gc, boolean calculateOnly) {
        this._verticalLineLocations.clear();
        this._verticalWeekDividerLineLocations.clear();
        Rectangle headerBounds = new Rectangle(this._mainBounds.x, this._mainBounds.y, this._mainBounds.width, this._mainBounds.height);
        if (this._settings.lockHeaderOnVerticalScroll()) {
            headerBounds.y = this._lockedHeaderY;
        }
        if (this.hasGanttPhases() && !calculateOnly) {
            this.drawGanttPhases(gc, headerBounds, true, null);
        }
        if (this._currentView == 1) {
            if (!calculateOnly) {
                this.drawHourTopBoxes(gc, headerBounds);
            }
            this.drawHourBottomBoxes(gc, headerBounds, calculateOnly);
        } else if (this._currentView == 2) {
            if (!calculateOnly) {
                this.drawWeekTopBoxes(gc, headerBounds);
            }
            this.drawWeekBottomBoxes(gc, headerBounds, calculateOnly);
        } else if (this._currentView == 3) {
            if (!calculateOnly) {
                this.drawMonthTopBoxes(gc, headerBounds);
            }
            this.drawMonthBottomBoxes(gc, headerBounds, calculateOnly);
        } else if (this._currentView == 4) {
            if (!calculateOnly) {
                this.drawYearTopBoxes(gc, headerBounds);
            }
            this.drawYearBottomBoxes(gc, headerBounds, calculateOnly);
        } else if (this._currentView == 5) {
            if (!calculateOnly) {
                this.drawDDayTopBoxes(gc, headerBounds);
            }
            this.drawDDayBottomBoxes(gc, headerBounds, calculateOnly);
        }
        if (!calculateOnly) {
            this.drawTopHorizontalLines(gc, headerBounds);
        }
    }

    private void showMenu(int x, int y, GanttEvent event, final MouseEvent me) {
        if (!this._settings.showMenuItemsOnRightClick()) {
            return;
        }
        this.killDialogs();
        if (this._rightClickMenu != null && !this._rightClickMenu.isDisposed()) {
            this._rightClickMenu.dispose();
        }
        this._rightClickMenu = new Menu((Decorations)this.getDisplay().getActiveShell(), 8);
        if (event != null) {
            Menu eventMenu = event.getMenu();
            MenuItem[] items = eventMenu.getItems();
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    final MenuItem mItem = items[i];
                    MenuItem copy = new MenuItem(this._rightClickMenu, 8);
                    copy.setText(mItem.getText());
                    copy.setImage(mItem.getImage());
                    copy.setEnabled(mItem.getEnabled());
                    copy.setAccelerator(mItem.getAccelerator());
                    copy.setData(mItem.getData());
                    copy.setSelection(mItem.getSelection());
                    copy.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            mItem.notifyListeners(13, event);
                        }
                    });
                }
            }
            if (!this._settings.showDefaultMenuItemsOnEventRightClick()) {
                this._rightClickMenu.setLocation(x, y);
                this._rightClickMenu.setVisible(true);
                return;
            }
            if (items != null && items.length > 0) {
                new MenuItem(this._rightClickMenu, 2);
            }
        }
        if (this._settings.enableZooming()) {
            MenuItem zoomIn = new MenuItem(this._rightClickMenu, 8);
            zoomIn.setText(this._languageManager.getZoomInMenuText());
            MenuItem zoomOut = new MenuItem(this._rightClickMenu, 8);
            zoomOut.setText(this._languageManager.getZoomOutMenuText());
            MenuItem zoomReset = new MenuItem(this._rightClickMenu, 8);
            zoomReset.setText(this._languageManager.getZoomResetMenuText());
            zoomIn.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    GanttComposite.this.zoomIn();
                }
            });
            zoomOut.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    GanttComposite.this.zoomOut();
                }
            });
            zoomReset.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    GanttComposite.this.resetZoom();
                }
            });
            new MenuItem(this._rightClickMenu, 2);
        }
        final MenuItem showPlaque = new MenuItem(this._rightClickMenu, 32);
        showPlaque.setText(this._languageManager.getShowNumberOfDaysOnEventsMenuText());
        showPlaque.setSelection(this._showNumDays);
        showPlaque.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GanttComposite.this._showNumDays = !GanttComposite.this._showNumDays;
                showPlaque.setSelection(GanttComposite.this._showNumDays);
                GanttComposite.this.redraw();
            }
        });
        new MenuItem(this._rightClickMenu, 2);
        final MenuItem showEsts = new MenuItem(this._rightClickMenu, 32);
        showEsts.setText(this._languageManager.getShowPlannedDatesMenuText());
        showEsts.setSelection(this._showPlannedDates);
        showEsts.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GanttComposite.this.setShowPlannedDates(!GanttComposite.this.isShowingPlannedDates());
                showEsts.setSelection(GanttComposite.this._showPlannedDates);
                GanttComposite.this.redraw();
            }
        });
        new MenuItem(this._rightClickMenu, 2);
        MenuItem showThreeDee = new MenuItem(this._rightClickMenu, 32);
        showThreeDee.setText(this._languageManager.get3DMenuText());
        showThreeDee.setSelection(this._threeDee);
        showThreeDee.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GanttComposite.this._threeDee = !GanttComposite.this._threeDee;
                GanttComposite.this.redraw();
            }
        });
        if (this._settings.showDeleteMenuOption() && event != null) {
            new MenuItem(this._rightClickMenu, 2);
            MenuItem delete = new MenuItem(this._rightClickMenu, 8);
            delete.setText(this._languageManager.getDeleteMenuText());
            delete.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    if (!GanttComposite.this._selectedEvents.isEmpty()) {
                        for (int i = 0; i < GanttComposite.this._eventListeners.size(); ++i) {
                            IGanttEventListener listener = (IGanttEventListener)GanttComposite.this._eventListeners.get(i);
                            listener.eventsDeleteRequest(GanttComposite.this._selectedEvents, me);
                        }
                    }
                }
            });
        }
        if (this._settings.showPropertiesMenuOption() && !this._selectedEvents.isEmpty()) {
            new MenuItem(this._rightClickMenu, 2);
            MenuItem properties = new MenuItem(this._rightClickMenu, 8);
            properties.setText(this._languageManager.getPropertiesMenuText());
            properties.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (!GanttComposite.this._selectedEvents.isEmpty()) {
                        for (int i = 0; i < GanttComposite.this._eventListeners.size(); ++i) {
                            IGanttEventListener listener = (IGanttEventListener)GanttComposite.this._eventListeners.get(i);
                            listener.eventPropertiesSelected(GanttComposite.this._selectedEvents);
                        }
                    }
                }
            });
        }
        this._rightClickMenu.setLocation(x, y);
        this._rightClickMenu.setVisible(true);
    }

    public List getSelectedEvents() {
        this.checkWidget();
        return this._selectedEvents;
    }

    public void setTopItem(GanttEvent ge, int yOffset, int side) {
        if (this._settings.lockHeaderOnVerticalScroll()) {
            this.vScrollToY(ge.getY() + yOffset, false);
        } else {
            int takeOff = this.getHeaderHeight();
            this.vScrollToY(ge.getY() - this._vScrollPos + yOffset - takeOff, false);
        }
        this.internalSetDate(ge.getActualStartDate(), side, true, false);
        this.redraw();
    }

    public void setTopItem(GanttEvent ge, int side) {
        this.setTopItem(ge, 0, side);
    }

    public void showEvent(GanttEvent ge, int side) {
        if (ge.getActualStartDate() == null) {
            return;
        }
        this.vScrollToY(ge.getY(), false);
        this.internalSetDate(ge.getActualStartDate(), side, true, false);
        this._recalcScopes = true;
        this._recalcSecBounds = true;
        this.redraw();
    }

    private void vScrollToY(int yPos, boolean redraw) {
        int y = yPos;
        y = this._settings.lockHeaderOnVerticalScroll() ? (y -= this.getHeaderHeight()) : (y -= this._mainBounds.y - this.getHeaderHeight());
        int max = this._vScrollBar.getMaximum() - this._vScrollBar.getThumb();
        if ((y += this._vScrollPos) < 0) {
            y = 0;
        }
        if (y > max) {
            y = max;
        }
        this._lastVScrollPos = this._vScrollPos = y;
        this._vScrollBar.setSelection(y);
        this.flagForceFullUpdate();
        if (redraw) {
            this.redraw();
        }
    }

    public Rectangle getBounds() {
        if (this._mainBounds == null) {
            return super.getBounds();
        }
        return new Rectangle(0, 0, super.getBounds().width, this._bottomMostY);
    }

    private void calculateSectionBounds(GC gc, Rectangle bounds) {
        int yStart = this.getHeaderHeight() == 0 ? bounds.y : bounds.y + this.getHeaderHeight();
        for (int i = 0; i < this._ganttSections.size(); ++i) {
            GanttSection gs = (GanttSection)this._ganttSections.get(i);
            Point extent = null;
            if (gs.needsNameUpdate() || gs.getNameExtent() == null) {
                extent = gc.textExtent(gs.getName(), 2);
                gs.setNameExtent(extent);
                gs.setNeedsNameUpdate(false);
            } else {
                extent = gs.getNameExtent();
            }
            int strHeight = extent.x;
            if (gs.getTextOrientation() == 256) {
                strHeight = extent.y;
            }
            int gsHeight = gs.getEventsHeight(this._settings);
            int height = Math.max(gsHeight, strHeight);
            if (strHeight > gsHeight) {
                height += this._settings.getSectionTextSpacer();
            }
            Rectangle gsBounds = new Rectangle(bounds.x, yStart, bounds.width, height);
            gs.setBounds(gsBounds);
            yStart += height - 1;
            yStart += this._settings.getSectionBarDividerHeight();
        }
    }

    private int getHeaderHeight() {
        if (!this._settings.drawHeader()) {
            return 0;
        }
        int ret = this._settings.getHeaderDayHeight() + this._settings.getHeaderMonthHeight() + 1;
        if (this.hasGanttPhases()) {
            ret += this._settings.getPhasesHeaderHeight();
        }
        return ret;
    }

    private void drawFills(GC gc, Rectangle bounds, GanttSection gs) {
        this.internalDrawFills(gc, bounds, gs);
    }

    private void drawFills(GC gc, Rectangle bounds) {
        this.internalDrawFills(gc, bounds, null);
    }

    private void internalDrawFills(GC gc, Rectangle bounds, GanttSection gs) {
        int dayWidth = this._currentView == 2 || this._currentView == 5 ? this._dayWidth : this._monthDayWidth;
        int maxX = bounds.width + dayWidth;
        int startX = bounds.x;
        int offset = 0;
        if (gs == null) {
            offset = this._vScrollPos;
            if (offset > this.getHeaderHeight()) {
                offset = this.getHeaderHeight();
            }
        } else {
            offset = this._vScrollPos;
        }
        int startY = bounds.y - offset;
        int heightY = gs == null ? bounds.height : gs.getBounds().height;
        switch (this._currentView) {
            case 1: {
                gc.setForeground(this.getDayBackgroundGradient(2, true, gs));
                gc.setBackground(this.getDayBackgroundGradient(2, false, gs));
                gc.fillGradientRectangle(startX, startY, maxX, heightY, true);
                return;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                gc.setForeground(this.getDayBackgroundGradient(2, true, gs));
                gc.setBackground(this.getDayBackgroundGradient(2, false, gs));
                gc.fillGradientRectangle(startX, startY, maxX, heightY, true);
                return;
            }
        }
        Calendar temp = Calendar.getInstance(this._defaultLocale);
        temp.setTime(this._mainCalendar.getTime());
        gc.setForeground(this.getDayBackgroundGradient(2, true, gs));
        gc.setBackground(this.getDayBackgroundGradient(2, false, gs));
        gc.fillGradientRectangle(startX, startY, maxX, heightY, true);
        do {
            int day = temp.get(7);
            if (this._selHeaderDates.contains(temp)) {
                gc.setForeground(this._colorManager.getSelectedDayColorTop());
                gc.setBackground(this._colorManager.getSelectedDayColorBottom());
                gc.fillGradientRectangle(startX, startY, dayWidth, heightY, true);
            } else if (this._currentView != 5) {
                if (day == 7 || day == 1) {
                    gc.setForeground(this.getDayBackgroundGradient(day, true, gs));
                    gc.setBackground(this.getDayBackgroundGradient(day, false, gs));
                    gc.fillGradientRectangle(startX, startY, dayWidth, heightY, true);
                }
                if (DateHelper.isToday(temp)) {
                    gc.setForeground(this._todayBGColorTop);
                    gc.setBackground(this._todayBGColorBottom);
                    gc.fillGradientRectangle(startX + 1, startY, dayWidth - 1, heightY, true);
                }
            }
            temp.add(5, 1);
        } while ((startX += dayWidth) <= maxX);
    }

    private void drawZoomLevel(GC gc) {
        int bottomLeftY = this._mainBounds.height - 19 - 3;
        int bottomLeftX = this._mainBounds.x + 3;
        if (!this._ganttSections.isEmpty() && this._bottomMostY < bottomLeftY) {
            bottomLeftX = 3;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this._languageManager.getZoomLevelText());
        buf.append(": ");
        if (this._zoomLevel == 0) {
            buf.append(this._languageManager.getZoomMaxText());
        } else if (this._zoomLevel == 13) {
            buf.append(this._languageManager.getZoomMinText());
        } else {
            buf.append(this._zoomLevel);
        }
        String qText = buf.toString();
        Point point = gc.stringExtent(qText);
        int helpWidth = point.x + 5;
        Rectangle outer = new Rectangle(bottomLeftX, bottomLeftY, helpWidth, 19);
        Rectangle inner = new Rectangle(bottomLeftX + 1, bottomLeftY + 1, helpWidth - 1, 18);
        this._zoomLevelArea = outer;
        gc.setForeground(this._colorManager.getZoomBackgroundColorTop());
        gc.setBackground(this._colorManager.getZoomBackgroundColorBottom());
        gc.fillGradientRectangle(inner.x, inner.y, inner.width, inner.height, true);
        gc.setForeground(this._colorManager.getZoomBorderColor());
        gc.drawRectangle(outer);
        gc.setForeground(this._colorManager.getZoomTextColor());
        gc.drawString(qText, bottomLeftX + 4, bottomLeftY + 3, true);
    }

    private void drawSectionColumn(GC gc, Rectangle bounds, boolean columnOnly, boolean forceUsageOfBounds, boolean drawCornerOnly, boolean force) {
        int bottomPos;
        int lineLoc;
        boolean rightSide;
        if (this._ganttSections.isEmpty()) {
            return;
        }
        boolean bl = rightSide = this._settings.getSectionSide() == 131072;
        if (this._savingChartImage && rightSide && !force) {
            return;
        }
        int xMax = this._settings.getSectionBarWidth() - 1;
        int horiSpacer = 3;
        for (int i = 0; i < this._ganttSections.size(); ++i) {
            GanttSection gs = (GanttSection)this._ganttSections.get(i);
            if (gs.getTextOrientation() != 256) continue;
            Point p = null;
            if (gs.needsNameUpdate() || gs.getNameExtent() == null) {
                p = gc.textExtent(gs.getName(), 2);
                gs.setNameExtent(p);
                gs.setNeedsNameUpdate(false);
            } else {
                p = gs.getNameExtent();
            }
            xMax = Math.max(xMax, p.x + 6);
        }
        int yStart = lineLoc = this.getHeaderHeight() == 0 ? bounds.y : bounds.y + this.getHeaderHeight();
        yStart -= this._vScrollPos;
        int x = 0;
        x = rightSide ? (forceUsageOfBounds ? bounds.width - xMax : super.getClientArea().width - xMax) : 0;
        int neg = 0;
        if (rightSide) {
            neg = -this._settings.getSectionBarWidth();
        }
        GanttSection bottomSection = (GanttSection)this._ganttSections.get(this._ganttSections.size() - 1);
        if (drawCornerOnly) {
            lineLoc += this._vScrollPos;
        }
        gc.setForeground(this._colorManager.getNonActiveSessionBarColorLeft());
        gc.setBackground(this._colorManager.getNonActiveSessionBarColorRight());
        int n = bottomPos = this._settings.drawGanttSectionBarToBottom() ? this._mainBounds.y + this._mainBounds.height : lineLoc;
        if (drawCornerOnly) {
            bottomPos = this.getHeaderHeight();
        }
        gc.fillGradientRectangle(x, 0, xMax + 1, bottomPos, false);
        gc.setForeground(this._colorManager.getTopHorizontalLinesColor());
        gc.drawLine(x + xMax + neg, 0, x + xMax + neg, bottomSection.getBounds().y + bottomSection.getBounds().height - 1);
        if (!drawCornerOnly) {
            for (int i = 0; i < this._ganttSections.size(); ++i) {
                GanttSection gs = (GanttSection)this._ganttSections.get(i);
                int gsHeight = gs.getBounds().height;
                gc.setForeground(this._colorManager.getActiveSessionBarColorLeft());
                gc.setBackground(this._colorManager.getActiveSessionBarColorRight());
                gc.fillGradientRectangle(x, yStart, xMax, gsHeight, false);
                gc.setForeground(this._textColor);
                if (gs.getTextOrientation() == 512) {
                    Image image = null;
                    int xStart = xMax / 2;
                    if (gs.getNameImage() == null || gs.needsNameUpdate()) {
                        Point extent = null;
                        if (gs.needsNameUpdate() || gs.getNameExtent() == null) {
                            extent = gc.textExtent(gs.getName(), 2);
                            gs.setNameExtent(extent);
                            gs.setNeedsNameUpdate(false);
                        } else {
                            extent = gs.getNameExtent();
                        }
                        if (extent.x == 0) {
                            extent.x = 1;
                        }
                        Image textImage = new Image((Device)this.getDisplay(), extent.x, xMax - 2);
                        GC gcTemp = new GC((Drawable)textImage);
                        if (rightSide) {
                            gcTemp.setForeground(this._colorManager.getActiveSessionBarColorRight());
                            gcTemp.setBackground(this._colorManager.getActiveSessionBarColorLeft());
                        } else {
                            gcTemp.setForeground(this._colorManager.getActiveSessionBarColorLeft());
                            gcTemp.setBackground(this._colorManager.getActiveSessionBarColorRight());
                        }
                        gcTemp.fillGradientRectangle(0, 0, extent.x, xMax - 2, true);
                        gcTemp.setForeground(this._textColor);
                        gcTemp.drawText(gs.getName(), 0, 0, true);
                        gcTemp.dispose();
                        ImageData id = textImage.getImageData();
                        image = new Image((Device)this.getDisplay(), GanttComposite.rotate(id, rightSide ? 131072 : 16384));
                        gs.setNameImage(image);
                    } else {
                        image = gs.getNameImage();
                    }
                    int textLocY = gsHeight / 2 - image.getBounds().height / 2;
                    gc.drawImage(image, x + (xStart -= image.getBounds().width / 2 - 2) - 1, yStart + textLocY);
                } else if (gs.getTextOrientation() == 256) {
                    gc.drawText(gs.getName(), 3, yStart + gsHeight / 2 - gs.getNameExtent().y / 2, true);
                }
                yStart += gsHeight - 1;
                int width = bounds.x + bounds.width;
                if (rightSide && !forceUsageOfBounds) {
                    width = super.getClientArea().width;
                }
                if (columnOnly) continue;
                gc.setForeground(this._colorManager.getTopHorizontalLinesColor());
                if (i != this._ganttSections.size() - 1 && this._settings.getSectionBarDividerHeight() != 0) {
                    gc.setForeground(this._colorManager.getSessionBarDividerColorLeft());
                    gc.setBackground(this._colorManager.getSessionBarDividerColorRight());
                    gc.fillGradientRectangle(0, yStart, width, this._settings.getSectionBarDividerHeight(), false);
                    gc.setForeground(this._colorManager.getTopHorizontalLinesColor());
                    gc.drawLine(0, yStart, width, yStart);
                    gc.drawLine(0, (yStart += this._settings.getSectionBarDividerHeight()) - 1, width, yStart - 1);
                    continue;
                }
                gc.drawLine(0, yStart, width, yStart);
                yStart += this._settings.getSectionBarDividerHeight();
            }
        }
        gc.setForeground(this._colorManager.getTopHorizontalLinesColor());
        if (this._settings.drawHeader()) {
            gc.drawLine(x, bounds.y, x + xMax, bounds.y);
        }
        gc.drawLine(x, lineLoc - this._vScrollPos, x + xMax, lineLoc - this._vScrollPos);
    }

    private void drawHorizontalLines(GC gc, Rectangle bounds) {
        gc.setForeground(this._lineColor);
        ArrayList<GanttGroup> usedGroups = new ArrayList<GanttGroup>();
        for (int i = 0; i < this._ganttEvents.size(); ++i) {
            int y;
            GanttEvent ge = (GanttEvent)this._ganttEvents.get(i);
            if (ge.isHidden()) continue;
            int yExtra = ge.isAutomaticRowHeight() ? 0 : ge.getFixedRowHeight();
            yExtra -= this._vScrollPos;
            if (ge.getGanttGroup() != null) {
                if (usedGroups.contains(ge.getGanttGroup())) continue;
                usedGroups.add(ge.getGanttGroup());
            }
            if (ge.isAutomaticRowHeight()) {
                yExtra += this._eventSpacer / 2;
            }
            gc.drawLine(bounds.x, ge.getHorizontalLineBottomY() + yExtra, bounds.x + bounds.width, ge.getHorizontalLineBottomY() + yExtra);
            if (i != this._ganttEvents.size() - 1 || (y = ge.getHorizontalLineBottomY() - this._eventSpacer) <= ge.getHorizontalLineBottomY() + yExtra) continue;
            if (!ge.isAutomaticRowHeight()) {
                y += ge.getFixedRowHeight();
            }
            gc.drawLine(bounds.x, y, bounds.x + bounds.width, y);
        }
    }

    private void drawVerticalLines(GC gc, Rectangle bounds, boolean applyVscroll) {
        int yStart = bounds.y - (applyVscroll ? this._vScrollPos : 0);
        int height = bounds.height + yStart - 1 + (applyVscroll ? this._vScrollPos : 0);
        if (this._currentView == 2 || this._currentView == 3 || this._currentView == 1 || this._currentView == 5) {
            gc.setForeground(this._lineColor);
            for (int i = 0; i < this._verticalLineLocations.size(); ++i) {
                int current = (Integer)this._verticalLineLocations.get(i);
                gc.drawLine(current, yStart, current, height);
            }
            gc.setForeground(this._lineWkDivColor);
            Object[] weekLocs = this._verticalWeekDividerLineLocations.toArray();
            if (this._useAlpha) {
                gc.setAlpha(this._colorManager.getWeekDividerAlpha());
            }
            for (int i = 0; i < weekLocs.length; ++i) {
                int current = (Integer)weekLocs[i];
                gc.drawLine(current, yStart, current, height);
            }
            if (this._useAlpha) {
                gc.setAlpha(255);
                gc.setAdvanced(false);
            }
            Calendar today = Calendar.getInstance(this._defaultLocale);
            this.drawTodayLine(gc, bounds, this.getStartingXFor(today), today.get(7));
        } else if (this._currentView == 4) {
            for (int i = 0; i < this._verticalLineLocations.size(); ++i) {
                gc.setForeground(this._lineWkDivColor);
                int x = (Integer)this._verticalLineLocations.get(i);
                gc.drawLine(x, yStart, x, height);
            }
            Calendar today = Calendar.getInstance(this._defaultLocale);
            this.drawTodayLine(gc, bounds, this.getStartingXFor(today), today.get(7));
        }
    }

    private void drawYearBottomBoxes(GC gc, Rectangle bounds, boolean calculateOnly) {
        int monthMax;
        int xMax = bounds.width + bounds.x;
        int current = bounds.x;
        int topY = bounds.y + this._settings.getHeaderMonthHeight();
        int heightY = this._settings.getHeaderDayHeight();
        this._daysVisible = 0;
        Calendar temp = Calendar.getInstance(this._defaultLocale);
        temp.setTime(this._mainCalendar.getTime());
        temp.set(5, 1);
        gc.setForeground(this._txtHeaderBGColorTop);
        gc.setBackground(this._txtHeaderBGColorBottom);
        gc.fillGradientRectangle(0, topY, xMax, heightY, true);
        gc.setBackground(this._wkBGColorTop);
        do {
            if (temp.get(5) == 1) {
                this._verticalLineLocations.add(new Integer(current));
                if (!calculateOnly) {
                    gc.setForeground(this._colorManager.getYearTimeDividerColor());
                    gc.drawLine(current, topY, current, topY + heightY);
                    gc.setForeground(this._textColor);
                    gc.drawString(this.getDateString(temp, false), current + 4, topY + 3, true);
                }
            }
            monthMax = temp.getActualMaximum(5);
            this._daysVisible += monthMax;
            temp.add(2, 1);
        } while ((current += this._yearDayWidth * monthMax) <= xMax);
        this._endCalendar = temp;
    }

    private void drawYearTopBoxes(GC gc, Rectangle bounds) {
        int monthMax;
        int xMax = bounds.width + bounds.x;
        int current = bounds.x;
        int topY = bounds.y;
        int bottomY = this._settings.getHeaderMonthHeight();
        Calendar temp = Calendar.getInstance(this._defaultLocale);
        temp.setTime(this._mainCalendar.getTime());
        temp.set(5, 1);
        gc.setForeground(this._txtHeaderBGColorTop);
        gc.setBackground(this._txtHeaderBGColorBottom);
        gc.fillGradientRectangle(current, topY + 1, xMax, bottomY - 1, true);
        int lastYear = -1;
        do {
            if (temp.get(1) != lastYear) {
                gc.setForeground(this._colorManager.getTickMarkColor());
                gc.drawLine(current, topY + this._settings.getVerticalTickMarkOffset(), current, topY + this._settings.getHeaderDayHeight());
                gc.setForeground(this._textColor);
                gc.drawString(this.getDateString(temp, true), current + 4, topY + 3, true);
            }
            lastYear = temp.get(1);
            monthMax = temp.getActualMaximum(5);
            this._daysVisible += monthMax;
            temp.add(5, monthMax);
        } while ((current += this._yearDayWidth * monthMax) <= xMax);
    }

    private void drawMonthBottomBoxes(GC gc, Rectangle bounds, boolean calculateOnly) {
        int xMax = bounds.width + bounds.x;
        int current = bounds.x;
        int topY = bounds.y + this._settings.getHeaderMonthHeight();
        int heightY = this._settings.getHeaderDayHeight();
        Calendar temp = Calendar.getInstance(this._defaultLocale);
        temp.setTime(this._mainCalendar.getTime());
        Calendar temp2 = Calendar.getInstance(this._defaultLocale);
        temp2.setTime(this._mainCalendar.getTime());
        temp2.set(7, temp.getFirstDayOfWeek());
        int days = (int)DateHelper.daysBetween(temp, temp2);
        current += days * this._monthDayWidth;
        temp.set(7, temp.getFirstDayOfWeek());
        do {
            int curDay = temp.get(7);
            this._verticalLineLocations.add(new Integer(current));
            if (curDay == temp.getFirstDayOfWeek()) {
                this._verticalWeekDividerLineLocations.add(new Integer(current));
                if (!calculateOnly) {
                    gc.setForeground(this._colorManager.getMonthTimeDividerColor());
                    gc.drawRectangle(current, topY, this._monthWeekWidth, heightY);
                    gc.setForeground(this._txtHeaderBGColorTop);
                    gc.setBackground(this._txtHeaderBGColorBottom);
                    gc.fillGradientRectangle(current + 1, topY + 1, this._monthWeekWidth - 1, heightY - 1, true);
                    gc.setForeground(this._textColor);
                    gc.drawString(this.getDateString(temp, false), current + 4, topY + 3, true);
                }
            }
            temp.add(5, 1);
        } while ((current += this._monthDayWidth) <= xMax);
        this._endCalendar = temp;
    }

    private void drawMonthTopBoxes(GC gc, Rectangle bounds) {
        int xMax = bounds.width + bounds.x;
        int current = bounds.x;
        int topY = bounds.y;
        int bottomY = this._settings.getHeaderMonthHeight();
        this._daysVisible = 0;
        gc.setForeground(this._txtHeaderBGColorTop);
        gc.setBackground(this._txtHeaderBGColorBottom);
        gc.fillGradientRectangle(current, topY + 1, xMax, bottomY - 1, true);
        Calendar temp = Calendar.getInstance(this._defaultLocale);
        temp.setTime(this._mainCalendar.getTime());
        Calendar temp2 = Calendar.getInstance(this._defaultLocale);
        temp2.setTime(this._mainCalendar.getTime());
        temp2.set(7, temp.getFirstDayOfWeek());
        int days = (int)DateHelper.daysBetween(temp, temp2);
        current += days * this._monthDayWidth;
        temp.set(7, temp.getFirstDayOfWeek());
        do {
            if (temp.get(5) == 1) {
                gc.setForeground(this._colorManager.getTickMarkColor());
                gc.drawLine(current, topY + this._settings.getVerticalTickMarkOffset(), current, topY + this._settings.getHeaderDayHeight());
                gc.setForeground(this._textColor);
                gc.drawString(this.getDateString(temp, true), current + 4, topY + 3, true);
            }
            temp.add(5, 1);
            ++this._daysVisible;
        } while ((current += this._monthDayWidth) <= xMax);
    }

    private void drawWeekTopBoxes(GC gc, Rectangle bounds) {
        int xMax = bounds.width + bounds.x;
        int current = bounds.x;
        int topY = bounds.y;
        int bottomY = this._settings.getHeaderMonthHeight();
        Calendar temp = Calendar.getInstance(this._defaultLocale);
        temp.setTime(this._mainCalendar.getTime());
        int day = temp.get(7);
        int firstDayOfWeek = temp.getFirstDayOfWeek();
        int dayOffset = firstDayOfWeek - day;
        if (dayOffset > 0) {
            dayOffset -= 7;
        }
        int toTakeOff = dayOffset * this._dayWidth;
        current += toTakeOff;
        temp.set(7, temp.getFirstDayOfWeek());
        do {
            gc.setForeground(this._lineColor);
            gc.drawRectangle(current, topY, this._weekWidth, bottomY);
            gc.setForeground(this._txtHeaderBGColorTop);
            gc.setBackground(this._txtHeaderBGColorBottom);
            gc.fillGradientRectangle(current < bounds.x ? bounds.x : current, topY + 1, this._weekWidth, bottomY - 1, true);
            gc.setForeground(this._colorManager.getTickMarkColor());
            gc.drawLine(current, topY + this._settings.getVerticalTickMarkOffset(), current, topY + this._settings.getHeaderDayHeight());
            gc.setForeground(this._textColor);
            gc.drawString(this.getDateString(temp, true), current + 4, topY + 3, true);
            if (temp.get(7) != temp.getFirstDayOfWeek()) continue;
            temp.add(5, 7);
        } while ((current += this._weekWidth) <= xMax);
    }

    private void drawWeekBottomBoxes(GC gc, Rectangle bounds, boolean calculateOnly) {
        int xMax = bounds.width + bounds.x;
        int current = bounds.x;
        int topY = bounds.y + this._settings.getHeaderMonthHeight();
        int heightY = this._settings.getHeaderDayHeight();
        int day = this._mainCalendar.get(7);
        this._daysVisible = 0;
        Calendar temp = Calendar.getInstance(this._defaultLocale);
        temp.setTime(this._mainCalendar.getTime());
        do {
            if (!calculateOnly) {
                if (this._selHeaderDates.contains(temp)) {
                    gc.setForeground(this._colorManager.getSelectedDayHeaderColorTop());
                    gc.setBackground(this._colorManager.getSelectedDayHeaderColorBottom());
                } else {
                    gc.setForeground(this._timeHeaderBGColorTop);
                    gc.setBackground(this._timeHeaderBGColorBottom);
                }
                gc.fillGradientRectangle(current + 1, topY + 1, this._dayWidth - 1, heightY - 1, true);
            }
            this._verticalLineLocations.add(new Integer(current));
            if (temp.get(7) == this._mainCalendar.getFirstDayOfWeek()) {
                this._verticalWeekDividerLineLocations.add(new Integer(current));
            }
            if (!calculateOnly) {
                gc.setForeground(this._colorManager.getWeekTimeDividerColor());
                gc.drawRectangle(current, topY, this._dayWidth, heightY);
                int hSpacer = this._settings.getDayHorizontalSpacing();
                int vSpacer = this._settings.getDayVerticalSpacing();
                String dayLetter = this.getDateString(temp, false);
                if (this._settings.adjustForLetters()) {
                    Point extent = null;
                    if (this._dayLetterStringExtentMap.containsKey(dayLetter)) {
                        extent = (Point)this._dayLetterStringExtentMap.get(dayLetter);
                    } else {
                        extent = gc.stringExtent(dayLetter);
                        this._dayLetterStringExtentMap.put(dayLetter, extent);
                    }
                    switch (extent.x) {
                        case 1: {
                            hSpacer += 5;
                            break;
                        }
                        case 2: {
                            hSpacer += 5;
                            break;
                        }
                        case 3: {
                            hSpacer += 4;
                            break;
                        }
                        case 4: {
                            hSpacer += 3;
                            break;
                        }
                        case 5: {
                            hSpacer += 3;
                            break;
                        }
                        case 6: {
                            hSpacer += 2;
                            break;
                        }
                        case 7: {
                            ++hSpacer;
                            break;
                        }
                        case 8: {
                            ++hSpacer;
                            break;
                        }
                        case 9: {
                            --hSpacer;
                            break;
                        }
                    }
                }
                gc.setForeground(this.getDayTextColor(day));
                gc.drawString(dayLetter, current + hSpacer, topY + vSpacer, true);
                gc.setForeground(this._lineColor);
            }
            temp.add(5, 1);
            current += this._dayWidth;
            if (++day > 7) {
                day = 1;
            }
            ++this._daysVisible;
        } while (current <= xMax);
        this._endCalendar = temp;
    }

    private void drawDDayTopBoxes(GC gc, Rectangle bounds) {
        int xMax = bounds.width + bounds.x;
        int current = bounds.x;
        int topY = bounds.y;
        int bottomY = this._settings.getHeaderMonthHeight();
        int splitEvery = this._settings.getDDaySplitCount();
        Calendar temp = Calendar.getInstance(this._defaultLocale);
        temp.setTime(this._mainCalendar.getTime());
        int startX = this.getXForDate(this._dDayCalendar);
        int daysFromStartOffset = startX / this._dayWidth;
        int dayOffset = 0;
        int letter = 0;
        float count = (float)daysFromStartOffset / (float)splitEvery;
        count = (float)Math.floor(count);
        int takeOff = (int)Math.ceil(count * (float)splitEvery);
        dayOffset = daysFromStartOffset - takeOff;
        letter = -takeOff;
        int dDayWeekWidth = this._dayWidth * splitEvery;
        if ((current += dayOffset * this._dayWidth) > 0) {
            current -= dDayWeekWidth;
            letter -= splitEvery;
        }
        do {
            gc.setForeground(this._lineColor);
            gc.drawRectangle(current, topY, dDayWeekWidth, bottomY);
            gc.setForeground(this._txtHeaderBGColorTop);
            gc.setBackground(this._txtHeaderBGColorBottom);
            gc.fillGradientRectangle(current < bounds.x ? bounds.x : current, topY + 1, dDayWeekWidth, bottomY - 1, true);
            gc.setForeground(this._colorManager.getTickMarkColor());
            gc.drawLine(current, topY + this._settings.getVerticalTickMarkOffset(), current, topY + this._settings.getHeaderDayHeight());
            gc.setForeground(this._textColor);
            StringBuffer buf = new StringBuffer();
            buf.append(letter);
            gc.drawString(buf.toString(), current + 4, topY + 3, true);
            letter += splitEvery;
            temp.add(5, splitEvery);
        } while ((current += dDayWeekWidth) <= xMax);
    }

    private void drawDDayBottomBoxes(GC gc, Rectangle bounds, boolean calculateOnly) {
        int xMax = bounds.width + bounds.x;
        int current = bounds.x;
        int topY = bounds.y + this._settings.getHeaderMonthHeight();
        int heightY = this._settings.getHeaderDayHeight();
        int startX = this.getXForDate(this._dDayCalendar);
        int daysFromStartOffset = startX / this._dayWidth;
        int dayOffset = 0;
        int splitEvery = this._settings.getDDaySplitCount();
        int letter = 0;
        float count = (float)daysFromStartOffset / (float)splitEvery;
        int takeOff = (int)Math.ceil((count = (float)Math.floor(count)) * (float)splitEvery);
        dayOffset = daysFromStartOffset - takeOff;
        letter = splitEvery - Math.abs(dayOffset);
        if (letter >= splitEvery) {
            letter -= splitEvery;
        }
        this._daysVisible = 0;
        Calendar temp = Calendar.getInstance(this._defaultLocale);
        temp.setTime(this._mainCalendar.getTime());
        do {
            this._verticalLineLocations.add(new Integer(current));
            if (!calculateOnly) {
                if (this._selHeaderDates.contains(temp)) {
                    gc.setForeground(this._colorManager.getSelectedDayHeaderColorTop());
                    gc.setBackground(this._colorManager.getSelectedDayHeaderColorBottom());
                } else {
                    gc.setForeground(this._timeHeaderBGColorTop);
                    gc.setBackground(this._timeHeaderBGColorBottom);
                }
                gc.fillGradientRectangle(current + 1, topY + 1, this._dayWidth - 1, heightY - 1, true);
                gc.setForeground(this._colorManager.getWeekTimeDividerColor());
                gc.drawRectangle(current, topY, this._dayWidth, heightY);
                int hSpacer = this._settings.getDayHorizontalSpacing();
                int vSpacer = this._settings.getDayVerticalSpacing();
                StringBuffer buf = new StringBuffer();
                buf.append(letter);
                String dayLetter = buf.toString();
                if (this._settings.adjustForLetters()) {
                    Point extent = null;
                    if (this._dayLetterStringExtentMap.containsKey(dayLetter)) {
                        extent = (Point)this._dayLetterStringExtentMap.get(dayLetter);
                    } else {
                        extent = gc.stringExtent(dayLetter);
                        this._dayLetterStringExtentMap.put(dayLetter, extent);
                    }
                    switch (extent.x) {
                        case 1: 
                        case 2: {
                            hSpacer += 5;
                            break;
                        }
                        case 3: {
                            hSpacer += 4;
                            break;
                        }
                        case 4: 
                        case 5: {
                            hSpacer += 3;
                            break;
                        }
                        case 6: {
                            hSpacer += 2;
                            break;
                        }
                        case 7: 
                        case 8: {
                            ++hSpacer;
                            break;
                        }
                        case 9: {
                            --hSpacer;
                            break;
                        }
                    }
                }
                gc.setForeground(this.getDayTextColor(3));
                gc.drawString(dayLetter, current + hSpacer, topY + vSpacer, true);
            }
            temp.add(5, 1);
            gc.setForeground(this._lineColor);
            current += this._dayWidth;
            ++this._daysVisible;
            if (++letter % splitEvery != 0) continue;
            this._verticalWeekDividerLineLocations.add(new Integer(current));
            letter = 0;
        } while (current <= xMax);
        this._endCalendar = temp;
    }

    private void drawHourTopBoxes(GC gc, Rectangle bounds) {
        int xMax = bounds.width + bounds.x;
        int current = bounds.x;
        int topY = bounds.y;
        int bottomY = this._settings.getHeaderMonthHeight();
        Calendar temp = Calendar.getInstance(this._defaultLocale);
        temp.setTime(this._mainCalendar.getTime());
        int hour = temp.get(11);
        int toTakeOff = hour * this._dayWidth;
        int wWidth = this._weekWidth;
        current -= toTakeOff;
        boolean once = false;
        do {
            gc.setForeground(this._txtHeaderBGColorTop);
            gc.setBackground(this._txtHeaderBGColorBottom);
            gc.fillGradientRectangle(current, topY + 1, wWidth, bottomY - 1, true);
            gc.setForeground(this._colorManager.getTickMarkColor());
            gc.drawLine(current, topY + this._settings.getVerticalTickMarkOffset(), current, topY + this._settings.getHeaderDayHeight());
            gc.setForeground(this._textColor);
            String dString = this.getDateString(temp, true);
            if (current >= bounds.x) {
                gc.drawString(dString, current + 4, topY + 3, true);
            }
            if (!once && this._mainCalendar.get(11) != 0) {
                gc.drawString(dString, bounds.x + 4, topY + 3, true);
                once = true;
            }
            temp.add(5, 1);
        } while ((current += this._weekWidth) <= xMax);
    }

    private void drawHourBottomBoxes(GC gc, Rectangle bounds, boolean calculateOnly) {
        int xMax = bounds.width + bounds.x;
        int current = bounds.x;
        int topY = bounds.y + this._settings.getHeaderMonthHeight();
        int heightY = this._settings.getHeaderDayHeight();
        Calendar temp = Calendar.getInstance(this._defaultLocale);
        temp.setTime(this._mainCalendar.getTime());
        boolean first = true;
        this._hoursVisible = 0;
        while (true) {
            gc.setForeground(this._colorManager.getHourTimeDividerColor());
            int spacer = 1;
            this._verticalLineLocations.add(new Integer(current));
            if (!calculateOnly) {
                if (!this._ganttSections.isEmpty() && first) {
                    gc.drawRectangle(current - 1, topY, this._dayWidth + 1, heightY);
                    spacer = 0;
                } else {
                    gc.drawRectangle(current, topY, this._dayWidth, heightY);
                }
                gc.setForeground(this._timeHeaderBGColorTop);
                gc.setBackground(this._timeHeaderBGColorBottom);
                gc.fillGradientRectangle(current + spacer, topY + 1, this._dayWidth - spacer, heightY - 1, true);
                int hSpacer = this._settings.getDayHorizontalSpacing();
                int vSpacer = this._settings.getDayVerticalSpacing();
                gc.setForeground(this._textColor);
                gc.drawString(this.getDateString(temp, false), current + hSpacer, topY + vSpacer, true);
            }
            if ((current += this._dayWidth) > xMax) {
                current -= this._dayWidth;
                break;
            }
            ++this._hoursVisible;
            temp.add(11, 1);
            if (temp.get(11) == 0) {
                this._verticalWeekDividerLineLocations.add(new Integer(current));
            }
            first = false;
        }
        this._endCalendar = temp;
        int hr = (this._mainBounds.width - this._mainBounds.x) / this._dayWidth;
        int total = hr * this._dayWidth;
        float ppm = 60.0f / (float)this._dayWidth;
        int extra = this._mainBounds.width - this._mainBounds.x - total;
        int totalMinutes = (int)(((float)total + (float)extra) * ppm);
        Calendar fakeEnd = Calendar.getInstance(this._defaultLocale);
        fakeEnd.setTime(this._mainCalendar.getTime());
        for (int i = 0; i < totalMinutes; ++i) {
            fakeEnd.add(12, 1);
            if (temp.get(11) < 24) continue;
            temp.add(5, 1);
            temp.set(11, 0);
        }
        this._endCalendar = fakeEnd;
    }

    private void drawGanttSpecialDateRanges(GC gc, Rectangle bounds, GanttSection gs) {
        for (int i = 0; i < this._specDateRanges.size(); ++i) {
            GanttSpecialDateRange range = (GanttSpecialDateRange)this._specDateRanges.get(i);
            if (!range.isVisible(this._mainCalendar, this._endCalendar)) continue;
            if (range.getBackgroundColorTop() != null) {
                gc.setForeground(range.getBackgroundColorTop());
            }
            if (range.getBackgroundColorBottom() != null) {
                gc.setBackground(range.getBackgroundColorBottom());
            }
            int offset = 0;
            if (gs == null) {
                offset = this._vScrollPos;
                if (offset > this.getHeaderHeight()) {
                    offset = this.getHeaderHeight();
                }
            } else {
                offset = this._vScrollPos;
            }
            int yStart = bounds.y - offset;
            int yHeight = bounds.height + offset;
            int extra = 0;
            if (!this._ganttSections.isEmpty() && this._settings.getSectionSide() == 16384) {
                extra += this._settings.getSectionBarWidth();
            }
            yHeight -= offset;
            List toDraw = range.getBlocks(this._mainCalendar, this._endCalendar);
            for (int x = 0; x < toDraw.size(); ++x) {
                List cals = (List)toDraw.get(x);
                Calendar eStart = (Calendar)cals.get(0);
                Calendar eEnd = (Calendar)cals.get(1);
                if (this._currentView == 1) {
                    eEnd.add(14, 1);
                }
                int xStart = this.getXForDate(eStart);
                int xEnd = this.getXForDate(eEnd);
                if ((xStart += extra) == (xEnd += extra) && this._currentView >= 2) {
                    xEnd += this.getDayWidth();
                }
                gc.fillGradientRectangle(xStart, yStart, xEnd - xStart, yHeight, true);
            }
        }
    }

    private void drawGanttPhases(GC gc, Rectangle bounds, boolean header, GanttSection gs) {
        int pHeight = this._settings.getPhasesHeaderHeight();
        int extra = 0;
        if (!this._ganttSections.isEmpty() && this._settings.getSectionSide() == 16384) {
            extra += this._settings.getSectionBarWidth();
        }
        int offset = 0;
        if (gs == null) {
            offset = this._vScrollPos;
            if (offset > this.getHeaderHeight()) {
                offset = this.getHeaderHeight();
            }
        } else {
            offset = this._vScrollPos;
        }
        if (header) {
            int yLoc = pHeight;
            if (!this._settings.lockHeaderOnVerticalScroll()) {
                yLoc += offset;
            }
            gc.setBackground(this._phaseHeaderBGColorBottom);
            gc.setForeground(this._phaseHeaderBGColorTop);
            gc.fillGradientRectangle(bounds.x, this.getHeaderHeight() - yLoc, bounds.width, yLoc, true);
            gc.setForeground(this._colorManager.getTopHorizontalLinesColor());
            gc.drawLine(bounds.x, this.getHeaderHeight() - 1, bounds.width + extra, this.getHeaderHeight() - 1);
        }
        for (int i = 0; i < this._ganttPhases.size(); ++i) {
            GanttPhase phase = (GanttPhase)this._ganttPhases.get(i);
            if (phase.isHidden() || !phase.isDisplayable()) continue;
            int xStart = this.getStartingXFor(phase.getStartDate());
            int xEnd = this.getXForDate(phase.getEndDate());
            xEnd += extra;
            int yStart = bounds.y - offset;
            int yHeight = bounds.height + offset;
            yHeight -= offset;
            if (phase.getAlpha() == 255) {
                gc.setAlpha(255);
                gc.setAdvanced(false);
            } else {
                gc.setAlpha(phase.getAlpha());
            }
            if (header) {
                yStart = this.getHeaderHeight() - pHeight;
                if (!this._settings.lockHeaderOnVerticalScroll()) {
                    yStart -= offset;
                }
                gc.setBackground(phase.getHeaderBackgroundColor());
                gc.setForeground(phase.getHeaderForegroundColor());
                gc.fillGradientRectangle(xStart, yStart, xEnd - xStart, pHeight, true);
                Rectangle hBounds = new Rectangle(xStart, yStart, xEnd - xStart, pHeight - 1);
                if (phase.getTitle() != null) {
                    if (phase.getHeaderFont() != null) {
                        gc.setFont(phase.getHeaderFont());
                    }
                    String str = this.getStringToDisplay(gc, hBounds, phase.getTitle());
                    Point p = gc.stringExtent(str);
                    int textX = (xEnd - xStart) / 2 - p.x / 2 + 1;
                    int textY = yStart + pHeight / 2 - p.y / 2 - 2;
                    gc.setForeground(phase.getHeaderTextColor());
                    gc.drawText(str, xStart + textX, textY, true);
                }
                phase.setHeaderBounds(hBounds);
            } else {
                gc.setBackground(phase.getBodyTopColor());
                gc.setForeground(phase.getBodyBottomColor());
                gc.fillGradientRectangle(xStart, yStart, xEnd - xStart, yHeight, true);
                phase.setBounds(new Rectangle(xStart, yStart, xEnd - xStart, yHeight));
            }
            if (!header || !phase.isDrawBorders()) continue;
            yStart = this.getHeaderHeight() - pHeight;
            gc.setLineWidth(phase.getBorderWidth());
            gc.setForeground(phase.getBorderColor());
            gc.drawLine(xStart, yStart, xStart, yStart + pHeight);
            gc.drawLine(xEnd - 1, yStart, xEnd - 1, yStart + pHeight);
        }
        gc.setAlpha(255);
        gc.setAdvanced(false);
    }

    private String getStringToDisplay(GC gc, Rectangle area, String text) {
        Point p = null;
        if (this._stringWidthCache.containsKey(text)) {
            p = (Point)this._stringWidthCache.get(text);
        } else {
            p = gc.stringExtent(text);
            this._stringWidthCache.put(text, p);
        }
        StringBuffer buf = new StringBuffer();
        String line = text;
        if (p.x > area.width) {
            int textLen = line.length();
            for (int i = textLen - 1; i >= 0; --i) {
                String temp = line.substring(0, i) + "...";
                int width = 0;
                if (this._stringWidthCache.containsKey(temp)) {
                    width = ((Point)this._stringWidthCache.get((Object)temp)).x;
                } else {
                    Point p2 = gc.stringExtent(temp);
                    width = p2.x;
                    this._stringWidthCache.put(temp, p2);
                }
                if (width < area.width) {
                    line = temp;
                    break;
                }
                if (i != 0) continue;
                line = "";
            }
        } else {
            return text;
        }
        buf.append(line);
        return buf.toString();
    }

    private Color getDayBackgroundGradient(int day, boolean top, GanttSection gs) {
        return this.internalGetDayBackgroundGradient(day, top, gs);
    }

    private Color internalGetDayBackgroundGradient(int day, boolean top, GanttSection gs) {
        Color ret = null;
        switch (day) {
            case 7: {
                if (top) {
                    if (gs == null) {
                        ret = this._satBGColorTop;
                        break;
                    }
                    ret = gs.getSaturdayBackgroundColorTop();
                    break;
                }
                if (gs == null) {
                    ret = this._satBGColorBottom;
                    break;
                }
                ret = gs.getSaturdayBackgroundColorBottom();
                break;
            }
            case 1: {
                if (top) {
                    if (gs == null) {
                        ret = this._sunBGColorTop;
                        break;
                    }
                    ret = gs.getSundayBackgroundColorTop();
                    break;
                }
                if (gs == null) {
                    ret = this._sunBGColorBottom;
                    break;
                }
                ret = gs.getSundayBackgroundColorBottom();
                break;
            }
            default: {
                if (top) {
                    if (gs == null) {
                        ret = this._wkBGColorTop;
                        break;
                    }
                    ret = gs.getWeekdayBackgroundColorTop();
                    break;
                }
                ret = gs == null ? this._wkBGColorBottom : gs.getWeekdayBackgroundColorBottom();
            }
        }
        return ret;
    }

    private Color getDayTextColor(int day) {
        switch (day) {
            case 7: {
                return this._satTextColor;
            }
            case 1: {
                return this._sunTextColor;
            }
        }
        return this._weekdayTextColor;
    }

    private void drawEvents(GC gc, Rectangle bounds, GanttSection gs) {
        this.internalDrawEvents(gc, bounds, gs);
    }

    private void drawEvents(GC gc, Rectangle bounds) {
        this.internalDrawEvents(gc, bounds, null);
    }

    private void internalDrawEvents(GC gc, Rectangle bounds, GanttSection gs) {
        int i;
        if (this._ganttEvents.isEmpty()) {
            return;
        }
        HashSet<GanttEvent> alreadyDrawn = new HashSet<GanttEvent>();
        List events = this._ganttEvents;
        if (gs != null) {
            events = gs.getEvents();
        }
        ArrayList<IGanttChartItem> correctOrder = new ArrayList<IGanttChartItem>();
        for (i = 0; i < events.size(); ++i) {
            IGanttChartItem event = (IGanttChartItem)events.get(i);
            if (event instanceof GanttGroup) {
                GanttGroup gg = (GanttGroup)event;
                List children = gg.getEventMembers();
                correctOrder.addAll(children);
                continue;
            }
            correctOrder.add(event);
        }
        this._totVisEventCnt = 0;
        if (gs != null) {
            correctOrder.addAll(gs.getDNDGanttEvents());
        }
        for (i = 0; i < correctOrder.size(); ++i) {
            GanttEvent ge = (GanttEvent)correctOrder.get(i);
            if (ge.isHidden() || alreadyDrawn.contains(ge)) continue;
            ++this._totVisEventCnt;
            if (ge.getVisibility() != 1) {
                if (ge.getNameExtent() != null && !ge.isNameChanged()) continue;
                String toDraw = this.getStringForEvent(ge);
                ge.setNameExtent(gc.stringExtent(toDraw));
                ge.setParsedString(toDraw);
                ge.setNameChanged(false);
                continue;
            }
            alreadyDrawn.add(ge);
            this.drawOneEvent(gc, ge, bounds);
        }
    }

    private void drawOneEvent(GC gc, GanttEvent ge, Rectangle boundsToUse) {
        int xStart = ge.getX();
        int xEventWidth = ge.getWidth();
        Rectangle bounds = new Rectangle(boundsToUse.x, boundsToUse.y, boundsToUse.width, boundsToUse.height);
        Color cEvent = ge.getStatusColor();
        Color gradient = ge.getGradientStatusColor();
        if (cEvent == null) {
            cEvent = this._settings.getDefaultEventColor();
        }
        if (gradient == null) {
            gradient = this._settings.getDefaultGradientEventColor();
        }
        int yDrawPos = ge.getY();
        int dw = this.getDayWidth();
        boolean advanced = false;
        if (this.getLayerOpacity(ge.getLayer()) != -1) {
            advanced = true;
            gc.setAlpha(this.getLayerOpacity(ge.getLayer()));
        }
        if (ge.isCheckpoint()) {
            this._paintManager.drawCheckpoint(this, this._settings, this._colorManager, ge, gc, this._threeDee, dw, xStart, yDrawPos, bounds);
        } else if (ge.isImage()) {
            this._paintManager.drawImage(this, this._settings, this._colorManager, ge, gc, ge.getPicture(), this._threeDee, dw, xStart, yDrawPos, bounds);
        } else if (ge.isScope()) {
            this._paintManager.drawScope(this, this._settings, this._colorManager, ge, gc, this._threeDee, dw, xStart, yDrawPos, xEventWidth, bounds);
        } else {
            this._paintManager.drawEvent(this, this._settings, this._colorManager, ge, gc, !this._selectedEvents.isEmpty() && this._selectedEvents.contains(ge), this._threeDee, dw, xStart, yDrawPos, xEventWidth, bounds);
        }
        if (ge.hasMovementConstraints()) {
            int startStart = -1;
            int endStart = -1;
            if (ge.getNoMoveBeforeDate() != null) {
                startStart = this.getStartingXFor(ge.getNoMoveBeforeDate());
            }
            if (ge.getNoMoveAfterDate() != null) {
                endStart = this.getStartingXFor(ge.getNoMoveAfterDate());
            }
            if (this._settings.drawLockedDateMarks()) {
                this._paintManager.drawLockedDateRangeMarker(this, this._settings, this._colorManager, ge, gc, this._threeDee, dw, yDrawPos, startStart, endStart, bounds);
            }
        }
        if (this._showPlannedDates) {
            this._paintManager.drawPlannedDates(this, this._settings, this._colorManager, ge, gc, this._threeDee, xStart, yDrawPos, xEventWidth, bounds);
        }
        if (this._showNumDays) {
            long days = DateHelper.daysBetween(ge.getActualStartDate(), ge.getActualEndDate()) + 1L;
            this._paintManager.drawDaysOnChart(this, this._settings, this._colorManager, ge, gc, this._threeDee, xStart, yDrawPos, xEventWidth, (int)days, bounds);
        }
        Font oldFont = gc.getFont();
        if (ge.isNameChanged()) {
            String toDraw = this.getStringForEvent(ge);
            ge.setNameExtent(gc.stringExtent(toDraw));
            ge.setParsedString(toDraw);
            ge.setNameChanged(false);
        }
        if (ge.getParsedString() != null) {
            this._paintManager.drawEventString(this, this._settings, this._colorManager, ge, gc, ge.getParsedString(), this._threeDee, xStart, yDrawPos, xEventWidth, bounds);
        }
        gc.setFont(oldFont);
        if (advanced) {
            gc.setAdvanced(false);
        }
    }

    private void updateEventVisibilities(Rectangle bounds) {
        Object[] all = this._allEventsCombined.toArray();
        for (int i = 0; i < all.length; ++i) {
            GanttEvent ge = (GanttEvent)all[i];
            ge.setVisibility(this.getEventVisibility(ge, bounds));
        }
    }

    private void calculateAllScopes(Rectangle bounds, GanttSection gs) {
        IGanttChartItem event;
        int i;
        if (this._ganttEvents.isEmpty()) {
            return;
        }
        int yStart = bounds.y + this._settings.getEventsTopSpacer();
        HashSet allEventsInGroups = new HashSet();
        for (int i2 = 0; i2 < this._ganttGroups.size(); ++i2) {
            allEventsInGroups.addAll(((GanttGroup)this._ganttGroups.get(i2)).getEventMembers());
        }
        boolean lastLoopWasGroup = false;
        HashMap<GanttGroup, Integer> groupLocations = new HashMap<GanttGroup, Integer>();
        List events = this._ganttEvents;
        if (gs != null) {
            events = gs.getEvents();
        }
        ArrayList<IGanttChartItem> correctOrder = new ArrayList<IGanttChartItem>();
        for (i = 0; i < events.size(); ++i) {
            event = (IGanttChartItem)events.get(i);
            if (event instanceof GanttGroup) {
                GanttGroup gg = (GanttGroup)event;
                List children = gg.getEventMembers();
                correctOrder.addAll(children);
                continue;
            }
            correctOrder.add(event);
        }
        for (i = 0; i < correctOrder.size(); ++i) {
            event = (IGanttChartItem)correctOrder.get(i);
            GanttEvent ge = (GanttEvent)event;
            if (this._fixedRowHeight != 0) {
                ge.setFixedRowHeight(this._fixedRowHeight);
                if (ge.getGanttGroup() != null) {
                    ge.getGanttGroup().setFixedRowHeight(this._fixedRowHeight);
                }
            }
            boolean groupedEvent = false;
            boolean newGroup = false;
            ge.setVisibility(this.getEventVisibility(ge, bounds));
            if (ge.isHidden()) continue;
            if (ge.isScope()) {
                ge.calculateScope();
            }
            int xStart = this.getStartingXFor(ge);
            int xEventWidth = this.getXLengthForEvent(ge);
            if (allEventsInGroups.contains(ge)) {
                groupedEvent = true;
                if (!groupLocations.containsKey(ge.getGanttGroup())) {
                    newGroup = true;
                    if (i != 0 && lastLoopWasGroup) {
                        yStart += this._eventHeight + this._eventSpacer;
                    }
                    groupLocations.put(ge.getGanttGroup(), new Integer(yStart));
                }
            }
            if (lastLoopWasGroup && !groupedEvent) {
                yStart += this._eventHeight + this._eventSpacer;
            }
            int yDrawPos = yStart - this._vScrollPos;
            if (groupedEvent && groupLocations.containsKey(ge.getGanttGroup())) {
                yDrawPos = (Integer)groupLocations.get(ge.getGanttGroup());
            }
            int fixedRowHeight = this._fixedRowHeight;
            int verticalAlignment = ge.getVerticalEventAlignment();
            if (ge.getGanttGroup() == null) {
                if (!ge.isAutomaticRowHeight()) {
                    fixedRowHeight = ge.getFixedRowHeight();
                }
            } else {
                verticalAlignment = ge.getGanttGroup().getVerticalEventAlignment();
                if (!ge.getGanttGroup().isAutomaticRowHeight()) {
                    fixedRowHeight = ge.getGanttGroup().getFixedRowHeight();
                }
            }
            boolean fixedHeight = fixedRowHeight > 0;
            ge.setHorizontalLineTopY(yStart + this._vScrollPos);
            if (fixedHeight) {
                yStart += fixedRowHeight;
                int extra = 0;
                switch (verticalAlignment) {
                    case 1024: {
                        extra = fixedRowHeight - this._eventHeight;
                        break;
                    }
                    case 0x1000000: {
                        extra = fixedRowHeight / 2 - this._eventHeight / 2;
                        break;
                    }
                    case 0: 
                    case 128: {
                        extra = this._eventSpacer - this._eventHeight;
                        break;
                    }
                }
                if (extra < 0) {
                    extra = 0;
                }
                yDrawPos += extra;
            }
            if (!newGroup && groupedEvent) {
                yDrawPos = (Integer)groupLocations.get(ge.getGanttGroup());
            }
            if (fixedHeight) {
                ge.setHorizontalLineBottomY(yDrawPos - this._eventHeight + this._vScrollPos);
            } else {
                ge.setHorizontalLineBottomY(yDrawPos + this._eventHeight + this._vScrollPos);
            }
            ge.setBounds(new Rectangle(xStart, yDrawPos, xEventWidth, this._eventHeight));
            ge.updateActualWidth();
            if (groupedEvent) {
                lastLoopWasGroup = true;
            } else {
                if (!fixedHeight) {
                    this._bottomMostY = (yStart += this._eventHeight + this._eventSpacer) + this._eventHeight;
                }
                lastLoopWasGroup = false;
            }
            this._bottomMostY = Math.max(this._bottomMostY, yStart + this._eventHeight);
        }
        this._bottomMostY -= this._eventSpacer;
    }

    private String getStringForEvent(GanttEvent ge) {
        long days;
        StringBuffer buf;
        String toUse = ge.getTextDisplayFormat();
        if (toUse == null) {
            toUse = this._settings.getTextDisplayFormat();
        }
        if (toUse == null) {
            return "";
        }
        String dateFormat = this._currentView == 1 ? this._settings.getHourDateFormat() : this._settings.getDateFormat();
        String toReturn = toUse;
        if (toReturn.indexOf("#name#") > -1) {
            toReturn = ge.getName() == null ? toReturn.replaceAll("#name#", "") : toReturn.replaceAll("#name#", ge.getName());
        }
        if (toReturn.indexOf("#pc#") > -1) {
            buf = new StringBuffer();
            buf.append(ge.getPercentComplete());
            toReturn = toReturn.replaceAll("#pc#", buf.toString());
        }
        if (toReturn.indexOf("#sd#") > -1) {
            toReturn = ge.getStartDate() == null ? toReturn.replaceAll("#sd#", "") : toReturn.replaceAll("#sd#", DateHelper.getDate(ge.getStartDate(), dateFormat));
        }
        if (toReturn.indexOf("#ed#") > -1) {
            toReturn = ge.getEndDate() == null ? toReturn.replaceAll("#ed#", "") : toReturn.replaceAll("#ed#", DateHelper.getDate(ge.getEndDate(), dateFormat));
        }
        if (toReturn.indexOf("#rs#") > -1) {
            toReturn = ge.getRevisedStart() == null ? toReturn.replaceAll("#rs#", "") : toReturn.replaceAll("#rs#", DateHelper.getDate(ge.getRevisedStart(), dateFormat));
        }
        if (toReturn.indexOf("#re#") > -1) {
            toReturn = ge.getRevisedEnd() == null ? toReturn.replaceAll("#re#", "") : toReturn.replaceAll("#re#", DateHelper.getDate(ge.getRevisedEnd(), dateFormat));
        }
        if (toReturn.indexOf("#days#") > 1) {
            if (ge.getStartDate() == null || ge.getEndDate() == null) {
                toReturn = toReturn.replaceAll("#days#", "");
            } else {
                buf = new StringBuffer();
                days = DateHelper.daysBetween(ge.getStartDate(), ge.getEndDate());
                buf.append(days);
                toReturn = toReturn.replaceAll("#days#", buf.toString());
            }
        }
        if (toReturn.indexOf("#reviseddays#") > -1) {
            if (ge.getRevisedStart() == null || ge.getRevisedEnd() == null) {
                toReturn = toReturn.replaceAll("#reviseddays#", "");
            } else {
                buf = new StringBuffer();
                days = DateHelper.daysBetween(ge.getRevisedStart(), ge.getRevisedEnd());
                buf.append(days);
                toReturn = toReturn.replaceAll("#reviseddays#", buf.toString());
            }
        }
        return toReturn;
    }

    private void drawTopHorizontalLines(GC gc, Rectangle bounds) {
        int yStart = bounds.y;
        int width = bounds.x + bounds.width;
        int xStart = bounds.x;
        int monthHeight = bounds.y + this._settings.getHeaderMonthHeight();
        gc.setForeground(this._colorManager.getTopHorizontalLinesColor());
        gc.drawLine(xStart, yStart, width, yStart);
        gc.drawLine(xStart, monthHeight, width, monthHeight);
        gc.drawLine(xStart, monthHeight + this._settings.getHeaderDayHeight(), width, monthHeight + this._settings.getHeaderDayHeight());
    }

    public void addDependency(GanttEvent source, GanttEvent target) {
        this.addDependency(source, target, null);
    }

    public void addDependency(GanttEvent source, GanttEvent target, Color color) {
        this.checkWidget();
        if (source == null || target == null) {
            return;
        }
        GanttConnection con = new GanttConnection(source, target, color);
        if (!this._ganttConnections.contains(con)) {
            this._ganttConnections.add(con);
        }
    }

    void connectionAdded(GanttConnection conn) {
        this.checkWidget();
        this.addDependency(conn.getSource(), conn.getTarget(), conn.getColor());
    }

    void connectionRemoved(GanttConnection conn) {
        this.checkWidget();
        this._ganttConnections.remove(conn);
    }

    public boolean isConnected(GanttEvent ge) {
        for (int i = 0; i < this._ganttConnections.size(); ++i) {
            GanttConnection gc = (GanttConnection)this._ganttConnections.get(i);
            if (!gc.getSource().equals(ge) && !gc.getTarget().equals(ge)) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected(GanttEvent source, GanttEvent target) {
        for (int i = 0; i < this._ganttConnections.size(); ++i) {
            GanttConnection gc = (GanttConnection)this._ganttConnections.get(i);
            if (!gc.getSource().equals(source) || !gc.getTarget().equals(target)) continue;
            return true;
        }
        return false;
    }

    public void addConnection(GanttEvent source, GanttEvent target) {
        this.addDependency(source, target, null);
    }

    public void addConnection(GanttEvent source, GanttEvent target, Color color) {
        this.addDependency(source, target, color);
    }

    private Rectangle getFirstStub(GanttConnection con) {
        GanttEvent ge1 = con.getSource();
        int xStart = ge1.getX() + ge1.getWidth();
        int yStart = ge1.getY() + this._eventHeight / 2;
        return new Rectangle(xStart, yStart, 4, this._eventHeight);
    }

    private void drawConnections(GC gc) {
        int dw = this.getDayWidth();
        for (int i = 0; i < this._ganttConnections.size(); ++i) {
            int yDest;
            boolean isLinux;
            Rectangle rect;
            boolean targetIsOutOfBounds;
            GanttConnection connection = (GanttConnection)this._ganttConnections.get(i);
            GanttEvent ge1 = connection.getSource();
            GanttEvent ge2 = connection.getTarget();
            if (ge1 == null || ge2 == null || ge1.equals(ge2) || ge1.getX() == 0 && ge2.getY() == 0 || ge1.isHidden() || ge2.isHidden()) continue;
            gc.setForeground(connection.getColor() == null ? this._arrowColor : connection.getColor());
            if (!this._hiddenLayers.isEmpty() && (this._hiddenLayers.contains(ge1.getLayerInt()) || this._hiddenLayers.contains(ge2.getLayerInt()))) continue;
            boolean sourceIsOutOfBounds = ge1.getVisibility() != 1;
            boolean bl = targetIsOutOfBounds = ge2.getVisibility() != 1;
            if (sourceIsOutOfBounds && targetIsOutOfBounds && (ge1.getVisibility() == 2 && ge2.getVisibility() == 2 || ge1.getVisibility() == 3 && ge2.getVisibility() == 3 || ge1.getVisibility() == 5 && ge2.getVisibility() == 5 || ge1.getVisibility() == 6 && ge2.getVisibility() == 6)) continue;
            if (this._settings.showOnlyDependenciesForSelectedItems()) {
                if (this._selectedEvents.isEmpty()) {
                    return;
                }
                if (!this._selectedEvents.contains(connection.getSource())) continue;
            }
            if (this._settings.getArrowConnectionType() != 3) {
                if (this._settings.getArrowConnectionType() == 4) {
                    if (ge1.getX() < ge2.getX()) {
                        gc.drawLine(ge1.getXEnd(), ge1.getBottomY(), ge2.getX(), ge2.getY());
                        continue;
                    }
                    gc.drawLine(ge1.getX(), ge1.getY(), ge2.getXEnd(), ge2.getBottomY());
                    continue;
                }
                rect = this.getFirstStub(connection);
                gc.drawLine(rect.x + 1, rect.y, rect.x + rect.width - 1, rect.y);
                Rectangle down = new Rectangle(rect.x + rect.width, rect.y, rect.width, rect.height / 2 + this._eventSpacer / 2);
                gc.drawLine(down.x, down.y, rect.x + down.width, rect.y + down.height);
                Rectangle rGe2 = new Rectangle(ge2.getX() - this._settings.getArrowHeadEventSpacer(), ge2.getY() + this._settings.getArrowHeadVerticalAdjuster(), ge2.getWidth(), ge2.getHeight());
                boolean goingUp = false;
                boolean goingLeft = false;
                if (rect.y > rGe2.y) {
                    goingUp = true;
                }
                if (rect.x > rGe2.x) {
                    goingLeft = true;
                }
                if (this._settings.getArrowConnectionType() == 1) {
                    gc.drawLine(down.x, rect.y + down.height, rGe2.x, rect.y + down.height);
                    if (goingLeft) {
                        if (goingUp) {
                            gc.drawLine(rGe2.x, rect.y + down.height, rGe2.x, rGe2.y + this._eventHeight + 1);
                        } else {
                            gc.drawLine(rGe2.x, rect.y + down.height, rGe2.x, rGe2.y);
                        }
                    } else {
                        gc.drawLine(rGe2.x, rect.y + down.height, rGe2.x, rGe2.y);
                    }
                    if (!this._settings.showArrows()) continue;
                    if (goingUp) {
                        this._paintManager.drawArrowHead(rGe2.x, rGe2.y + this._eventHeight / 2 + 4, 128, gc);
                        continue;
                    }
                    this._paintManager.drawArrowHead(rGe2.x, rGe2.y - this._eventHeight / 2 - 1, 1024, gc);
                    continue;
                }
                if (this._settings.getArrowConnectionType() != 2) continue;
                int offset = 10;
                gc.drawLine(down.x, rect.y + down.height, rGe2.x - 10, rect.y + down.height);
                gc.drawLine(rGe2.x - 10, rect.y + down.height, rGe2.x - 10, rGe2.y + this._eventHeight / 2);
                gc.drawLine(rGe2.x - 10, rGe2.y + this._eventHeight / 2, rGe2.x, rGe2.y + this._eventHeight / 2);
                if (!this._settings.showArrows()) continue;
                if (goingUp) {
                    this._paintManager.drawArrowHead(rGe2.x - 7, rGe2.y + this._eventHeight / 2, 16384, gc);
                    continue;
                }
                this._paintManager.drawArrowHead(rGe2.x - 7, rGe2.y + this._eventHeight / 2, 131072, gc);
                continue;
            }
            rect = this.getFirstStub(connection);
            int x = rect.x;
            int y = rect.y;
            boolean aboveUs = ge2.getY() < ge1.getY();
            boolean belowUs = ge2.getY() > ge1.getY();
            boolean sameRow = ge2.getY() == ge1.getY();
            boolean targetIsOnLeft = ge2.getXEnd() < ge1.getX();
            boolean targetIsOnRight = ge2.getX() > ge1.getXEnd();
            Rectangle bounds1 = ge1.getBounds();
            Rectangle bounds2 = ge2.getBounds();
            bounds1.y = bounds2.y;
            boolean eventsOverlap = bounds1.intersects(bounds2);
            boolean targetIsOnLeftBorder = ge2.getXEnd() == ge1.getX();
            boolean targetIsOnRightBorder = ge2.getX() == ge1.getXEnd();
            int neg = 8;
            Point xy = null;
            boolean bl2 = isLinux = _osType == 3;
            if (belowUs) {
                gc.setForeground(connection.getColor() == null ? this._arrowColor : connection.getColor());
                gc.drawLine(x, y, x + rect.width, y);
                xy = this.drawBend(gc, 2, (x += rect.width) - (isLinux ? 1 : 0), y, true);
                x = xy.x;
                y = xy.y;
                if (targetIsOnRight) {
                    int yTarget = ge2.getY() + ge2.getHeight() / 2;
                    gc.drawLine(x, y, x, yTarget - (isLinux ? 1 : 2));
                    y = yTarget - 2;
                    xy = this.drawBend(gc, 2, x, y, true);
                    x = xy.x;
                    y = xy.y;
                    gc.drawLine(x, y, ge2.getX(), y);
                    if (!this._settings.showArrows()) continue;
                    x = ge2.getX() - 8;
                    this._paintManager.drawArrowHead(x, y, 131072, gc);
                    continue;
                }
                if (!targetIsOnLeft && !eventsOverlap && !targetIsOnLeftBorder && !targetIsOnRightBorder) continue;
                yDest = ge1.getBottomY() + this._eventSpacer / 2;
                gc.drawLine(x, y, x, yDest);
                y = yDest;
                if (isLinux) {
                    --y;
                }
                xy = this.drawBend(gc, 4, x, y, true);
                x = xy.x;
                y = xy.y;
                gc.drawLine(x, y, ge2.getX() - 8, y);
                x = ge2.getX() - 8;
                xy = this.drawBend(gc, 4, x, y, true);
                x = xy.x;
                y = xy.y;
                int yTarget = ge2.getY() + ge2.getHeight() / 2;
                gc.drawLine(x, y, x, yTarget - (isLinux ? 1 : 2));
                y = yTarget - 2;
                xy = this.drawBend(gc, 2, x, y, true);
                x = xy.x;
                y = xy.y;
                gc.drawLine(x, y, ge2.getX(), y);
                if (!this._settings.showArrows()) continue;
                x = ge2.getX() - 8;
                this._paintManager.drawArrowHead(x, y, 131072, gc);
                continue;
            }
            if (aboveUs) {
                gc.setForeground(connection.getColor() == null ? this._reverseArrowColor : connection.getColor());
                gc.drawLine(x, y, x + rect.width, y);
                x += rect.width;
                if (targetIsOnLeft || eventsOverlap || targetIsOnRightBorder || targetIsOnLeftBorder) {
                    xy = this.drawBend(gc, 2, x, y, true);
                    x = xy.x;
                    y = xy.y;
                    yDest = ge1.getBottomY() + this._eventSpacer / 2;
                    gc.drawLine(x, y, x, yDest);
                    y = yDest;
                    xy = this.drawBend(gc, 4, x, y, true);
                    x = xy.x;
                    y = xy.y;
                    gc.drawLine(x, y, ge2.getX() - 8 - this._settings.getReverseDependencyLineHorizontalSpacer(), y);
                    x = ge2.getX() - 8 - this._settings.getReverseDependencyLineHorizontalSpacer();
                    xy = this.drawBend(gc, 3, x, y, true);
                    x = xy.x;
                    y = xy.y;
                    if (this._settings.useSplitArrowConnections()) {
                        gc.drawLine(x, y, x, ge2.getY() + ge2.getHeight());
                        y = ge2.getY() + ge2.getHeight();
                    } else {
                        gc.drawLine(x, y, x, ge2.getY() + ge2.getHeight() / 2 + 2);
                        y = ge2.getY() + ge2.getHeight() / 2 + 2;
                    }
                    xy = this.drawBend(gc, 1, x, y, true);
                    x = xy.x;
                    y = xy.y;
                    gc.drawLine(x, y, ge2.getX(), y);
                    if (!this._settings.showArrows()) continue;
                    x = ge2.getX() - 8;
                    this._paintManager.drawArrowHead(x, y, 131072, gc);
                    continue;
                }
                if (!targetIsOnRight) continue;
                xy = this.drawBend(gc, 1, x, y, true);
                x = xy.x;
                y = xy.y;
                if (this._settings.useSplitArrowConnections()) {
                    gc.drawLine(x, y, x, ge2.getY() + ge2.getHeight());
                    y = ge2.getY() + ge2.getHeight();
                } else {
                    gc.drawLine(x, y, x, ge2.getY() + ge2.getHeight() / 2 + 2);
                    y = ge2.getY() + ge2.getHeight() / 2 + 2;
                }
                xy = this.drawBend(gc, 1, x, y, true);
                x = xy.x;
                y = xy.y;
                gc.drawLine(x, y, ge2.getX(), y);
                if (!this._settings.showArrows()) continue;
                x = ge2.getX() - 8;
                this._paintManager.drawArrowHead(x, y, 131072, gc);
                continue;
            }
            if (!sameRow) continue;
            if (targetIsOnLeft || eventsOverlap || targetIsOnRightBorder || targetIsOnLeftBorder) {
                gc.setForeground(connection.getColor() == null ? this._reverseArrowColor : connection.getColor());
                gc.drawLine(x, y, x + rect.width, y);
                xy = this.drawBend(gc, 2, x += rect.width, y, true);
                x = xy.x;
                y = xy.y;
                if (this._settings.useSplitArrowConnections()) {
                    gc.drawLine(x, y, x, ge2.getY() + ge2.getHeight() + this._eventSpacer / 2);
                    y = ge2.getY() + ge2.getHeight();
                } else {
                    gc.drawLine(x, y, x, ge2.getY() + ge2.getHeight() / 2 + 2 + this._eventSpacer / 2);
                    y = ge2.getY() + ge2.getHeight() / 2 + 2;
                }
                xy = this.drawBend(gc, 4, x, y += this._eventSpacer / 2, true);
                x = xy.x;
                y = xy.y;
                gc.drawLine(x, y, ge2.getX() - 8 - 4, y);
                x = ge2.getX() - 8 - 4;
                xy = this.drawBend(gc, 3, x, y, true);
                x = xy.x;
                y = xy.y;
                if (this._settings.useSplitArrowConnections()) {
                    gc.drawLine(x, y, x, ge2.getY() + ge2.getHeight() / 2 + 8 - this._settings.getReverseDependencyLineHorizontalSpacer());
                    y = ge2.getY() + ge2.getHeight() / 2 + 8 - this._settings.getReverseDependencyLineHorizontalSpacer();
                } else {
                    gc.drawLine(x, y, x, ge2.getY() + ge2.getHeight() / 2 + 8 - this._settings.getReverseDependencyLineHorizontalSpacer());
                    y = ge2.getY() + ge2.getHeight() / 2 + 8 - this._settings.getReverseDependencyLineHorizontalSpacer();
                }
                xy = this.drawBend(gc, 1, x, y, true);
                x = xy.x;
                y = xy.y;
                gc.drawLine(x, y, ge2.getX(), y);
                if (!this._settings.showArrows()) continue;
                x = ge2.getX() - 8;
                this._paintManager.drawArrowHead(x, y, 131072, gc);
                continue;
            }
            if (!targetIsOnRight) continue;
            gc.setForeground(connection.getColor() == null ? this._arrowColor : connection.getColor());
            if (ge2.getX() - ge1.getXEnd() <= dw) {
                gc.drawLine(ge1.getXEnd(), y, ge2.getX(), y);
                if (!this._settings.showArrows()) continue;
                x = ge2.getX() - 8;
                this._paintManager.drawArrowHead(x, y, 131072, gc);
                continue;
            }
            gc.drawLine(x, y, x + rect.width, y);
            xy = this.drawBend(gc, 2, x += rect.width, y, true);
            x = xy.x;
            y = xy.y;
            if (this._settings.useSplitArrowConnections()) {
                gc.drawLine(x, y, x, ge2.getY() + ge2.getHeight() + this._eventSpacer / 2);
                y = ge2.getY() + ge2.getHeight();
            } else {
                gc.drawLine(x, y, x, ge2.getY() + ge2.getHeight() / 2 + 2 + this._eventSpacer / 2);
                y = ge2.getY() + ge2.getHeight() / 2 + 2;
            }
            xy = this.drawBend(gc, 2, x, y += this._eventSpacer / 2, true);
            x = xy.x;
            y = xy.y;
            gc.drawLine(x, y, ge2.getX() - 8 - 4, y);
            x = ge2.getX() - 8 - 4;
            xy = this.drawBend(gc, 1, x, y, true);
            x = xy.x;
            y = xy.y;
            if (this._settings.useSplitArrowConnections()) {
                gc.drawLine(x, y, x, ge2.getY() + ge2.getHeight() / 2 + 2);
                y = ge2.getY() + ge2.getHeight() / 2 + 2;
            } else {
                gc.drawLine(x, y, x, ge2.getY() + ge2.getHeight() / 2 + 2);
                y = ge2.getY() + ge2.getHeight() / 2 + 2;
            }
            xy = this.drawBend(gc, 1, x, y, true);
            x = xy.x;
            y = xy.y;
            gc.drawLine(x, y, ge2.getX(), y);
            if (!this._settings.showArrows()) continue;
            x = ge2.getX() - 8;
            this._paintManager.drawArrowHead(x, y, 131072, gc);
        }
        gc.setLineStyle(1);
        gc.setLineWidth(1);
    }

    private Point drawBend(GC gc, int style, int x, int y, boolean rounded) {
        int bonus;
        Point xy = new Point(0, 0);
        int n = bonus = _osType == 3 ? 1 : 0;
        if (rounded) {
            switch (style) {
                case 1: {
                    gc.drawLine(x + 1, y - 1, x + 1 + bonus, y - 1 - bonus);
                    gc.drawLine(x + 2, y - 2, x + 2 + bonus, y - 2 - bonus);
                    xy.x = x + 2;
                    xy.y = y - 2;
                    break;
                }
                case 2: {
                    gc.drawLine(x + 1, y + 1, x + 1 + bonus, y + 1 + bonus);
                    gc.drawLine(x + 2, y + 2, x + 2 + bonus, y + 2 + bonus);
                    xy.x = x + 2;
                    xy.y = y + 2;
                    break;
                }
                case 4: {
                    gc.drawLine(x - 1, y + 1, x - 1 + bonus, y + 1 + bonus);
                    gc.drawLine(x - 2, y + 2, x - 2 + bonus, y + 2 + bonus);
                    xy.x = x - 2;
                    xy.y = y + 2;
                    break;
                }
                case 3: {
                    gc.drawLine(x - 1, y - 1, x - 1 + bonus, y - 1 - bonus);
                    gc.drawLine(x - 2, y - 2, x - 2 + bonus, y - 2 - bonus);
                    xy.x = x - 2;
                    xy.y = y - 2;
                    break;
                }
            }
        } else {
            xy.x = x;
            xy.y = y;
        }
        return xy;
    }

    private void drawTodayLine(GC gc, Rectangle bounds, int x, int dayOfWeek) {
        if (this._currentView == 5) {
            return;
        }
        int xStart = x;
        gc.setForeground(this._lineTodayColor);
        gc.setLineWidth(this._settings.getTodayLineWidth());
        gc.setLineStyle(this._settings.getTodayLineStyle());
        if ((this._currentView == 2 || this._currentView == 3) && dayOfWeek == this._mainCalendar.getFirstDayOfWeek()) {
            --xStart;
        }
        int vOffset = this._settings.getTodayLineVerticalOffset();
        int yStart = bounds.y - this._settings.getHeaderMonthHeight();
        if (!this._settings.drawHeader()) {
            vOffset = 0;
        }
        yStart += vOffset;
        if (!this._settings.drawHeader()) {
            yStart = bounds.y;
        }
        yStart -= this._vScrollPos;
        if (this._useAlpha) {
            gc.setAlpha(this._colorManager.getTodayLineAlpha());
        }
        gc.drawLine(xStart, yStart, xStart, bounds.height + yStart + this._vScrollPos);
        if (this._useAlpha) {
            gc.setAlpha(0);
            gc.setAdvanced(false);
        }
        gc.setLineWidth(1);
        gc.setLineStyle(1);
    }

    private String getDateString(Calendar cal, boolean top) {
        if (top) {
            switch (this._currentView) {
                case 2: {
                    return DateHelper.getDate(cal, this._settings.getWeekHeaderTextDisplayFormatTop());
                }
                case 3: {
                    return DateHelper.getDate(cal, this._settings.getMonthHeaderTextDisplayFormatTop());
                }
                case 1: {
                    return DateHelper.getDate(cal, this._settings.getDayHeaderTextDisplayFormatTop());
                }
                case 4: {
                    return DateHelper.getDate(cal, this._settings.getYearHeaderTextDisplayFormatTop());
                }
            }
        } else {
            switch (this._currentView) {
                case 2: {
                    return DateHelper.getDate(cal, this._settings.getWeekHeaderTextDisplayFormatBottom()).substring(0, 1);
                }
                case 3: {
                    return DateHelper.getDate(cal, this._settings.getMonthHeaderTextDisplayFormatBottom());
                }
                case 1: {
                    return DateHelper.getDate(cal, this._settings.getDayHeaderTextDisplayFormatBottom());
                }
                case 4: {
                    return DateHelper.getDate(cal, this._settings.getYearHeaderTextDisplayFormatBottom());
                }
            }
        }
        return cal.getTime().toString();
    }

    public void setDate(Calendar date) {
        this.checkWidget();
        this.setDate(date, false);
    }

    public void jumpToToday() {
        this.jumpToToday(16384);
    }

    public void jumpToToday(int side) {
        this.checkWidget();
        Calendar cal = Calendar.getInstance(this._defaultLocale);
        if (this._currentView == 1) {
            this.internalSetDate(cal, side, true, true);
        } else {
            this.setDate(cal, side, false);
        }
    }

    public void jumpToEarliestEvent() {
        this.jumpToEvent(true);
    }

    public void jumpToLatestEvent() {
        this.jumpToEvent(false);
    }

    private void jumpToEvent(boolean earliestEvent) {
        Calendar cal = Calendar.getInstance(this._defaultLocale);
        Date earliest = this.getEventDate(earliestEvent);
        if (earliest == null) {
            return;
        }
        this.flagForceFullUpdate();
        cal.setTime(earliest);
        if (this._currentView == 1) {
            this.internalSetDate(cal, 16384, true, true);
        } else {
            this.setDate(cal, false);
        }
    }

    public void jumpToEvent(GanttEvent event, boolean start, int side) {
        Calendar cal = Calendar.getInstance(this._defaultLocale);
        if (start) {
            cal.setTime(event.getActualStartDate().getTime());
        } else {
            cal.setTime(event.getActualEndDate().getTime());
        }
        this.internalSetDate(cal, side, true, true);
    }

    private GanttEvent getEvent(boolean earliest, boolean pixelComparison) {
        Calendar cal = null;
        GanttEvent retEvent = null;
        for (int i = 0; i < this._ganttEvents.size(); ++i) {
            Rectangle r;
            GanttEvent ge = (GanttEvent)this._ganttEvents.get(i);
            if (earliest) {
                if (cal == null) {
                    cal = ge.getEarliestStartDate();
                    retEvent = ge;
                    continue;
                }
                if (pixelComparison) {
                    r = ge.getActualBounds();
                    if (r.x >= retEvent.getActualBounds().x) continue;
                    cal = ge.getEarliestStartDate();
                    retEvent = ge;
                    continue;
                }
                if (!ge.getEarliestStartDate().before(cal)) continue;
                cal = ge.getEarliestStartDate();
                retEvent = ge;
                continue;
            }
            if (cal == null) {
                cal = ge.getLatestEndDate();
                retEvent = ge;
                continue;
            }
            if (pixelComparison) {
                r = ge.getActualBounds();
                Rectangle other = retEvent.getActualBounds();
                if (r.x + r.width <= other.x + other.width) continue;
                cal = ge.getLatestEndDate();
                retEvent = ge;
                continue;
            }
            if (!ge.getLatestEndDate().after(cal)) continue;
            cal = ge.getLatestEndDate();
            retEvent = ge;
        }
        return retEvent;
    }

    private Date getEventDate(boolean earliest) {
        Calendar ret = null;
        for (int i = 0; i < this._ganttEvents.size(); ++i) {
            GanttEvent ge = (GanttEvent)this._ganttEvents.get(i);
            if (earliest) {
                if (ret == null) {
                    ret = ge.getActualStartDate();
                    continue;
                }
                if (!ge.getActualStartDate().before(ret)) continue;
                ret = ge.getActualStartDate();
                continue;
            }
            if (ret == null) {
                ret = ge.getActualEndDate();
                continue;
            }
            if (!ge.getActualEndDate().after(ret)) continue;
            ret = ge.getActualEndDate();
        }
        return ret == null ? null : ret.getTime();
    }

    public void setDate(Calendar date, int side, boolean clearMinutes) {
        this.internalSetDate(date, side, clearMinutes, true);
    }

    public void setDate(Calendar date, int side) {
        this.internalSetDate(date, side, true, true);
    }

    private void internalSetDateAtX(int x, Calendar preZoomDate, boolean clearMinutes, boolean redraw, boolean zoomIn) {
        Calendar target = this.getDateAt(x);
        if (this._currentView == 1) {
            int hours = DateHelper.hoursBetween(target, preZoomDate, false);
            Calendar toSet = DateHelper.getNewCalendar(this._mainCalendar);
            if (zoomIn) {
                hours = Math.abs(hours);
            }
            toSet.add(11, hours);
            this.internalSetDate(toSet, 16384, clearMinutes, redraw);
        } else {
            int days = (int)DateHelper.daysBetween(target, preZoomDate);
            if (zoomIn) {
                days = Math.abs(days);
            }
            Calendar toSet = DateHelper.getNewCalendar(this._mainCalendar);
            toSet.add(5, days);
            this.internalSetDate(toSet, 16384, clearMinutes, redraw);
        }
    }

    private void internalSetDate(Calendar date, int side, boolean clearMinutes, boolean redraw) {
        this.checkWidget();
        this._mainCalendar = DateHelper.getNewCalendar(date);
        if (clearMinutes) {
            this._mainCalendar.set(12, 0);
            this._mainCalendar.set(13, 0);
            this._mainCalendar.set(14, 0);
        }
        Calendar copy = DateHelper.getNewCalendar(date);
        copy.set(11, 0);
        if (clearMinutes) {
            copy.set(12, 0);
            copy.set(13, 0);
            copy.set(14, 0);
        }
        switch (side) {
            case 16384: {
                if (this._currentView != 1) break;
                copy.set(11, date.get(11));
                break;
            }
            case 0x1000000: {
                if (this._currentView == 1) {
                    int middleHours = this._hoursVisible / 2;
                    copy.set(11, date.get(11));
                    copy.add(11, -middleHours);
                    break;
                }
                int middle = this._daysVisible / 2;
                copy.add(5, -middle);
                break;
            }
            case 131072: {
                if (this._currentView == 1) {
                    copy.set(11, date.get(11));
                    copy.add(11, -this._hoursVisible);
                    break;
                }
                copy.add(5, -this._daysVisible + 1);
                break;
            }
        }
        this._mainCalendar = copy;
        this._recalcScopes = true;
        this._recalcSecBounds = true;
        if (redraw) {
            this.redraw();
        }
    }

    public void setDate(Calendar date, boolean applyOffset) {
        this.setDate(date, applyOffset, true);
    }

    private void setDate(Calendar date, boolean applyOffset, boolean redraw) {
        this.checkWidget();
        Calendar copy = DateHelper.getNewCalendar(date);
        if (applyOffset) {
            copy.add(5, this._calStartOffset);
        }
        if (this._settings.startCalendarOnFirstDayOfWeek() && this._currentView != 5) {
            copy.set(7, copy.getFirstDayOfWeek());
        }
        this.internalSetDate(copy, 16384, true, redraw);
    }

    public void reindex(GanttEvent event, int newIndex) {
        this._ganttEvents.remove(event);
        this._ganttEvents.add(newIndex, event);
        this.redrawEventsArea();
    }

    public void reindex(GanttSection section, int newIndex) {
        this._ganttSections.remove(section);
        this._ganttSections.add(newIndex, section);
        this.redrawEventsArea();
    }

    public void reindex(GanttGroup group, int newIndex) {
        this.checkWidget();
        this._ganttGroups.remove(group);
        this._ganttGroups.add(newIndex, group);
        this.redrawEventsArea();
    }

    public void addPhase(GanttPhase phase) {
        this.checkWidget();
        this.addPhase(phase, true);
    }

    public void removePhase(GanttPhase phase) {
        this.removePhase(phase, true);
    }

    public void addSpecialDateRange(GanttSpecialDateRange range) {
        this.addSpecialDateRange(range, true);
    }

    public void removeSpecialDateRange(GanttSpecialDateRange range) {
        this.removeSpecialDateRange(range, true);
    }

    public void removeSpecialDateRange(GanttSpecialDateRange range, boolean redraw) {
        this.checkWidget();
        this._specDateRanges.remove(range);
        if (redraw) {
            this.redraw();
        }
    }

    public void clearSpecialDateRanges() {
        this.checkWidget();
        this._specDateRanges.clear();
        this.redraw();
    }

    public void addSpecialDateRange(GanttSpecialDateRange range, boolean redraw) {
        this.checkWidget();
        if (!this._specDateRanges.contains(range)) {
            this._specDateRanges.add(range);
        }
        if (redraw) {
            this.redraw();
        }
    }

    public void addPhase(GanttPhase phase, boolean redraw) {
        this.checkWidget();
        if (!this._ganttPhases.contains(phase)) {
            this._ganttPhases.add(phase);
        }
        if (redraw) {
            this.redraw();
        }
    }

    public void removePhase(GanttPhase phase, boolean redraw) {
        this.checkWidget();
        this._ganttPhases.remove(phase);
        if (redraw) {
            this.redraw();
        }
    }

    public void clearPhases() {
        this._ganttPhases.clear();
        this.redraw();
    }

    public void addEvent(GanttEvent event) {
        this.checkWidget();
        this.addEvent(event, true);
    }

    public void addEvent(GanttEvent event, int index) {
        this.checkWidget();
        this.internalAddEvent(index, event);
        this.redraw();
    }

    public void addEvent(GanttEvent event, boolean redraw) {
        this.checkWidget();
        this.internalAddEvent(-1, event);
        if (redraw) {
            this.redraw();
        }
    }

    public boolean removeEvent(GanttEvent event) {
        int i;
        if (event == null) {
            return false;
        }
        this.checkWidget();
        this.internalRemoveEvent(event);
        ArrayList<GanttConnection> toRemove = new ArrayList<GanttConnection>();
        for (i = 0; i < this._ganttConnections.size(); ++i) {
            GanttConnection con = (GanttConnection)this._ganttConnections.get(i);
            if (!con.getSource().equals(event) && !con.getTarget().equals(event)) continue;
            toRemove.add(con);
        }
        for (i = 0; i < toRemove.size(); ++i) {
            this._ganttConnections.remove(toRemove.get(i));
        }
        if (event.getScopeParent() != null) {
            event.getScopeParent().removeScopeEvent(event);
        }
        if (event.getGanttSection() != null) {
            event.getGanttSection().removeGanttEvent(event);
        }
        if (event.getGanttGroup() != null) {
            event.getGanttGroup().removeEvent(event);
        }
        boolean ret = this._ganttEvents.remove(event);
        this.redrawEventsArea();
        return ret;
    }

    public List getGanttConnections() {
        return this._ganttConnections;
    }

    void eventDatesChanged(GanttEvent ge, boolean redraw) {
        int newStartX = this.getXForDate(ge.getActualStartDate());
        int newEndX = this.getXForDate(ge.getActualEndDate());
        if (this._currentView != 1) {
            newEndX += this.getDayWidth();
        }
        ge.updateX(newStartX);
        ge.updateWidth(newEndX - newStartX);
        if (redraw) {
            this.redraw();
        }
    }

    public void clearGanttEvents() {
        this.checkWidget();
        this._ganttEvents.clear();
        this._ganttConnections.clear();
        this.eventNumbersChanged();
        this._forceSBUpdate = true;
        this._vScrollPos = 0;
        this._lastVScrollPos = 0;
        this._vScrollBar.setSelection(0);
        this.redraw();
    }

    public void clearGanttGroups() {
        this.checkWidget();
        this._ganttGroups.clear();
        this.eventNumbersChanged();
        this._forceSBUpdate = true;
        this._vScrollPos = 0;
        this._lastVScrollPos = 0;
        this._vScrollBar.setSelection(0);
        this.redraw();
    }

    public void clearGanttSections() {
        this.checkWidget();
        this._ganttSections.clear();
        this.eventNumbersChanged();
        this._forceSBUpdate = true;
        this._vScrollPos = 0;
        this._lastVScrollPos = 0;
        this._vScrollBar.setSelection(0);
        this.redraw();
    }

    public void clearChart() {
        this.checkWidget();
        this._ganttEvents.clear();
        this._ganttConnections.clear();
        this._ganttSections.clear();
        this._ganttGroups.clear();
        this._ganttPhases.clear();
        this._specDateRanges.clear();
        this.eventNumbersChanged();
        this._forceSBUpdate = true;
        this._vScrollPos = 0;
        this._lastVScrollPos = 0;
        this._vScrollBar.setSelection(0);
        this.flagForceFullUpdate();
        this.redraw();
    }

    public boolean hasEvent(GanttEvent event) {
        this.checkWidget();
        return this._ganttEvents.contains(event);
    }

    public void nextMonth() {
        this._viewPortHandler.nextMonth();
    }

    public void prevMonth() {
        this._viewPortHandler.prevMonth();
    }

    public void nextWeek() {
        this._viewPortHandler.nextWeek();
    }

    public void prevWeek() {
        this._viewPortHandler.prevWeek();
    }

    public void nextHour() {
        this._viewPortHandler.nextHour();
    }

    public void prevHour() {
        this._viewPortHandler.prevHour();
    }

    public void nextDay() {
        this._viewPortHandler.nextDay();
    }

    public void prevDay() {
        this._viewPortHandler.prevDay();
    }

    void setNoRecalc() {
        this._recalcScopes = false;
        this._recalcSecBounds = false;
    }

    private void internalAddEvent(int index, GanttEvent event) {
        if (!this._ganttEvents.contains(event)) {
            if (index == -1) {
                this._ganttEvents.add(event);
            } else {
                this._ganttEvents.add(index, event);
            }
        }
        this._allEventsCombined.add(event);
        this.flagForceFullUpdate();
    }

    private void internalRemoveEvent(GanttEvent event) {
        this._ganttEvents.remove(event);
        this._allEventsCombined.remove(event);
        this.flagForceFullUpdate();
    }

    private void internalAddGroup(int index, GanttGroup group) {
        if (!this._ganttGroups.contains(group)) {
            if (index == -1) {
                this._ganttGroups.add(group);
            } else {
                this._ganttGroups.add(index, group);
            }
        }
        this._allEventsCombined.addAll(group.getEventMembers());
        this.flagForceFullUpdate();
    }

    private void internalRemoveGroup(GanttGroup group) {
        this._ganttGroups.remove(group);
        this._allEventsCombined.removeAll(group.getEventMembers());
        this.flagForceFullUpdate();
    }

    private void internalAddSection(GanttSection section) {
        if (!this._ganttSections.contains(section)) {
            this._ganttSections.add(section);
        }
        this.flagForceFullUpdate();
    }

    private void internalRemoveSection(GanttSection section) {
        this._ganttSections.remove(section);
        this.flagForceFullUpdate();
    }

    private void eventNumbersChanged() {
        int i;
        this._allEventsCombined.clear();
        for (i = 0; i < this._ganttEvents.size(); ++i) {
            Object obj = this._ganttEvents.get(i);
            if (obj instanceof GanttEvent) {
                this._allEventsCombined.add(obj);
                continue;
            }
            if (!(obj instanceof GanttGroup)) continue;
            this._allEventsCombined.addAll(((GanttGroup)obj).getEventMembers());
        }
        for (i = 0; i < this._ganttGroups.size(); ++i) {
            this._allEventsCombined.addAll(((GanttGroup)this._ganttGroups.get(i)).getEventMembers());
        }
        this.flagForceFullUpdate();
    }

    void moveXBounds(boolean positive) {
        Object[] objs = this._allEventsCombined.toArray();
        int dw = this.getDayWidth();
        if (this._currentView == 4) {
            Calendar temp = Calendar.getInstance(this._defaultLocale);
            temp.setTime(this._mainCalendar.getTime());
            temp.add(2, positive ? 1 : -1);
            long days = DateHelper.daysBetween(this._mainCalendar, temp);
            dw = Math.abs((int)days * dw);
        }
        for (int i = 0; i < this._allEventsCombined.size(); ++i) {
            GanttEvent ge = (GanttEvent)objs[i];
            ge.updateX(ge.getX() + (positive ? dw : -dw));
        }
    }

    private void moveYBounds(int move) {
        Object[] objs = this._allEventsCombined.toArray();
        for (int i = 0; i < objs.length; ++i) {
            GanttEvent ge = (GanttEvent)objs[i];
            ge.updateY(ge.getY() - move);
        }
        this._visibleBounds.y += move;
        this.updateEventVisibilities(this._visibleBounds);
    }

    public void refresh() {
        this.checkWidget();
        this.redraw();
    }

    private void redrawEventsArea() {
        this.redraw();
    }

    public boolean isEventVisible(GanttEvent event, Rectangle bounds) {
        return this.getEventVisibility(event, bounds) == 1;
    }

    private int getEventVisibility(GanttEvent event, Rectangle bounds) {
        if (this._savingChartImage && !event.isHidden()) {
            return 1;
        }
        if (this._hiddenLayers.contains(new Integer(event.getLayer()))) {
            return 4;
        }
        if (event.getActualStartDate() == null || event.getActualEndDate() == null) {
            return 4;
        }
        Rectangle fakeBounds = new Rectangle(event.getX(), event.getY(), event.getWidth(), event.getHeight());
        fakeBounds.y += this._vScrollPos;
        if (event.getY() != 0) {
            if (fakeBounds.y > this._visibleBounds.y + this._visibleBounds.height) {
                return 6;
            }
            if (fakeBounds.y + fakeBounds.height < this._visibleBounds.y) {
                return 5;
            }
        }
        Calendar sCal = null;
        Calendar eCal = null;
        if (this.isShowingPlannedDates()) {
            sCal = event.getEarliestStartDate();
            eCal = event.getLatestEndDate();
        } else {
            sCal = event.getActualStartDate();
            eCal = event.getActualEndDate();
            if (sCal == null) {
                sCal = event.getRevisedStart();
            }
            if (eCal == null) {
                eCal = event.getRevisedEnd();
            }
        }
        if (event.isScope()) {
            GanttEvent earliest = event.getEarliestScopeEvent();
            GanttEvent latest = event.getLatestScopeEvent();
            if (earliest != null) {
                sCal = earliest.getActualStartDate();
            }
            if (latest != null) {
                eCal = latest.getActualEndDate();
            }
            if (sCal == null || eCal == null) {
                return 4;
            }
        }
        if (event.hasMovementConstraints()) {
            if (event.getNoMoveBeforeDate() != null && event.getNoMoveBeforeDate().before(sCal)) {
                sCal = event.getNoMoveBeforeDate();
            }
            if (event.getNoMoveAfterDate() != null && event.getNoMoveAfterDate().after(eCal)) {
                eCal = event.getNoMoveAfterDate();
            }
        }
        if (event.getWidthWithText() == 0) {
            Date eventStart = sCal.getTime();
            Date eventEnd = eCal.getTime();
            Calendar temp = Calendar.getInstance(this._defaultLocale);
            temp.setTime(this._mainCalendar.getTime());
            long viewPortStart = temp.getTimeInMillis();
            if (this._daysVisible == 0) {
                temp.setTime(this._endCalendar.getTime());
            } else {
                temp.add(5, this._daysVisible);
            }
            long viewPortEnd = temp.getTimeInMillis();
            if (eventStart.getTime() <= viewPortEnd && eventEnd.getTime() >= viewPortStart) {
                return 1;
            }
            if (eventStart.getTime() <= viewPortStart && eventEnd.getTime() >= viewPortEnd) {
                return 1;
            }
            if (eventStart.getTime() >= viewPortStart && eventStart.getTime() <= viewPortEnd && eventEnd.getTime() >= viewPortEnd) {
                return 1;
            }
        } else {
            int xStart = this.getStartingXFor(sCal);
            int xEnd = this.getXForDate(eCal);
            int buffer = this._settings.getArrowHeadEventSpacer();
            xEnd += buffer;
            xStart -= buffer;
            if (event.getHorizontalTextLocation() == 131072) {
                xEnd += event.getNameExtent().x;
            }
            if (xEnd < 0) {
                return 2;
            }
            if (xStart > bounds.width) {
                return 3;
            }
            if (!(event.getVisibility() != 5 && event.getVisibility() != 6 || event.isBoundsSet())) {
                event.updateX(xStart);
                event.updateWidth(xEnd - xStart + this.getDayWidth());
            }
            return 1;
        }
        return 4;
    }

    private int getStartingXFor(GanttEvent event) {
        if (this._currentView == 1) {
            return this.getStartingXForEventHours(event);
        }
        return this.getStartingXFor(event.getActualStartDate());
    }

    public int getStartingXForEventDate(Calendar date) {
        return this.getStartingXFor(date);
    }

    private int getStartingXForEventHours(GanttEvent event) {
        return this.getStartingXForEventHours(event.getActualStartDate());
    }

    private int getStartingXForEventHours(Calendar start) {
        Calendar temp = Calendar.getInstance(this._defaultLocale);
        temp.setTime(this._mainCalendar.getTime());
        int dw = this.getDayWidth();
        int daysBetween = (int)DateHelper.daysBetween(temp, start);
        int ret = daysBetween * this._weekWidth;
        ret += this._mainBounds.x;
        float hoursBetween = DateHelper.hoursBetween(temp, start, true);
        float minutesBetween = DateHelper.minutesBetween(temp.getTime(), start.getTime(), true, false);
        float minPixels = 0.0f;
        if (!this._settings.roundHourlyEventsOffToNearestHour()) {
            float remainderMins = minutesBetween - hoursBetween * 60.0f;
            float oneMinWidth = (float)dw / 60.0f;
            minPixels = oneMinWidth * remainderMins;
        }
        ret = (int)((float)ret + (hoursBetween * (float)dw + minPixels));
        return ret;
    }

    public int getStartingXFor(Calendar date) {
        this.checkWidget();
        if (this._currentView == 1) {
            return this.getStartingXForEventHours(date);
        }
        if (date == null) {
            return this._mainBounds.x;
        }
        Calendar temp = DateHelper.getNewCalendar(this._mainCalendar);
        if (this._currentView == 4) {
            temp.set(5, 1);
        }
        long daysBetween = DateHelper.daysBetween(temp, date);
        int dw = this.getDayWidth();
        int extra = 0;
        if (this._drawToMinute && this._currentView != 1) {
            float ppm = 60.0f / (float)this._dayWidth;
            int mins = date.get(11);
            extra = (int)((float)mins * ppm);
        }
        return this._mainBounds.x + (int)daysBetween * dw + extra;
    }

    private int getXLengthForEventHours(GanttEvent event) {
        return this.getXForDate(event.getActualEndDate()) - this.getXForDate(event.getActualStartDate());
    }

    private int getXLengthForEvent(GanttEvent event) {
        if (this._currentView == 1) {
            return this.getXLengthForEventHours(event);
        }
        return (event.getDaysBetweenStartAndEnd() + this._daysToAppendForEndOfDay) * this.getDayWidth();
    }

    public int getDayWidth() {
        int dw = this._dayWidth;
        if (this._currentView == 3) {
            dw = this._monthDayWidth;
        } else if (this._currentView == 4) {
            dw = this._yearDayWidth;
        }
        return dw;
    }

    private boolean isInside(int x, int y, Rectangle rect) {
        if (rect == null) {
            return false;
        }
        return x >= rect.x && y >= rect.y && x <= rect.x + rect.width && y <= rect.y + rect.height;
    }

    public void mouseDoubleClick(MouseEvent me) {
        this.killDialogs();
        this.killMouseState();
        for (int i = 0; i < this._ganttEvents.size(); ++i) {
            GanttEvent event = (GanttEvent)this._ganttEvents.get(i);
            if (!this.isInside(me.x, me.y, new Rectangle(event.getX(), event.getY(), event.getWidth(), event.getHeight()))) continue;
            for (int j = 0; j < this._eventListeners.size(); ++j) {
                ((IGanttEventListener)this._eventListeners.get(j)).eventDoubleClicked(event, me);
            }
            return;
        }
    }

    private void killMouseState() {
        this._mouseIsDown = false;
    }

    public List getAllSelectedHeaderDates() {
        return this._selHeaderDates;
    }

    public void clearAllSelectedHeaders() {
        this._selHeaderDates.clear();
        this.redraw();
    }

    public void setSelectedHeaderDates(List dates) {
        this._selHeaderDates = dates;
        this.redraw();
    }

    private void doMultiSelect(Rectangle rect, MouseEvent me) {
        if (rect == null) {
            return;
        }
        for (int i = 0; i < this._ganttEvents.size(); ++i) {
            GanttEvent ge = (GanttEvent)this._ganttEvents.get(i);
            if (ge.isScope() || !ge.getBounds().intersects(rect)) continue;
            this._selectedEvents.add(ge);
        }
        for (int x = 0; x < this._eventListeners.size(); ++x) {
            IGanttEventListener listener = (IGanttEventListener)this._eventListeners.get(x);
            listener.eventSelected(null, this._selectedEvents, me);
        }
        this.redraw();
    }

    public void mouseDown(MouseEvent me) {
        Rectangle headerBounds;
        if (me.button == 1) {
            this._mouseIsDown = true;
        }
        Point ctrlPoint = this.toDisplay(new Point(me.x, me.y));
        if (this._settings.allowBlankAreaDragAndDropToMoveDates() && me.button == 1) {
            this.setCursor(Constants.CURSOR_HAND);
        }
        if (!this._selectedEvents.isEmpty() && this._settings.drawSelectionMarkerAroundSelectedEvent()) {
            for (int x = 0; x < this._selectedEvents.size(); ++x) {
                GanttEvent selEvent = (GanttEvent)this._selectedEvents.get(x);
                this.redraw(selEvent.getX() - 2, selEvent.getY() - 2, selEvent.getWidth() + 4, selEvent.getHeight() + 4, false);
            }
        }
        if (this._settings.drawHeader() && this._settings.allowHeaderSelection() && me.button == 1 && this.isInside(me.x, me.y, headerBounds = new Rectangle(this._mainBounds.x, this._settings.getHeaderMonthHeight() + this._vScrollPos, this._mainBounds.width, this._settings.getHeaderDayHeight()))) {
            Calendar cal = this.getDateAt(me.x - this._mainBounds.x);
            if (me.stateMask == SWT.MOD1 || me.stateMask == 131072 || me.stateMask == (SWT.MOD1 | 0x20000)) {
                if (me.stateMask == SWT.MOD1) {
                    if (this._selHeaderDates.contains(cal)) {
                        this._selHeaderDates.remove(cal);
                    } else {
                        this._selHeaderDates.add(cal);
                    }
                } else if (!this._selHeaderDates.isEmpty()) {
                    Calendar last = (Calendar)this._selHeaderDates.get(this._selHeaderDates.size() - 1);
                    long days = 0L;
                    boolean reverse = false;
                    if (last.before(cal)) {
                        days = DateHelper.daysBetween(last, cal);
                    } else {
                        days = DateHelper.daysBetween(cal, last);
                        reverse = true;
                    }
                    Calendar temp = Calendar.getInstance(this._defaultLocale);
                    temp.setTime(last.getTime());
                    for (int i = 0; i < (int)days; ++i) {
                        temp.add(5, reverse ? -1 : 1);
                        Calendar temp2 = Calendar.getInstance(this._defaultLocale);
                        temp2.setTime(temp.getTime());
                        this._selHeaderDates.add(temp2);
                    }
                }
            } else if (this._selHeaderDates.contains(cal)) {
                this._selHeaderDates.clear();
            } else {
                this._selHeaderDates.clear();
                this._selHeaderDates.add(cal);
            }
            for (int i = 0; i < this._eventListeners.size(); ++i) {
                ((IGanttEventListener)this._eventListeners.get(i)).eventHeaderSelected(cal, this._selHeaderDates);
            }
            this.redraw();
            return;
        }
        for (int i = 0; i < this._ganttEvents.size(); ++i) {
            int x;
            GanttEvent event = (GanttEvent)this._ganttEvents.get(i);
            if (event.isScope() && !this._settings.allowScopeMenu() || !this.isInside(me.x, me.y, new Rectangle(event.getX(), event.getY(), event.getWidth(), event.getHeight()))) continue;
            GC gc = new GC((Drawable)this);
            if (me.button == 3 && event.isScope()) {
                this.showMenu(ctrlPoint.x, ctrlPoint.y, event, me);
                gc.dispose();
                return;
            }
            if (me.stateMask == 0 || !this._multiSelect) {
                this._selectedEvents.clear();
            }
            if (this._multiSelect) {
                if (this._selectedEvents.contains(event) && me.stateMask == SWT.MOD1) {
                    this._selectedEvents.remove(event);
                } else {
                    this._selectedEvents.add(event);
                }
            } else {
                this._selectedEvents.add(event);
            }
            if (!this._selectedEvents.isEmpty()) {
                for (x = 0; x < this._eventListeners.size(); ++x) {
                    IGanttEventListener listener = (IGanttEventListener)this._eventListeners.get(x);
                    listener.eventSelected(event, this._selectedEvents, me);
                }
            }
            for (x = 0; x < this._selectedEvents.size(); ++x) {
                GanttEvent selEvent = (GanttEvent)this._selectedEvents.get(x);
                if (selEvent.isCheckpoint() || selEvent.isScope() || selEvent.isImage() || !this._settings.drawSelectionMarkerAroundSelectedEvent()) continue;
                gc.setForeground(ColorCache.getWhite());
                this.drawSelectionAroundEvent(gc, event, event.getX(), event.getY(), event.getWidth(), this._mainBounds);
            }
            gc.dispose();
            if (this._settings.showOnlyDependenciesForSelectedItems()) {
                this.redrawEventsArea();
            }
            if (me.button == 3 && !this._selectedEvents.isEmpty()) {
                this.showMenu(ctrlPoint.x, ctrlPoint.y, (GanttEvent)this._selectedEvents.get(this._selectedEvents.size() - 1), me);
            }
            return;
        }
        if (me.button == 3) {
            this._selectedEvents.clear();
            this.showMenu(ctrlPoint.x, ctrlPoint.y, null, me);
            return;
        }
        if (this._multiSelect && me.button == 1 && me.stateMask == SWT.MOD1) {
            this.setCursor(Constants.CURSOR_NONE);
            this._tracker = new Tracker((Composite)this, 16);
            this._tracker.setCursor(Constants.CURSOR_NONE);
            this._tracker.setStippled(true);
            this._tracker.setRectangles(new Rectangle[]{new Rectangle(me.x, me.y, 1, 1)});
            if (this._tracker.open()) {
                this.doMultiSelect(this._tracker.getRectangles()[0], me);
            }
            return;
        }
        if (me.stateMask == 0) {
            this._selectedEvents.clear();
        }
        if (this._settings.showOnlyDependenciesForSelectedItems()) {
            this.redrawEventsArea();
        }
    }

    private void drawSelectionAroundEvent(GC gc, GanttEvent ge, int xPos, int yPos, int eventWidth, Rectangle bounds) {
        boolean oobRight;
        if (!this._settings.drawSelectionMarkerAroundSelectedEvent()) {
            return;
        }
        gc.setLineStyle(3);
        int y = yPos;
        int x = xPos;
        boolean oobLeft = x < bounds.x;
        boolean bl = oobRight = x + eventWidth > bounds.width;
        if (oobLeft || oobRight) {
            if (!oobLeft || !oobRight) {
                if (oobLeft) {
                    x = bounds.x;
                    gc.drawLine(x, y, x + eventWidth, y);
                    gc.drawLine(x + eventWidth, y, x + eventWidth, y + ge.getHeight());
                    gc.drawLine(x, y + ge.getHeight(), x + eventWidth, y + ge.getHeight());
                } else {
                    gc.drawLine(x, y, bounds.width, y);
                    gc.drawLine(x, y, x, y + ge.getHeight());
                    gc.drawLine(x, y + ge.getHeight(), bounds.width, y + ge.getHeight());
                }
            } else {
                gc.drawLine(bounds.x, y, bounds.x + bounds.width, y);
                gc.drawLine(bounds.x, y + ge.getHeight(), bounds.x + bounds.width, y + ge.getHeight());
            }
        } else {
            gc.drawRectangle(x, y, eventWidth, this._eventHeight);
        }
        gc.setLineStyle(1);
    }

    public void mouseUp(MouseEvent event) {
        int i;
        this._mouseIsDown = false;
        boolean needsRedraw = false;
        if (this._tracker != null && !this._tracker.isDisposed()) {
            this._tracker.dispose();
        }
        if (!this._dragEvents.isEmpty()) {
            if (this._resizing) {
                for (i = 0; i < this._eventListeners.size(); ++i) {
                    ((IGanttEventListener)this._eventListeners.get(i)).eventsResizeFinished(this._dragEvents, event);
                }
            }
            if (this._dragging) {
                for (i = 0; i < this._eventListeners.size(); ++i) {
                    ((IGanttEventListener)this._eventListeners.get(i)).eventsMoveFinished(this._dragEvents, event);
                }
            }
        }
        if (this._freeDragging) {
            for (i = 0; i < this._ganttSections.size(); ++i) {
                GanttSection gs = (GanttSection)this._ganttSections.get(i);
                gs.clearDNDGanttEvents();
            }
            this._freeDragging = false;
            this._vDragDir = 0;
            this.handlePostVerticalDragDrop();
            this._vDNDManager.clear();
        }
        ClusteredCommand cc = new ClusteredCommand();
        if (this.hasSpecialDateRanges()) {
            for (int i2 = 0; i2 < this._specDateRanges.size(); ++i2) {
                GanttSpecialDateRange range = (GanttSpecialDateRange)this._specDateRanges.get(i2);
                ArrayList<GanttEvent> failedMoves = new ArrayList<GanttEvent>();
                for (int x = 0; x < this._dragEvents.size(); ++x) {
                    GanttEvent ge = (GanttEvent)this._dragEvents.get(x);
                    if (range.canEventOccupy(ge.getActualStartDate(), ge.getActualEndDate())) continue;
                    ge.moveCancelled();
                    this._dragEvents.remove(ge);
                    needsRedraw = true;
                    failedMoves.add(ge);
                }
                if (failedMoves.isEmpty()) continue;
                for (int j = 0; j < this._eventListeners.size(); ++j) {
                    ((IGanttEventListener)this._eventListeners.get(j)).eventsDroppedOrResizedOntoUnallowedDateRange(failedMoves, range);
                }
            }
        }
        for (int i3 = 0; i3 < this._dragEvents.size(); ++i3) {
            GanttEvent ge = (GanttEvent)this._dragEvents.get(i3);
            ge.moveFinished();
            IUndoRedoCommand undoCommand = ge.getPostMoveOrResizeUndoCommand();
            cc.addCommand(undoCommand);
        }
        if (cc.size() > 0) {
            this._undoRedoManager.record(cc);
        }
        if (this._dragPhase != null) {
            boolean notifyListeners = true;
            if (!this._settings.allowPhaseOverlap()) {
                for (int i4 = 0; i4 < this._ganttPhases.size(); ++i4) {
                    GanttPhase gp = (GanttPhase)this._ganttPhases.get(i4);
                    if (gp.equals(this._dragPhase) || !gp.getBounds().intersects(this._dragPhase.getBounds())) continue;
                    this._dragPhase.undoLastDragDrop();
                    notifyListeners = false;
                }
            }
            if (notifyListeners) {
                if (this._resizing) {
                    for (int i5 = 0; i5 < this._eventListeners.size(); ++i5) {
                        ((IGanttEventListener)this._eventListeners.get(i5)).phaseResizeFinished(this._dragPhase, event);
                    }
                }
                if (this._dragging) {
                    for (int i6 = 0; i6 < this._eventListeners.size(); ++i6) {
                        ((IGanttEventListener)this._eventListeners.get(i6)).phaseMoveFinished(this._dragPhase, event);
                    }
                }
            } else {
                needsRedraw = true;
            }
        }
        if (needsRedraw) {
            this.redraw();
        }
        this.endEverything();
        this.updateHorizontalScrollbar();
    }

    private void handlePostVerticalDragDrop() {
        if (this._dragEvents.isEmpty()) {
            this.redraw();
            return;
        }
        int vDragMode = this._settings.getVerticalEventDragging();
        for (int i = 0; i < this._dragEvents.size(); ++i) {
            int x;
            GanttEvent ge = (GanttEvent)this._dragEvents.get(i);
            GanttEvent top = this._vDNDManager.getTopEvent();
            GanttEvent bottom = this._vDNDManager.getBottomEvent();
            GanttSection targetSection = this._vDNDManager.getTargetSection();
            if (ge.getGanttSection() != null && targetSection != null && ge.getGanttSection() == targetSection && vDragMode == 2) {
                ge.undoVerticalDragging();
                continue;
            }
            if (ge.getGanttSection() != targetSection && this.hasGanttSections()) {
                for (x = 0; x < this._eventListeners.size(); ++x) {
                    ((IGanttEventListener)this._eventListeners.get(x)).eventMovedToNewSection(ge, ge.getGanttSection(), targetSection);
                }
            } else {
                for (x = 0; x < this._eventListeners.size(); ++x) {
                    ((IGanttEventListener)this._eventListeners.get(x)).eventReordered(ge);
                }
            }
            if (top == null && bottom == null) {
                if (targetSection == null) continue;
                ge.reparentToNewGanttSection(0, targetSection);
                continue;
            }
            int index = 0;
            if (ge.getPreVerticalDragBounds() != null && ge.getY() == ge.getPreVerticalDragBounds().y) continue;
            if (this.hasGanttSections()) {
                GanttSection fromSection = ge.getGanttSection();
                if (targetSection == null) {
                    targetSection = fromSection;
                }
                List toEvents = targetSection.getEvents();
                if (top == null) {
                    index = 0;
                }
                if (bottom == null) {
                    index = toEvents.size();
                }
                if (top != null && bottom != null) {
                    index = toEvents.indexOf(top);
                }
                if (ge.wasVerticallyMovedUp() && ge.getGanttSection() == targetSection) {
                    if (top != null) {
                        ++index;
                    }
                } else if (ge.wasVerticallyMovedUp() && ge.getGanttSection() != targetSection && top != null) {
                    ++index;
                }
                if (!ge.wasVerticallyMovedUp() && ge.getGanttSection() != targetSection && top != null) {
                    ++index;
                }
                if (index < 0) {
                    index = 0;
                }
                fromSection.removeGanttEvent(ge);
                targetSection.addGanttEvent(index, ge);
                continue;
            }
            if (top != null) {
                index = this._ganttEvents.indexOf(top);
            }
            if (ge.wasVerticallyMovedUp()) {
                ++index;
            }
            this._ganttEvents.remove(ge);
            this._ganttEvents.add(index, ge);
        }
        this.heavyRedraw();
    }

    private GanttSection getSectionForVerticalDND(GanttEvent event, boolean accountForVerticalDragDirection) {
        GanttSection gs;
        int i;
        if (!this.hasGanttSections()) {
            return null;
        }
        for (i = 0; i < this._ganttSections.size(); ++i) {
            gs = (GanttSection)this._ganttSections.get(i);
            if (!gs.getBounds().contains(event.getX(), event.getY() + this._vScrollPos)) continue;
            return gs;
        }
        if (event.getY() < this.getHeaderHeight()) {
            return event.getGanttSection();
        }
        for (i = 0; i < this._ganttSections.size(); ++i) {
            gs = (GanttSection)this._ganttSections.get(i);
            GanttSection next = null;
            if (i == this._ganttSections.size() - 1 || (next = (GanttSection)this._ganttSections.get(i + 1)) == null || event.getY() < gs.getBounds().y + gs.getBounds().height || event.getY() > next.getBounds().y) continue;
            if (accountForVerticalDragDirection) {
                if (this._vDragDir == 128) {
                    return gs;
                }
                return next;
            }
            return gs;
        }
        return null;
    }

    private List getSurroundingVerticalEvents(GanttEvent event, GanttSection section) {
        List allEvents = section == null ? this._ganttEvents : section.getEvents();
        ArrayList<GanttEvent> ret = new ArrayList<GanttEvent>();
        if (allEvents.isEmpty()) {
            ret.add(null);
            ret.add(null);
            return ret;
        }
        ArrayList<IGanttChartItem> sorted = new ArrayList<IGanttChartItem>();
        for (int i = 0; i < allEvents.size(); ++i) {
            IGanttChartItem ge = (IGanttChartItem)allEvents.get(i);
            if (!(ge instanceof GanttEvent) || ((GanttEvent)ge).isHidden()) continue;
            sorted.add(ge);
        }
        Collections.sort(sorted, new Comparator(){

            public int compare(Object one, Object two) {
                GanttEvent ge1 = (GanttEvent)one;
                GanttEvent ge2 = (GanttEvent)two;
                Integer i1 = new Integer(ge1.getY());
                Integer i2 = new Integer(ge2.getY());
                return i1.compareTo(i2);
            }
        });
        GanttEvent nearestUp = null;
        GanttEvent nearestDown = null;
        for (int i = 0; i < sorted.size(); ++i) {
            GanttEvent cur = (GanttEvent)sorted.get(i);
            GanttEvent next = null;
            if (i < sorted.size() - 1) {
                next = (GanttEvent)sorted.get(i + 1);
            }
            if (event.getY() < cur.getY() && (next == null || next != null && next.getY() > event.getY())) {
                if (nearestDown == null) {
                    nearestDown = cur;
                } else if (cur.getY() < nearestDown.getY()) {
                    nearestDown = cur;
                }
                for (int x = i; x >= 0; --x) {
                    GanttEvent ge = (GanttEvent)sorted.get(x);
                    if (ge.getY() >= nearestDown.getY() || ge.equals(event)) continue;
                    nearestUp = ge;
                    break;
                }
            }
            if (nearestUp != null && nearestDown != null) break;
        }
        Object first = null;
        if (!sorted.isEmpty()) {
            first = (GanttEvent)sorted.get(0);
        }
        if (first.equals(event) && sorted.size() > 1) {
            first = (GanttEvent)sorted.get(1);
        }
        int topMostY = ((GanttEvent)first).getY();
        int botMostY = ((GanttEvent)sorted.get(sorted.size() - 1)).getY();
        if (event.getY() < topMostY) {
            if (section == null) {
                nearestUp = null;
            } else {
                nearestUp = null;
                nearestDown = (GanttEvent)allEvents.get(0);
            }
        }
        if (event.getY() + event.getHeight() > botMostY) {
            if (section == null) {
                nearestDown = null;
            } else {
                nearestUp = (GanttEvent)allEvents.get(allEvents.size() - 1);
                nearestDown = null;
            }
        }
        ret.add(nearestUp);
        ret.add(nearestDown);
        return ret;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 27) {
            int i;
            ArrayList<GanttEvent> scopeEventsToUpdate = new ArrayList<GanttEvent>();
            if (!this._dragEvents.isEmpty()) {
                for (i = 0; i < this._dragEvents.size(); ++i) {
                    GanttEvent ge = (GanttEvent)this._dragEvents.get(i);
                    ge.moveCancelled();
                    if (ge.getScopeParent() == null || scopeEventsToUpdate.contains(ge.getScopeParent())) continue;
                    scopeEventsToUpdate.add(ge.getScopeParent());
                }
            }
            for (i = 0; i < scopeEventsToUpdate.size(); ++i) {
                this.updateScopeXY((GanttEvent)scopeEventsToUpdate.get(i));
            }
            this._dragPhase = null;
            this._dragEvents.clear();
            this.endEverything();
            this._selectedEvents.clear();
            this.killDialogs();
            if (this._freeDragging) {
                this.heavyRedraw();
            } else {
                this.redraw();
            }
            this.setCursor(Constants.CURSOR_NONE);
        }
        if (this._settings.allowArrowKeysToScrollChart()) {
            if (e.keyCode == 0x1000003) {
                if (this._currentView == 4) {
                    this.prevMonth();
                } else if (this._currentView == 1) {
                    this.prevHour();
                } else {
                    this.prevDay();
                }
            } else if (e.keyCode == 0x1000004) {
                if (this._currentView == 4) {
                    this.nextMonth();
                } else if (this._currentView == 1) {
                    this.nextHour();
                } else {
                    this.nextDay();
                }
            } else if (e.keyCode == 0x1000001) {
                this._vScrollBar.setSelection(this._vScrollBar.getSelection() - 10);
                this.vScroll(null);
            } else if (e.keyCode == 0x1000002) {
                this._vScrollBar.setSelection(this._vScrollBar.getSelection() + 10);
                this.vScroll(null);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        this.checkWidget();
        this.endEverything();
    }

    private void endEverything() {
        if (this._tracker != null && !this._tracker.isDisposed()) {
            this._tracker.dispose();
            this._mouseIsDown = false;
        }
        if (this._mouseIsDown) {
            return;
        }
        this._initialHoursDragOffset = 0;
        this._justStartedMoveOrResize = false;
        this._mouseIsDown = false;
        this._mouseDragStartLocation = null;
        this._dragStartDate = null;
        this.endAutoScroll();
        this._showZoomHelper = false;
        if (this._zoomLevelArea != null) {
            this.redraw(this._zoomLevelArea.x, this._zoomLevelArea.y, this._zoomLevelArea.width + 1, this._zoomLevelArea.height + 1, false);
        }
        this._dragging = false;
        this._dragStartLoc = null;
        this._dragEvents.clear();
        this._dragPhase = null;
        this._resizing = false;
        this.setCursor(Constants.CURSOR_NONE);
        this._lastX = 0;
        this._cursor = 0;
        this.killDialogs();
    }

    public void mouseMove(MouseEvent me) {
        try {
            int i;
            if (me.stateMask == 0) {
                this.killDialogs();
            }
            if (this._tracker != null && !this._tracker.isDisposed()) {
                return;
            }
            String dateFormat = this._currentView == 1 ? this._settings.getHourDateFormat() : this._settings.getDateFormat();
            Rectangle area = super.getClientArea();
            if (me.x >= area.x && me.x < area.width) {
                this.endAutoScroll();
            }
            boolean dndOK = this._settings.enableDragAndDrop();
            boolean resizeOK = this._settings.enableResizing();
            if ((this._dragging || this._resizing) && this._settings.enableAutoScroll()) {
                if (me.x < 0 || me.x > this._mainBounds.width) {
                    this.doAutoScroll(me);
                }
                if (this._freeDragging && (me.y > this._mainBounds.height || me.y < 0)) {
                    this.doAutoScroll(me);
                }
            }
            if (this._freeDragging && this._dragging && !this._ganttSections.isEmpty() && !this._dragEvents.isEmpty()) {
                GanttEvent drag = (GanttEvent)this._dragEvents.get(0);
                for (int i2 = 0; i2 < this._ganttSections.size(); ++i2) {
                    GanttSection gs = (GanttSection)this._ganttSections.get(i2);
                    if (drag.getGanttSection() == gs) continue;
                    if (gs.getBounds().intersects(drag.getBounds())) {
                        gs.addDNDGanttEvent(drag);
                        continue;
                    }
                    gs.clearDNDGanttEvents();
                }
            }
            if (this._dragPhase != null && (this._resizing || this._dragging)) {
                AdvancedTooltipDialog.kill();
                GanttToolTip.kill();
                if (this._dragging && dndOK) {
                    this.handlePhaseMove(me, this._dragPhase, 3, true);
                }
                if (this._resizing && resizeOK && (this._cursor == 12 || this._cursor == 13)) {
                    this.handlePhaseMove(me, this._dragPhase, this._lastLeft ? 1 : 2, true);
                }
                return;
            }
            if (this._dragging && dndOK) {
                AdvancedTooltipDialog.kill();
                GanttToolTip.kill();
                for (int x = 0; x < this._selectedEvents.size(); ++x) {
                    this.handleMove(me, (GanttEvent)this._selectedEvents.get(x), 3, x == 0);
                }
                return;
            }
            if (this._resizing && resizeOK && (this._cursor == 12 || this._cursor == 13)) {
                for (int x = 0; x < this._selectedEvents.size(); ++x) {
                    this.handleMove(me, (GanttEvent)this._selectedEvents.get(x), this._lastLeft ? 1 : 2, x == 0);
                }
                return;
            }
            if (!this._resizing && !this._dragging && dndOK && resizeOK && me.stateMask != 0 && this._cursor != 0 && !this._selectedEvents.isEmpty()) {
                if (this._cursor == 12 || this._cursor == 13) {
                    for (int x = 0; x < this._selectedEvents.size(); ++x) {
                        this.handleMove(me, (GanttEvent)this._selectedEvents.get(x), this._cursor == 13 ? 1 : 2, x == 0);
                    }
                    return;
                }
                if (this._cursor == 5) {
                    for (int x = 0; x < this._selectedEvents.size(); ++x) {
                        this.handleMove(me, (GanttEvent)this._selectedEvents.get(x), 3, x == 0);
                    }
                    return;
                }
            }
            if (me.stateMask == 0) {
                this.setCursor(Constants.CURSOR_NONE);
            }
            boolean insideAnyEvent = false;
            int x = me.x;
            int y = me.y;
            for (i = 0; i < this._ganttEvents.size(); ++i) {
                GanttEvent event = (GanttEvent)this._ganttEvents.get(i);
                if (!this.isInside(me.x, me.y, new Rectangle(event.getX(), event.getY(), event.getWidth(), event.getHeight()))) continue;
                insideAnyEvent = true;
                if (event.isScope() || this._hiddenLayers.contains(event.getLayerInt())) continue;
                Rectangle rect = new Rectangle(event.getX(), event.getY(), event.getWidth(), event.getHeight());
                boolean onRightBorder = false;
                boolean onLeftBorder = false;
                if (x >= rect.x + rect.width - this._settings.getResizeBorderSensitivity() && y >= rect.y && x <= rect.x + rect.width + this._settings.getResizeBorderSensitivity() && y <= rect.y + rect.height) {
                    onRightBorder = true;
                } else if (x >= rect.x - this._settings.getResizeBorderSensitivity() && y >= rect.y && x <= rect.x + this._settings.getResizeBorderSensitivity() && y <= rect.y + rect.height) {
                    onLeftBorder = true;
                }
                if (me.stateMask == 0 || me.stateMask == this._settings.getDragAllModifierKey()) {
                    if (resizeOK && event.isResizable() && (event.isCheckpoint() && this._settings.allowCheckpointResizing() || !event.isCheckpoint() && !event.isImage())) {
                        if (onRightBorder) {
                            this.setCursor(Constants.CURSOR_SIZEE);
                            this._cursor = 12;
                            return;
                        }
                        if (onLeftBorder) {
                            this.setCursor(Constants.CURSOR_SIZEW);
                            this._cursor = 13;
                            return;
                        }
                    }
                    if (!dndOK || !event.isMoveable()) break;
                    this.setCursor(Constants.CURSOR_SIZEALL);
                    this._cursor = 5;
                    return;
                }
                if ((dndOK || event.isMoveable()) && this._cursor == 5 && this.isInMoveArea(event, me.x)) {
                    this.handleMove(me, event, 3, true);
                    return;
                }
                if (event.isCheckpoint() || !resizeOK && !event.isResizable() || this._cursor != 12 && this._cursor != 13) break;
                this.handleMove(me, event, onLeftBorder ? 1 : 2, true);
                return;
            }
            if (this.hasGanttPhases()) {
                for (i = 0; i < this._ganttPhases.size(); ++i) {
                    GanttPhase phase = (GanttPhase)this._ganttPhases.get(i);
                    if (phase.isHidden() || !phase.isDisplayable() || phase.getHeaderBounds() == null || phase.getBounds() == null || !phase.isResizable() && !phase.isMoveable() || phase.isLocked() || !this.isInside(me.x, me.y, phase.getHeaderBounds())) continue;
                    boolean onRightBorder = false;
                    boolean onLeftBorder = false;
                    Rectangle rect = phase.getHeaderBounds();
                    if (x >= rect.x + rect.width - this._settings.getResizeBorderSensitivity() && y >= rect.y && x <= rect.x + rect.width + this._settings.getResizeBorderSensitivity() && y <= rect.y + rect.height) {
                        onRightBorder = true;
                    } else if (x >= rect.x - this._settings.getResizeBorderSensitivity() && y >= rect.y && x <= rect.x + this._settings.getResizeBorderSensitivity() && y <= rect.y + rect.height) {
                        onLeftBorder = true;
                    }
                    if (me.stateMask == 0) {
                        if (onRightBorder) {
                            this.setCursor(Constants.CURSOR_SIZEE);
                            this._cursor = 12;
                            return;
                        }
                        if (onLeftBorder) {
                            this.setCursor(Constants.CURSOR_SIZEW);
                            this._cursor = 13;
                            return;
                        }
                        if (!phase.isMoveable()) continue;
                        this.setCursor(Constants.CURSOR_SIZEALL);
                        this._cursor = 5;
                        return;
                    }
                    if (onLeftBorder || onRightBorder) {
                        this.handlePhaseMove(me, phase, onLeftBorder ? 1 : 2, true);
                        return;
                    }
                    this.handlePhaseMove(me, phase, 3, true);
                    return;
                }
            }
            if (!(insideAnyEvent || this._dragging || this._resizing || this._cursor == 0)) {
                this.setCursor(Constants.CURSOR_NONE);
                this._cursor = 0;
            }
            if (this._mouseIsDown && this._settings.allowBlankAreaDragAndDropToMoveDates()) {
                boolean up;
                if (this._mouseDragStartLocation == null) {
                    this._mouseDragStartLocation = new Point(me.x, me.y);
                }
                int xDiff = me.x - this._mouseDragStartLocation.x;
                int yDiff = me.y - this._mouseDragStartLocation.y;
                boolean left = xDiff < 0;
                boolean bl = up = yDiff < 0;
                if (this._settings.flipBlankAreaDragDirection()) {
                    left = !left;
                }
                xDiff /= this.getDayWidth();
                if ((xDiff = Math.abs(xDiff)) > 0 && 4 != this._currentView) {
                    this._mouseDragStartLocation = new Point(me.x, me.y);
                }
                if (this._settings.allowBlankAreaVerticalDragAndDropToMoveChart()) {
                    this._mouseDragStartLocation = new Point(me.x, me.y);
                }
                if (yDiff != 0 && this._settings.allowBlankAreaVerticalDragAndDropToMoveChart()) {
                    yDiff *= 2;
                    if ((me.stateMask & 0x20000) != 0) {
                        yDiff *= 2;
                    }
                    if (this._settings.flipBlankAreaDragDirection()) {
                        this._vScrollBar.setSelection(this._vScrollBar.getSelection() + -yDiff);
                    } else {
                        this._vScrollBar.setSelection(this._vScrollBar.getSelection() + yDiff);
                    }
                    this.vScroll(null);
                }
                if (4 == this._currentView && xDiff < this._mainCalendar.getActualMaximum(5)) {
                    return;
                }
                if (4 == this._currentView) {
                    this._mouseDragStartLocation = new Point(me.x, me.y);
                    int times = xDiff / this._mainCalendar.getActualMaximum(5);
                    if (times == 0) {
                        times = 1;
                    }
                    for (int i3 = 0; i3 < times; ++i3) {
                        if (left) {
                            this.prevMonth();
                            continue;
                        }
                        this.nextMonth();
                    }
                    return;
                }
                for (int i4 = 0; i4 < xDiff; ++i4) {
                    if (left) {
                        if (this._currentView == 1) {
                            this.prevHour();
                            continue;
                        }
                        this.prevDay();
                        continue;
                    }
                    if (this._currentView == 1) {
                        this.nextHour();
                        continue;
                    }
                    this.nextDay();
                }
                this.updateHorizontalScrollbar();
                if (this._currentView == 4 && xDiff > 7) {
                    this._recalcScopes = true;
                    this._recalcSecBounds = true;
                    this.redraw();
                }
                Point loc = new Point(this._mouseDragStartLocation.x + 10, this._mouseDragStartLocation.y - 20);
                if (this._zoomLevel >= 9) {
                    Calendar temp = Calendar.getInstance(this._defaultLocale);
                    temp.setTime(this._mainCalendar.getTime());
                    temp.set(5, 1);
                    GanttDateTip.makeDialog(this._colorManager, DateHelper.getDate(temp, dateFormat), this.toDisplay(loc), this._mainBounds.y);
                } else if (this._currentView == 5) {
                    GanttDateTip.makeDialog(this._colorManager, this.getCurrentDDate() + "        ", this.toDisplay(loc), this._mainBounds.y);
                } else {
                    GanttDateTip.makeDialog(this._colorManager, DateHelper.getDate(this._mainCalendar, dateFormat), this.toDisplay(loc), this._mainBounds.y);
                }
            }
        }
        catch (Exception error) {
            SWT.error((int)1, (Throwable)error);
        }
    }

    public int getDaysVisible() {
        return this._daysVisible;
    }

    private String getCurrentDDate() {
        int days = (int)DateHelper.daysBetween(this._dDayCalendar, this._mainCalendar);
        if (days > 0) {
            return "+" + days;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(days);
        return buf.toString();
    }

    private boolean isInMoveArea(GanttEvent event, int x) {
        Rectangle bounds = new Rectangle(event.getX(), event.getY(), event.getWidth(), event.getHeight());
        return x > bounds.x + this._moveAreaInsets && x < bounds.x + bounds.width - this._moveAreaInsets;
    }

    private void doAutoScroll(MouseEvent event) {
        if (event.x < this._mainBounds.x) {
            this.doAutoScroll(1);
        } else if (event.x > this._mainBounds.width) {
            this.doAutoScroll(2);
        } else if (this._freeDragging) {
            if (event.y < 0) {
                this.doAutoScroll(3);
            } else if (event.y > this._mainBounds.height) {
                this.doAutoScroll(4);
            } else {
                this.endAutoScroll();
            }
        } else {
            this.endAutoScroll();
        }
    }

    private void doAutoScroll(int direction) {
        Runnable timer = null;
        if (this._autoScrollDir == direction) {
            return;
        }
        final Display display = this.getDisplay();
        if (direction == 1) {
            timer = new Runnable(){

                public void run() {
                    if (GanttComposite.this._autoScrollDir == 1) {
                        if (GanttComposite.this._currentView == 1) {
                            GanttComposite.this.prevHour();
                        } else {
                            GanttComposite.this.prevDay();
                        }
                        display.timerExec(25, (Runnable)this);
                    }
                }
            };
        } else if (direction == 2) {
            timer = new Runnable(){

                public void run() {
                    if (GanttComposite.this._autoScrollDir == 2) {
                        if (GanttComposite.this._currentView == 1) {
                            GanttComposite.this.nextHour();
                        } else {
                            GanttComposite.this.nextDay();
                        }
                        display.timerExec(25, (Runnable)this);
                    }
                }
            };
        } else if (direction == 4) {
            timer = new Runnable(){

                public void run() {
                    if (GanttComposite.this._autoScrollDir == 4) {
                        GanttComposite.this._vScrollBar.setSelection(GanttComposite.this._vScrollBar.getSelection() + 10);
                        GanttComposite.this.vScroll(null);
                        display.timerExec(25, (Runnable)this);
                    }
                }
            };
        } else if (direction == 3) {
            timer = new Runnable(){

                public void run() {
                    if (GanttComposite.this._autoScrollDir == 3) {
                        GanttComposite.this._vScrollBar.setSelection(GanttComposite.this._vScrollBar.getSelection() - 10);
                        GanttComposite.this.vScroll(null);
                        display.timerExec(25, (Runnable)this);
                    }
                }
            };
        }
        if (timer != null) {
            this._autoScrollDir = direction;
            display.timerExec(25, timer);
        }
    }

    boolean isChartReady() {
        return this._mainBounds != null;
    }

    private void endAutoScroll() {
        this._autoScrollDir = 0;
    }

    public int getXForDate(Date date) {
        this.checkWidget();
        Calendar cal = Calendar.getInstance(this._defaultLocale);
        cal.setTime(date);
        return this.getXForDate(cal);
    }

    public int getXForDate(Calendar cal) {
        this.checkWidget();
        if (this._currentView == 1) {
            return this.getStartingXForEventHours(cal);
        }
        Calendar temp = DateHelper.getNewCalendar(this._mainCalendar);
        int dw = this.getDayWidth();
        if (this._currentView == 4) {
            temp.set(5, 1);
        }
        long days = DateHelper.daysBetween(temp, cal);
        int extra = 0;
        if (this._drawToMinute && this._currentView != 1) {
            float ppm = 60.0f / (float)this._dayWidth;
            int mins = cal.get(11);
            extra = (int)((float)mins * ppm);
        }
        return (int)days * dw + extra;
    }

    public Calendar getDateAt(int x) {
        int xx;
        int xPosition = x;
        this.checkWidget();
        Calendar temp = DateHelper.getNewCalendar(this._mainCalendar);
        int dw = this.getDayWidth();
        if (this._currentView == 4) {
            temp.set(5, 1);
        } else if (this._currentView == 1) {
            float ppm = 60.0f / (float)dw;
            int totalMinutes = (int)((float)(xPosition -= this._mainBounds.x) * ppm);
            Calendar fakeEnd = Calendar.getInstance(this._defaultLocale);
            fakeEnd.setTime(temp.getTime());
            for (int i = 0; i < totalMinutes; ++i) {
                fakeEnd.add(12, 1);
                if (temp.get(11) < 24) continue;
                temp.add(5, 1);
                temp.set(11, 0);
            }
            return fakeEnd;
        }
        if (xPosition < 0) {
            while (true) {
                if (xx != 0) {
                    temp.add(5, -1);
                }
                if (xx >= xPosition) {
                    xx -= dw;
                    continue;
                }
                break;
            }
        } else {
            for (xx = 0; xx <= xPosition; xx += dw) {
                if (xx == 0) continue;
                temp.add(5, 1);
            }
        }
        return temp;
    }

    private boolean isNoOverlap(Calendar dat1, Calendar dat2) {
        if (this._currentView == 1) {
            return DateHelper.minutesBetween(dat1.getTime(), dat2.getTime(), false, false) >= 0;
        }
        return DateHelper.daysBetween(dat1, dat2) >= 0L;
    }

    public void drawMarker(Date date) {
        this.checkWidget();
        Calendar cal = Calendar.getInstance(this._defaultLocale);
        cal.setTime(date);
        int x = this.getXForDate(cal);
        if (x == -1) {
            return;
        }
        GC gc = new GC((Drawable)this);
        gc.setLineStyle(3);
        gc.drawRectangle(x, 0, x, this._mainBounds.height);
        gc.setLineStyle(1);
        gc.dispose();
    }

    private void handlePhaseMove(MouseEvent me, GanttPhase phase, int type, boolean showToolTip) {
        String dateFormat = this._currentView == 1 ? this._settings.getHourDateFormat() : this._settings.getDateFormat();
        Calendar mouseDateCal = this.getDateAt(me.x);
        if ((me.stateMask & 0x80000) != 0 && !this._dragging && !this._resizing) {
            if (type == 3) {
                this._dragging = true;
                this._resizing = false;
                this.setCursor(Constants.CURSOR_SIZEALL);
            } else {
                this._dragging = false;
                this._resizing = true;
                this.setCursor(type == 1 ? Constants.CURSOR_SIZEW : Constants.CURSOR_SIZEE);
                this._lastLeft = type == 1;
            }
            this._dragEvents.clear();
            this._dragPhase = phase;
            this._dragPhase.markDragStart();
            this._lastX = me.x;
            this._dragStartDate = mouseDateCal;
            this._justStartedMoveOrResize = true;
        }
        if ((me.stateMask & 0x80000) != 0 && (this._dragging || this._resizing) && me.x > this._lastX || me.x < this._lastX) {
            int diff = 0;
            if (this._currentView == 1) {
                Calendar cal = this._dragPhase.getStartDate();
                if (this._resizing && !this._lastLeft) {
                    cal = this._dragPhase.getEndDate();
                }
                diff = DateHelper.minutesBetween(mouseDateCal.getTime(), cal.getTime(), false, false);
                if (this._justStartedMoveOrResize) {
                    if (this._dragging) {
                        this._initialHoursDragOffset = diff;
                    }
                    this._justStartedMoveOrResize = false;
                    return;
                }
                if (this._dragging) {
                    diff -= this._initialHoursDragOffset;
                }
                this._justStartedMoveOrResize = false;
                diff = -diff;
            } else {
                diff = me.x > this._lastX ? (int)DateHelper.daysBetween(this._dragStartDate, mouseDateCal) : (int)DateHelper.daysBetween(mouseDateCal, this._dragStartDate);
                if (me.x < this._lastX) {
                    diff = -diff;
                }
            }
            this._dragStartDate = mouseDateCal;
            int calMark = 5;
            if (this._currentView == 1) {
                calMark = 12;
            }
            if (diff != 0) {
                boolean ok = true;
                if (type == 3) {
                    this._dragPhase.move(calMark, diff);
                } else {
                    if (!this._settings.allowPhaseOverlap()) {
                        for (int i = 0; i < this._ganttPhases.size(); ++i) {
                            GanttPhase other = (GanttPhase)this._ganttPhases.get(i);
                            if (other.equals(this._dragPhase) || (type != 1 || diff >= 0) && (type != 2 || diff <= 0) || !this._dragPhase.willOverlapResize(other, calMark, diff, type == 1)) continue;
                            ok = false;
                            break;
                        }
                    }
                    if (ok) {
                        if (type == 1) {
                            this._dragPhase.moveStart(calMark, diff);
                        } else if (type == 2) {
                            this._dragPhase.moveEnd(calMark, diff);
                        }
                    }
                }
                this.redraw();
                if (ok) {
                    for (int x = 0; x < this._eventListeners.size(); ++x) {
                        IGanttEventListener listener = (IGanttEventListener)this._eventListeners.get(x);
                        if (type == 3) {
                            listener.phaseMoved(this._dragPhase, me);
                            continue;
                        }
                        listener.phaseResized(this._dragPhase, me);
                    }
                }
                if (this._settings.showDateTips() && (this._dragging || this._resizing) && showToolTip) {
                    Rectangle eBounds = this._dragPhase.getBounds();
                    Point eventOnDisplay = this.toDisplay(me.x, eBounds.y);
                    if (this._currentView == 5) {
                        StringBuffer buf = new StringBuffer();
                        buf.append(this._dragPhase.getDDayStart());
                        buf.append(" - ");
                        buf.append(this._dragPhase.getDDayEnd());
                        buf.append("       ");
                        GanttDateTip.makeDialog(this._colorManager, buf.toString(), eventOnDisplay, this._mainBounds.y);
                    } else {
                        StringBuffer buf = new StringBuffer();
                        buf.append(DateHelper.getDate(this._dragPhase.getStartDate(), dateFormat));
                        buf.append(" - ");
                        buf.append(DateHelper.getDate(this._dragPhase.getEndDate(), dateFormat));
                        GanttDateTip.makeDialog(this._colorManager, buf.toString(), eventOnDisplay, this._mainBounds.y);
                    }
                }
            }
        }
    }

    private void calculateVerticalInsertLocations() {
        this._vDNDManager.clear();
        if (!this._freeDragging) {
            return;
        }
        if (this._dragEvents.isEmpty()) {
            return;
        }
        GanttEvent ge = (GanttEvent)this._dragEvents.get(0);
        GanttSection dragOverSection = this.getSectionForVerticalDND(ge, true);
        List surrounding = this.getSurroundingVerticalEvents(ge, dragOverSection);
        GanttEvent top = (GanttEvent)surrounding.get(0);
        GanttEvent bottom = (GanttEvent)surrounding.get(1);
        this._vDNDManager.setTopEvent(top);
        this._vDNDManager.setBottomEvent(bottom);
        this._vDNDManager.setTargetSection(dragOverSection);
        this._vDNDManager.setSurroundingEvents(surrounding);
    }

    private void drawVerticalInsertMarkers(GC gc) {
        if (!this._freeDragging) {
            return;
        }
        if (this._dragEvents.isEmpty()) {
            return;
        }
        gc.setForeground(this._colorManager.getOriginalLocationColor());
        gc.setLineWidth(1);
        gc.setAdvanced(false);
        GanttEvent ge = (GanttEvent)this._dragEvents.get(0);
        GanttEvent top = this._vDNDManager.getTopEvent();
        GanttEvent bottom = this._vDNDManager.getBottomEvent();
        int xDrawStart = 0;
        int xDrawEnd = this._mainBounds.width;
        if (this.hasGanttSections() && this._settings.getSectionSide() == 16384) {
            xDrawStart = this._settings.getSectionBarWidth();
            xDrawEnd = this._mainBounds.width + xDrawStart;
        }
        if (ge.hasMovedVertically()) {
            if (top != null) {
                if (bottom != null) {
                    int midDiff = (bottom.getY() - top.getBottomY()) / 2;
                    gc.drawLine(xDrawStart, top.getBottomY() + midDiff, xDrawEnd, top.getBottomY() + midDiff);
                } else {
                    gc.drawLine(xDrawStart, top.getBottomY() + 5, xDrawEnd, top.getBottomY() + 5);
                }
            } else {
                if (bottom == null) {
                    gc.drawLine(xDrawStart, this._mainBounds.height - 5, xDrawEnd, this._mainBounds.height - 5);
                    return;
                }
                gc.drawLine(xDrawStart, bottom.getY() - 5, xDrawEnd, bottom.getY() - 5);
            }
        }
        gc.setLineStyle(2);
        for (int i = 0; i < this._dragEvents.size(); ++i) {
            GanttEvent e = (GanttEvent)this._dragEvents.get(i);
            if (e.getPreVerticalDragBounds() == null) continue;
            gc.drawRectangle(e.getPreVerticalDragBounds());
        }
        gc.setLineStyle(1);
    }

    private void handleMove(MouseEvent me, GanttEvent event, int type, boolean showToolTip) {
        int diff;
        if (event == null) {
            return;
        }
        if (event.isLocked()) {
            return;
        }
        if (!this._settings.enableDragAndDrop() && type == 3) {
            return;
        }
        if (!(this._settings.enableResizing() || type != 1 && type != 2)) {
            return;
        }
        if (!this._mouseIsDown) {
            return;
        }
        if (type == 3 && !event.isMoveable()) {
            return;
        }
        if (!(type != 1 && type != 2 || event.isResizable())) {
            return;
        }
        String dateFormat = this._currentView == 1 ? this._settings.getHourDateFormat() : this._settings.getDateFormat();
        Calendar mouseDateCal = this.getDateAt(me.x);
        if ((me.stateMask & 0x80000) != 0 && !this._dragging && !this._resizing) {
            if (type == 3) {
                event.flagDragging();
                this._dragging = true;
                this._resizing = false;
                this._dragStartLoc = new Point(me.x, me.y);
                this.setCursor(Constants.CURSOR_SIZEALL);
            } else {
                this._dragging = false;
                this._resizing = true;
                this.setCursor(type == 1 ? Constants.CURSOR_SIZEW : Constants.CURSOR_SIZEE);
                this._lastLeft = type == 1;
            }
            this._dragEvents.clear();
            this._dragEvents.add(event);
            this._lastX = me.x;
            this._lastY = me.y;
            this._dragStartDate = mouseDateCal;
            this._justStartedMoveOrResize = true;
        }
        if (this._settings.getVerticalEventDragging() != 0 && this._dragStartLoc != null) {
            diff = this._dragStartLoc.y - me.y;
            if (Math.abs(diff) > this._settings.getVerticalDragResistance()) {
                if (!this._freeDragging) {
                    this._freeDragging = true;
                }
                event.updateY(me.y);
            } else if (this._freeDragging) {
                event.undoVerticalDragging();
                this.redraw();
            }
            if (me.y > this._lastY) {
                this._vDragDir = 1024;
            } else if (me.y < this._lastY) {
                this._vDragDir = 128;
            }
        }
        if ((me.stateMask & 0x80000) != 0 && (this._dragging || this._resizing)) {
            if (this._freeDragging) {
                this.redraw();
            }
            if (me.x > this._lastX || me.x < this._lastX) {
                diff = 0;
                if (this._currentView == 1) {
                    Calendar cal = event.getActualStartDate();
                    if (this._resizing && !this._lastLeft) {
                        cal = event.getActualEndDate();
                    }
                    diff = DateHelper.minutesBetween(mouseDateCal.getTime(), cal.getTime(), false, false);
                    if (this._justStartedMoveOrResize) {
                        if (this._dragging) {
                            this._initialHoursDragOffset = diff;
                        }
                        this._justStartedMoveOrResize = false;
                        return;
                    }
                    if (this._dragging) {
                        diff -= this._initialHoursDragOffset;
                    }
                    this._justStartedMoveOrResize = false;
                    diff = -diff;
                } else {
                    diff = me.x > this._lastX ? (int)DateHelper.daysBetween(this._dragStartDate, mouseDateCal) : (int)DateHelper.daysBetween(mouseDateCal, this._dragStartDate);
                    if (me.x < this._lastX) {
                        diff = -diff;
                    }
                }
                this._dragStartDate = mouseDateCal;
                this.moveEvent(event, diff, me.stateMask, me, type);
            }
        }
        if (event.getScopeParent() != null) {
            this.updateScopeXY(event.getScopeParent());
            this._recalcScopes = true;
        }
        this._lastX = me.x;
        this._lastY = me.y;
        if (this._settings.showDateTips() && (this._dragging || this._resizing) && showToolTip) {
            Rectangle eBounds = new Rectangle(event.getX(), event.getY() - 25, event.getWidth(), event.getHeight());
            Point eventOnDisplay = this.toDisplay(me.x, eBounds.y);
            if (event.isCheckpoint()) {
                long days = DateHelper.daysBetween(event.getActualStartDate(), event.getActualEndDate());
                if (++days == 1L) {
                    GanttDateTip.makeDialog(this._colorManager, DateHelper.getDate(event.getActualStartDate(), dateFormat), eventOnDisplay, this._mainBounds.y);
                } else {
                    StringBuffer buf = new StringBuffer();
                    if (this._currentView == 5) {
                        buf.append(event.getActualDDayStart());
                        buf.append(" - ");
                        buf.append(event.getActualDDayEnd());
                        GanttDateTip.makeDialog(this._colorManager, buf.toString(), eventOnDisplay, this._mainBounds.y);
                    } else {
                        buf.append(DateHelper.getDate(event.getActualStartDate(), dateFormat));
                        buf.append(" - ");
                        buf.append(DateHelper.getDate(event.getActualEndDate(), dateFormat));
                        GanttDateTip.makeDialog(this._colorManager, buf.toString(), eventOnDisplay, this._mainBounds.y);
                    }
                }
            } else if (this._currentView == 5) {
                StringBuffer buf = new StringBuffer();
                buf.append(event.getActualDDayStart());
                buf.append(" - ");
                buf.append(event.getActualDDayEnd());
                buf.append("       ");
                GanttDateTip.makeDialog(this._colorManager, buf.toString(), eventOnDisplay, this._mainBounds.y);
            } else {
                StringBuffer buf = new StringBuffer();
                buf.append(DateHelper.getDate(event.getActualStartDate(), dateFormat));
                buf.append(" - ");
                buf.append(DateHelper.getDate(event.getActualEndDate(), dateFormat));
                GanttDateTip.makeDialog(this._colorManager, buf.toString(), eventOnDisplay, this._mainBounds.y);
            }
        }
    }

    private void updateScopeXY(GanttEvent ge) {
        if (ge != null) {
            ge.calculateScope();
            int newStartX = this.getXForDate(ge.getEarliestScopeEvent().getActualStartDate());
            int newWidth = this.getXLengthForEvent(ge);
            ge.updateX(newStartX);
            ge.updateWidth(newWidth);
        }
    }

    private void moveEvent(GanttEvent ge, int diff, int stateMask, MouseEvent me, int type) {
        int x;
        if (diff == 0 && !this._freeDragging) {
            return;
        }
        if (ge.isLocked()) {
            return;
        }
        ArrayList<GanttEvent> eventsMoved = new ArrayList<GanttEvent>();
        int calMark = 5;
        if (this._currentView == 1) {
            calMark = 12;
        }
        ArrayList toMove = new ArrayList();
        if ((stateMask & this._settings.getDragAllModifierKey()) != 0 && this._settings.moveLinkedEventsWhenEventsAreMoved()) {
            int x2;
            List conns = this.getEventsDependingOn(ge);
            ArrayList<GanttEvent> translated = new ArrayList<GanttEvent>();
            for (x2 = 0; x2 < conns.size(); ++x2) {
                GanttEvent md = (GanttEvent)conns.get(x2);
                if (md.isLocked() || md.isCheckpoint() && type != 3 && !this._settings.allowCheckpointResizing()) continue;
                translated.add(md);
            }
            if (this._multiSelect) {
                for (x2 = 0; x2 < this._selectedEvents.size(); ++x2) {
                    GanttEvent selEvent = (GanttEvent)this._selectedEvents.get(x2);
                    if (selEvent.isScope() || translated.contains(selEvent)) continue;
                    translated.add(selEvent);
                }
            }
            toMove.addAll(translated);
        }
        if (!toMove.contains(ge)) {
            toMove.add(ge);
        }
        if (this._settings.moveAndResizeOnlyDependentEventsThatAreLaterThanLinkedMoveEvent()) {
            ArrayList<GanttEvent> toRemove = new ArrayList<GanttEvent>();
            for (int x3 = 0; x3 < toMove.size(); ++x3) {
                GanttEvent moveEvent = (GanttEvent)toMove.get(x3);
                if (moveEvent.equals(ge) || moveEvent.getActualEndDate().getTimeInMillis() >= ge.getActualEndDate().getTimeInMillis()) continue;
                toRemove.add(moveEvent);
            }
            toMove.removeAll(toRemove);
        }
        this._dragEvents = new ArrayList(toMove);
        for (x = 0; x < toMove.size(); ++x) {
            GanttEvent event = (GanttEvent)toMove.get(x);
            Calendar cal1 = Calendar.getInstance(this._defaultLocale);
            Calendar cal2 = Calendar.getInstance(this._defaultLocale);
            cal1.setTime(event.getActualStartDate().getTime());
            cal2.setTime(event.getActualEndDate().getTime());
            if (type == 3) {
                long milliDiff;
                long millis;
                event.moveStarted(type);
                cal1.add(calMark, diff);
                cal2.add(calMark, diff);
                if (event.getNoMoveBeforeDate() != null && cal1.before(event.getNoMoveBeforeDate())) {
                    millis = event.getNoMoveBeforeDate().getTimeInMillis();
                    milliDiff = Math.abs(event.getActualStartDate().getTimeInMillis() - millis);
                    event.setRevisedStart(DateHelper.getNewCalendar(event.getNoMoveBeforeDate()), false);
                    Calendar end = DateHelper.getNewCalendar(event.getActualEndDate());
                    end.add(14, (int)(-milliDiff));
                    event.setRevisedEnd(end, false);
                    event.updateX(this.getStartingXFor(event.getRevisedStart()));
                    continue;
                }
                if (event.getNoMoveAfterDate() != null && cal2.after(event.getNoMoveAfterDate())) {
                    millis = event.getNoMoveAfterDate().getTimeInMillis();
                    milliDiff = Math.abs(event.getActualEndDate().getTimeInMillis() - millis);
                    event.setRevisedEnd(DateHelper.getNewCalendar(event.getNoMoveAfterDate()), false);
                    Calendar start = DateHelper.getNewCalendar(event.getActualStartDate());
                    start.add(14, (int)milliDiff);
                    event.setRevisedStart(start, false);
                    event.updateX(this.getStartingXFor(event.getRevisedStart()));
                    continue;
                }
                event.setRevisedStart(cal1, false);
                event.setRevisedEnd(cal2, false);
                event.updateX(this.getStartingXFor(cal1));
            } else if (type == 1) {
                cal1.add(calMark, diff);
                if (!this.isNoOverlap(cal1, event.getActualEndDate())) continue;
                event.moveStarted(type);
                if (event.getNoMoveBeforeDate() != null && cal1.before(event.getNoMoveBeforeDate())) {
                    event.setRevisedStart(event.getNoMoveBeforeDate());
                    continue;
                }
                event.setRevisedStart(cal1, false);
                event.updateX(this.getStartingXFor(cal1));
                event.updateWidth(this.getXLengthForEvent(event));
            } else if (type == 2) {
                cal2.add(calMark, diff);
                if (!this.isNoOverlap(event.getActualStartDate(), cal2) || event.getNoMoveAfterDate() != null && cal2.after(event.getNoMoveAfterDate())) continue;
                event.moveStarted(type);
                event.setRevisedEnd(cal2, false);
                event.updateX(this.getStartingXFor(cal1));
                event.updateWidth(this.getXLengthForEvent(event));
            }
            if (eventsMoved.contains(event)) continue;
            eventsMoved.add(event);
        }
        if (!eventsMoved.contains(ge)) {
            eventsMoved.add(ge);
        }
        for (x = 0; x < this._eventListeners.size(); ++x) {
            IGanttEventListener listener = (IGanttEventListener)this._eventListeners.get(x);
            if (type == 3) {
                listener.eventsMoved(eventsMoved, me);
                continue;
            }
            listener.eventsResized(eventsMoved, me);
        }
        this.redrawEventsArea();
    }

    public void mouseEnter(MouseEvent event) {
    }

    public void mouseExit(MouseEvent event) {
    }

    public void mouseHover(MouseEvent me) {
        if (this._dragging || this._resizing) {
            return;
        }
        if (!this._settings.showToolTips()) {
            return;
        }
        if (GanttToolTip.isActive()) {
            return;
        }
        if (me.stateMask != 0) {
            return;
        }
        for (int i = 0; i < this._ganttEvents.size(); ++i) {
            GanttEvent event = (GanttEvent)this._ganttEvents.get(i);
            if (!this.isInside(me.x, me.y, new Rectangle(event.getX(), event.getY(), event.getWidth(), event.getHeight()))) continue;
            this.showTooltip(event, me);
            return;
        }
    }

    private void showTooltip(GanttEvent event, MouseEvent me) {
        StringBuffer buf;
        AdvancedTooltip at;
        boolean dDay;
        if (!this._settings.showToolTips()) {
            return;
        }
        long days = DateHelper.daysBetween(event.getStartDate(), event.getEndDate());
        ++days;
        long revisedDays = 0L;
        boolean bl = dDay = this._currentView == 5;
        if (dDay) {
            days = event.getDDateRange();
        }
        int xPlus = 0;
        if (this.isUseAdvancedTooltips() || event.getAdvancedTooltip() != null) {
            xPlus = this._settings.getAdvancedTooltipXOffset();
        }
        Point displayLocation = super.toDisplay(new Point(me.x + xPlus, me.y));
        String dateFormat = this._currentView == 1 ? this._settings.getHourDateFormat() : this._settings.getDateFormat();
        String startDate = DateHelper.getDate(event.getStartDate(), dateFormat);
        String endDate = DateHelper.getDate(event.getEndDate(), dateFormat);
        Calendar revisedStart = event.getRevisedStart();
        Calendar revisedEnd = event.getRevisedEnd();
        StringBuffer extra = new StringBuffer();
        String revisedStartText = null;
        String revisedEndText = null;
        int dDayStart = 0;
        int dDayEnd = 0;
        if (dDay) {
            dDayStart = event.getDDayStart() + 1;
            dDayEnd = event.getDDayEnd();
            startDate = "" + dDayStart;
            endDate = "" + dDayEnd;
        }
        if (dDay) {
            if (event.getDDayRevisedStart() == Integer.MAX_VALUE) {
                revisedStart = null;
            }
            if (event.getDDayRevisedEnd() == Integer.MAX_VALUE) {
                revisedEnd = null;
            }
        }
        if (revisedStart != null) {
            extra.append(this._languageManager.getRevisedText());
            extra.append(": ");
            revisedStartText = dDay ? "" + event.getDDayRevisedStart() : DateHelper.getDate(revisedStart, dateFormat);
            extra.append(revisedStartText);
        }
        if (revisedEnd != null) {
            if (revisedStart == null) {
                revisedStart = event.getActualStartDate();
            }
            revisedEndText = dDay ? "" + event.getDDayRevisedEnd() : DateHelper.getDate(revisedEnd, dateFormat);
            revisedDays = DateHelper.daysBetween(revisedStart, revisedEnd);
            ++revisedDays;
            extra.append(" - ");
            extra.append(revisedEndText);
            extra.append(" (");
            if (dDay) {
                revisedDays = event.getRevisedDDateRange();
            }
            extra.append(revisedDays);
            extra.append(' ');
            if (revisedDays == 1L || revisedDays == -1L) {
                extra.append(this._languageManager.getDaysText());
            } else {
                extra.append(this._languageManager.getDaysPluralText());
            }
            extra.append(')');
        }
        if ((at = event.getAdvancedTooltip()) == null && this.isUseAdvancedTooltips()) {
            String ttText = this._settings.getDefaultAdvancedTooltipTextExtended();
            if (event.isCheckpoint() || event.isImage() || event.isScope() || revisedStartText == null && revisedEnd == null) {
                ttText = this._settings.getDefaultAdvancedTooltipText();
            }
            at = new AdvancedTooltip(this._settings.getDefaultAdvancedTooltipTitle(), ttText, this._settings.getDefaultAdvandedTooltipImage(), this._settings.getDefaultAdvandedTooltipHelpImage(), this._settings.getDefaultAdvancedTooltipHelpText());
        }
        if (at != null) {
            String title = this.fixTooltipString(at.getTitle(), event.getName(), startDate, endDate, revisedStartText, revisedEndText, days, revisedDays, event.getPercentComplete());
            String content = this.fixTooltipString(at.getContent(), event.getName(), startDate, endDate, revisedStartText, revisedEndText, days, revisedDays, event.getPercentComplete());
            String help = this.fixTooltipString(at.getHelpText(), event.getName(), startDate, endDate, revisedStartText, revisedEndText, days, revisedDays, event.getPercentComplete());
            AdvancedTooltipDialog.makeDialog(at, this._colorManager, displayLocation, title, content, help);
        } else if (extra.length() > 0) {
            buf = new StringBuffer();
            buf.append(this._languageManager.getPlannedText());
            buf.append(": ");
            if (dDay) {
                buf.append(dDayStart);
            } else {
                buf.append(startDate);
            }
            buf.append(" - ");
            if (dDay) {
                buf.append(dDayEnd);
            } else {
                buf.append(endDate);
            }
            buf.append(" (");
            buf.append(days);
            buf.append(' ');
            buf.append(days == 1L || days == -1L ? this._languageManager.getDaysText() : this._languageManager.getDaysPluralText());
            buf.append(')');
            GanttToolTip.makeDialog(this._colorManager, event.getName(), extra.toString(), buf.toString(), event.getPercentComplete() + this._languageManager.getPercentCompleteText(), displayLocation);
        } else {
            buf = new StringBuffer();
            if (dDay) {
                buf.append(dDayStart);
            } else {
                buf.append(startDate);
            }
            buf.append(" - ");
            if (dDay) {
                buf.append(dDayEnd);
            } else {
                buf.append(endDate);
            }
            buf.append(" (");
            buf.append(days);
            buf.append(' ');
            buf.append(days == 1L || days == -1L ? this._languageManager.getDaysText() : this._languageManager.getDaysPluralText());
            buf.append(')');
            GanttToolTip.makeDialog(this._colorManager, event.getName(), buf.toString(), event.getPercentComplete() + this._languageManager.getPercentCompleteText(), displayLocation);
        }
    }

    private String fixTooltipString(String input, String name, String startDate, String endDate, String plannedStart, String plannedEnd, long days, long plannedDays, int percentageComplete) {
        String str = input;
        if (str != null) {
            str = str.replaceAll("#name#", name);
            str = str.replaceAll("#sd#", startDate);
            str = str.replaceAll("#ed#", endDate);
            str = str.replaceAll("#rs#", plannedStart == null ? "n/a" : plannedStart);
            str = str.replaceAll("#re#", plannedEnd == null ? "n/a" : plannedEnd);
            str = str.replaceAll("#days#", "" + days);
            str = str.replaceAll("#reviseddays#", "" + plannedDays);
            str = str.replaceAll("#pc#", "" + percentageComplete);
            return str;
        }
        return null;
    }

    public Rectangle getVisibleBounds() {
        return this._visibleBounds;
    }

    public int getCurrentView() {
        return this._currentView;
    }

    public void setView(int view) {
        this._currentView = view;
        this.redraw();
    }

    public List getEvents() {
        return this._ganttEvents;
    }

    public Image getImage() {
        return this.getImage(this._visibleBounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Image getFullImage() {
        Image image;
        GanttEvent geRight;
        Rectangle fullBounds;
        GanttEvent geLeft;
        Calendar currentCalendar;
        Rectangle oldBounds;
        int oldVscroll;
        block10: {
            this.checkWidget();
            this._savingChartImage = true;
            oldVscroll = this._vScrollPos;
            this._vScrollPos = 0;
            this.moveYBounds(-oldVscroll);
            oldBounds = this._mainBounds;
            currentCalendar = DateHelper.getNewCalendar(this._mainCalendar);
            this.setRedraw(false);
            geLeft = this.getEvent(true, true);
            fullBounds = new Rectangle(0, 0, 0, 0);
            geRight = this.getEvent(false, true);
            if (geRight != null && geLeft != null) break block10;
            Image image2 = this.getImage();
            this._vScrollPos = oldVscroll;
            this.moveYBounds(this._vScrollPos);
            this._savingChartImage = false;
            this._mainBounds = oldBounds;
            this._mainCalendar = currentCalendar;
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    GanttComposite.this.flagForceFullUpdate();
                    GanttComposite.this.setRedraw(true);
                    GanttComposite.this.redraw();
                }
            });
            return image2;
        }
        try {
            boolean drawSections = this.hasGanttSections();
            int extraX = 0;
            int extraW = 0;
            if (drawSections) {
                if (this._settings.getSectionSide() == 16384) {
                    extraX = -this._settings.getSectionBarWidth();
                    extraW = this._settings.getSectionBarWidth();
                } else {
                    extraW = this._settings.getSectionBarWidth();
                }
            }
            this._mainCalendar = this.getDateAt(geLeft.getActualBounds().x + extraX);
            Rectangle rBounds = geRight.getActualBounds();
            if (drawSections && this._settings.getSectionSide() == 131072) {
                extraW += this.getDayWidth();
            }
            fullBounds.width = rBounds.x + rBounds.width - geLeft.getActualBounds().x + extraW;
            fullBounds.height = this._bottomMostY;
            this._mainBounds = fullBounds;
            this.flagForceFullUpdate();
            Image buffer = new Image((Device)this.getDisplay(), fullBounds);
            GC gc2 = new GC((Drawable)buffer);
            this.drawChartOntoGC(gc2, fullBounds);
            this.drawHeader(gc2, false);
            if (drawSections && this._settings.getSectionSide() == 131072) {
                this.drawSectionColumn(gc2, fullBounds, false, true, false, true);
            }
            gc2.dispose();
            image = buffer;
            this._vScrollPos = oldVscroll;
            this.moveYBounds(this._vScrollPos);
            this._savingChartImage = false;
            this._mainBounds = oldBounds;
            this._mainCalendar = currentCalendar;
        }
        catch (Exception err) {
            try {
                SWT.error((int)1, (Throwable)err);
                this._vScrollPos = oldVscroll;
                this.moveYBounds(this._vScrollPos);
                this._savingChartImage = false;
                this._mainBounds = oldBounds;
                this._mainCalendar = currentCalendar;
            }
            catch (Throwable throwable) {
                this._vScrollPos = oldVscroll;
                this.moveYBounds(this._vScrollPos);
                this._savingChartImage = false;
                this._mainBounds = oldBounds;
                this._mainCalendar = currentCalendar;
                this.getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            this.getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
            return null;
        }
        this.getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(Rectangle bounds) {
        this.checkWidget();
        this.setRedraw(false);
        this._savingChartImage = true;
        try {
            Image buffer = new Image((Device)this.getDisplay(), bounds);
            GC gc2 = new GC((Drawable)buffer);
            this.drawChartOntoGC(gc2, bounds);
            if (this.hasGanttSections() && this._settings.getSectionSide() == 131072) {
                this.drawSectionColumn(gc2, bounds, false, true, false, true);
            }
            gc2.dispose();
            Image image = buffer;
            return image;
        }
        catch (Exception err) {
            SWT.error((int)1, (Throwable)err);
        }
        finally {
            this._savingChartImage = false;
            this.setRedraw(true);
            this.redraw();
        }
        return null;
    }

    private List getEventsDependingOn(GanttEvent ge) {
        if (this._ganttConnections.isEmpty()) {
            return new ArrayList();
        }
        GanttMap gm = new GanttMap();
        for (int i = 0; i < this._ganttConnections.size(); ++i) {
            GanttConnection conn = (GanttConnection)this._ganttConnections.get(i);
            gm.put(conn.getSource(), conn.getTarget());
            gm.put(conn.getTarget(), conn.getSource());
        }
        Set ret = this.recursiveGetEventsDependingOn(ge, gm, new HashSet());
        if (!ret.contains(ge)) {
            ret.add(ge);
        }
        ArrayList retList = new ArrayList();
        Iterator ite = ret.iterator();
        while (ite.hasNext()) {
            retList.add(ite.next());
        }
        return retList;
    }

    private Set recursiveGetEventsDependingOn(GanttEvent ge, GanttMap gm, Set ret) {
        List conns = gm.get(ge);
        if (conns != null && conns.size() > 0) {
            for (int i = 0; i < conns.size(); ++i) {
                GanttEvent event = (GanttEvent)conns.get(i);
                if (ret.contains(event)) continue;
                ret.add(event);
                Set more = this.recursiveGetEventsDependingOn(event, gm, ret);
                if (more.size() <= 0) continue;
                for (Object obj : more) {
                    if (ret.contains(obj)) continue;
                    ret.add(obj);
                }
            }
        }
        return ret;
    }

    private void updateZoomLevel() {
        int originalDayWidth = this._settings.getDayWidth();
        int originalMonthWeekWidth = this._settings.getMonthDayWidth();
        int originalYearMonthDayWidth = this._settings.getYearMonthDayWidth();
        boolean dDay = false;
        if (this._currentView == 5) {
            dDay = true;
        }
        switch (this._zoomLevel) {
            case 0: {
                this._currentView = 1;
                this._dayWidth = originalDayWidth * 6;
                break;
            }
            case 1: {
                this._currentView = 1;
                this._dayWidth = originalDayWidth * 4;
                break;
            }
            case 2: {
                this._currentView = 1;
                this._dayWidth = originalDayWidth * 2;
                break;
            }
            case 3: {
                this._currentView = 2;
                this._dayWidth = originalDayWidth * 3;
                break;
            }
            case 4: {
                this._currentView = 2;
                this._dayWidth = originalDayWidth * 2;
                break;
            }
            case 5: {
                this._currentView = 2;
                this._dayWidth = originalDayWidth;
                break;
            }
            case 6: {
                this._currentView = 3;
                this._monthDayWidth = originalMonthWeekWidth + 6;
                break;
            }
            case 7: {
                this._currentView = 3;
                this._monthDayWidth = originalMonthWeekWidth + 3;
                break;
            }
            case 8: {
                this._currentView = 3;
                this._monthDayWidth = originalMonthWeekWidth;
                break;
            }
            case 9: {
                this._currentView = 4;
                this._yearDayWidth = originalYearMonthDayWidth + 3;
                break;
            }
            case 10: {
                this._currentView = 4;
                this._yearDayWidth = originalYearMonthDayWidth + 2;
                break;
            }
            case 11: {
                this._currentView = 4;
                this._yearDayWidth = originalYearMonthDayWidth;
                break;
            }
            case 12: {
                this._currentView = 4;
                this._yearDayWidth = originalYearMonthDayWidth - 1;
                break;
            }
            case 13: {
                this._currentView = 4;
                this._yearDayWidth = originalYearMonthDayWidth - 2;
                break;
            }
        }
        this._weekWidth = this._dayWidth * 7;
        this._monthWeekWidth = this._monthDayWidth * 7;
        if (this._zoomLevel == 0 || this._zoomLevel == 1 || this._zoomLevel == 2) {
            this._weekWidth = this._dayWidth * 24;
        }
        if (dDay) {
            this._currentView = 5;
        }
    }

    public void heavyRedraw() {
        this._zoomLevelChanged = true;
        this.forceFullUpdate();
    }

    void forceFullUpdate() {
        this.flagForceFullUpdate();
        this.redraw();
    }

    void flagForceFullUpdate() {
        this._recalcScopes = true;
        this._recalcSecBounds = true;
        for (int i = 0; i < this._ganttEvents.size(); ++i) {
            ((GanttEvent)this._ganttEvents.get(i)).setBoundsSet(false);
        }
        this._forceSBUpdate = true;
    }

    ViewPortHandler getViewPortHandler() {
        return this._viewPortHandler;
    }

    void updateHorizontalScrollbar() {
        this._hScrollHandler.recalculate();
    }

    int getLeftMostPixel() {
        return this.getPixel(true);
    }

    int getRightMostPixel() {
        return this.getPixel(false);
    }

    private int getPixel(boolean left) {
        int max = left ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        for (int i = 0; i < this._ganttEvents.size(); ++i) {
            GanttEvent ge = (GanttEvent)this._ganttEvents.get(i);
            Rectangle actualBounds = ge.getActualBounds();
            if (left) {
                if (actualBounds.x >= max) continue;
                max = actualBounds.x;
                continue;
            }
            int w = actualBounds.x + actualBounds.width;
            if (w <= max) continue;
            max = w;
        }
        return max;
    }

    public void setZoomLevel(int level) {
        if (level == this._zoomLevel) {
            return;
        }
        int toSet = level;
        if (toSet < 0) {
            toSet = 0;
        }
        if (toSet > 13) {
            toSet = 13;
        }
        int oldZoomLevel = this._zoomLevel;
        this._zoomLevel = toSet;
        this.updateZoomLevel();
        this._zoomLevelChanged = true;
        this.forceFullUpdate();
        for (int i = 0; i < this._eventListeners.size(); ++i) {
            IGanttEventListener listener = (IGanttEventListener)this._eventListeners.get(i);
            if (toSet < oldZoomLevel) {
                listener.zoomedOut(this._zoomLevel);
                continue;
            }
            listener.zoomedIn(this._zoomLevel);
        }
    }

    public void zoomIn() {
        this.zoomIn(false, null);
    }

    private void zoomIn(boolean fromMouseWheel, Point mouseLoc) {
        this.checkWidget();
        if (!this._settings.enableZooming()) {
            return;
        }
        --this._zoomLevel;
        if (this._zoomLevel < 0) {
            this._zoomLevel = 0;
            return;
        }
        Calendar preZoom = null;
        if (fromMouseWheel && mouseLoc != null) {
            preZoom = this.getDateAt(mouseLoc.x);
        }
        this.updateZoomLevel();
        if (fromMouseWheel && this._settings.zoomToMousePointerDateOnWheelZooming() && mouseLoc != null) {
            this.internalSetDateAtX(mouseLoc.x, preZoom, true, false, true);
        }
        this._zoomLevelChanged = true;
        this.forceFullUpdate();
        for (int i = 0; i < this._eventListeners.size(); ++i) {
            IGanttEventListener listener = (IGanttEventListener)this._eventListeners.get(i);
            listener.zoomedIn(this._zoomLevel);
        }
    }

    public void zoomOut() {
        this.zoomOut(false, null);
    }

    private void zoomOut(boolean fromMouseWheel, Point mouseLoc) {
        this.checkWidget();
        if (!this._settings.enableZooming()) {
            return;
        }
        ++this._zoomLevel;
        if (this._zoomLevel > 13) {
            this._zoomLevel = 13;
            return;
        }
        if (this._currentView == 5 && this._zoomLevel > 5) {
            this._zoomLevel = 5;
            return;
        }
        Calendar preZoom = null;
        if (fromMouseWheel && mouseLoc != null) {
            preZoom = this.getDateAt(mouseLoc.x);
        }
        this.updateZoomLevel();
        if (fromMouseWheel && this._settings.zoomToMousePointerDateOnWheelZooming() && mouseLoc != null) {
            this.internalSetDateAtX(mouseLoc.x, preZoom, true, false, false);
        }
        this._zoomLevelChanged = true;
        this.forceFullUpdate();
        for (int i = 0; i < this._eventListeners.size(); ++i) {
            IGanttEventListener listener = (IGanttEventListener)this._eventListeners.get(i);
            listener.zoomedOut(this._zoomLevel);
        }
    }

    public void resetZoom() {
        this.checkWidget();
        if (!this._settings.enableZooming()) {
            return;
        }
        this._zoomLevel = this._settings.getInitialZoomLevel();
        this.updateZoomLevel();
        this._zoomLevelChanged = true;
        this.forceFullUpdate();
        for (int i = 0; i < this._eventListeners.size(); ++i) {
            IGanttEventListener listener = (IGanttEventListener)this._eventListeners.get(i);
            listener.zoomReset();
        }
    }

    public void redraw() {
        this._paintManager.redrawStarting();
        super.redraw();
    }

    public void addGanttEventListener(IGanttEventListener listener) {
        this.checkWidget();
        if (this._eventListeners.contains(listener)) {
            return;
        }
        this._eventListeners.add(listener);
    }

    public void removeGanttEventListener(IGanttEventListener listener) {
        this.checkWidget();
        this._eventListeners.remove(listener);
    }

    private boolean isUseAdvancedTooltips() {
        return this._useAdvTooltips;
    }

    public void setUseAdvancedTooltips(boolean useAdvancedTooltips) {
        this._useAdvTooltips = useAdvancedTooltips;
    }

    public Calendar getDDayCalendar() {
        return DateHelper.getNewCalendar(this._dDayCalendar);
    }

    public GanttUndoRedoManager getUndoRedoManager() {
        return this._undoRedoManager;
    }

    public int getTotalVisibileGanttEvents() {
        return this._totVisEventCnt;
    }

    public void selectAll() {
        this._selectedEvents.clear();
        Object[] all = this._allEventsCombined.toArray();
        for (int i = 0; i < all.length; ++i) {
            this._selectedEvents.add(all[i]);
        }
        this.redraw();
    }

    public void deselectAll() {
        this._selectedEvents.clear();
        this.redraw();
    }

    static ImageData rotate(ImageData srcData, int direction) {
        int bytesPerPixel = srcData.bytesPerLine / srcData.width;
        int destBytesPerLine = direction == 1024 ? srcData.width * bytesPerPixel : srcData.height * bytesPerPixel;
        byte[] newData = new byte[srcData.data.length];
        int width = 0;
        int height = 0;
        for (int srcY = 0; srcY < srcData.height; ++srcY) {
            for (int srcX = 0; srcX < srcData.width; ++srcX) {
                int destX = 0;
                int destY = 0;
                int destIndex = 0;
                int srcIndex = 0;
                switch (direction) {
                    case 16384: {
                        destX = srcY;
                        destY = srcData.width - srcX - 1;
                        width = srcData.height;
                        height = srcData.width;
                        break;
                    }
                    case 131072: {
                        destX = srcData.height - srcY - 1;
                        destY = srcX;
                        width = srcData.height;
                        height = srcData.width;
                        break;
                    }
                    case 1024: {
                        destX = srcData.width - srcX - 1;
                        destY = srcData.height - srcY - 1;
                        width = srcData.width;
                        height = srcData.height;
                        break;
                    }
                }
                destIndex = destY * destBytesPerLine + destX * bytesPerPixel;
                srcIndex = srcY * srcData.bytesPerLine + srcX * bytesPerPixel;
                System.arraycopy(srcData.data, srcIndex, newData, destIndex, bytesPerPixel);
            }
        }
        return new ImageData(width, height, srcData.depth, srcData.palette, destBytesPerLine, newData);
    }

    static ImageData flip(ImageData srcData, boolean vertical) {
        int bytesPerPixel = srcData.bytesPerLine / srcData.width;
        int destBytesPerLine = srcData.width * bytesPerPixel;
        byte[] newData = new byte[srcData.data.length];
        for (int srcY = 0; srcY < srcData.height; ++srcY) {
            for (int srcX = 0; srcX < srcData.width; ++srcX) {
                int destX = 0;
                int destY = 0;
                int destIndex = 0;
                int srcIndex = 0;
                if (vertical) {
                    destX = srcX;
                    destY = srcData.height - srcY - 1;
                } else {
                    destX = srcData.width - srcX - 1;
                    destY = srcY;
                }
                destIndex = destY * destBytesPerLine + destX * bytesPerPixel;
                srcIndex = srcY * srcData.bytesPerLine + srcX * bytesPerPixel;
                System.arraycopy(srcData.data, srcIndex, newData, destIndex, bytesPerPixel);
            }
        }
        return new ImageData(srcData.width, srcData.height, srcData.depth, srcData.palette, destBytesPerLine, newData);
    }

    boolean hasGanttPhases() {
        return !this._ganttPhases.isEmpty();
    }

    boolean hasGanttSections() {
        return !this._ganttSections.isEmpty();
    }

    boolean hasSpecialDateRanges() {
        return !this._specDateRanges.isEmpty();
    }

    boolean isDDayCalendar() {
        return this._currentView == 5;
    }

    ISettings getSettings() {
        return this._settings;
    }

    static {
        String osProperty = System.getProperty("os.name");
        if (osProperty != null) {
            String osName = osProperty.toUpperCase(Locale.getDefault());
            if (osName.indexOf("WINDOWS") > -1) {
                _osType = 1;
            } else if (osName.indexOf("MAC") > -1) {
                _osType = 2;
            } else if (osName.indexOf("NIX") > -1 || osName.indexOf("NUX") > -1) {
                _osType = 3;
            }
        }
    }
}

