/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.concurrent.future;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.concurrent.future.AbstractFuture;
import org.eclipse.equinox.concurrent.future.FutureProgressMonitor;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.TimeoutException;

public class SingleOperationFuture
extends AbstractFuture {
    private static final String PLUGIN_ID = "org.eclipse.equinox.concurrent";
    private Object resultValue = null;
    private IStatus status = null;
    private TimeoutException timeoutException = null;
    protected IProgressMonitor progressMonitor;

    public SingleOperationFuture() {
        this(null);
    }

    public SingleOperationFuture(IProgressMonitor progressMonitor) {
        this.progressMonitor = new FutureProgressMonitor((IProgressMonitor)(progressMonitor == null ? new NullProgressMonitor() : progressMonitor));
    }

    public synchronized Object get() throws InterruptedException, OperationCanceledException {
        this.throwIfCanceled();
        while (!this.isDone()) {
            this.wait();
        }
        this.throwIfCanceled();
        return this.resultValue;
    }

    public synchronized Object get(long waitTimeInMillis) throws InterruptedException, TimeoutException, OperationCanceledException {
        if (waitTimeInMillis < 0L) {
            throw new IllegalArgumentException("waitTimeInMillis must be => 0");
        }
        this.throwIfCanceled();
        if (this.timeoutException != null) {
            throw this.timeoutException;
        }
        if (this.isDone()) {
            return this.resultValue;
        }
        long startTime = System.currentTimeMillis();
        long waitTime = waitTimeInMillis;
        do {
            this.wait(waitTime);
            this.throwIfCanceled();
            if (!this.isDone()) continue;
            return this.resultValue;
        } while ((waitTime = waitTimeInMillis - (System.currentTimeMillis() - startTime)) > 0L);
        throw this.createTimeoutException(waitTimeInMillis);
    }

    public synchronized boolean isDone() {
        return this.status != null;
    }

    public void runWithProgress(final IProgressRunnable runnable) {
        Assert.isNotNull((Object)runnable);
        if (!this.isCanceled()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    if (!SingleOperationFuture.this.isCanceled()) {
                        SingleOperationFuture.this.setException(exception);
                    }
                }

                public void run() throws Exception {
                    Object result = runnable.run(SingleOperationFuture.this.getProgressMonitor());
                    if (!SingleOperationFuture.this.isCanceled()) {
                        SingleOperationFuture.this.set(result);
                    }
                }
            });
        }
    }

    public synchronized IStatus getStatus() {
        return this.status;
    }

    public boolean hasValue() {
        return this.isDone();
    }

    public synchronized boolean cancel() {
        if (this.isDone()) {
            return false;
        }
        if (this.isCanceled()) {
            return false;
        }
        this.setStatus((IStatus)new Status(8, PLUGIN_ID, 8, "Operation canceled", null));
        this.getProgressMonitor().setCanceled(true);
        this.notifyAll();
        return true;
    }

    protected synchronized void setException(Throwable ex) {
        this.setStatus((IStatus)new Status(4, PLUGIN_ID, 4, "Exception during operation", ex));
        this.notifyAll();
    }

    protected synchronized void set(Object newValue) {
        this.resultValue = newValue;
        this.setStatus(Status.OK_STATUS);
        this.notifyAll();
    }

    private synchronized void setStatus(IStatus status) {
        this.status = status;
    }

    private TimeoutException createTimeoutException(long timeout) {
        this.setStatus((IStatus)new Status(4, PLUGIN_ID, 4, "Operation timeout after " + timeout + "ms", null));
        this.timeoutException = new TimeoutException("Single operation timeout", timeout);
        return this.timeoutException;
    }

    private void throwIfCanceled() throws OperationCanceledException {
        IProgressMonitor pm = this.getProgressMonitor();
        if (pm != null && pm.isCanceled()) {
            throw new OperationCanceledException("Single operation canceled");
        }
    }

    public synchronized IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public synchronized boolean isCanceled() {
        return this.getProgressMonitor().isCanceled();
    }
}

