/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.HibernateException;
import org.hibernate.engine.EntityKey;
import org.hibernate.event.LoadEvent;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.event.def.DefaultLoadEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.dao.DaoFactory;
import ru.ssa.cashadmin.dao.DaoInterface;
import ru.ssa.cashadmin.domain.Aspectscheme;
import ru.ssa.cashadmin.domain.Aspectvalueset;
import ru.ssa.cashadmin.domain.Country;
import ru.ssa.cashadmin.domain.Dept;
import ru.ssa.cashadmin.domain.InventGroup;
import ru.ssa.cashadmin.domain.Note;
import ru.ssa.cashadmin.domain.Sprices;
import ru.ssa.cashadmin.domain.Units;
import ru.ssa.cashadmin.domain.Valut;
import ru.ssa.cashadmin.domain.Vat;
import ru.ssa.cashadmin.excep.ExecuteQueryException;

public class SkipZeroKeyListener
extends DefaultLoadEventListener
implements SaveOrUpdateEventListener {
    private static final Logger log = LoggerFactory.getLogger(SkipZeroKeyListener.class);
    private static final long serialVersionUID = 1L;
    private static final Integer ZERO_INT = 0;
    private static final String ZERO_STRING = "0";
    private Map<String, List<Object>> existsMap = new ConcurrentHashMap<String, List<Object>>();

    protected Object proxyOrLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        log.trace("entity:{},id:{},idclass:{}", new Object[]{event.getEntityClassName(), event.getEntityId(), event.getEntityId() == null ? "null" : event.getEntityId().getClass()});
        if (event.getEntityClassName().equals(Valut.class.getName()) && this.isZeroKey(event)) {
            return null;
        }
        if (event.getEntityClassName().equals(Note.class.getName()) && this.isZeroKey(event)) {
            return null;
        }
        if (event.getEntityClassName().equals(Sprices.class.getName()) && this.isZeroKey(event)) {
            return null;
        }
        if (event.getEntityClassName().equals(InventGroup.class.getName()) && (this.isZeroKey(event) || this.isZeroCollection(InventGroup.class) || !this.isExistId(InventGroup.class, event))) {
            return null;
        }
        if (event.getEntityClassName().equals(Dept.class.getName()) && (this.isZeroKey(event) || this.isZeroCollection(Dept.class))) {
            return null;
        }
        if (event.getEntityClassName().equals(Country.class.getName()) && (this.isZeroKey(event) || this.isZeroCollection(Country.class))) {
            return null;
        }
        if (event.getEntityClassName().equals(Vat.class.getName()) && (this.isZeroKey(event) || this.isZeroCollection(Vat.class) || !this.isExistId(Vat.class, event))) {
            return null;
        }
        if (event.getEntityClassName().equals(Aspectvalueset.class.getName()) && this.isZeroKey(event)) {
            return null;
        }
        if (event.getEntityClassName().equals(Aspectscheme.class.getName()) && this.isZeroKey(event)) {
            return null;
        }
        if (event.getEntityClassName().equals(Units.class.getName()) && (this.isZeroCollection(Units.class) || !this.isExistId(Units.class, event))) {
            return null;
        }
        return super.proxyOrLoad(event, persister, keyToLoad, options);
    }

    private boolean isZeroCollection(Class<?> cl) {
        String name = cl.getName();
        Map<String, Boolean> collections = DaoFactory.getZeroCollections();
        if (!collections.containsKey(name)) {
            try {
                Boolean isEmpty = DaoFactory.getDAO(cl).count() == 0L;
                collections.put(name, isEmpty);
                log.info("mark collection {} " + (isEmpty != false ? "emty" : "not empty"), (Object)name);
            }
            catch (ExecuteQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return collections.get(name);
    }

    private boolean isExistId(Class<?> cl, LoadEvent event) {
        String name = cl.getName();
        if (!this.existsMap.containsKey(name) || this.existsMap.get(name).isEmpty()) {
            try {
                DaoInterface<Object> dao = DaoFactory.getDAO(cl);
                List<Object> ids = dao.findIds();
                this.existsMap.put(name, ids);
                dao.putExistsIds(ids);
                log.info("fill collectio {}", (Object)name);
            }
            catch (ExecuteQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.existsMap.get(name).contains(event.getEntityId());
    }

    private boolean isZeroKey(LoadEvent event) {
        return ZERO_INT.equals(event.getEntityId()) || ZERO_STRING.equals(event.getEntityId());
    }

    public void onSaveOrUpdate(SaveOrUpdateEvent event) throws HibernateException {
        this.onPostUpdateInsert(event.getEntity(), event.getResultId());
    }

    private void onPostUpdateInsert(Object entity, Object newId) {
        if (entity instanceof Units) {
            this.updateExistsMapAfterInsert(Units.class, newId);
        } else if (entity instanceof InventGroup) {
            this.updateExistsMapAfterInsert(InventGroup.class, newId);
        } else if (entity instanceof Vat) {
            this.updateExistsMapAfterInsert(Vat.class, newId);
        }
    }

    private void updateExistsMapAfterInsert(Class<?> cl, Object newId) {
        String name = cl.getName();
        Map<String, Boolean> collections = DaoFactory.getZeroCollections();
        collections.put(name, false);
        try {
            DaoInterface<Object> dao = DaoFactory.getDAO(cl);
            List<Object> ids = dao.findIds();
            if (ids != null && !ids.contains(newId)) {
                ids.add(newId);
            }
            this.existsMap.put(name, ids);
            dao.putExistsIds(ids);
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

