/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.directory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.yuki.directory.CombinationElement;
import su.artix.yuki.directory.CombinationService;

public class CombinationServiceImpl
implements CombinationService {
    private static final Logger log = LoggerFactory.getLogger(CombinationServiceImpl.class);
    private Map<Class<?>, CombinationElement> map = new ConcurrentHashMap();

    @Override
    public void put(Class<?> base, Class<?> editorClass, Class<?> selectorClass) {
        if (this.map.containsKey(base)) {
            CombinationElement element = this.map.get(base);
            if (element.getEditorClass() == null) {
                element.setEditorClass(editorClass);
            }
            if (element.getSelectorClass() == null) {
                element.setSelectorClass(selectorClass);
            }
        } else {
            this.map.put(base, new CombinationElement(editorClass, selectorClass));
        }
    }

    @Override
    public Class<?> getEditorClass(Class<?> base) {
        log.trace("get editor class for base:{}", base);
        return this.map.get(base).getEditorClass();
    }

    @Override
    public Class<?> getSelectorClass(Class<?> base) {
        log.trace("get selector class for base:{}", base);
        return this.map.get(base).getSelectorClass();
    }
}

