/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.perforce;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.optional.perforce.FStatP4OutputHandler;
import org.apache.tools.ant.taskdefs.optional.perforce.P4Base;
import org.apache.tools.ant.types.FileSet;

public class P4Fstat
extends P4Base {
    private int changelist;
    private String addCmd = "";
    private Vector filesets = new Vector();
    private static final int DEFAULT_CMD_LENGTH = 300;
    private int cmdLength = 300;
    private static final int SHOW_ALL = 0;
    private static final int SHOW_EXISTING = 1;
    private static final int SHOW_NON_EXISTING = 2;
    private int show = 2;
    private FStatP4OutputHandler handler;
    private StringBuffer filelist;
    private int fileNum = 0;
    private int doneFileNum = 0;
    private boolean debug = false;
    private static final String EXISTING_HEADER = "Following files exist in perforce";
    private static final String NONEXISTING_HEADER = "Following files do not exist in perforce";

    public void setShowFilter(String filter) {
        if (filter.equalsIgnoreCase("all")) {
            this.show = 0;
        } else if (filter.equalsIgnoreCase("existing")) {
            this.show = 1;
        } else if (filter.equalsIgnoreCase("non-existing")) {
            this.show = 2;
        } else {
            throw new BuildException("P4Fstat: ShowFilter should be one of: all, existing, non-existing");
        }
    }

    public void setChangelist(int changelist) throws BuildException {
        if (changelist <= 0) {
            throw new BuildException("P4FStat: Changelist# should be a positive number");
        }
        this.changelist = changelist;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void execute() throws BuildException {
        this.handler = new FStatP4OutputHandler(this);
        if (this.P4View != null) {
            this.addCmd = this.P4View;
        }
        this.P4CmdOpts = this.changelist > 0 ? "-c " + this.changelist : "";
        this.filelist = new StringBuffer();
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            if (srcFiles != null) {
                this.fileNum = srcFiles.length;
                for (int j = 0; j < srcFiles.length; ++j) {
                    File f = new File(ds.getBasedir(), srcFiles[j]);
                    this.filelist.append(" ").append('\"').append(f.getAbsolutePath()).append('\"');
                    ++this.doneFileNum;
                    if (this.filelist.length() <= this.cmdLength) continue;
                    this.execP4Fstat(this.filelist);
                    this.filelist = new StringBuffer();
                }
                if (this.filelist.length() <= 0) continue;
                this.execP4Fstat(this.filelist);
                continue;
            }
            this.log("No files specified to query status on!", 1);
        }
        if (this.show == 0 || this.show == 1) {
            this.printRes(this.handler.getExisting(), EXISTING_HEADER);
        }
        if (this.show == 0 || this.show == 2) {
            this.printRes(this.handler.getNonExisting(), NONEXISTING_HEADER);
        }
    }

    public int getLengthOfTask() {
        return this.fileNum;
    }

    int getPasses() {
        return this.filesets.size();
    }

    private void printRes(ArrayList ar, String header) {
        this.log(header, 2);
        for (int i = 0; i < ar.size(); ++i) {
            this.log((String)ar.get(i), 2);
        }
    }

    private void execP4Fstat(StringBuffer list) {
        String l = list.substring(0);
        if (this.debug) {
            this.log("Executing fstat " + this.P4CmdOpts + " " + this.addCmd + l + "\n", 2);
        }
        this.execP4Command("fstat " + this.P4CmdOpts + " " + this.addCmd + l, this.handler);
    }
}

