/*
 * Decompiled with CFR 0.152.
 */
package su.artix.accounting.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import su.artix.accounting.domain.Account;
import su.artix.accounting.domain.CardStatus;
import su.artix.accounting.domain.CardTransaction;
import su.artix.accounting.domain.Terminal;

@Entity
@Table(name="cardAccounting")
@Document
public class Card
implements Serializable {
    private static final long serialVersionUID = 747648092682490349L;
    private String idcard;
    @Id
    private String number;
    @DBRef(db="account")
    private Account account;
    private String accountNumber;
    private CardStatus status;
    private List<CardTransaction> cardOperations;
    private BigDecimal lastKnownBonusBalance;
    private Date lastKnownBonusBalanceDate;
    private String additionalStatus;

    @javax.persistence.Id
    public String getIdcard() {
        return this.idcard;
    }

    public void setIdcard(String idcard) {
        this.idcard = idcard;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @ManyToOne
    @JoinColumn(name="accountNumber", referencedColumnName="number")
    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
        this.accountNumber = account != null ? account.getNumber() : null;
    }

    public void setAccount(Terminal terminal, Account account) {
        this.setAccount(account);
        this.fillCardTransaction(terminal);
    }

    @Column(insertable=false, updatable=false)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    @Enumerated(value=EnumType.STRING)
    public CardStatus getStatus() {
        if (this.status == null) {
            return CardStatus.EARN_PAY;
        }
        return CardStatus.convertFromDeprecated(this.status);
    }

    public void setStatus(CardStatus status) {
        this.status = status;
    }

    public BigDecimal getLastKnownBonusBalance() {
        return this.lastKnownBonusBalance;
    }

    public void setLastKnownBonusBalance(BigDecimal lastKnownBonusBalance) {
        this.lastKnownBonusBalance = lastKnownBonusBalance;
    }

    public Date getLastKnownBonusBalanceDate() {
        return this.lastKnownBonusBalanceDate;
    }

    public void setLastKnownBonusBalanceDate(Date lastKnownBonusBalanceDate) {
        this.lastKnownBonusBalanceDate = lastKnownBonusBalanceDate;
    }

    public String getAdditionalStatus() {
        return this.additionalStatus;
    }

    public void setAdditionalStatus(String additionalStatus) {
        this.additionalStatus = additionalStatus;
    }

    public void setStatus(Terminal terminal, CardStatus status) {
        this.setStatus(status);
        this.fillCardTransaction(terminal);
    }

    public void setStatus(Terminal terminal, CardStatus status, String additionalStatus) {
        this.setStatus(status);
        this.setAdditionalStatus(additionalStatus);
        this.fillCardTransaction(terminal);
    }

    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="card_id")
    public List<CardTransaction> getCardOperations() {
        return this.cardOperations;
    }

    public void setCardOperations(List<CardTransaction> cardOperations) {
        this.cardOperations = cardOperations;
    }

    protected void fillCardTransaction(Terminal terminal) {
        CardTransaction cardTransaction = new CardTransaction();
        cardTransaction.setOperationDate(new Date());
        cardTransaction.setStatus(this.status);
        cardTransaction.setTerminal(terminal);
        cardTransaction.setAccountNumber(this.accountNumber);
        if (this.cardOperations == null) {
            this.cardOperations = new ArrayList<CardTransaction>();
        }
        this.cardOperations.add(cardTransaction);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Card [idcard=");
        builder.append(this.idcard);
        builder.append(", number=");
        builder.append(this.number);
        builder.append(", account=");
        builder.append(this.account);
        builder.append(", status=");
        builder.append((Object)this.status);
        builder.append("]");
        return builder.toString();
    }
}

