/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.keyboard.domain;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import su.artix.yuki.keyboard.domain.KeyboardButtonData;

@XmlRootElement(name="keyboard")
public class KeyboardContainer {
    private String name;
    @XmlAttribute
    private int currentX;
    @XmlAttribute
    private int currentY;
    @XmlTransient
    private int currentHeigth;
    private List<KeyboardButtonData> buttons = new ArrayList<KeyboardButtonData>();

    public void add(KeyboardButtonData button) {
        button.setX(this.currentX);
        button.setY(this.currentY);
        this.currentX += button.getWidth();
        this.currentHeigth = Math.max(this.currentHeigth, button.getHeigth());
        this.buttons.add(button);
    }

    public KeyboardContainer copy() {
        KeyboardContainer keyboard = new KeyboardContainer();
        keyboard.name = this.name;
        keyboard.currentX = this.currentX;
        keyboard.currentY = this.currentY;
        keyboard.currentHeigth = this.currentHeigth;
        keyboard.buttons = new ArrayList<KeyboardButtonData>();
        for (KeyboardButtonData data : this.buttons) {
            KeyboardButtonData newData = data.copy();
            keyboard.buttons.add(newData);
        }
        return keyboard;
    }

    public void newLine() {
        this.currentY += this.currentHeigth;
        this.currentX = 0;
    }

    public void zeroSpaceRight(int width) {
        this.currentX += width;
    }

    public void zeroSpaceBottom(int heigth) {
        this.currentY += heigth;
    }

    public void upSpaceBottom(int heigth) {
        this.currentY -= heigth;
        this.currentHeigth -= heigth;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElementWrapper(name="buttons")
    @XmlElement(name="button")
    public List<KeyboardButtonData> getButtons() {
        return this.buttons;
    }

    public void setButtons(List<KeyboardButtonData> buttons) {
        this.buttons = buttons;
    }
}

