/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.connect;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResourceAccessException;
import ru.ssa.artixadmin.ArtixAdminActivator;
import ru.ssa.cashadmin.domain.CSVersion;
import ru.ssa.cashadmin.domain.Connect;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.artixadmin.connection.ManagedHost;
import su.artix.cashserver.core.cashregistry.domain.CashServerMode;
import su.artix.cashserver.core.cashregistry.domain.WebUser;
import su.artix.cashserver.core.cashregistry.repository.WebUserRepository;
import su.artix.cashserver.rest.client.IClientGetter;
import su.artix.cashserver.rest.client.RestInvokerManager;
import su.artix.cashserver.rest.domain.CashServerModeInfo;

public class UserConnecting {
    private static final Logger log = LoggerFactory.getLogger(UserConnecting.class);

    public static void initAuth(Connect connect) {
        String id = connect.isMysqlServerSplitConnect() ? connect.getMysqlServerHost() : String.valueOf(connect.getAddress()) + connect.getPort() + connect.getPrefix() + "All";
        ArtixAdminActivator.getDefault().getBeanByClass(ManagedHost.class, "httpInvokerHost").put((Object)id, connect.getAddress(), connect.getRcpPort());
        ArtixAdminActivator.getDefault().getBeanByClass(RestInvokerManager.class, "restInvokerManager").setDefault(connect.getAddress(), connect.getHttpPort());
        String supportIp = System.getProperty("yuki.supportRestIp");
        if (supportIp != null) {
            String supportPort = System.getProperty("yuki.supportRestPort", "8080");
            ArtixAdminActivator.getDefault().getBeanByClass(RestInvokerManager.class, "supportRestInvokerManager").setDefault(supportIp, supportPort);
        }
        if (!connect.getCsVersion().older(CSVersion.VERSION3_0)) {
            try {
                CashServerModeInfo info = ArtixAdminActivator.getDefault().getBeanByClass(IClientGetter.class).getClient().getSystemEntity().getCashServerModeInfo();
                CashServerMode cashServerMode = new CashServerMode();
                cashServerMode.setCashserverId(info.getCashserverId());
                cashServerMode.setCashserverName(info.getCashserverName());
                cashServerMode.setClusterMode(info.getClusterMode());
                cashServerMode.setHierarhyMode(info.getHierarhyMode());
                cashServerMode.setMiddleServerState(info.getMiddleServerState());
                cashServerMode.setStateDescription(info.getStateDescription());
                ArtixAdminContextHolder.setCashServerMode((CashServerMode)cashServerMode);
            }
            catch (RuntimeException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            ArtixAdminContextHolder.setCashServerMode((CashServerMode)new CashServerMode());
        }
        ArtixAdminContextHolder.setConnectionId((String)id);
    }

    public static WebUser auth(String authName, String authPassword) {
        WebUserRepository webUserRepository = ArtixAdminActivator.getDefault().getBeanByClass(WebUserRepository.class);
        WebUser webUser = null;
        if (authName.length() > 0 && authPassword.length() > 0) {
            try {
                if (ArtixAdminContextHolder.isCashserver()) {
                    UserConnecting.setUserForRest(authName, authPassword);
                }
                webUser = webUserRepository.findByNameAndPassword(authName, authPassword);
                log.info("find user:{}", (Object)webUser);
                if (webUser == null) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438", (String)"\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044f!");
                }
            }
            catch (DataAccessException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438", (String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0411\u0414 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f!");
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (RemoteConnectFailureException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430 HTTP", (String)"\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b HTTP \u043a\u0430\u0441\u0441\u043e\u0432\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430!");
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (HttpClientErrorException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430 HTTP", (String)"\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b HTTP \u043a\u0430\u0441\u0441\u043e\u0432\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430!");
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (ResourceAccessException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430 HTTP", (String)"\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b HTTP \u043a\u0430\u0441\u0441\u043e\u0432\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430!");
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return webUser;
    }

    public static void setUserForRest(String login, String password) {
        RestInvokerManager restInvokerManager = ArtixAdminActivator.getDefault().getBeanByClass(RestInvokerManager.class, "restInvokerManager");
        restInvokerManager.setUseGlobalAuth(true);
        restInvokerManager.resetUserInfo();
        restInvokerManager.setUserInfo(login, password);
    }
}

