/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view;

import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.ArtixAdminActivator;
import ru.ssa.artixadmin.CashConnector;
import ru.ssa.artixadmin.StatusHelper;
import ru.ssa.artixadmin.view.directory.action.ActionpanelGuiTableView;
import ru.ssa.cashadmin.domain.Connect;
import ru.ssa.cashadmin.domain.docs.Workshift;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.artixadmin.connection.ManagedWebUserSource;
import su.artix.cashserver.cashtree.domain.Category;
import su.artix.cashserver.cashtree.domain.Group;
import su.artix.cashserver.cashtree.domain.MiddleServer;
import su.artix.cashserver.cashtree.domain.ParentType;
import su.artix.cashserver.cashtree.domain.Shop;
import su.artix.cashserver.cashtree.model.TreeModel;
import su.artix.cashserver.cashtree.view.ViewShops;
import su.artix.cashserver.core.cashregistry.domain.CashServerMode;
import su.artix.cashserver.core.cashregistry.domain.WebUser;
import su.artix.discountmanager.Activator;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryEditModel;

public enum CashTreeActivity {
    INSTANCE;

    private String activityId = "su.artix.cashserver.cashtree.activityCashTree";
    private ISelectionListener mylistener;
    private ISelection previousTreeSelection = null;
    private ISelection previousTreeSelectionNofilter = null;
    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(CashTreeActivity.class);
    }

    public void cashTreeActivate() {
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager activityManager = activitySupport.getActivityManager();
        HashSet<String> enabledActivities = new HashSet<String>();
        for (Object oldId : activityManager.getEnabledActivityIds()) {
            enabledActivities.add((String)oldId);
        }
        if (activityManager.getActivity(this.activityId).isDefined()) {
            enabledActivities.add(this.activityId);
        }
        activitySupport.setEnabledActivityIds(enabledActivities);
    }

    public void cashTreeDeActivate() {
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        HashSet<String> enabledActivities = new HashSet<String>();
        IActivityManager activityManager = activitySupport.getActivityManager();
        for (Object oldId : activityManager.getEnabledActivityIds()) {
            if (this.activityId.equals(oldId)) continue;
            enabledActivities.add((String)oldId);
        }
        activitySupport.setEnabledActivityIds(enabledActivities);
        IPerspectiveDescriptor[] openPerspectives = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getOpenPerspectives();
        IPerspectiveDescriptor openPerspective = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = openPerspectives;
        int n = openPerspectives.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor perspective = iPerspectiveDescriptorArray[n2];
            if (!perspective.getId().equals(openPerspective.getId())) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closePerspective(perspective, false, true);
            }
            ++n2;
        }
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().resetPerspective();
    }

    private void closeNotActivePerspectives() {
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSortedPerspectives();
        int n = iPerspectiveDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor pd = iPerspectiveDescriptorArray[n2];
            if (!pd.getId().equals("ru.ssa.artixadmin.Perspective") && !pd.equals(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective())) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closePerspective(pd, true, false);
            }
            ++n2;
        }
    }

    private void connect(String shopCode, Connect connect, String clusterId) {
        if (!ArtixAdminActivator.getDefault().getCurrentConnect().getStoreId().equals(shopCode)) {
            this.closeNotActivePerspectives();
            connect.setStoreId(shopCode);
            connect.setClusterId(clusterId);
            Display.getCurrent().syncExec(new Runnable(){

                @Override
                public void run() {
                    Display.getCurrent().getActiveShell().setCursor(new Cursor((Device)Display.getCurrent(), 1));
                }
            });
            WebUser webUser = ArtixAdminActivator.getDefault().getBeanByClass(ManagedWebUserSource.class).getCurrentUser();
            CashConnector.getInstance().connectToCashserver(connect, webUser, null, false);
            Display.getCurrent().syncExec(new Runnable(){

                @Override
                public void run() {
                    Display.getCurrent().getActiveShell().setCursor(new Cursor((Device)Display.getCurrent(), 0));
                }
            });
        }
    }

    private boolean saveDiscountRequest(String currentShopId, String newShopId, ViewShops part) {
        if (!StringUtils.equals((String)currentShopId, (String)newShopId)) {
            ActionpanelGuiTableView view;
            if (!Activator.getDefault().saveDiscountSystems()) {
                this.restoreSelection(currentShopId, part);
                return false;
            }
            log.info("before change shop {}", (Object)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId());
            if ("ru.ssa.artixadmin.perspectives.ActionpanelPerspective".equals(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId()) && (view = (ActionpanelGuiTableView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("ru.ssa.artixadmin.view.directory.ActionpanelGuiTableView")) != null && view.getPanel().isChanged() && !view.getPanel().openConfirmDilog()) {
                log.info("some data is changed ");
                ViewShops viewShops = (ViewShops)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("su.artix.cashserver.cashtree.viewShops");
                viewShops.getCommonViewer().setSelection(this.previousTreeSelectionNofilter);
                return false;
            }
        }
        return true;
    }

    private void restoreSelection(String currentShopId, ViewShops part) {
        TreeSelection oldSelection = null;
        if ("All".equals(currentShopId)) {
            for (Object group : ArtixAdminActivator.getDefault().getBeanByClass(TreeModel.class).getRootGroups(this.getClusterCurrentUser())) {
                if (!(group instanceof Group) || ((Group)group).getParentGroup() != null) continue;
                oldSelection = new TreeSelection(new TreePath(new Object[]{group}));
                break;
            }
        } else {
            for (Object shop : ArtixAdminActivator.getDefault().getBeanByClass(TreeModel.class).getShops()) {
                if (!(shop instanceof Shop) || !StringUtils.equals((String)((Shop)shop).getId(), (String)currentShopId)) continue;
                oldSelection = new TreeSelection(new TreePath(new Object[]{shop}));
                break;
            }
        }
        part.getCommonViewer().setSelection(oldSelection, true);
    }

    private String getClusterCurrentUser() {
        WebUser webUser = ArtixAdminActivator.getDefault().getBeanByClass(ManagedWebUserSource.class).getCurrentUser();
        return webUser.getClusterId();
    }

    public void addCashTreeListener(final Connect connect) {
        this.mylistener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selectionIn) {
                IStructuredSelection selection = (IStructuredSelection)selectionIn;
                if (part instanceof ViewShops && selection.size() == 1) {
                    ArtixAdminActivator.getDefault().setSelectedCategory(null);
                    if (CashServerMode.HierarchyMode.MIDDLE.equals((Object)ArtixAdminContextHolder.getCashServerMode().getHierarhyMode())) {
                        if (selection.getFirstElement() instanceof MiddleServer) {
                            MiddleServer middleServer = (MiddleServer)selection.getFirstElement();
                            if (ArtixAdminContextHolder.getCashServerMode().getCashserverId().equals(middleServer.getId())) {
                                String currentStoreId = ArtixAdminActivator.getDefault().getCurrentConnect().getStoreId();
                                if (!CashTreeActivity.this.saveDiscountRequest(currentStoreId, "All", (ViewShops)part)) {
                                    return;
                                }
                                StatusHelper.setConnectionInfoOnStatusLine(StatusHelper.StatusTypes.CONNECTED, "\u041c\u0430\u0433\u0430\u0437\u0438\u043d", "All", "All");
                                CashTreeActivity.this.connect("All", connect, this.getClusterFormUser(middleServer.getClusterId()));
                            }
                        } else if (selection.getFirstElement() instanceof Shop) {
                            Shop shop = (Shop)selection.getFirstElement();
                            String currentStoreId = ArtixAdminActivator.getDefault().getCurrentConnect().getStoreId();
                            if (!CashTreeActivity.this.saveDiscountRequest(currentStoreId, shop.getId(), (ViewShops)part)) {
                                return;
                            }
                            StatusHelper.setConnectionInfoOnStatusLine(StatusHelper.StatusTypes.CONNECTED, "\u041c\u0430\u0433\u0430\u0437\u0438\u043d", shop.getId(), shop.getTitle());
                            CashTreeActivity.this.connect(shop.getId(), connect, shop.getClusterId());
                        } else if (selection.getFirstElement() instanceof Category) {
                            Category category = (Category)selection.getFirstElement();
                            String currentStoreId = ArtixAdminActivator.getDefault().getCurrentConnect().getStoreId();
                            if (!CashTreeActivity.this.saveDiscountRequest(currentStoreId, category.getId(), (ViewShops)part)) {
                                return;
                            }
                            StatusHelper.setConnectionInfoOnStatusLine(StatusHelper.StatusTypes.CONNECTED, "\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f", category.getId(), category.getTitle());
                            CashTreeActivity.this.connect(category.getId(), connect, category.getClusterId());
                        }
                    } else if (selection.getFirstElement() instanceof MiddleServer) {
                        MiddleServer middleServer = (MiddleServer)selection.getFirstElement();
                        String currentStoreId = ArtixAdminActivator.getDefault().getCurrentConnect().getStoreId();
                        if (!CashTreeActivity.this.saveDiscountRequest(currentStoreId, middleServer.getId(), (ViewShops)part)) {
                            return;
                        }
                        StatusHelper.setConnectionInfoOnStatusLine(StatusHelper.StatusTypes.CONNECTED, "\u041c\u041a\u0421", middleServer.getId(), middleServer.getTitle());
                        CashTreeActivity.this.connect(middleServer.getId(), connect, middleServer.getClusterId());
                    } else if (selection.getFirstElement() instanceof Shop) {
                        Shop shop = (Shop)selection.getFirstElement();
                        String currentStoreId = ArtixAdminActivator.getDefault().getCurrentConnect().getStoreId();
                        if (!CashTreeActivity.this.saveDiscountRequest(currentStoreId, shop.getId(), (ViewShops)part)) {
                            return;
                        }
                        if (shop.getParentObject() != null && ParentType.MIDDLE_SERVER.equals((Object)shop.getParentObject().getParentType())) {
                            return;
                        }
                        StatusHelper.setConnectionInfoOnStatusLine(StatusHelper.StatusTypes.CONNECTED, "\u041c\u0430\u0433\u0430\u0437\u0438\u043d", shop.getId(), shop.getTitle());
                        CashTreeActivity.this.connect(shop.getId(), connect, shop.getClusterId());
                        CashTreeActivity.this.processDocument(shop.getId());
                    } else if (selection.getFirstElement() instanceof Group) {
                        if (((Group)selection.getFirstElement()).getParentGroup() == null) {
                            String currentStoreId = ArtixAdminActivator.getDefault().getCurrentConnect().getStoreId();
                            if (!CashTreeActivity.this.saveDiscountRequest(currentStoreId, "All", (ViewShops)part)) {
                                return;
                            }
                            StatusHelper.setConnectionInfoOnStatusLine(StatusHelper.StatusTypes.CONNECTED, "\u041c\u0430\u0433\u0430\u0437\u0438\u043d", "All", "All");
                            String clusterId = ((Group)selection.getFirstElement()).getClusterId();
                            clusterId = this.getClusterFormUser(clusterId);
                            CashTreeActivity.this.connect("All", connect, clusterId);
                        }
                    } else if (selection.getFirstElement() instanceof Category) {
                        final Category category = (Category)selection.getFirstElement();
                        IPerspectiveDescriptor perspective = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
                        String id = perspective.getId();
                        if ("ru.ssa.artixadmin.perspectives.DocumentsPerspective".equals(id) || "ru.ssa.artixadmin.perspectives.CrightsPerspective".equals(id)) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", (String)("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432 \u043d\u0435 \u043f\u0440\u0435\u0434\u043f\u043e\u043b\u0430\u0433\u0430\u044e\u0442 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432, \u043f\u043e\u044d\u0442\u043e\u043c\u0443 \u0432\u044b\u0431\u043e\u0440 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438: \"" + category.getTitle() + "\" \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d."));
                                }
                            });
                            IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("su.artix.cashserver.cashtree.viewShops");
                            ViewShops viewShops = (ViewShops)view;
                            viewShops.getCommonViewer().setSelection(CashTreeActivity.this.previousTreeSelection);
                        } else {
                            ArtixAdminActivator.getDefault().setSelectedCategory(category);
                            String currentStoreId = ArtixAdminActivator.getDefault().getCurrentConnect().getStoreId();
                            if (!CashTreeActivity.this.saveDiscountRequest(currentStoreId, category.getId(), (ViewShops)part)) {
                                return;
                            }
                            StatusHelper.setConnectionInfoOnStatusLine(StatusHelper.StatusTypes.CONNECTED, "\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f", category.getId(), category.getTitle());
                            CashTreeActivity.this.connect(category.getId(), connect, category.getClusterId());
                        }
                    }
                }
                if (!(selection.getFirstElement() instanceof Category)) {
                    CashTreeActivity.this.previousTreeSelection = (ISelection)selection;
                }
                CashTreeActivity.this.previousTreeSelectionNofilter = (ISelection)selection;
            }

            protected String getClusterFormUser(String clusterId) {
                if (clusterId == null) {
                    WebUser webUser = ArtixAdminActivator.getDefault().getBeanByClass(ManagedWebUserSource.class).getCurrentUser();
                    clusterId = webUser.getClusterId();
                }
                return clusterId;
            }
        };
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener(this.mylistener);
    }

    private void processDocument(String id) {
        if (ArtixAdminActivator.getDefault().isGlobalSale()) {
            DirectoryEditModel model = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Workshift.class);
            model.setStoreId(id);
        }
    }

    public void dispose() {
        if (this.mylistener != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener(this.mylistener);
        }
    }
}

