/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.directory.goods;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.view.directory.goods.GroupHierarchicalView;
import ru.ssa.artixadmin.view.directory.goods.InventViewPanel;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.InventGroup;
import ru.ssa.cashadmin.utils.AdditionalCriteria;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.action.DirectoryEditActionGroup;
import su.artix.yuki.directory.Directory;
import su.artix.yuki.editors.utils.BitsModel;
import su.artix.yuki.editors.utils.BitsToolTipSupport;
import su.artix.yuki.images.ArtixAdminImages;
import su.artix.yuki.provider.LazyContentProvider;
import su.artix.yuki.provider.PojoTableLabelProvider;
import su.artix.yuki.view.DirectoryTableView;
import su.artix.yuki.view.DirectoryViewPanel;

@SecurityKey(title="\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438. \u0422\u043e\u0432\u0430\u0440\u044b. \u0422\u043e\u0432\u0430\u0440\u044b")
public class InventTableView
extends DirectoryTableView<Invent> {
    public static final String ID = "ru.ssa.artixadmin.view.directory.TmcTableView";
    private static final Logger log = LoggerFactory.getLogger(InventTableView.class);
    private InventGroup parentGroups;

    protected String getID() {
        return ID;
    }

    public void createPartControl(Composite parent) {
        this.setPojoClass(Invent.class);
        this.setViewPanel((DirectoryViewPanel)new InventViewPanel(parent, 0, false));
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        LazyContentProvider lazyContentProvider = new LazyContentProvider(Invent.class, (TableViewer)this.getViewer());
        lazyContentProvider.setSortProperty("bcode");
        ((TableViewer)this.getViewer()).setContentProvider((IContentProvider)lazyContentProvider);
        HashMap<Integer, BitsModel> map = new HashMap<Integer, BitsModel>();
        map.put(23, new BitsModel(Directory.tmcBcodeModes, "bcodeMode"));
        map.put(24, new BitsModel(Directory.tmcDeptModes, "deptMode"));
        map.put(25, new BitsModel(Directory.tmcOpModes, "opMode"));
        map.put(26, new BitsModel(Directory.tmcPriceModes, "priceMode"));
        map.put(27, new BitsModel(Directory.tmcQuantModes, "quantMode"));
        map.put(28, new BitsModel(Directory.tmcOstatModes, "ostat"));
        BitsToolTipSupport.enableFor((ColumnViewer)this.getViewer(), (int)2, map);
        ((TableViewer)this.getViewer()).setLabelProvider((IBaseLabelProvider)new PojoTableLabelProvider(this.getColumns()));
        this.getViewPanel().setInput(null);
        ArrayList<ShowGroupsAction> customActions = new ArrayList<ShowGroupsAction>();
        customActions.add(new ShowGroupsAction());
        this.commonActionGroup = new DirectoryEditActionGroup(Invent.class, customActions);
        this.commonActionGroup.fillActionBars(this.getViewSite().getActionBars());
        super.createPartControl(parent);
        this.restoreState();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selectionIn) {
        log.trace("selectionChanged part {} selection {}", (Object)part, (Object)selectionIn);
        IStructuredSelection selection = (IStructuredSelection)selectionIn;
        if (part instanceof GroupHierarchicalView && selection.size() == 1 && selection.getFirstElement() instanceof InventGroup) {
            InventGroup newGroups = (InventGroup)selection.getFirstElement();
            if (this.parentGroups != null && this.parentGroups.getGroupcode().equals(newGroups.getGroupcode())) {
                this.getViewPanel().getFilter().setAdditionalCriteria(null);
                this.getViewPanel().setInput(null);
                this.parentGroups = null;
            } else {
                this.parentGroups = newGroups;
                Invent tmc = (Invent)LibActivator.getDefault().getActualClassResolver().getInstance(Invent.class);
                tmc.setGroup(newGroups);
                this.commonActionGroup.getAddAction().setModel((Object)tmc);
                this.commonActionGroup.getAddAction().setEnabled(true);
                List set = Collections.emptyList();
                if (!set.isEmpty()) {
                    this.getViewPanel().getFilter().setAdditionalCriteria(new AdditionalCriteria(AdditionalCriteria.Type.IN, new Object[]{"groupcode", set.toArray()}));
                    this.getViewPanel().setInput(null);
                } else {
                    this.getViewPanel().getFilter().setAdditionalCriteria(null);
                    this.getViewPanel().setInput((Object)tmc);
                }
            }
        }
    }

    private class ShowGroupsAction
    extends Action {
        private boolean checked;

        public ShowGroupsAction() {
            this.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/group"));
            this.setToolTipText("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u044b");
        }

        public int getStyle() {
            return 2;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
            try {
                if (this.isChecked()) {
                    this.setToolTipText("\u0421\u043f\u0440\u044f\u0442\u0430\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u044b");
                    this.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("shadow/16x16/group"));
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ru.ssa.artixadmin.view.directory.goods.GroupHierarchicalView");
                } else {
                    IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("ru.ssa.artixadmin.view.directory.goods.GroupHierarchicalView");
                    this.setToolTipText("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u044b");
                    this.setImageDescriptor(ArtixAdminImages.getDefault().getImageDescriptor("plane/16x16/group"));
                    viewPart.getSite().getSelectionProvider().setSelection(null);
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(viewPart);
                    InventTableView.this.getViewPanel().getFilter().setAdditionalCriteria(null);
                    InventTableView.this.getViewPanel().setInput(null);
                    InventTableView.this.parentGroups = null;
                }
            }
            catch (PartInitException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            super.setChecked(checked);
        }
    }
}

