/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.view.document;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.ArtixAdminActivator;
import ru.ssa.artixadmin.view.document.ClientViewPanel;
import ru.ssa.artixadmin.view.document.DocumentTableView;
import ru.ssa.artixadmin.view.document.WorkshiftTableView;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.dao.DaoFactory;
import ru.ssa.cashadmin.dao.DaoInterface;
import ru.ssa.cashadmin.domain.docs.Carditem;
import ru.ssa.cashadmin.domain.docs.Client;
import ru.ssa.cashadmin.domain.docs.ClientServerV22;
import ru.ssa.cashadmin.domain.docs.Document;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import ru.ssa.cashadmin.utils.FilterRestriction;
import su.artix.cashserver.security.SecurityKey;
import su.artix.yuki.action.DirectoryEditActionGroup;
import su.artix.yuki.provider.LazyContentProvider;
import su.artix.yuki.provider.PojoTableLabelProvider;
import su.artix.yuki.view.DirectoryTableView;
import su.artix.yuki.view.DirectoryViewPanel;

@SecurityKey(title="\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b. \u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b. \u041a\u043b\u0438\u0435\u043d\u0442\u044b")
public class ClientTableView
extends DirectoryTableView<Client> {
    public static final String ID = "ru.ssa.artixadmin.view.document.ClientTableView";
    private static final Logger log = LoggerFactory.getLogger(ClientTableView.class);
    private boolean firstInitial = true;

    public void createPartControl(Composite parent) {
        this.setPojoClass(Client.class);
        this.setViewPanel((DirectoryViewPanel)new ClientViewPanel(parent, 0, true));
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        ((TableViewer)this.getViewer()).setContentProvider((IContentProvider)new LazyContentProvider(Client.class, (TableViewer)this.getViewer()));
        ((TableViewer)this.getViewer()).setLabelProvider((IBaseLabelProvider)new PojoTableLabelProvider(this.getColumns(), false));
        this.commonActionGroup = new DirectoryEditActionGroup(Client.class).removeAction(new String[]{"ru.ssa.artixadmin.action.DirectoryAddAction", "ru.ssa.artixadmin.action.DirectoryEditAction", "ru.ssa.artixadmin.action.DirectoryCopyAction"});
        this.commonActionGroup.fillActionBars(this.getViewSite().getActionBars());
        this.commonActionGroup.setEnabledEditGroupActions(Boolean.valueOf(false));
        super.createPartControl(parent);
        this.restoreState();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selectionIn) {
        block11: {
            if (selectionIn.isEmpty() && this.firstInitial) {
                ISelection selectionTemp = part.getSite().getPage().getSelection("ru.ssa.artixadmin.view.document.DocumentTableView");
                selectionIn = selectionTemp == null ? selectionIn : selectionTemp;
            }
            log.trace("selectionChanged part {} selection {}", (Object)part, (Object)selectionIn);
            IStructuredSelection selection = (IStructuredSelection)selectionIn;
            if (part instanceof DocumentTableView || selectionIn != null && !selectionIn.isEmpty() && this.firstInitial) {
                if (selection.size() == 1 && selection.getFirstElement() instanceof Document) {
                    if (!ArtixAdminActivator.getDefault().isCashServer()) {
                        Carditem carditem = (Carditem)LibActivator.getDefault().getActualClassResolver().getInstance(Carditem.class);
                        Document document = (Document)selection.getFirstElement();
                        carditem.setDocumentid(document.getDocumentid());
                        carditem.setCashcode(document.getCashcode());
                        try {
                            DaoInterface dao = DaoFactory.getDAO(Carditem.class);
                            List ids = dao.getProjectionList("clientitemid", (Object)carditem);
                            this.getViewPanel().getFilter().clearAll();
                            if (CollectionUtils.isNotEmpty((Collection)ids) && ids.get(0) != null) {
                                int k = 0;
                                for (Object id : ids) {
                                    this.getViewPanel().getFilter().add(new FilterRestriction("clientitemid", id, k > 0 ? FilterRestriction.LinkCondition.or : FilterRestriction.LinkCondition.unique, FilterRestriction.Condition.eq, Boolean.valueOf(true)));
                                    ++k;
                                }
                                ((TableViewer)this.getViewPanel().getViewer()).setInput((Object)this.getViewPanel().getFilter());
                                break block11;
                            }
                            this.getViewPanel().getFilter().add(new FilterRestriction("clientitemid", (Object)-1, FilterRestriction.LinkCondition.unique, FilterRestriction.Condition.eq, Boolean.valueOf(true)));
                            ((TableViewer)this.getViewPanel().getViewer()).setInput((Object)this.getViewPanel().getFilter());
                        }
                        catch (ExecuteQueryException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    } else {
                        this.getViewPanel().getFilter().clearAll();
                        ClientServerV22 client = (ClientServerV22)LibActivator.getDefault().getActualClassResolver().getInstance(Client.class);
                        Document document = (Document)selection.getFirstElement();
                        client.setDocumentid(document.getDocumentid());
                        this.getViewPanel().setInput((Object)client);
                    }
                }
            } else if (part instanceof WorkshiftTableView) {
                this.getViewPanel().getFilter().clearAll();
                this.getViewPanel().getFilter().add(new FilterRestriction("clientitemid", (Object)-1, FilterRestriction.LinkCondition.unique, FilterRestriction.Condition.eq, Boolean.valueOf(true)));
                ((TableViewer)this.getViewPanel().getViewer()).setInput((Object)this.getViewPanel().getFilter());
            }
        }
        this.firstInitial = false;
    }

    protected String getID() {
        return ID;
    }
}

