/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.calculator;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.mihalis.opal.calculator.CalculatorButtonsComposite;

public class Calculator
extends Composite {
    private final Label displayArea;
    private final CalculatorButtonsComposite panel;

    public Calculator(Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)new GridLayout());
        this.displayArea = this.createTextArea();
        this.panel = new CalculatorButtonsComposite(this, 0);
        this.panel.setLayoutData(new GridData(4, 4, true, true));
        this.panel.setDisplayArea(this.displayArea);
        this.displayArea.addKeyListener(this.panel.getKeyListener());
    }

    private Label createTextArea() {
        Label label = new Label((Composite)this, 133120);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 150;
        label.setLayoutData((Object)gridData);
        label.setText("0");
        label.setBackground(this.getDisplay().getSystemColor(1));
        return label;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        this.panel.addModifyListener(modifyListener);
    }

    public String getValue() {
        this.checkWidget();
        return this.displayArea.getText();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        this.panel.removeModifyListener(modifyListener);
    }

    public void setValue(String string) {
        this.checkWidget();
        new Float(string);
        this.displayArea.setText(string);
    }
}

