/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.FacetTag;
import javax.faces.webapp.UIComponentClassicTagBase;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public abstract class UIComponentTag
extends UIComponentClassicTagBase {
    private String _binding = null;
    private String _rendered = null;
    private Boolean _suppressed = null;

    public void release() {
        super.release();
        this._binding = null;
        this._rendered = null;
    }

    public void setBinding(String binding) throws JspException {
        if (!UIComponentTag.isValueReference(binding)) {
            throw new IllegalArgumentException("not a valid binding: " + binding);
        }
        this._binding = binding;
    }

    public void setRendered(String rendered) {
        this._rendered = rendered;
    }

    public static UIComponentTag getParentUIComponentTag(PageContext pageContext) {
        UIComponentClassicTagBase parentTag = UIComponentTag.getParentUIComponentClassicTagBase(pageContext);
        return parentTag instanceof UIComponentTag ? (UIComponentTag)parentTag : new UIComponentTagWrapper(parentTag);
    }

    public static boolean isValueReference(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        int start = value.indexOf("#{");
        if (start < 0) {
            return false;
        }
        int end = value.lastIndexOf(125);
        return end >= 0 && start < end;
    }

    protected UIComponent createComponent(FacesContext context, String id) {
        String componentType = this.getComponentType();
        if (componentType == null) {
            throw new NullPointerException("componentType");
        }
        if (this._binding != null) {
            Application application = context.getApplication();
            ValueBinding componentBinding = application.createValueBinding(this._binding);
            UIComponent component = application.createComponent(componentBinding, context, componentType);
            component.setId(id);
            component.setValueBinding("binding", componentBinding);
            this.setProperties(component);
            return component;
        }
        UIComponent component = context.getApplication().createComponent(componentType);
        component.setId(id);
        this.setProperties(component);
        return component;
    }

    private boolean isFacet() {
        return this.getParent() != null && this.getParent() instanceof FacetTag;
    }

    protected boolean isSuppressed() {
        if (this._suppressed == null) {
            if (this.isFacet()) {
                this._suppressed = Boolean.TRUE;
                return true;
            }
            UIComponent component = this.getComponentInstance();
            for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.getRendersChildren()) continue;
                this._suppressed = Boolean.TRUE;
                return true;
            }
            while (component != null) {
                if (!component.isRendered()) {
                    this._suppressed = Boolean.TRUE;
                    return true;
                }
                component = component.getParent();
            }
            this._suppressed = Boolean.FALSE;
        }
        return this._suppressed;
    }

    protected void setProperties(UIComponent component) {
        if (this.getRendererType() != null) {
            component.setRendererType(this.getRendererType());
        }
        if (this._rendered != null) {
            if (UIComponentTag.isValueReference(this._rendered)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(this._rendered);
                component.setValueBinding("rendered", vb);
            } else {
                boolean b = Boolean.valueOf(this._rendered);
                component.setRendered(b);
            }
        }
    }

    protected boolean hasBinding() {
        return this._binding != null;
    }

    private static class UIComponentTagWrapper
    extends UIComponentTag {
        public UIComponentTagWrapper(UIComponentClassicTagBase classicTag) {
            this.setId(classicTag.getId());
            this.setJspId(classicTag.getJspId());
            this.setParent(classicTag.getParent());
        }

        public String getComponentType() {
            return null;
        }

        public String getRendererType() {
            return null;
        }

        protected UIComponent createComponent(FacesContext context, String newId) {
            return null;
        }
    }
}

