/*
 * Decompiled with CFR 0.152.
 */
package su.artix.loyaltylib.convertor.discountsystem;

import java.util.List;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.loyaltylib.convertor.discountsystem.PythonInterpreterFactory;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountSystem;
import su.artix.loyaltylib.domain.java.observable.AbstractDiscountModel;

public class DiscountSystem2Yaml {
    private static final Logger log = LoggerFactory.getLogger(DiscountSystem2Yaml.class);

    private static PyObject convertJavaDiscountObjectToPyDiscountSubTree(AbstractDiscountModel discountModel, String usedFunction) {
        long point = System.currentTimeMillis();
        PythonInterpreter interpreter = PythonInterpreterFactory.resolveInterpreter();
        interpreter.set("jModel", (Object)discountModel);
        interpreter.exec("jInitialGroup = jModel");
        interpreter.exec("import discsystem2json");
        interpreter.exec("pyModel = discsystem2json.%usedFunction%(jInitialGroup, None)".replace("%usedFunction%", usedFunction));
        PyObject pyDiscountModel = interpreter.get("pyModel");
        log.info("convert to python delta={}", (Object)(System.currentTimeMillis() - point));
        PythonInterpreterFactory.releaseInterpreter(interpreter);
        return pyDiscountModel;
    }

    private static String getYamlString(PyObject object) {
        long point = System.currentTimeMillis();
        PythonInterpreter interpreter = PythonInterpreterFactory.resolveInterpreter();
        interpreter.set("toYamlObject", object);
        interpreter.exec("yamlString=yaml.dump(toYamlObject)");
        PyObject yamlDiscountModel = interpreter.get("yamlString");
        log.info("get  yaml string delta={}", (Object)(System.currentTimeMillis() - point));
        PythonInterpreterFactory.releaseInterpreter(interpreter);
        return yamlDiscountModel.asString();
    }

    public static String getPyDiscountObject(List<AbstractDiscountModel> discountModels) throws Exception {
        Class<?> abstractModelType = null;
        PyList pyList = new PyList();
        if (discountModels.size() > 0) {
            abstractModelType = discountModels.get(0).getClass();
        }
        for (AbstractDiscountModel discountModel : discountModels) {
            if (discountModel.getClass().isAssignableFrom(abstractModelType)) {
                if (discountModel.getClass().isAssignableFrom(DiscountSystem.class)) {
                    pyList.append(DiscountSystem2Yaml.convertJavaDiscountObjectToPyDiscountSubTree((AbstractDiscountModel)((DiscountSystem)discountModel).getCampaignGroup(), "createCampaignGroup"));
                    continue;
                }
                if (discountModel.getClass().isAssignableFrom(DiscountCampaign.class)) {
                    pyList.append(DiscountSystem2Yaml.convertJavaDiscountObjectToPyDiscountSubTree(discountModel, "createDiscountCampaign"));
                    continue;
                }
                if (!discountModel.getClass().isAssignableFrom(Discount.class)) continue;
                pyList.append(DiscountSystem2Yaml.convertJavaDiscountObjectToPyDiscountSubTree(discountModel, "createDiscount"));
                continue;
            }
            throw new Exception("Exported elements has different types!");
        }
        return DiscountSystem2Yaml.getYamlString((PyObject)pyList);
    }

    private DiscountSystem2Yaml() {
    }

    public static String getDiscountSystemYaml(DiscountSystem discountSystem) {
        PyObject pySubTree = DiscountSystem2Yaml.getPyDiscountSystemTree(discountSystem);
        String discountSystemYaml = pySubTree != null ? DiscountSystem2Yaml.getYamlString(pySubTree) : "";
        return discountSystemYaml;
    }

    public static String getDiscountSystemYaml(PyObject pySubTree) {
        return DiscountSystem2Yaml.getYamlString(pySubTree);
    }

    public static PyObject getPyDiscountSystemTree(DiscountSystem discountSystem) {
        PyObject pySubTree = null;
        if (discountSystem != null && discountSystem.getCampaignGroup() != null) {
            pySubTree = DiscountSystem2Yaml.convertJavaDiscountObjectToPyDiscountSubTree((AbstractDiscountModel)discountSystem.getCampaignGroup(), "createCampaignGroup");
        }
        return pySubTree;
    }
}

