/*
 * Decompiled with CFR 0.152.
 */
package su.artix.loyaltylib.convertor.discountsystem;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaPythonProxy {
    private static final Logger log = LoggerFactory.getLogger(JavaPythonProxy.class);
    private PyObject pyObject;

    public JavaPythonProxy(PyObject pyObject) {
        this.pyObject = pyObject;
    }

    public String getString(String attr) {
        PyObject objData = this.pyObject.__findattr__(attr);
        if (objData == null || objData.toString().equals("None")) {
            return null;
        }
        if (objData instanceof PyLong) {
            PyLong pyLong = (PyLong)objData;
            return String.valueOf(pyLong.getLong(Long.MIN_VALUE, Long.MAX_VALUE));
        }
        return objData.toString();
    }

    public Date getDate(String attr) {
        PyObject strDate = this.pyObject.__findattr__(attr);
        if (strDate == null || strDate.__str__().toString().equalsIgnoreCase("None")) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return df.parse(strDate.__str__().toString());
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Iterator<PyObject> getIterable(String attr) {
        return this.pyObject.__getattr__(attr).asIterable().iterator();
    }

    public PyObject getObject(String attr) {
        return this.pyObject.__getattr__(attr);
    }

    public PyObject getPyObject() {
        return this.pyObject;
    }

    public void setPyObject(PyObject pyObject) {
        this.pyObject = pyObject;
    }
}

