/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.cashtree.images;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.osgi.framework.Bundle;
import su.artix.cashserver.cashtree.Activator;

public enum ImagesFactory implements ISharedImages
{
    INSTANCE;

    private Map<String, ImageDescriptor> descriptors;
    private ImageRegistry imageRegistry;

    private void declareImages() {
        this.declareImage("group.png", "icons/group.png", true);
        this.declareImage("server.png", "icons/server.png", true);
        this.declareImage("shop.png", "icons/shop.png", true);
        this.declareImage("cash.png", "icons/cash.png", true);
        this.declareImage("delete.png", "icons/delete.png", true);
        this.declareImage("label.png", "icons/label.png", true);
        this.declareImage("property.png", "icons/property.png", true);
        this.declareImage("tag.png", "icons/tag.png", true);
        this.declareImage("tag_type.png", "icons/tag_type.png", true);
        this.declareImage("filter.png", "icons/filter.png", true);
        this.declareImage("category.png", "icons/category.png", true);
    }

    private void initializeImageRegistry() {
        this.imageRegistry = new ImageRegistry();
        this.descriptors = new HashMap<String, ImageDescriptor>();
        this.declareImages();
    }

    private Map<String, ImageDescriptor> getDescriptors() {
        if (this.descriptors == null) {
            this.initializeImageRegistry();
        }
        return this.descriptors;
    }

    public void dispose() {
        if (this.imageRegistry != null) {
            this.imageRegistry.dispose();
            this.imageRegistry = null;
        }
        this.descriptors = null;
    }

    public ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.initializeImageRegistry();
        }
        return this.imageRegistry;
    }

    private void declareImage(String key, String path, boolean shared) {
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(path), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        this.declareImage(key, desc, shared);
    }

    public void declareImage(String symbolicName, ImageDescriptor descriptor, boolean shared) {
        this.getDescriptors().put(symbolicName, descriptor);
        if (shared) {
            this.getImageRegistry().put(symbolicName, descriptor);
        }
    }

    public Image getImage(String symbolicName) {
        Image image = this.getImageRegistry().get(symbolicName);
        if (image == null) {
            ImageDescriptor imageDescriptor = Activator.getImageDescriptor(symbolicName);
            if (imageDescriptor == null) {
                image = this.getImageRegistry().get("IMG_OBJ_ELEMENTS");
            } else {
                this.getImageRegistry().put(symbolicName, imageDescriptor);
                image = this.getImageRegistry().get(symbolicName);
            }
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String symbolicName) {
        return this.getDescriptors().get(symbolicName);
    }
}

