/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageCache {
    private static Map mImageMap = new HashMap();

    public static Image getImage(String fileName) {
        Image image = (Image)mImageMap.get(fileName);
        if (image == null) {
            image = ImageCache.createImage(fileName);
            mImageMap.put(fileName, image);
        }
        return image;
    }

    private static Image createImage(String fileName) {
        ClassLoader classLoader = ImageCache.class.getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(fileName);
        if (stream == null && (stream = classLoader.getResourceAsStream(fileName.substring(1))) == null && (stream = classLoader.getResourceAsStream(fileName)) == null && (stream = classLoader.getResourceAsStream(fileName.substring(1))) == null) {
            return null;
        }
        Image img = new Image((Device)Display.getDefault(), stream);
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return img;
    }

    public static void dispose() {
        Iterator iterator = mImageMap.values().iterator();
        while (iterator.hasNext()) {
            ((Image)iterator.next()).dispose();
        }
    }
}

