/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.controls.actions;

import java.util.Calendar;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.images.ImagesFactory;
import su.artix.discountmanager.trees.CustomSystemTreeViewer;
import su.artix.discountmanager.views.DiscountGanttChartView;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCampaign;

public class PeriodCampaignsFilterAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(PeriodCampaignsFilterAction.class);
    private DateTime beginDateTime;
    private DateTime endDateTime;
    private CustomSystemTreeViewer discountTreeViewer;
    private CampaignPeriodFilter filter;
    private DiscountGanttChartView discountGanttChartView;
    private boolean checked;
    private String activeToolTip;
    private String deactiveToolTip;

    public PeriodCampaignsFilterAction() {
        this.setImageDescriptor(ImagesFactory.INSTANCE.getImageDescriptor("16x16/plane/period.png"));
    }

    public String getActiveToolTip() {
        return this.activeToolTip;
    }

    public void setActiveToolTip(String activeToolTip) {
        this.activeToolTip = activeToolTip;
    }

    public String getDeactiveToolTip() {
        return this.deactiveToolTip;
    }

    public void setDeactiveToolTip(String deactiveToolTip) {
        this.deactiveToolTip = deactiveToolTip;
    }

    public void createFilter(DateTime beginDateTime, DateTime endDateTime) {
        this.beginDateTime = beginDateTime;
        this.endDateTime = endDateTime;
        this.filter = new CampaignPeriodFilter();
        this.beginDateTime.addSelectionListener((SelectionListener)new DateChangedListener());
        this.endDateTime.addSelectionListener((SelectionListener)new DateChangedListener());
    }

    public int getStyle() {
        return 2;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        if (this.discountTreeViewer == null) {
            this.discountTreeViewer = (CustomSystemTreeViewer)ViewHolder.INSTANCE.getActiveViewPart().getSite().getSelectionProvider();
        }
        this.discountGanttChartView = (DiscountGanttChartView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("su.artix.discountmanager.views.DiscountGanttChartView");
        if (this.isChecked()) {
            this.discountTreeViewer.addFilter(this.filter);
            if (this.discountGanttChartView != null) {
                this.discountGanttChartView.getViewPanel().addFilter(this.discountTreeViewer.getJoinedViewID(), this.filter);
            }
            this.setToolTipText(this.deactiveToolTip);
        } else {
            this.discountTreeViewer.removeFilter(this.filter);
            if (this.discountGanttChartView != null) {
                this.discountGanttChartView.getViewPanel().removeFilter(this.discountTreeViewer.getJoinedViewID(), this.filter);
            }
            this.setToolTipText(this.activeToolTip);
        }
        super.setChecked(checked);
    }

    public class CampaignPeriodFilter
    extends ViewerFilter {
        private Calendar createCalendarByFields(int year, int month, int day, int hour, int min, int sec) {
            Calendar ret = Calendar.getInstance();
            ret.clear();
            ret.set(1, year);
            ret.set(2, month);
            ret.set(5, day);
            ret.set(10, hour);
            ret.set(12, min);
            ret.set(13, sec);
            return ret;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            Calendar end;
            if (!(element instanceof DiscountCampaign)) {
                return true;
            }
            Calendar begin = this.getBeginDate();
            return ((DiscountCampaign)element).isActiveBetween(begin, end = this.getEndDate()) == 0;
        }

        public Calendar getBeginDate() {
            return this.createCalendarByFields(PeriodCampaignsFilterAction.this.beginDateTime.getYear(), PeriodCampaignsFilterAction.this.beginDateTime.getMonth(), PeriodCampaignsFilterAction.this.beginDateTime.getDay(), 0, 0, 0);
        }

        public Calendar getEndDate() {
            return this.createCalendarByFields(PeriodCampaignsFilterAction.this.endDateTime.getYear(), PeriodCampaignsFilterAction.this.endDateTime.getMonth(), PeriodCampaignsFilterAction.this.endDateTime.getDay(), 23, 59, 59);
        }
    }

    private class DateChangedListener
    extends SelectionAdapter {
        private DateChangedListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            PeriodCampaignsFilterAction.this.discountTreeViewer.refresh();
            PeriodCampaignsFilterAction.this.discountGanttChartView = (DiscountGanttChartView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("su.artix.discountmanager.views.DiscountGanttChartView");
            if (PeriodCampaignsFilterAction.this.discountGanttChartView != null) {
                PeriodCampaignsFilterAction.this.discountGanttChartView.getViewPanel().refresh();
            }
        }
    }
}

