/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import su.artix.discountmanager.dialogs.SystemTitleAreaDialog;
import su.artix.discountmanager.dialogs.discountsystem.ConditionTemplateConverter;
import su.artix.discountmanager.dialogs.discountsystem.DiscountConditionConstructorDialog;
import su.artix.discountmanager.dialogs.discountsystem.DiscountConditionTemplateFillerDialog;
import su.artix.discountmanager.dialogs.discountsystem.DiscountConditionTemplatePanel;
import su.artix.discountmanager.dialogs.discountsystem.ViewFilledTemplateDialog;
import su.artix.discountmanager.images.ImagesFactory;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCardCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCouponCondition;
import su.artix.yuki.discount.condition.constructor.dao.ConstructorTreeProcessor;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplate;
import su.artix.yuki.discount.condition.domain.xml.ConditionType;
import su.artix.yuki.discount.condition.template.dao.ConditionTemplateDAO;
import su.artix.yuki.editors.DialogMode;

public class DiscountConditionTemplateDialog
extends SystemTitleAreaDialog {
    private static final String TITLE = "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f";
    private static final String TITLE_AREA_TEXT = "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f \u0438\u0437 \u0448\u0430\u0431\u043b\u043e\u043d\u0430";
    private static final String TITLE_AREA_MESSAGE = "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d, \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u0435\u0433\u043e \u0438 \u0434\u043e\u0431\u0430\u0432\u044c\u0442\u0435";
    public static final int EXTENDED_BUTTON_CODE = 3;
    private Discount discount;
    private ConditionTemplateDAO conditionTemplatesDAO;
    private ConstructorTreeProcessor processor;
    private DiscountCondition condition;
    private ConditionTemplate template;
    private Text descriptionTextField;
    private DiscountConditionTemplatePanel panel;
    private Action fillFinalTemplateAction;
    private Action viewFinalFormulaAction;
    private SelectionAdapter gotoExtendedModeAction = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            DiscountConditionConstructorDialog dialog = new DiscountConditionConstructorDialog(DiscountConditionTemplateDialog.this.discount, DiscountConditionTemplateDialog.this.processor, DiscountConditionTemplateDialog.this.conditionTemplatesDAO);
            if (dialog.open() == 0) {
                DiscountConditionTemplateDialog.this.condition = dialog.getDiscountCondition();
                DiscountConditionTemplateDialog.this.okPressed();
            } else {
                DiscountConditionTemplateDialog.this.refresh();
            }
        }
    };

    public DiscountConditionTemplateDialog(Discount discount, ConditionTemplateDAO dao, ConstructorTreeProcessor processor) {
        super(Display.getCurrent().getActiveShell(), DialogMode.CREATE, null);
        this.discount = discount;
        this.conditionTemplatesDAO = dao;
        this.processor = processor;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(TITLE);
        shell.setMinimumSize(420, 450);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.setTitle(TITLE_AREA_TEXT);
        this.setMessage(TITLE_AREA_MESSAGE);
        Composite mainPanel = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(mainPanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainPanel);
        this.panel = new DiscountConditionTemplatePanel(mainPanel, 0, this.discount, this.conditionTemplatesDAO, true);
        this.panel.setTemplateFilled(new Action(){

            public void run() {
                DiscountConditionTemplateDialog.this.condition = DiscountConditionTemplateDialog.this.panel.getDiscountCondition();
                DiscountConditionTemplateDialog.this.template = DiscountConditionTemplateDialog.this.panel.getSelectedTemplate();
                DiscountConditionTemplateDialog.this.descriptionTextField.setText(DiscountConditionTemplateDialog.this.condition.getDescription());
                DiscountConditionTemplateDialog.this.getButton(0).setEnabled(true);
                DiscountConditionTemplateDialog.this.fillFinalTemplateAction.setEnabled(true);
                DiscountConditionTemplateDialog.this.viewFinalFormulaAction.setEnabled(true);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.panel);
        Group viewPanel = new Group(mainPanel, 0);
        viewPanel.setText("\u0418\u0442\u043e\u0433\u043e\u0432\u043e\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u0435:");
        GridLayoutFactory.fillDefaults().margins(2, 2).applyTo((Composite)viewPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)viewPanel);
        ToolBar toolBar = new ToolBar((Composite)viewPanel, 0x820000);
        GridDataFactory.fillDefaults().applyTo((Control)toolBar);
        this.fillFinalTemplateAction = new FillFinalTemplateAction();
        this.fillFinalTemplateAction.setEnabled(false);
        this.viewFinalFormulaAction = new ViewFinalTemplateAction();
        this.viewFinalFormulaAction.setEnabled(false);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        toolBarManager.add((IAction)this.fillFinalTemplateAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.viewFinalFormulaAction);
        toolBarManager.update(true);
        this.descriptionTextField = new Text((Composite)viewPanel, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.descriptionTextField);
        return mainPanel;
    }

    protected void okPressed() {
        if (this.condition != null) {
            for (DiscountCondition currentCondition : this.discount.getDiscountConditions()) {
                if (!currentCondition.equalsWithoutParent((Object)this.condition)) continue;
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430!", (String)"\u0422\u0430\u043a\u043e\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
                return;
            }
        }
        super.okPressed();
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(2).margins(8, 10).applyTo(parent);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, true).applyTo((Control)parent);
        Composite leftPanel = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(leftPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)leftPanel);
        this.createButton(leftPanel, 3, "\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c", false);
        this.getButton(3).addSelectionListener((SelectionListener)this.gotoExtendedModeAction);
        this.getButton(3).setImage(ImagesFactory.INSTANCE.getImage("16x16/shadow/construction.png"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.getButton(3));
        this.createButton(parent, 0, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0443\u0441\u043b\u043e\u0432\u0438\u0435", true).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public DiscountCondition getDiscountCondition() {
        return this.condition;
    }

    public void refresh() {
        this.panel.refresh();
    }

    private class FillFinalTemplateAction
    extends Action {
        public FillFinalTemplateAction() {
            super("&\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c", ImagesFactory.INSTANCE.getImageDescriptor("16x16/shadow/form_green.png"));
        }

        public void run() {
            DiscountConditionTemplateFillerDialog dialog;
            if (DiscountConditionTemplateDialog.this.template != null && (dialog = new DiscountConditionTemplateFillerDialog(DiscountConditionTemplateDialog.this.getShell(), DiscountConditionTemplateDialog.this.template, "\u0417\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f")).open() == 0) {
                if (ConditionType.CARD.equals((Object)DiscountConditionTemplateDialog.this.template.getType())) {
                    DiscountConditionTemplateDialog.this.condition = (DiscountCondition)new DiscountCardCondition();
                } else if (ConditionType.COUPON.equals((Object)DiscountConditionTemplateDialog.this.template.getType())) {
                    DiscountConditionTemplateDialog.this.condition = (DiscountCondition)new DiscountCouponCondition();
                } else {
                    DiscountConditionTemplateDialog.this.condition = new DiscountCondition();
                }
                DiscountConditionTemplateDialog.this.condition.setCondition(dialog.getCondition());
                DiscountConditionTemplateDialog.this.condition.setDescription(dialog.getDescription());
                DiscountConditionTemplateDialog.this.condition.setTemplate(ConditionTemplateConverter.convert(dialog.getTemplate()));
                DiscountConditionTemplateDialog.this.descriptionTextField.setText(DiscountConditionTemplateDialog.this.condition.getDescription());
            }
        }
    }

    private class ViewFinalTemplateAction
    extends Action {
        public ViewFinalTemplateAction() {
            super("&\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c", ImagesFactory.INSTANCE.getImageDescriptor("16x16/shadow/view.png"));
        }

        public void run() {
            ViewFilledTemplateDialog dialog = new ViewFilledTemplateDialog(DiscountConditionTemplateDialog.this.getShell(), DiscountConditionTemplateDialog.this.condition, "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u0443\u0441\u043b\u043e\u0432\u0438\u044f");
            if (dialog.open() == 0) {
                DiscountConditionTemplateDialog.this.condition.setDescription(dialog.getDescription());
                DiscountConditionTemplateDialog.this.descriptionTextField.setText(dialog.getDescription());
            }
        }
    }
}

