/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.handlers.cards;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.domain.Card;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.discountmanager.handlers.cards.ConfirmDialog;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.yuki.action.DirectoryRemoveAction;
import su.artix.yuki.model.ModelActivator;

public class DeleteCardAction
extends DirectoryRemoveAction<Card> {
    private static final Logger log = LoggerFactory.getLogger(DeleteCardAction.class);
    private boolean ask;
    private boolean delete;
    private boolean cancel;

    public DeleteCardAction() {
        super(Card.class);
    }

    public void run() {
        this.ask = true;
        this.delete = false;
        this.cancel = false;
        ISelection selection = this.window.getSelectionService().getSelection();
        log.trace("selection {}", (Object)selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            try {
                if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", (String)"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043a\u0430\u0440\u0442\u044b?")) {
                    for (Object obj : structuredSelection.toList()) {
                        if (this.cancel) break;
                        Card card = (Card)obj;
                        if (card.getClient() != null) {
                            if (this.ask) {
                                this.confirmClientedCard(card);
                                continue;
                            }
                            if (!this.delete) continue;
                            this.delete(card);
                            continue;
                        }
                        this.delete(card);
                    }
                }
                ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.getClazz()).doRefresh();
            }
            catch (ExecuteQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
                ErrorMessageFactory.exceptionMessage(e);
            }
        }
    }

    private void confirmClientedCard(Card card) throws ExecuteQueryException {
        ConfirmDialog messageBox = new ConfirmDialog(Display.getCurrent().getActiveShell(), "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435!", null, "\u041a\u0430\u0440\u0442\u0430 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c " + card.getNumber() + " \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u0430 \u043a \u043a\u043b\u0438\u0435\u043d\u0442\u0443 " + card.getClient().getName() + ". \u0423\u0434\u0430\u043b\u0438\u0442\u044c?", 0, new String[0], 1);
        int rc = messageBox.open();
        switch (rc) {
            case 2: {
                this.delete(card);
                break;
            }
            case 4: {
                this.delete(card);
                this.ask = false;
                this.delete = true;
                break;
            }
            case 21: {
                this.ask = false;
                this.delete = false;
                break;
            }
            case 1: {
                this.cancel = true;
            }
        }
    }

    private void delete(Card card) throws ExecuteQueryException {
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(Card.class).delete((Object)card);
    }
}

