/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.providers.accounting;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.accounting.domain.Asset;
import su.artix.accounting.domain.AssetTransactionStatus;
import su.artix.accounting.rpc.logic.LocationNotFound;
import su.artix.discountmanager.Activator;
import su.artix.discountmanagercore.dao.accounting.AccountingDAO;

public class AccountingContentProvider
implements ILazyTreeContentProvider {
    private static final Logger log = LoggerFactory.getLogger(AccountingContentProvider.class);
    private List<Asset> list = Collections.emptyList();
    private TreeViewer viewer;
    private boolean loadData = false;

    public AccountingContentProvider(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void dispose() {
        this.list = Collections.emptyList();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private List<?> readList(Object inputElement) {
        if (!this.loadData) {
            return Collections.emptyList();
        }
        try {
            if (this.list.isEmpty()) {
                this.list = Activator.getDefault().getBeanByClass(AccountingDAO.class).getAssets(inputElement.toString());
            }
        }
        catch (LocationNotFound e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (this.list == null) {
            this.list = Collections.emptyList();
        }
        BeanComparator dateComparator = new BeanComparator("date");
        Collections.sort(this.list, new ReverseComparator((Comparator)dateComparator));
        return this.list;
    }

    public Object getParent(Object arg0) {
        return null;
    }

    public void updateElement(Object parent, int index) {
        if (!this.loadData) {
            return;
        }
        Object element = parent instanceof Asset ? ((Asset)parent).getTransactionStatuses().get(index) : this.readList(parent).get(index);
        this.viewer.replace(parent, index, element);
        this.updateChildCount(element, -1);
    }

    public void updateChildCount(Object element, int currentChildCount) {
        List transactionStatuses;
        if (!this.loadData) {
            return;
        }
        int length = 0;
        length = element instanceof Asset ? ((transactionStatuses = ((Asset)element).getTransactionStatuses()) == null ? 0 : transactionStatuses.size()) : (element instanceof AssetTransactionStatus ? 0 : this.readList(element).size());
        this.viewer.setChildCount(element, length);
    }

    public void setLoadData() {
        this.loadData = true;
    }
}

