/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client.entities;

import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import su.artix.cashserver.core.cashregistry.domain.ShopGroupLabel;
import su.artix.cashserver.rest.client.RestInvoker;
import su.artix.cashserver.rest.client.RestInvokerManager;

public class ShopGroupLabelsRestClient {
    private static final String SHOP_GROUP_LABEL_URL = "shopGroupLabels";
    private final RestInvokerManager restInvokerManager;

    public ShopGroupLabelsRestClient(RestInvokerManager restInvokerManager) {
        this.restInvokerManager = restInvokerManager;
    }

    public Long countShopGroupLabel() {
        return this.restInvokerManager.getRestInvoker().invokeGet("shopGroupLabels/count", Long.class);
    }

    public Boolean existsShopGroupLabel(String id) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("shopGroupLabels/{0}/exists", id), Boolean.class);
    }

    public List<ShopGroupLabel> getShopGroupLabels() {
        ParameterizedTypeReference<List<ShopGroupLabel>> returnTypeRef = new ParameterizedTypeReference<List<ShopGroupLabel>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(SHOP_GROUP_LABEL_URL, returnTypeRef);
    }

    public List<ShopGroupLabel> getShopGroupLabels(int page, int size) {
        ParameterizedTypeReference<List<ShopGroupLabel>> returnTypeRef = new ParameterizedTypeReference<List<ShopGroupLabel>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet("shopGroupLabels?page=" + page + "&size=" + size, returnTypeRef);
    }

    public List<ShopGroupLabel> getShopGroupLabels(String clusterId) {
        ParameterizedTypeReference<List<ShopGroupLabel>> returnTypeRef = new ParameterizedTypeReference<List<ShopGroupLabel>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("shopGroupLabels?clusterId={0}", clusterId), returnTypeRef);
    }

    public ShopGroupLabel getShopGroupLabel(String shopGroupLabel) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("shopGroupLabels/{0}", shopGroupLabel), ShopGroupLabel.class);
    }

    public long countNotSystem() {
        return this.restInvokerManager.getRestInvoker().invokeGet("shopGroupLabels/count?withSystemGroups=false", Long.class);
    }

    public List<ShopGroupLabel> findNotSystem() {
        ParameterizedTypeReference<List<ShopGroupLabel>> returnTypeRef = new ParameterizedTypeReference<List<ShopGroupLabel>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet("shopGroupLabels?withSystemGroups=false", returnTypeRef);
    }
}

