/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import com.sun.org.apache.xml.internal.security.utils.I18n;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Init {
    public static final String CONF_NS = "http://www.xmlsecurity.org/NS/#configuration";
    private static final Logger LOG = LoggerFactory.getLogger(Init.class);
    private static boolean alreadyInitialized = false;

    public static final synchronized boolean isInitialized() {
        return alreadyInitialized;
    }

    public static synchronized void init() {
        if (alreadyInitialized) {
            return;
        }
        InputStream inputStream = AccessController.doPrivileged(() -> {
            String string = System.getProperty("com.sun.org.apache.xml.internal.security.resource.config");
            if (string == null) {
                return null;
            }
            return Init.class.getResourceAsStream(string);
        });
        if (inputStream == null) {
            Init.dynamicInit();
        } else {
            Init.fileInit(inputStream);
        }
        alreadyInitialized = true;
    }

    private static void dynamicInit() {
        I18n.init("en", "US");
        LOG.debug("Registering default algorithms");
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws XMLSecurityException {
                    ElementProxy.registerDefaultPrefixes();
                    Transform.registerDefaultAlgorithms();
                    SignatureAlgorithm.registerDefaultAlgorithms();
                    JCEMapper.registerDefaultAlgorithms();
                    Canonicalizer.registerDefaultAlgorithms();
                    ResourceResolver.registerDefaultResolvers();
                    KeyResolver.registerDefaultResolvers();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            XMLSecurityException xMLSecurityException = (XMLSecurityException)privilegedActionException.getException();
            LOG.error(xMLSecurityException.getMessage(), xMLSecurityException);
            xMLSecurityException.printStackTrace();
        }
    }

    /*
     * Could not resolve type clashes
     */
    private static void fileInit(InputStream inputStream) {
        try {
            Node node;
            Document document = XMLUtils.read(inputStream, false);
            for (node = document.getFirstChild(); node != null && !"Configuration".equals(node.getLocalName()); node = node.getNextSibling()) {
            }
            if (node == null) {
                LOG.error("Error in reading configuration file - Configuration element not found");
                return;
            }
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                Object[] objectArray;
                String string;
                Object object6;
                Object object2;
                Object object3;
                if (1 != node2.getNodeType()) continue;
                String string2 = node2.getLocalName();
                if ("ResourceBundles".equals(string2)) {
                    object3 = (Element[])node2;
                    object2 = object3.getAttributeNodeNS(null, "defaultLanguageCode");
                    Object object4 = object3.getAttributeNodeNS(null, "defaultCountryCode");
                    String string3 = object2 == null ? null : object2.getNodeValue();
                    Object object5 = object4 == null ? null : object4.getNodeValue();
                    I18n.init(string3, (String)object5);
                }
                if ("CanonicalizationMethods".equals(string2)) {
                    for (Object object5 : object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "CanonicalizationMethod")) {
                        object6 = object5.getAttributeNS(null, "URI");
                        string = object5.getAttributeNS(null, "JAVACLASS");
                        try {
                            Canonicalizer.register((String)object6, string);
                            LOG.debug("Canonicalizer.register({}, {})", object6, string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            objectArray = new Object[]{object6, string};
                            LOG.error(I18n.translate("algorithm.classDoesNotExist", objectArray));
                        }
                    }
                }
                if ("TransformAlgorithms".equals(string2)) {
                    for (Object object5 : object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "TransformAlgorithm")) {
                        object6 = object5.getAttributeNS(null, "URI");
                        string = object5.getAttributeNS(null, "JAVACLASS");
                        try {
                            Transform.register((String)object6, string);
                            LOG.debug("Transform.register({}, {})", object6, string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            objectArray = new Object[]{object6, string};
                            LOG.error(I18n.translate("algorithm.classDoesNotExist", objectArray));
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            LOG.warn("Not able to found dependencies for algorithm, I'll keep working.");
                        }
                    }
                }
                if ("JCEAlgorithmMappings".equals(string2) && (object3 = ((Element)node2).getElementsByTagName("Algorithms").item(0)) != null) {
                    object2 = XMLUtils.selectNodes(object3.getFirstChild(), CONF_NS, "Algorithm");
                    for (Object object6 : object2) {
                        string = object6.getAttributeNS(null, "URI");
                        JCEMapper.register(string, new JCEMapper.Algorithm((Element)object6));
                    }
                }
                if ("SignatureAlgorithms".equals(string2)) {
                    for (Object object5 : object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "SignatureAlgorithm")) {
                        object6 = object5.getAttributeNS(null, "URI");
                        string = object5.getAttributeNS(null, "JAVACLASS");
                        try {
                            SignatureAlgorithm.register((String)object6, string);
                            LOG.debug("SignatureAlgorithm.register({}, {})", object6, string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            objectArray = new Object[]{object6, string};
                            LOG.error(I18n.translate("algorithm.classDoesNotExist", objectArray));
                        }
                    }
                }
                if ("ResourceResolvers".equals(string2)) {
                    for (Object object5 : object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "Resolver")) {
                        object6 = object5.getAttributeNS(null, "JAVACLASS");
                        string = object5.getAttributeNS(null, "DESCRIPTION");
                        if (string != null && string.length() > 0) {
                            LOG.debug("Register Resolver: {}: {}", object6, string);
                        } else {
                            LOG.debug("Register Resolver: {}: For unknown purposes", object6);
                        }
                        try {
                            ResourceResolver.register((String)object6);
                        }
                        catch (Throwable throwable) {
                            LOG.warn("Cannot register:" + (String)object6 + " perhaps some needed jars are not installed", throwable);
                        }
                    }
                }
                if ("KeyResolver".equals(string2)) {
                    object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "Resolver");
                    object2 = new ArrayList(((Object)object3).length);
                    for (Object object6 : object3) {
                        string = object6.getAttributeNS(null, "JAVACLASS");
                        String string4 = object6.getAttributeNS(null, "DESCRIPTION");
                        if (string4 != null && string4.length() > 0) {
                            LOG.debug("Register Resolver: {}: {}", string, string4);
                        } else {
                            LOG.debug("Register Resolver: {}: For unknown purposes", string);
                        }
                        object2.add(string);
                    }
                    KeyResolver.registerClassNames((List<String>)object2);
                }
                if (!"PrefixMappings".equals(string2)) continue;
                LOG.debug("Now I try to bind prefixes:");
                for (Object object5 : object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "PrefixMapping")) {
                    object6 = object5.getAttributeNS(null, "namespace");
                    string = object5.getAttributeNS(null, "prefix");
                    LOG.debug("Now I try to bind {} to {}", string, object6);
                    ElementProxy.setDefaultPrefix((String)object6, string);
                }
            }
        }
        catch (Exception exception) {
            LOG.error("Bad: ", exception);
        }
    }
}

