/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;

public abstract class ResolutionSyntax
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2706743076526672017L;
    private int crossFeedResolution;
    private int feedResolution;
    public static final int DPI = 100;
    public static final int DPCM = 254;

    public ResolutionSyntax(int n, int n2, int n3) {
        if (n < 1) {
            throw new IllegalArgumentException("crossFeedResolution is < 1");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("feedResolution is < 1");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("units is < 1");
        }
        this.crossFeedResolution = n * n3;
        this.feedResolution = n2 * n3;
    }

    private static int convertFromDphi(int n, int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException(": units is < 1");
        }
        int n3 = n2 / 2;
        return (n + n3) / n2;
    }

    public int[] getResolution(int n) {
        return new int[]{this.getCrossFeedResolution(n), this.getFeedResolution(n)};
    }

    public int getCrossFeedResolution(int n) {
        return ResolutionSyntax.convertFromDphi(this.crossFeedResolution, n);
    }

    public int getFeedResolution(int n) {
        return ResolutionSyntax.convertFromDphi(this.feedResolution, n);
    }

    public String toString(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCrossFeedResolution(n));
        stringBuffer.append('x');
        stringBuffer.append(this.getFeedResolution(n));
        if (string != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public boolean lessThanOrEquals(ResolutionSyntax resolutionSyntax) {
        return this.crossFeedResolution <= resolutionSyntax.crossFeedResolution && this.feedResolution <= resolutionSyntax.feedResolution;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof ResolutionSyntax && this.crossFeedResolution == ((ResolutionSyntax)object).crossFeedResolution && this.feedResolution == ((ResolutionSyntax)object).feedResolution;
    }

    public int hashCode() {
        return this.crossFeedResolution & 0xFFFF | (this.feedResolution & 0xFFFF) << 16;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.crossFeedResolution);
        stringBuffer.append('x');
        stringBuffer.append(this.feedResolution);
        stringBuffer.append(" dphi");
        return stringBuffer.toString();
    }

    protected int getCrossFeedResolutionDphi() {
        return this.crossFeedResolution;
    }

    protected int getFeedResolutionDphi() {
        return this.feedResolution;
    }
}

