/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.expression.DefaultResolver;
import org.apache.commons.beanutils.expression.Resolver;
import org.apache.commons.lang.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActualClassResolver {
    private static final Logger log = LoggerFactory.getLogger(ActualClassResolver.class);
    private static Resolver resolver = new DefaultResolver();
    private Map<Class<?>, Class<?>> actualClassMap = new ConcurrentHashMap();
    private Map<Class<?>, Class<?>> baseClassMap = new ConcurrentHashMap();

    public void putActual(Class<?> base, Class<?> actual) {
        this.actualClassMap.put(base, actual);
        this.baseClassMap.put(actual, base);
    }

    public boolean isDatabaseClass(Class<?> cl) {
        return this.actualClassMap.containsKey(cl) || this.actualClassMap.containsValue(cl);
    }

    public <E> Class<E> getActual(Class<E> base) {
        Class<Object> cl = this.actualClassMap.get(base);
        if (cl == null) {
            cl = base;
        }
        return cl;
    }

    public <E> E getInstance(Class<E> base) {
        try {
            Class<E> actual = this.getActual(base);
            Constructor<E> constructor = actual.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Class<?> getBase(Class<?> actual) {
        Class<?> cl = this.baseClassMap.get(actual);
        if (cl == null) {
            cl = actual;
        }
        return cl;
    }

    public boolean isValidProperty(Class<?> pojoClass, String columnProperty) {
        Class<?> actualClass = this.getActual(pojoClass);
        if (!resolver.hasNested(columnProperty)) {
            return this.getResult(columnProperty, actualClass);
        }
        String nested = resolver.next(columnProperty);
        Field field = FieldUtils.getField(actualClass, (String)nested, (boolean)true);
        if (field != null) {
            Class<?> nestedClass = field.getType();
            String sub = resolver.remove(columnProperty);
            return this.getResult(sub, nestedClass);
        }
        log.error("property:{} for class:{} not found", (Object)columnProperty, actualClass);
        return false;
    }

    private boolean getResult(String columnProperty, Class<?> actualClass) {
        Field field = FieldUtils.getField(actualClass, (String)columnProperty, (boolean)true);
        if (field == null) {
            log.error("property:{} for class:{} not found", (Object)columnProperty, actualClass);
            return false;
        }
        return true;
    }
}

