/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain.advanced;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.dao.DaoFactory;
import ru.ssa.cashadmin.dao.SessionManager;
import ru.ssa.cashadmin.domain.Actionparameter;
import ru.ssa.cashadmin.domain.Cmaction;
import ru.ssa.cashadmin.domain.advanced.HierarchicalMenuAbstract;
import ru.ssa.cashadmin.excep.ExecuteQueryException;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class HierarchicalMenuItem
extends HierarchicalMenuAbstract {
    private static final Logger log = LoggerFactory.getLogger(HierarchicalMenuItem.class);
    private static final long serialVersionUID = 1L;
    @XmlIDREF
    @XmlElement
    private HierarchicalMenuItem parent;
    @XmlID
    @XmlElement
    @NotEmpty
    private String name;
    @XmlElement
    @NotEmpty
    private Integer order;
    @XmlElement
    private List<HierarchicalMenuItem> menues = new ArrayList<HierarchicalMenuItem>();
    @XmlElement
    private List<HierarchicalMenuItem> actions = new ArrayList<HierarchicalMenuItem>();

    public HierarchicalMenuItem() {
        this.name = "";
        this.order = 1;
    }

    public HierarchicalMenuItem(String name, Integer order) {
        this.name = name;
        this.order = order;
    }

    public List<HierarchicalMenuItem> getMenues() {
        return this.menues;
    }

    public void setMenues(List<HierarchicalMenuItem> menues) {
        this.menues = menues;
    }

    public List<HierarchicalMenuItem> getActions() {
        return this.actions;
    }

    public void setActions(List<HierarchicalMenuItem> actions) {
        this.actions = actions;
    }

    public HierarchicalMenuItem getParent() {
        return this.parent;
    }

    public void setParent(HierarchicalMenuItem parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public List<Actionparameter> getActionParameters() {
        SessionManager.flushSession(Cmaction.class);
        SessionManager.openSession(Cmaction.class);
        List<Actionparameter> actionparameters = new ArrayList<Actionparameter>();
        try {
            if (this.getCmaction().getCmactioncode() != null) {
                Cmaction cmaction = DaoFactory.getDAO(Cmaction.class).refresh(this.getCmaction());
                actionparameters = cmaction.getActionparameterCollection();
            }
        }
        catch (ExecuteQueryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        SessionManager.closeSession(Cmaction.class);
        return actionparameters;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HierarchicalMenuItem [parent=");
        builder.append(this.parent);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", order=");
        builder.append(this.order);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }
}

