/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.cashadmin.domain.payment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import ru.ssa.cashadmin.domain.payment.Category;

@Entity
@Table(name="agent")
@MappedSuperclass
public class Agent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @NotNull
    private String code;
    @Length(max=255, min=1)
    private String name;
    @Length(max=100)
    private String inn;
    @Length(max=100)
    private String phone;
    @Length(max=100)
    private String address;
    @Transient
    @NotNull
    private Integer type;
    @OneToMany(mappedBy="agentcode")
    private List<Category> categories = new ArrayList<Category>();

    protected Agent() {
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInn() {
        return this.inn;
    }

    public void setInn(String inn) {
        this.inn = inn;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setType(Integer type) {
        this.type = type;
        if (type == 1) {
            this.setName("payingAgent");
        } else if (type == 2) {
            this.setName("receivePaymentsOperator");
        } else if ("payingAgent".equalsIgnoreCase(this.getName()) || "receivePaymentsOperator".equalsIgnoreCase(this.getName())) {
            this.setName("");
        }
    }

    public Integer getType() {
        if (this.name == null) {
            return null;
        }
        if ("payingAgent".equalsIgnoreCase(this.name)) {
            return 1;
        }
        if ("receivePaymentsOperator".equalsIgnoreCase(this.name)) {
            return 2;
        }
        return 0;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Agent other = (Agent)obj;
        return !(this.code == null ? other.code != null : !this.code.equals(other.code));
    }

    public String toString() {
        return "Agent [code=" + this.code + ", name=" + this.name + "]";
    }
}

