/*
 * Decompiled with CFR 0.152.
 */
package su.artix.artixadmin.connection;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.remoting.httpinvoker.SimpleHttpInvokerRequestExecutor;
import org.springframework.remoting.support.RemoteInvocationResult;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.artixadmin.connection.ManagedHost;

public class CashserverHttpInvokerRequestExecutor
extends SimpleHttpInvokerRequestExecutor
implements ManagedHost {
    private static final Logger log = LoggerFactory.getLogger(CashserverHttpInvokerRequestExecutor.class);
    private Map<Object, String> resolvedHosts = new HashMap<Object, String>();
    private Map<Object, String> resolvedPorts = new HashMap<Object, String>();

    protected Object determineCurrentLookupKey() {
        return ArtixAdminContextHolder.getConnectionId();
    }

    @Override
    public void put(Object id, String host, String port) {
        log.trace("put host with id={}, host={}, port={}", new Object[]{id, host, port});
        if (this.resolvedHosts.containsKey(id)) {
            log.trace("id:{} already in map", id);
        }
        Object lookupKey = this.resolveSpecifiedLookupKey(id);
        this.resolvedHosts.put(lookupKey, host);
        this.resolvedPorts.put(lookupKey, port);
    }

    protected RemoteInvocationResult doExecuteRequest(final HttpInvokerClientConfiguration config, ByteArrayOutputStream baos) throws IOException, ClassNotFoundException {
        HttpInvokerClientConfiguration configuration = new HttpInvokerClientConfiguration(){

            public String getServiceUrl() {
                try {
                    return config.getServiceUrl().replaceFirst("%host%", CashserverHttpInvokerRequestExecutor.this.getHost()).replaceFirst("%port%", CashserverHttpInvokerRequestExecutor.this.getPort());
                }
                catch (NullPointerException nullPointerException) {
                    log.error("NPE on make service url");
                    return "";
                }
            }

            public String getCodebaseUrl() {
                return null;
            }
        };
        HttpURLConnection con = this.openConnection(configuration);
        log.trace("ConnectionHost: {}", (Object)con.getURL().getHost());
        this.prepareConnection(con, baos.size());
        this.writeRequestBody(configuration, con, baos);
        this.validateResponse(configuration, con);
        InputStream responseBody = this.readResponseBody(configuration, con);
        return this.readRemoteInvocationResult(responseBody, configuration.getCodebaseUrl());
    }

    protected Object resolveSpecifiedLookupKey(Object lookupKey) {
        return lookupKey;
    }

    private String getHost() {
        Object lookupKey = this.determineCurrentLookupKey();
        return this.resolvedHosts.get(lookupKey);
    }

    private String getPort() {
        Object lookupKey = this.determineCurrentLookupKey();
        return this.resolvedPorts.get(lookupKey);
    }
}

