/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.security;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.reflect.FieldUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.ActionGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.cashserver.security.SecurityKey;

public class ControlUtils {
    private static final Logger log = LoggerFactory.getLogger(ControlUtils.class);

    public List<SecurityElement> getControls(String prefix, Class<?> clazz, Object element) {
        ArrayList<SecurityElement> controls = new ArrayList<SecurityElement>();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            this.workWithFieldOfSuperClass(f, prefix, clazz, element, controls);
            ++n2;
        }
        return controls;
    }

    private static boolean isValidObject(Object obj) {
        return obj instanceof Control || obj instanceof ComboViewer || obj instanceof IAction;
    }

    public List<SecurityElement> getControlsOfSuperclass(String prefix, Class<?> clazz, Object element) {
        Field f;
        ArrayList<SecurityElement> controls = new ArrayList<SecurityElement>();
        Field[] fieldArray = clazz.getSuperclass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            f = fieldArray[n2];
            this.workWithFieldOfSuperClass(f, prefix, clazz, element, controls);
            ++n2;
        }
        fieldArray = clazz.getSuperclass().getSuperclass().getDeclaredFields();
        n = fieldArray.length;
        n2 = 0;
        while (n2 < n) {
            f = fieldArray[n2];
            this.workWithFieldOfSuperClass(f, prefix, clazz, element, controls);
            ++n2;
        }
        return controls;
    }

    private void workWithFieldOfSuperClass(Field f, String prefix, Class<?> clazz, Object element, List<SecurityElement> controls) {
        f.setAccessible(true);
        Object obj = null;
        try {
            obj = f.get(element);
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (obj != null && ControlUtils.isValidObject(obj)) {
            String fieldId = this.createFieldSecurityObject(prefix, clazz, f);
            controls.add(new SecurityElement(fieldId, obj, this.getElementType(obj)));
        }
    }

    private String createFieldSecurityObject(String prefix, Class<?> clazz, Field f) {
        SecurityKey ann;
        String annId;
        prefix = prefix.isEmpty() ? "" : String.valueOf(prefix) + ".";
        String className = clazz.getName();
        if (clazz.isAssignableFrom(ActionGroup.class)) {
            className = "su.artix.yuki.action.DirectoryExportActionGroup";
        }
        String id = String.valueOf(prefix) + className + "." + f.getName();
        if (f.isAnnotationPresent(SecurityKey.class) && (annId = (ann = f.getAnnotation(SecurityKey.class)).id()) != null && !annId.isEmpty()) {
            id = String.valueOf(prefix) + className + "." + annId;
        }
        return id;
    }

    private SecurityElementType getElementType(Object obj) {
        if (obj instanceof IAction) {
            return SecurityElementType.ACTION;
        }
        return SecurityElementType.CONTROL;
    }

    public List<SecurityElement> getPanel(String prefix, Class<?> clazz, Object element) {
        Field field = FieldUtils.getField(clazz, (String)"viewPanel", (boolean)true);
        ArrayList<SecurityElement> controls = new ArrayList<SecurityElement>();
        Object obj = null;
        try {
            obj = field.get(element);
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (obj != null && ControlUtils.isValidObject(obj)) {
            String fieldId = this.createFieldSecurityObject(prefix, clazz, field);
            controls.add(new SecurityElement(fieldId, obj, this.getElementType(obj)));
        }
        return controls;
    }

    public static class SecurityElement {
        private String id;
        private Object value;
        private SecurityElementType elementType;

        public SecurityElement(String id, Object value, SecurityElementType elementType) {
            this.id = id;
            this.value = value;
            this.elementType = elementType;
        }

        public String getId() {
            return this.id;
        }

        public Object getValue() {
            return this.value;
        }

        public SecurityElementType getElementType() {
            return this.elementType;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SecurityElement [id=");
            builder.append(this.id);
            builder.append(", elementType=");
            builder.append((Object)this.elementType);
            builder.append("]");
            return builder.toString();
        }
    }

    public static enum SecurityElementType {
        CONTROL,
        ACTION;

    }
}

