/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.cashtree.model.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import su.artix.cashserver.cashtree.domain.Category;
import su.artix.cashserver.cashtree.domain.Group;
import su.artix.cashserver.cashtree.domain.MiddleServer;
import su.artix.cashserver.cashtree.domain.Node;
import su.artix.cashserver.cashtree.domain.Shop;
import su.artix.cashserver.cashtree.domain.converter.DomainConverter;
import su.artix.cashserver.cashtree.model.AbstractTreeModel;
import su.artix.cashserver.rest.client.IClientGetter;
import su.artix.cashserver.rest.domain.GroupInfo;
import su.artix.cashserver.rest.legacy.domain.ShopInfo;

public class TreeModelRest
extends AbstractTreeModel {
    private static final Logger log = LoggerFactory.getLogger(TreeModelRest.class);
    @Autowired
    private IClientGetter clientGetter;
    @Autowired
    private DomainConverter domainConverter;

    public List<Node> getRoots(String clusterId) {
        ArrayList<Node> roots = new ArrayList<Node>();
        roots.addAll(this.getRootGroups(clusterId));
        roots.addAll(this.getRootShops(clusterId));
        return roots;
    }

    public List<Group> getRootGroups(String clusterId) {
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            for (GroupInfo info : this.clientGetter.getClient().getGroupEntity().getRootGroups()) {
                if (!StringUtils.isEmpty((String)clusterId) && !StringUtils.isEmpty((String)info.getClusterId()) && !clusterId.equals(info.getClusterId())) continue;
                groups.add((Group)this.domainConverter.convert((Object)info, Group.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return groups;
    }

    public List<Shop> getRootShops(String clusterId) {
        ArrayList<Shop> shops = new ArrayList<Shop>();
        try {
            for (ShopInfo info : this.clientGetter.getClient().getShopsLegacyEntity().getShopInfosList()) {
                if (!StringUtils.isEmpty((String)info.getParentGroup()) || !StringUtils.isEmpty((String)clusterId) && !clusterId.equals(info.getClusterId())) continue;
                shops.add((Shop)this.domainConverter.convert((Object)info, Shop.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return shops;
    }

    public List<Group> getGroups() {
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            for (GroupInfo info : this.clientGetter.getClient().getGroupEntity().getGroups()) {
                groups.add((Group)this.domainConverter.convert((Object)info, Group.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return groups;
    }

    public List<MiddleServer> getMiddleServers() {
        return Collections.emptyList();
    }

    public List<Shop> getShops() {
        ArrayList<Shop> shops = new ArrayList<Shop>();
        try {
            for (ShopInfo info : this.clientGetter.getClient().getShopsLegacyEntity().getShopInfosList()) {
                shops.add((Shop)this.domainConverter.convert((Object)info, Shop.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return shops;
    }

    public List<Group> getGroupsByParentCode(String clusterId, String code) {
        if (StringUtils.isEmpty((String)code)) {
            return Collections.emptyList();
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            for (GroupInfo info : this.clientGetter.getClient().getGroupEntity().getGroupsByGroupCode(code)) {
                if (!StringUtils.isEmpty((String)clusterId) && !clusterId.equals(info.getClusterId())) continue;
                groups.add((Group)this.domainConverter.convert((Object)info, Group.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return groups;
    }

    public List<MiddleServer> getMiddleServersByParentCode(String clusterId, String code) {
        return Collections.emptyList();
    }

    public List<Shop> getShopsByParentCode(String clusterId, String code) {
        if (StringUtils.isEmpty((String)code)) {
            return Collections.emptyList();
        }
        ArrayList<Shop> shops = new ArrayList<Shop>();
        try {
            for (ShopInfo info : this.clientGetter.getClient().getShopsLegacyEntity().getShopsByGroupCode(code)) {
                if (!StringUtils.isEmpty((String)clusterId) && !clusterId.equals(info.getClusterId())) continue;
                shops.add((Shop)this.domainConverter.convert((Object)info, Shop.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return shops;
    }

    public List<Category> getCategoriesByParentCode(String clusterId, String code) {
        return Collections.emptyList();
    }
}

