/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class ColorCache {
    public static final RGB BLACK = new RGB(0, 0, 0);
    public static final RGB WHITE = new RGB(255, 255, 255);
    private static Map _cache;
    private static ColorCache _instance;

    public static void disposeAll() {
        _instance.dispose();
    }

    public static void disposeCachedColor() {
        Iterator iterator = _cache.values().iterator();
        while (iterator.hasNext()) {
            ((Color)iterator.next()).dispose();
        }
        _cache.clear();
    }

    private ColorCache() {
        if (_cache == null) {
            _cache = new HashMap();
        }
    }

    private static void checkInstance() {
        if (_instance == null) {
            _instance = new ColorCache();
        }
    }

    private void dispose() {
        ColorCache.checkInstance();
        Iterator iterator = _cache.values().iterator();
        while (iterator.hasNext()) {
            ((Color)iterator.next()).dispose();
        }
        _cache.clear();
    }

    public static Color getWhite() {
        ColorCache.checkInstance();
        return ColorCache.getColor(WHITE);
    }

    public static Color getBlack() {
        ColorCache.checkInstance();
        return ColorCache.getColor(BLACK);
    }

    public static Color getColor(RGB rgb) {
        ColorCache.checkInstance();
        Color color = (Color)_cache.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            _cache.put(rgb, color);
        }
        return color;
    }

    public static Color getColor(int red, int green, int blue) {
        ColorCache.checkInstance();
        return ColorCache.getColor(new RGB(red, green, blue));
    }

    public static Color getRandomColor() {
        ColorCache.checkInstance();
        Random rand = new Random();
        int red = rand.nextInt(255);
        int green = rand.nextInt(255);
        int blue = rand.nextInt(255);
        return ColorCache.getColor(red, green, blue);
    }
}

