/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import org.eclipse.nebula.widgets.ganttchart.GanttChart;
import org.eclipse.nebula.widgets.ganttchart.ISettings;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class GanttHeaderSpacedLayout
extends Layout {
    private int _ganttHeaderSize;
    private boolean _calculated;
    private GanttChart _ganttChart;
    private int _maxY;
    private int _maxX;

    public GanttHeaderSpacedLayout() {
    }

    public GanttHeaderSpacedLayout(GanttChart chart) {
        this();
        this._ganttChart = chart;
    }

    public void setGanttChart(GanttChart chart) {
        this._ganttChart = chart;
    }

    private void recalculate(Composite composite) {
        Control[] children = composite.getChildren();
        if (children == null || children.length == 0) {
            return;
        }
        if (this._ganttChart == null) {
            return;
        }
        int widgetHeaderHeight = 0;
        int borderHeight = 0;
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            Point wantedSize = child.computeSize(-1, -1);
            this._maxY += wantedSize.y;
            this._maxX = Math.max(this._maxX, wantedSize.x);
            if (child instanceof Tree) {
                widgetHeaderHeight = ((Tree)child).getHeaderHeight();
                borderHeight = ((Tree)child).getBorderWidth();
                continue;
            }
            if (!(child instanceof Table)) continue;
            widgetHeaderHeight = ((Table)child).getHeaderHeight();
            borderHeight = ((Table)child).getBorderWidth();
        }
        ISettings settings = this._ganttChart.getSettings();
        this._ganttHeaderSize = settings.drawHeader() ? settings.getHeaderDayHeight() + settings.getHeaderMonthHeight() + settings.getEventsTopSpacer() - widgetHeaderHeight - borderHeight : 0;
        this._calculated = true;
    }

    protected Point computeSize(Composite composite, int hint, int hint2, boolean flushCache) {
        if (flushCache || !this._calculated) {
            this.recalculate(composite);
        }
        this.layout(composite, false);
        return new Point(this._maxX, this._maxY);
    }

    protected void layout(Composite composite, boolean flushCache) {
        if (flushCache || !this._calculated) {
            this.recalculate(composite);
        }
        Control[] children = composite.getChildren();
        Rectangle bounds = composite.getClientArea();
        int y = this._ganttHeaderSize;
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            Point wantedSize = child.computeSize(-1, -1);
            child.setLocation(0, y);
            child.setSize(bounds.width, bounds.height - y);
            y += wantedSize.y;
        }
    }
}

