/*
 * Decompiled with CFR 0.152.
 */
package com.richclientgui.toolbox.clock;

import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DigitalClock
extends Composite {
    private static final int MAX_DIGIT_VALUE = 9;
    private static final int DIGIT_10 = 10;
    private static final long SECOND_PERIOD = 1000L;
    private final CLOCK_STYLE currentStyle;
    private int currentAM_PM;
    private final Timer timer = new Timer();
    private TimerTask timerTask = new DigitalClockTimer();
    private Label currentClickedLabel;
    private final Label hourMSLbl;
    private final Label hourLSLbl;
    private final Label minuteMSLbl;
    private final Label minuteLSLbl;
    private final Label secondMSLbl;
    private final Label secondLSLbl;
    private final Label am_pm_Lbl;
    private final Label lbl1;
    private final Label lbl2;
    private int secondsMS = 0;
    private int secondsLS = 0;
    private int minutesMS = 0;
    private int minutesLS = 0;
    private int hoursMS = 0;
    private int hoursLS = 0;
    private final Cursor upCursor;
    private final Cursor downCursor;
    private boolean clicked = false;
    private boolean top = false;
    private Color highlightColor;

    public DigitalClock(Composite parent, int style, CLOCK_STYLE behaviour) {
        this(parent, style, behaviour, new Cursor((Device)Display.getDefault(), 0), new Cursor((Device)Display.getDefault(), 0));
    }

    public DigitalClock(Composite parent, int style, CLOCK_STYLE behaviour, Cursor upCursor, Cursor downCursor) {
        super(parent, style);
        this.upCursor = upCursor;
        this.downCursor = downCursor;
        this.highlightColor = Display.getDefault().getSystemColor(15);
        this.currentAM_PM = Calendar.getInstance().get(9);
        this.currentStyle = behaviour;
        this.setLayout((Layout)this.createGridLayout());
        this.hourMSLbl = this.createHourMSLabel();
        this.hourLSLbl = this.createHourLSLabel();
        this.lbl1 = this.createSeparatorLabel();
        this.minuteMSLbl = this.createMinuteMSLabel();
        this.minuteLSLbl = this.createMinuteLSLabel();
        this.lbl2 = this.createSeparatorLabel();
        this.secondMSLbl = this.createSecondMSLabel();
        this.secondLSLbl = this.createSecondLSLabel();
        this.am_pm_Lbl = this.currentStyle.equals((Object)CLOCK_STYLE.CLOCK_12_HOURS) ? this.createAMPMLabel() : null;
        if (this.currentStyle.equals((Object)CLOCK_STYLE.CLOCK_12_HOURS) || this.currentStyle.equals((Object)CLOCK_STYLE.CLOCK_24_HOURS)) {
            this.resetToCurrentTime();
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (DigitalClock.this.timerTask != null) {
                    DigitalClock.this.timerTask.cancel();
                }
                DigitalClock.this.timer.cancel();
                DigitalClock.this.timer.purge();
            }
        });
    }

    private Label createAMPMLabel() {
        final Label label = new Label((Composite)this, 0);
        label.setText(this.currentAM_PM == 0 ? "AM" : "PM");
        label.addPaintListener((PaintListener)new IncrementLabelPaintListener(label));
        label.addMouseMoveListener((MouseMoveListener)new ClockMouseMoveListener(label));
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DigitalClock.this.currentClickedLabel = label;
                DigitalClock.this.clicked = true;
                label.redraw();
            }

            public void mouseUp(MouseEvent e) {
                DigitalClock.this.clicked = false;
                label.redraw();
                DigitalClock.this.currentAM_PM = DigitalClock.this.currentAM_PM == 0 ? 1 : 0;
                DigitalClock.this.updateLabels();
            }
        });
        return label;
    }

    private Label createSecondLSLabel() {
        Label label = new Label((Composite)this, 0);
        label.setText("0");
        label.addPaintListener((PaintListener)new IncrementLabelPaintListener(label));
        label.addMouseMoveListener((MouseMoveListener)new ClockMouseMoveListener(label));
        label.addMouseListener((MouseListener)new ClockMouseListener(label, new IncDecListener(){

            @Override
            public void increase() {
                DigitalClock.this.incLSSeconds(false);
            }

            @Override
            public void decrease() {
                DigitalClock.this.decLSSeconds(false);
            }
        }));
        return label;
    }

    private Label createSecondMSLabel() {
        Label label = new Label((Composite)this, 0);
        label.setText("0");
        label.addPaintListener((PaintListener)new IncrementLabelPaintListener(label));
        label.addMouseMoveListener((MouseMoveListener)new ClockMouseMoveListener(label));
        label.addMouseListener((MouseListener)new ClockMouseListener(label, new IncDecListener(){

            @Override
            public void increase() {
                DigitalClock.this.incMSSeconds(false);
            }

            @Override
            public void decrease() {
                DigitalClock.this.decMSSeconds(false);
            }
        }));
        return label;
    }

    private Label createMinuteLSLabel() {
        Label label = new Label((Composite)this, 0);
        label.setText("0");
        label.addPaintListener((PaintListener)new IncrementLabelPaintListener(label));
        label.addMouseMoveListener((MouseMoveListener)new ClockMouseMoveListener(label));
        label.addMouseListener((MouseListener)new ClockMouseListener(label, new IncDecListener(){

            @Override
            public void increase() {
                DigitalClock.this.incLSMinutes(false);
            }

            @Override
            public void decrease() {
                DigitalClock.this.decLSMinutes(false);
            }
        }));
        return label;
    }

    private Label createMinuteMSLabel() {
        Label label = new Label((Composite)this, 0);
        label.setText("0");
        label.addPaintListener((PaintListener)new IncrementLabelPaintListener(label));
        label.addMouseMoveListener((MouseMoveListener)new ClockMouseMoveListener(label));
        label.addMouseListener((MouseListener)new ClockMouseListener(label, new IncDecListener(){

            @Override
            public void increase() {
                DigitalClock.this.incMSMinutes(false);
            }

            @Override
            public void decrease() {
                DigitalClock.this.decMSMinutes(false);
            }
        }));
        return label;
    }

    private Label createSeparatorLabel() {
        Label separator = new Label((Composite)this, 0);
        separator.setText(":");
        return separator;
    }

    private Label createHourLSLabel() {
        Label label = new Label((Composite)this, 0);
        label.setText("0");
        label.addPaintListener((PaintListener)new IncrementLabelPaintListener(label));
        label.addMouseMoveListener((MouseMoveListener)new ClockMouseMoveListener(label));
        label.addMouseListener((MouseListener)new ClockMouseListener(label, new IncDecListener(){

            @Override
            public void increase() {
                DigitalClock.this.incLSHours(false);
            }

            @Override
            public void decrease() {
                DigitalClock.this.decLSHours(false);
            }
        }));
        return label;
    }

    private Label createHourMSLabel() {
        Label label = new Label((Composite)this, 0);
        label.setText("0");
        label.addPaintListener((PaintListener)new IncrementLabelPaintListener(label));
        label.addMouseMoveListener((MouseMoveListener)new ClockMouseMoveListener(label));
        label.addMouseListener((MouseListener)new ClockMouseListener(label, new IncDecListener(){

            @Override
            public void increase() {
                DigitalClock.this.incMSHours(false);
            }

            @Override
            public void decrease() {
                DigitalClock.this.decMSHours();
            }
        }));
        return label;
    }

    private GridLayout createGridLayout() {
        GridLayout gl = new GridLayout(this.currentStyle.equals((Object)CLOCK_STYLE.CLOCK_12_HOURS) ? 9 : 8, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        return gl;
    }

    public void setHighLightColor(Color color) {
        this.checkWidget();
        this.highlightColor = color;
    }

    public void setAM_PMLabelFont(Font font) {
        this.checkWidget();
        if (this.am_pm_Lbl != null) {
            this.am_pm_Lbl.setFont(font);
        }
        this.layout();
    }

    public void setFont(Font font) {
        this.checkWidget();
        this.hourMSLbl.setFont(font);
        this.hourLSLbl.setFont(font);
        this.lbl1.setFont(font);
        this.minuteMSLbl.setFont(font);
        this.minuteLSLbl.setFont(font);
        this.lbl2.setFont(font);
        this.secondMSLbl.setFont(font);
        this.secondLSLbl.setFont(font);
        if (this.am_pm_Lbl != null) {
            this.am_pm_Lbl.setFont(font);
        }
        this.layout();
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.hourMSLbl.setBackground(color);
        this.hourLSLbl.setBackground(color);
        this.lbl1.setBackground(color);
        this.minuteMSLbl.setBackground(color);
        this.minuteLSLbl.setBackground(color);
        this.lbl2.setBackground(color);
        this.secondMSLbl.setBackground(color);
        this.secondLSLbl.setBackground(color);
        if (this.am_pm_Lbl != null) {
            this.am_pm_Lbl.setBackground(color);
        }
        super.setBackground(color);
        this.layout();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        this.hourMSLbl.setForeground(color);
        this.hourLSLbl.setForeground(color);
        this.lbl1.setForeground(color);
        this.minuteMSLbl.setForeground(color);
        this.minuteLSLbl.setForeground(color);
        this.lbl2.setForeground(color);
        this.secondMSLbl.setForeground(color);
        this.secondLSLbl.setForeground(color);
        if (this.am_pm_Lbl != null) {
            this.am_pm_Lbl.setForeground(color);
        }
        this.layout();
    }

    public void setForegroundHours(Color color) {
        this.checkWidget();
        this.hourMSLbl.setForeground(color);
        this.hourLSLbl.setForeground(color);
        this.layout();
    }

    public void setForegroundMinutes(Color color) {
        this.checkWidget();
        this.minuteMSLbl.setForeground(color);
        this.minuteLSLbl.setForeground(color);
        this.layout();
    }

    public void setForegroundSeconds(Color color) {
        this.checkWidget();
        this.secondMSLbl.setForeground(color);
        this.secondLSLbl.setForeground(color);
        this.layout();
    }

    public void setForegroundAM_PM(Color color) {
        this.checkWidget();
        if (this.am_pm_Lbl != null) {
            this.am_pm_Lbl.setForeground(color);
        }
        this.layout();
    }

    public void start() {
        this.checkWidget();
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = new DigitalClockTimer();
        this.timer.schedule(this.timerTask, 0L, 1000L);
    }

    public void stop() {
        this.checkWidget();
        this.timerTask.cancel();
    }

    public void reset() {
        this.checkWidget();
        this.timerTask.cancel();
        this.secondsLS = 0;
        this.secondsMS = 0;
        this.minutesLS = 0;
        this.minutesMS = 0;
        this.hoursLS = this.currentStyle.equals((Object)CLOCK_STYLE.CLOCK_12_HOURS) ? 1 : 0;
        this.hoursMS = 0;
        this.currentAM_PM = Calendar.getInstance().get(9);
        this.updateLabels();
    }

    public void resetToCurrentTime() {
        this.checkWidget();
        this.timerTask.cancel();
        int seconds = Calendar.getInstance().get(13);
        this.secondsMS = seconds / 10;
        this.secondsLS = seconds - this.secondsMS * 10;
        int minutes = Calendar.getInstance().get(12);
        this.minutesMS = minutes / 10;
        this.minutesLS = minutes - this.minutesMS * 10;
        if (this.currentStyle.equals((Object)CLOCK_STYLE.CLOCK_12_HOURS)) {
            int hours = Calendar.getInstance().get(10);
            if (hours == 0) {
                hours = 12;
            }
            this.hoursMS = hours / 10;
            this.hoursLS = hours - this.hoursMS * 10;
            this.currentAM_PM = Calendar.getInstance().get(9);
        } else if (this.currentStyle.equals((Object)CLOCK_STYLE.CLOCK_24_HOURS)) {
            int hours = Calendar.getInstance().get(11);
            this.hoursMS = hours / 10;
            this.hoursLS = hours - this.hoursMS * 10;
        } else {
            this.reset();
            return;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = new DigitalClockTimer();
        if (Calendar.getInstance().get(13) == seconds) {
            this.timer.schedule(this.timerTask, 1000L - (long)Calendar.getInstance().get(14), 1000L);
        } else {
            this.timer.schedule(this.timerTask, 0L, 1000L);
        }
        this.updateLabels();
    }

    public int getHours() {
        this.checkWidget();
        return this.hoursMS * 10 + this.hoursLS;
    }

    public int getMinutes() {
        this.checkWidget();
        return this.minutesMS * 10 + this.minutesLS;
    }

    public int getSeconds() {
        this.checkWidget();
        return this.secondsMS * 10 + this.secondsLS;
    }

    public int getAM_PM() {
        return this.currentAM_PM;
    }

    public CLOCK_STYLE getClockStyle() {
        return this.currentStyle;
    }

    private void incLSSeconds(boolean carry) {
        ++this.secondsLS;
        if (this.secondsLS > 9) {
            this.secondsLS = 0;
            if (carry) {
                this.incMSSeconds(true);
            }
        }
    }

    private void incMSSeconds(boolean carry) {
        ++this.secondsMS;
        if (this.secondsMS > 5) {
            this.secondsMS = 0;
            if (carry) {
                this.incLSMinutes(true);
            }
        }
    }

    private void incLSMinutes(boolean carry) {
        ++this.minutesLS;
        if (this.minutesLS > 9) {
            this.minutesLS = 0;
            if (carry) {
                this.incMSMinutes(true);
            }
        }
    }

    private void incMSMinutes(boolean carry) {
        ++this.minutesMS;
        if (this.minutesMS > 5) {
            this.minutesMS = 0;
            if (carry) {
                this.incLSHours(true);
            }
        }
    }

    private void incLSHours(boolean carry) {
        ++this.hoursLS;
        if (this.currentStyle.equals((Object)CLOCK_STYLE.CLOCK_24_HOURS)) {
            if (this.hoursMS > 1 && this.hoursLS > 3) {
                this.hoursLS = 0;
                if (carry) {
                    this.incMSHours(true);
                }
            } else if (this.hoursLS > 9) {
                this.hoursLS = 0;
                if (carry) {
                    this.incMSHours(true);
                }
            }
        } else if (this.currentStyle.equals((Object)CLOCK_STYLE.CLOCK_12_HOURS)) {
            if (this.hoursMS == 1 && this.hoursLS > 2) {
                if (carry) {
                    this.hoursLS = 1;
                    this.incMSHours(true);
                } else {
                    this.hoursLS = 0;
                }
            } else if (this.hoursMS == 0 && this.hoursLS > 9) {
                if (carry) {
                    this.hoursLS = 0;
                    this.incMSHours(true);
                } else {
                    this.hoursLS = 1;
                }
            } else if (this.hoursLS > 9) {
                this.hoursLS = 0;
                if (carry) {
                    this.incMSHours(true);
                }
            }
        } else if (this.hoursLS > 9 && this.currentStyle.equals((Object)CLOCK_STYLE.COUNTER)) {
            this.hoursLS = 0;
            if (carry) {
                this.incMSHours(true);
            }
        }
    }

    private void incMSHours(boolean carry) {
        ++this.hoursMS;
        if (this.currentStyle.equals((Object)CLOCK_STYLE.CLOCK_24_HOURS)) {
            if (this.hoursMS > 2) {
                this.hoursMS = 0;
            }
            if (this.hoursMS > 1 && this.hoursLS > 3) {
                this.hoursMS = 0;
            }
        } else if (this.currentStyle.equals((Object)CLOCK_STYLE.CLOCK_12_HOURS)) {
            if (this.hoursMS > 1) {
                if (this.hoursLS > 0) {
                    this.hoursMS = 0;
                    if (carry) {
                        this.currentAM_PM = this.currentAM_PM == 0 ? 1 : 0;
                    }
                } else {
                    this.hoursMS = 1;
                }
            } else if (this.hoursMS == 1 && this.hoursLS > 2) {
                this.hoursMS = 0;
            }
        } else if (this.hoursMS > 9 && this.currentStyle.equals((Object)CLOCK_STYLE.COUNTER)) {
            this.hoursMS = 0;
        }
    }

    private void decLSSeconds(boolean carry) {
        --this.secondsLS;
        if (this.secondsLS < 0) {
            this.secondsLS = 9;
            if (carry) {
                this.decMSSeconds(true);
            }
        }
    }

    private void decMSSeconds(boolean carry) {
        --this.secondsMS;
        if (this.secondsMS < 0) {
            this.secondsMS = 5;
            if (carry) {
                this.decLSMinutes(true);
            }
        }
    }

    private void decLSMinutes(boolean carry) {
        --this.minutesLS;
        if (this.minutesLS < 0) {
            this.minutesLS = 9;
            if (carry) {
                this.decMSMinutes(true);
            }
        }
    }

    private void decMSMinutes(boolean carry) {
        --this.minutesMS;
        if (this.minutesMS < 0) {
            this.minutesMS = 5;
            if (carry) {
                this.decLSHours(true);
            }
        }
    }

    private void decLSHours(boolean carry) {
        --this.hoursLS;
        if (this.hoursLS < 0 && this.currentStyle.equals((Object)CLOCK_STYLE.CLOCK_24_HOURS)) {
            if (this.hoursMS > 1) {
                this.hoursLS = 3;
                if (carry) {
                    this.decMSHours();
                }
            } else {
                this.hoursLS = 9;
                if (carry) {
                    this.decMSHours();
                }
            }
        } else if (this.hoursLS < 0 && this.currentStyle.equals((Object)CLOCK_STYLE.CLOCK_12_HOURS)) {
            if (this.hoursMS == 1) {
                this.hoursLS = 2;
                if (carry) {
                    this.decMSHours();
                }
            } else {
                this.hoursLS = 9;
                if (carry) {
                    this.decMSHours();
                }
            }
        } else if (this.hoursLS < 0 && this.currentStyle.equals((Object)CLOCK_STYLE.COUNTER)) {
            this.hoursLS = 9;
            if (carry) {
                this.decMSHours();
            }
        }
    }

    private void decMSHours() {
        --this.hoursMS;
        if (this.hoursMS < 0 && this.currentStyle.equals((Object)CLOCK_STYLE.CLOCK_24_HOURS)) {
            this.hoursMS = this.hoursLS > 3 ? 1 : 2;
        } else if (this.hoursMS < 0 && this.currentStyle.equals((Object)CLOCK_STYLE.CLOCK_12_HOURS)) {
            this.hoursMS = this.hoursLS > 2 ? 0 : 1;
        } else if (this.hoursMS < 0 && this.currentStyle.equals((Object)CLOCK_STYLE.COUNTER)) {
            this.hoursMS = 9;
        }
    }

    private void updateLabels() {
        this.secondLSLbl.setText(String.valueOf(this.secondsLS));
        this.secondMSLbl.setText(String.valueOf(this.secondsMS));
        this.minuteLSLbl.setText(String.valueOf(this.minutesLS));
        this.minuteMSLbl.setText(String.valueOf(this.minutesMS));
        this.hourLSLbl.setText(String.valueOf(this.hoursLS));
        this.hourMSLbl.setText(String.valueOf(this.hoursMS));
        if (this.am_pm_Lbl != null) {
            this.am_pm_Lbl.setText(this.currentAM_PM == 0 ? "AM" : "PM");
        }
        if (this.clicked) {
            this.secondLSLbl.redraw();
            this.secondMSLbl.redraw();
            this.minuteLSLbl.redraw();
            this.minuteMSLbl.redraw();
            this.hourLSLbl.redraw();
            this.hourMSLbl.redraw();
            if (this.am_pm_Lbl != null) {
                this.am_pm_Lbl.redraw();
            }
        }
    }

    private boolean isTopRegion(int y, int h) {
        this.top = (double)y <= (double)h / 2.0;
        return this.top;
    }

    public static enum CLOCK_STYLE {
        CLOCK_24_HOURS,
        CLOCK_12_HOURS,
        COUNTER;

    }

    private class ClockMouseListener
    extends MouseAdapter {
        private final Label label;
        private final IncDecListener incDecListener;

        ClockMouseListener(Label label, IncDecListener incDecListener) {
            this.label = label;
            this.incDecListener = incDecListener;
        }

        public void mouseDown(MouseEvent e) {
            DigitalClock.this.clicked = true;
            DigitalClock.this.currentClickedLabel = this.label;
            this.label.redraw();
        }

        public void mouseUp(MouseEvent e) {
            DigitalClock.this.clicked = false;
            this.label.redraw();
            if (DigitalClock.this.isTopRegion(e.y, this.label.getBounds().height)) {
                this.incDecListener.increase();
            } else {
                this.incDecListener.decrease();
            }
            DigitalClock.this.updateLabels();
        }
    }

    private class ClockMouseMoveListener
    implements MouseMoveListener {
        private final Label label;

        ClockMouseMoveListener(Label label) {
            this.label = label;
        }

        public void mouseMove(MouseEvent e) {
            if (DigitalClock.this.isTopRegion(e.y, this.label.getBounds().height)) {
                this.label.setCursor(DigitalClock.this.upCursor);
            } else {
                this.label.setCursor(DigitalClock.this.downCursor);
            }
        }
    }

    private class DigitalClockTimer
    extends TimerTask {
        private DigitalClockTimer() {
        }

        @Override
        public void run() {
            DigitalClock.this.incLSSeconds(true);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DigitalClock.this.updateLabels();
                }
            });
        }
    }

    private static interface IncDecListener {
        public void increase();

        public void decrease();
    }

    private class IncrementLabelPaintListener
    implements PaintListener {
        private final Label lbl;

        IncrementLabelPaintListener(Label lbl) {
            this.lbl = lbl;
        }

        public void paintControl(PaintEvent e) {
            if (DigitalClock.this.clicked && DigitalClock.this.currentClickedLabel != null && DigitalClock.this.currentClickedLabel.equals(this.lbl)) {
                e.gc.setBackground(DigitalClock.this.highlightColor);
                int h = this.lbl.getBounds().height;
                int h_factor = 8;
                e.gc.fillRectangle(0, DigitalClock.this.top ? 0 : h - h / 8, this.lbl.getBounds().width, h / 8);
            }
        }
    }
}

