/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.provider.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.cashserver.core.cashregistry.domain.SecurityObject;

public class SecurityObjectContentProvider
implements ITreeContentProvider {
    private static final Logger log = LoggerFactory.getLogger(SecurityObjectContentProvider.class);
    private Set<SecurityObject> securityObjects;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.securityObjects = (Set)newInput;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<SecurityObject> rootSecurityObjects = new ArrayList<SecurityObject>();
        log.trace("securityObjects:{}", (Object)this.securityObjects.size());
        if (this.securityObjects != null) {
            for (SecurityObject object : this.securityObjects) {
                if (object == null || object.getParent() != null || !this.hasChildren(object)) continue;
                rootSecurityObjects.add(object);
            }
        }
        Collections.sort(rootSecurityObjects, new SecurityObjectComparator());
        log.trace("root count:{}", (Object)rootSecurityObjects.size());
        return rootSecurityObjects.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<SecurityObject> childSecurityObjects = new ArrayList<SecurityObject>();
        for (SecurityObject object : this.securityObjects) {
            if (object.getParent() == null || !object.getParent().equals(parentElement)) continue;
            childSecurityObjects.add(object);
        }
        Collections.sort(childSecurityObjects, new SecurityObjectComparator());
        log.trace("child count:{}", (Object)childSecurityObjects.size());
        return childSecurityObjects.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        boolean result = false;
        for (SecurityObject object : this.securityObjects) {
            if (object.getParent() == null || !object.getParent().equals(element)) continue;
            result = true;
            break;
        }
        log.trace("result={} for {}", (Object)result, element);
        return result;
    }

    private class SecurityObjectComparator
    implements Comparator<SecurityObject> {
        private SecurityObjectComparator() {
        }

        @Override
        public int compare(SecurityObject o1, SecurityObject o2) {
            return o1.getId().substring(o1.getId().lastIndexOf(".") + 1).compareToIgnoreCase(o2.getId().substring(o2.getId().lastIndexOf(".") + 1));
        }
    }
}

