/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.propertyTable.editor;

import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.propertyTable.PTProperty;
import org.mihalis.opal.propertyTable.PTWidget;
import org.mihalis.opal.propertyTable.editor.PTEditor;
import org.mihalis.opal.utils.ResourceManager;
import org.mihalis.opal.utils.SWTGraphicUtil;

public abstract class PTChooserEditor
extends PTEditor {
    private PTWidget widget;
    private Item item;
    private PTProperty property;

    @Override
    public ControlEditor render(PTWidget pTWidget, Item item, PTProperty pTProperty) {
        this.widget = pTWidget;
        this.item = item;
        this.property = pTProperty;
        if (item instanceof TableItem) {
            ((TableItem)item).setText(1, this.getTextFor(pTProperty));
        } else {
            ((TreeItem)item).setText(1, this.getTextFor(pTProperty));
        }
        Color color = this.getBackgroundColor(pTProperty);
        if (color != null) {
            if (item instanceof TableItem) {
                ((TableItem)item).setBackground(1, color);
            }
            if (item instanceof TreeItem) {
                ((TreeItem)item).setBackground(1, color);
            }
            SWTGraphicUtil.addDisposer((Widget)item, (Resource)color);
        }
        Object object = pTWidget.getWidget() instanceof Table ? new TableEditor((Table)pTWidget.getWidget()) : new TreeEditor((Tree)pTWidget.getWidget());
        Composite composite = new Composite(pTWidget.getWidget(), 0);
        FillLayout fillLayout = new FillLayout(256);
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        composite.setLayout((Layout)fillLayout);
        this.createEraseButton(composite);
        this.createPlusButton(composite);
        composite.pack();
        object.minimumWidth = composite.getSize().x;
        object.horizontalAlignment = 131072;
        if (pTWidget.getWidget() instanceof Table) {
            object.setEditor((Control)composite, (TableItem)item, 1);
        } else {
            ((TreeEditor)object).setEditor((Control)composite, (TreeItem)item, 1);
        }
        return object;
    }

    private void createEraseButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText(" X ");
        button.setToolTipText(ResourceManager.getLabel("eraseProperty"));
        button.setEnabled(this.property.isEnabled());
        button.pack();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PTChooserEditor.this.property.setValue(null);
                if (PTChooserEditor.this.item instanceof TableItem) {
                    ((TableItem)PTChooserEditor.this.item).setBackground(1, Display.getDefault().getSystemColor(25));
                    ((TableItem)PTChooserEditor.this.item).setText(1, PTChooserEditor.this.getTextFor(PTChooserEditor.this.property));
                }
                if (PTChooserEditor.this.item instanceof TreeItem) {
                    ((TreeItem)PTChooserEditor.this.item).setBackground(1, Display.getDefault().getSystemColor(25));
                    ((TreeItem)PTChooserEditor.this.item).setText(1, PTChooserEditor.this.getTextFor(PTChooserEditor.this.property));
                }
            }
        });
        button.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                PTChooserEditor.this.widget.updateDescriptionPanel(PTChooserEditor.this.property);
            }
        });
    }

    private void createPlusButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText("...");
        button.setToolTipText(ResourceManager.getLabel("editProperty"));
        button.setEnabled(this.property.isEnabled());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PTChooserEditor.this.openWindow(PTChooserEditor.this.widget, PTChooserEditor.this.item, PTChooserEditor.this.property);
            }
        });
        button.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                PTChooserEditor.this.widget.updateDescriptionPanel(PTChooserEditor.this.property);
            }
        });
        button.pack();
    }

    protected abstract void openWindow(PTWidget var1, Item var2, PTProperty var3);

    protected abstract String getTextFor(PTProperty var1);

    protected abstract Color getBackgroundColor(PTProperty var1);
}

